/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.server.DraftCNDB;
import org.opends.server.replication.server.ReplicationDraftCNKey;
import org.opends.server.types.DebugLogLevel;

public class DraftCNDbIterator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DraftCNDB.DraftCNDBCursor draftCNDbCursor = null;

    public DraftCNDbIterator(DraftCNDB db, int startDraftCN) throws Exception, DatabaseException {
        this.draftCNDbCursor = db.openReadCursor(startDraftCN);
        if (this.draftCNDbCursor == null) {
            throw new Exception("no new change");
        }
    }

    public String getServiceID() {
        try {
            return this.draftCNDbCursor.currentServiceID();
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            return null;
        }
    }

    public ChangeNumber getChangeNumber() {
        try {
            ChangeNumber cn = this.draftCNDbCursor.currentChangeNumber();
            return cn;
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            return null;
        }
    }

    public int getDraftCN() {
        ReplicationDraftCNKey sk = (ReplicationDraftCNKey)this.draftCNDbCursor.getKey();
        int currentSeqnum = sk.getDraftCN();
        return currentSeqnum;
    }

    public boolean next() throws Exception, DatabaseException {
        return this.draftCNDbCursor.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCursor() {
        DraftCNDbIterator draftCNDbIterator = this;
        synchronized (draftCNDbIterator) {
            if (this.draftCNDbCursor != null) {
                this.draftCNDbCursor.close();
                this.draftCNDbCursor = null;
            }
        }
    }

    protected void finalize() {
        this.releaseCursor();
    }
}

