/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplicationMsg;

public abstract class StartMsg
extends ReplicationMsg {
    protected short protocolVersion;
    protected long generationId;
    protected byte groupId = (byte)-1;
    protected int headerLength;

    protected StartMsg() {
    }

    public StartMsg(short protocolVersion, long generationId) {
        this.protocolVersion = protocolVersion;
        this.generationId = generationId;
    }

    public byte[] encodeHeader(byte type, int additionalLength, short sessionProtocolVersion) throws UnsupportedEncodingException {
        byte[] byteGenerationID = String.valueOf(this.generationId).getBytes("UTF-8");
        int length = 2 + byteGenerationID.length + 1 + 1 + additionalLength;
        byte[] encodedMsg = new byte[length];
        encodedMsg[0] = type;
        encodedMsg[1] = (byte)sessionProtocolVersion;
        int pos = 2;
        pos = StartMsg.addByteArray(byteGenerationID, encodedMsg, pos);
        encodedMsg[pos] = this.groupId;
        this.headerLength = ++pos;
        return encodedMsg;
    }

    public byte[] encodeHeader_V1(byte type, int additionalLength) throws UnsupportedEncodingException {
        byte[] byteGenerationID = String.valueOf(this.generationId).getBytes("UTF-8");
        int length = 3 + byteGenerationID.length + 1 + additionalLength;
        byte[] encodedMsg = new byte[length];
        encodedMsg[0] = type;
        encodedMsg[1] = 49;
        encodedMsg[2] = 0;
        int pos = 3;
        this.headerLength = StartMsg.addByteArray(byteGenerationID, encodedMsg, pos);
        return encodedMsg;
    }

    public int decodeHeader(byte[] types, byte[] encodedMsg) throws DataFormatException {
        boolean foundMatchingType = false;
        for (byte type : types) {
            if (type != encodedMsg[0]) continue;
            foundMatchingType = true;
            break;
        }
        if (!foundMatchingType) {
            throw new DataFormatException("byte[] is not a valid start msg: " + encodedMsg[0]);
        }
        if (encodedMsg[0] == 7) {
            return this.decodeHeader_V1((byte)7, encodedMsg);
        }
        try {
            short readVersion = encodedMsg[1];
            if (readVersion < 2) {
                throw new DataFormatException("Not a valid message: type is " + encodedMsg[0] + " but protocol version byte is " + readVersion + " instead of " + ProtocolVersion.getCurrentVersion());
            }
            this.protocolVersion = readVersion;
            int pos = 2;
            int length = StartMsg.getNextLength(encodedMsg, pos);
            this.generationId = Long.valueOf(new String(encodedMsg, pos, length, "UTF-8"));
            this.groupId = encodedMsg[pos += length + 1];
            return ++pos;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public int decodeHeader_V1(byte type, byte[] encodedMsg) throws DataFormatException {
        if (encodedMsg[0] != type) {
            throw new DataFormatException("byte[] is not a valid start msg: expected  a V1 PDU, received: " + encodedMsg[0]);
        }
        if (encodedMsg[1] != 49) {
            throw new DataFormatException("Not a valid message: type is " + type + " but protocol version byte is " + encodedMsg[1] + " instead of " + 49);
        }
        this.protocolVersion = 1;
        try {
            int pos = 3;
            int length = StartMsg.getNextLength(encodedMsg, pos);
            this.generationId = Long.valueOf(new String(encodedMsg, pos, length, "UTF-8"));
            return pos += length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public short getVersion() {
        return this.protocolVersion;
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public byte getGroupId() {
        return this.groupId;
    }

    public void setGroupId(byte groupId) {
        this.groupId = groupId;
    }
}

