/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.DataFormatException;
import javax.net.ssl.SSLSocket;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.NotSupportedOldVersionPDUException;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.util.StaticUtils;

public final class Session
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final Socket plainSocket;
    private final SSLSocket secureSocket;
    private final InputStream plainInput;
    private final OutputStream plainOutput;
    private final byte[] rcvLengthBuf = new byte[8];
    private final String readableRemoteAddress;
    private final String remoteAddress;
    private final String localUrl;
    private volatile long lastPublishTime = 0L;
    private volatile long lastReceiveTime = 0L;
    private final Object stateLock = new Object();
    private volatile boolean closeInitiated = false;
    private Throwable sessionError = null;
    private final Lock publishLock = new ReentrantLock();
    private short protocolVersion = ProtocolVersion.getCurrentVersion();
    private boolean isEncrypted = true;
    private BufferedInputStream input;
    private BufferedOutputStream output;
    private final LinkedBlockingQueue<byte[]> sendQueue = new LinkedBlockingQueue(4000);
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private final CountDownLatch latch = new CountDownLatch(1);

    public Session(Socket socket, SSLSocket secureSocket) throws IOException {
        super("Replication Session from " + socket.getLocalSocketAddress() + " to " + socket.getRemoteSocketAddress());
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Creating Session from %s to %s in %s", socket.getLocalSocketAddress(), socket.getRemoteSocketAddress(), StaticUtils.stackTraceToSingleLineString(new Exception()));
        }
        this.plainSocket = socket;
        this.secureSocket = secureSocket;
        this.plainInput = this.plainSocket.getInputStream();
        this.plainOutput = this.plainSocket.getOutputStream();
        this.input = new BufferedInputStream(secureSocket.getInputStream());
        this.output = new BufferedOutputStream(secureSocket.getOutputStream());
        this.readableRemoteAddress = this.plainSocket.getRemoteSocketAddress().toString();
        this.remoteAddress = this.plainSocket.getInetAddress().getHostAddress();
        this.localUrl = this.plainSocket.getLocalAddress().getHostName() + ":" + this.plainSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Throwable localSessionError;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.closeInitiated) {
                return;
            }
            localSessionError = this.sessionError;
            this.closeInitiated = true;
        }
        try {
            this.interrupt();
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (DebugLogger.debugEnabled()) {
            if (localSessionError == null) {
                TRACER.debugInfo("Closing Session from %s to %s in %s", this.plainSocket.getLocalSocketAddress(), this.plainSocket.getRemoteSocketAddress(), StaticUtils.stackTraceToSingleLineString(new Exception()));
            } else {
                TRACER.debugInfo("Aborting Session from %s to %s in %s due to the following error: %s", this.plainSocket.getLocalSocketAddress(), this.plainSocket.getRemoteSocketAddress(), StaticUtils.stackTraceToSingleLineString(new Exception()), StaticUtils.stackTraceToSingleLineString(localSessionError));
            }
        }
        if (localSessionError == null && this.protocolVersion >= 4) {
            try {
                this.publish(new StopMsg());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        StaticUtils.close(this.plainSocket, this.secureSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeInitiated() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.closeInitiated;
        }
    }

    public long getLastPublishTime() {
        return this.lastPublishTime;
    }

    public long getLastReceiveTime() {
        if (this.lastReceiveTime == 0L) {
            return System.currentTimeMillis();
        }
        return this.lastReceiveTime;
    }

    public String getLocalUrl() {
        return this.localUrl;
    }

    public String getReadableRemoteAddress() {
        return this.readableRemoteAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void publish(ReplicationMsg msg) throws IOException {
        byte[] buffer = msg.getBytes(this.protocolVersion);
        if (this.isRunning.get()) {
            try {
                this.sendQueue.put(buffer);
            }
            catch (InterruptedException e) {
                this.setSessionError(e);
                throw new IOException(e.getMessage());
            }
        } else {
            this.send(buffer);
        }
    }

    private void send(byte[] buffer) throws IOException {
        String str = String.format("%08x", buffer.length);
        byte[] sendLengthBuf = str.getBytes();
        this.publishLock.lock();
        try {
            this.output.write(sendLengthBuf);
            this.output.write(buffer);
            this.output.flush();
        }
        catch (IOException e) {
            this.setSessionError(e);
            throw e;
        }
        finally {
            this.publishLock.unlock();
        }
        this.lastPublishTime = System.currentTimeMillis();
    }

    public ReplicationMsg receive() throws IOException, DataFormatException, NotSupportedOldVersionPDUException {
        try {
            int length;
            int read;
            this.lastReceiveTime = System.currentTimeMillis();
            for (length = 0; length < 8; length += read) {
                read = this.input.read(this.rcvLengthBuf, length, 8 - length);
                if (read != -1) continue;
                this.lastReceiveTime = 0L;
                throw new IOException("no more data");
            }
            int totalLength = Integer.parseInt(new String(this.rcvLengthBuf), 16);
            try {
                int read2;
                byte[] buffer = new byte[totalLength];
                for (length = 0; length < totalLength; length += read2) {
                    read2 = this.input.read(buffer, length, totalLength - length);
                    if (read2 != -1) continue;
                    this.lastReceiveTime = 0L;
                    throw new IOException("no more data");
                }
                this.lastReceiveTime = 0L;
                return ReplicationMsg.generateMsg(buffer, this.protocolVersion);
            }
            catch (OutOfMemoryError e) {
                throw new IOException("Packet too large, can't allocate " + totalLength + " bytes.");
            }
        }
        catch (IOException e) {
            this.setSessionError(e);
            throw e;
        }
        catch (DataFormatException e) {
            this.setSessionError(e);
            throw e;
        }
        catch (NotSupportedOldVersionPDUException e) {
            this.setSessionError(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.setSessionError(e);
            throw e;
        }
    }

    public void setProtocolVersion(short version) {
        this.protocolVersion = version;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.plainSocket.setSoTimeout(timeout);
    }

    public void stopEncryption() {
        this.input = new BufferedInputStream(this.plainInput);
        this.output = new BufferedOutputStream(this.plainOutput);
        this.isEncrypted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionError(Exception e) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.sessionError == null) {
                this.sessionError = e;
            }
        }
    }

    @Override
    public void run() {
        this.isRunning.set(true);
        this.latch.countDown();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this.getName() + " starting.");
        }
        boolean needClosing = false;
        while (!this.closeInitiated) {
            byte[] buffer;
            try {
                buffer = this.sendQueue.take();
            }
            catch (InterruptedException ie) {
                break;
            }
            try {
                this.send(buffer);
            }
            catch (IOException e) {
                this.setSessionError(e);
                needClosing = true;
            }
        }
        this.isRunning.set(false);
        if (needClosing) {
            this.close();
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this.getName() + " stopped.");
        }
    }

    public void waitForStartup() throws InterruptedException {
        this.latch.await();
    }
}

