/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.IOException;
import java.net.Socket;
import java.util.SortedSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.replication.protocol.Session;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DirectoryConfig;

public final class ReplSessionSecurity {
    private final boolean sslEncryption;
    private final String sslCertNickname;
    private final String[] sslProtocols;
    private final String[] sslCipherSuites;

    public ReplSessionSecurity() throws ConfigException {
        this(DirectoryConfig.getCryptoManager().getSslCertNickname(), DirectoryConfig.getCryptoManager().getSslProtocols(), DirectoryConfig.getCryptoManager().getSslCipherSuites(), DirectoryConfig.getCryptoManager().isSslEncryption());
    }

    public ReplSessionSecurity(String sslCertNickname, SortedSet<String> sslProtocols, SortedSet<String> sslCipherSuites, boolean sslEncryption) throws ConfigException {
        if (sslProtocols == null || sslProtocols.size() == 0) {
            this.sslProtocols = null;
        } else {
            this.sslProtocols = new String[sslProtocols.size()];
            sslProtocols.toArray(this.sslProtocols);
        }
        if (sslCipherSuites == null || sslCipherSuites.size() == 0) {
            this.sslCipherSuites = null;
        } else {
            this.sslCipherSuites = new String[sslCipherSuites.size()];
            sslCipherSuites.toArray(this.sslCipherSuites);
        }
        this.sslEncryption = sslEncryption;
        this.sslCertNickname = sslCertNickname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createClientSession(Socket socket, int soTimeout) throws ConfigException, IOException {
        boolean hasCompleted = false;
        Socket secureSocket = null;
        try {
            CryptoManager cryptoManager = DirectoryConfig.getCryptoManager();
            SSLContext sslContext = cryptoManager.getSslContext(this.sslCertNickname);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            secureSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), false);
            ((SSLSocket)secureSocket).setUseClientMode(true);
            secureSocket.setSoTimeout(soTimeout);
            if (this.sslProtocols != null) {
                ((SSLSocket)secureSocket).setEnabledProtocols(this.sslProtocols);
            }
            if (this.sslCipherSuites != null) {
                ((SSLSocket)secureSocket).setEnabledCipherSuites(this.sslCipherSuites);
            }
            ((SSLSocket)secureSocket).startHandshake();
            hasCompleted = true;
            Session session = new Session(socket, (SSLSocket)secureSocket);
            return session;
        }
        finally {
            if (!hasCompleted) {
                try {
                    socket.close();
                }
                catch (Exception ignored) {}
                if (secureSocket != null) {
                    try {
                        secureSocket.close();
                    }
                    catch (Exception ignored) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createServerSession(Socket socket, int soTimeout) throws ConfigException, IOException {
        boolean hasCompleted = false;
        Socket secureSocket = null;
        try {
            CryptoManager cryptoManager = DirectoryConfig.getCryptoManager();
            SSLContext sslContext = cryptoManager.getSslContext(this.sslCertNickname);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            secureSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), false);
            ((SSLSocket)secureSocket).setUseClientMode(false);
            ((SSLSocket)secureSocket).setNeedClientAuth(true);
            secureSocket.setSoTimeout(soTimeout);
            if (this.sslProtocols != null) {
                ((SSLSocket)secureSocket).setEnabledProtocols(this.sslProtocols);
            }
            if (this.sslCipherSuites != null) {
                ((SSLSocket)secureSocket).setEnabledCipherSuites(this.sslCipherSuites);
            }
            ((SSLSocket)secureSocket).startHandshake();
            hasCompleted = true;
            Session session = new Session(socket, (SSLSocket)secureSocket);
            return session;
        }
        catch (SSLException e) {
            Message message = ReplicationMessages.INFO_SSL_SERVER_CON_ATTEMPT_ERROR.get(socket.getRemoteSocketAddress().toString(), socket.getLocalSocketAddress().toString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            Session session = null;
            return session;
        }
        finally {
            if (!hasCompleted) {
                try {
                    socket.close();
                }
                catch (Exception ignored) {}
                if (secureSocket != null) {
                    try {
                        secureSocket.close();
                    }
                    catch (Exception ignored) {}
                }
            }
        }
    }

    public boolean isSslEncryption(String serverURL) {
        return this.sslEncryption;
    }
}

