/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.StartMsg;

public class ReplServerStartMsg
extends StartMsg {
    private Integer serverId;
    private String serverURL;
    private String baseDn = null;
    private int windowSize;
    private ServerState serverState;
    private boolean sslEncryption;
    private int degradedStatusThreshold = -1;

    public ReplServerStartMsg(int serverId, String serverURL, String baseDn, int windowSize, ServerState serverState, long generationId, boolean sslEncryption, byte groupId, int degradedStatusThreshold) {
        super((short)-1, generationId);
        this.serverId = serverId;
        this.serverURL = serverURL;
        this.baseDn = baseDn != null ? baseDn : null;
        this.windowSize = windowSize;
        this.serverState = serverState;
        this.sslEncryption = sslEncryption;
        this.groupId = groupId;
        this.degradedStatusThreshold = degradedStatusThreshold;
    }

    public ReplServerStartMsg(byte[] in) throws DataFormatException {
        byte[] allowedPduTypes = new byte[]{21, 7};
        this.headerLength = this.decodeHeader(allowedPduTypes, in);
        switch (this.protocolVersion) {
            case 1: {
                this.decodeBody_V1(in, this.headerLength);
                return;
            }
        }
        try {
            int pos = this.headerLength;
            int length = ReplServerStartMsg.getNextLength(in, pos);
            this.baseDn = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = ReplServerStartMsg.getNextLength(in, pos);
            String serverIdString = new String(in, pos, length, "UTF-8");
            this.serverId = Integer.valueOf(serverIdString);
            pos += length + 1;
            length = ReplServerStartMsg.getNextLength(in, pos);
            this.serverURL = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = ReplServerStartMsg.getNextLength(in, pos);
            this.windowSize = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = ReplServerStartMsg.getNextLength(in, pos);
            this.sslEncryption = Boolean.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = ReplServerStartMsg.getNextLength(in, pos);
            this.degradedStatusThreshold = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            this.serverState = new ServerState(in, pos += length + 1, in.length - 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public void decodeBody_V1(byte[] in, int pos) throws DataFormatException {
        try {
            int length = ReplServerStartMsg.getNextLength(in, pos);
            this.baseDn = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = ReplServerStartMsg.getNextLength(in, pos);
            String serverIdString = new String(in, pos, length, "UTF-8");
            this.serverId = Integer.valueOf(serverIdString);
            pos += length + 1;
            length = ReplServerStartMsg.getNextLength(in, pos);
            this.serverURL = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = ReplServerStartMsg.getNextLength(in, pos);
            this.windowSize = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = ReplServerStartMsg.getNextLength(in, pos);
            this.sslEncryption = Boolean.valueOf(new String(in, pos, length, "UTF-8"));
            this.serverState = new ServerState(in, pos += length + 1, in.length - 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    @Override
    public byte[] getBytes(short sessionProtocolVersion) throws UnsupportedEncodingException {
        switch (sessionProtocolVersion) {
            case 1: {
                return this.getBytes_V1();
            }
        }
        byte[] byteDn = this.baseDn.getBytes("UTF-8");
        byte[] byteServerId = String.valueOf(this.serverId).getBytes("UTF-8");
        byte[] byteServerUrl = this.serverURL.getBytes("UTF-8");
        byte[] byteServerState = this.serverState.getBytes();
        byte[] byteWindowSize = String.valueOf(this.windowSize).getBytes("UTF-8");
        byte[] byteSSLEncryption = String.valueOf(this.sslEncryption).getBytes("UTF-8");
        byte[] byteDegradedStatusThreshold = String.valueOf(this.degradedStatusThreshold).getBytes("UTF-8");
        int length = byteDn.length + 1 + byteServerId.length + 1 + byteServerUrl.length + 1 + byteWindowSize.length + 1 + byteSSLEncryption.length + 1 + byteDegradedStatusThreshold.length + 1 + byteServerState.length + 1;
        byte[] resultByteArray = this.encodeHeader((byte)21, length, sessionProtocolVersion);
        int pos = this.headerLength;
        pos = ReplServerStartMsg.addByteArray(byteDn, resultByteArray, pos);
        pos = ReplServerStartMsg.addByteArray(byteServerId, resultByteArray, pos);
        pos = ReplServerStartMsg.addByteArray(byteServerUrl, resultByteArray, pos);
        pos = ReplServerStartMsg.addByteArray(byteWindowSize, resultByteArray, pos);
        pos = ReplServerStartMsg.addByteArray(byteSSLEncryption, resultByteArray, pos);
        pos = ReplServerStartMsg.addByteArray(byteDegradedStatusThreshold, resultByteArray, pos);
        pos = ReplServerStartMsg.addByteArray(byteServerState, resultByteArray, pos);
        return resultByteArray;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public boolean getSSLEncryption() {
        return this.sslEncryption;
    }

    public int getDegradedStatusThreshold() {
        return this.degradedStatusThreshold;
    }

    public void setDegradedStatusThreshold(int degradedStatusThreshold) {
        this.degradedStatusThreshold = degradedStatusThreshold;
    }

    public String toString() {
        return "ReplServerStartMsg content: \nprotocolVersion: " + this.protocolVersion + "\ngenerationId: " + this.generationId + "\nbaseDn: " + this.baseDn + "\ngroupId: " + this.groupId + "\nserverId: " + this.serverId + "\nserverState: " + this.serverState + "\nserverURL: " + this.serverURL + "\nsslEncryption: " + this.sslEncryption + "\ndegradedStatusThreshold: " + this.degradedStatusThreshold + "\nwindowSize: " + this.windowSize;
    }

    public byte[] getBytes_V1() throws UnsupportedEncodingException {
        try {
            byte[] byteDn = this.baseDn.getBytes("UTF-8");
            byte[] byteServerId = String.valueOf(this.serverId).getBytes("UTF-8");
            byte[] byteServerUrl = this.serverURL.getBytes("UTF-8");
            byte[] byteServerState = this.serverState.getBytes();
            byte[] byteWindowSize = String.valueOf(this.windowSize).getBytes("UTF-8");
            byte[] byteSSLEncryption = String.valueOf(this.sslEncryption).getBytes("UTF-8");
            int length = byteDn.length + 1 + byteServerId.length + 1 + byteServerUrl.length + 1 + byteWindowSize.length + 1 + byteSSLEncryption.length + 1 + byteServerState.length + 1;
            byte[] resultByteArray = this.encodeHeader_V1((byte)7, length);
            int pos = this.headerLength;
            pos = ReplServerStartMsg.addByteArray(byteDn, resultByteArray, pos);
            pos = ReplServerStartMsg.addByteArray(byteServerId, resultByteArray, pos);
            pos = ReplServerStartMsg.addByteArray(byteServerUrl, resultByteArray, pos);
            pos = ReplServerStartMsg.addByteArray(byteWindowSize, resultByteArray, pos);
            pos = ReplServerStartMsg.addByteArray(byteSSLEncryption, resultByteArray, pos);
            pos = ReplServerStartMsg.addByteArray(byteServerState, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

