/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.MultiDomainServerState;
import org.opends.server.replication.protocol.LDAPUpdateMsg;
import org.opends.server.replication.protocol.NotSupportedOldVersionPDUException;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.types.DirectoryException;

public class ECLUpdateMsg
extends ReplicationMsg {
    private final LDAPUpdateMsg updateMsg;
    private final String serviceId;
    private MultiDomainServerState cookie;
    private int draftChangeNumber;

    public ECLUpdateMsg(LDAPUpdateMsg update, MultiDomainServerState cookie, String serviceId, int draftChangeNumber) {
        this.cookie = cookie;
        this.serviceId = serviceId;
        this.updateMsg = update;
        this.draftChangeNumber = draftChangeNumber;
    }

    public ECLUpdateMsg(byte[] in) throws DataFormatException, UnsupportedEncodingException, NotSupportedOldVersionPDUException {
        try {
            if (in[0] != 32) {
                throw new DataFormatException("byte[] is not a valid " + this.getClass().getCanonicalName());
            }
            int pos = 1;
            int length = ECLUpdateMsg.getNextLength(in, pos);
            String cookieStr = new String(in, pos, length, "UTF-8");
            this.cookie = new MultiDomainServerState(cookieStr);
            pos += length + 1;
            length = ECLUpdateMsg.getNextLength(in, pos);
            this.serviceId = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = ECLUpdateMsg.getNextLength(in, pos);
            this.draftChangeNumber = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = in.length - pos - 1;
            byte[] encodedMsg = new byte[length];
            System.arraycopy(in, pos, encodedMsg, 0, length);
            ReplicationMsg rmsg = ReplicationMsg.generateMsg(encodedMsg, ProtocolVersion.getCurrentVersion());
            this.updateMsg = (LDAPUpdateMsg)rmsg;
        }
        catch (DirectoryException de) {
            throw new DataFormatException(de.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public MultiDomainServerState getCookie() {
        return this.cookie;
    }

    public void setCookie(MultiDomainServerState cookie) {
        this.cookie = cookie;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public UpdateMsg getUpdateMsg() {
        return this.updateMsg;
    }

    public String toString() {
        return "ECLUpdateMsg:[ updateMsg: " + this.updateMsg + " cookie: " + this.cookie + " draftChangeNumber: " + this.draftChangeNumber + " serviceId: " + this.serviceId + "]";
    }

    @Override
    public byte[] getBytes(short protocolVersion) throws UnsupportedEncodingException {
        byte[] byteCookie = String.valueOf(this.cookie).getBytes("UTF-8");
        byte[] byteServiceId = String.valueOf(this.serviceId).getBytes("UTF-8");
        byte[] byteDraftChangeNumber = Integer.toString(this.draftChangeNumber).getBytes("UTF-8");
        byte[] byteUpdateMsg = this.updateMsg.getBytes(protocolVersion);
        int length = 1 + byteCookie.length + 1 + byteServiceId.length + 1 + byteDraftChangeNumber.length + 1 + byteUpdateMsg.length + 1;
        byte[] resultByteArray = new byte[length];
        resultByteArray[0] = 32;
        int pos = 1;
        pos = ECLUpdateMsg.addByteArray(byteCookie, resultByteArray, pos);
        pos = ECLUpdateMsg.addByteArray(byteServiceId, resultByteArray, pos);
        pos = ECLUpdateMsg.addByteArray(byteDraftChangeNumber, resultByteArray, pos);
        pos = ECLUpdateMsg.addByteArray(byteUpdateMsg, resultByteArray, pos);
        return resultByteArray;
    }

    public void setDraftChangeNumber(int draftChangeNumber) {
        this.draftChangeNumber = draftChangeNumber;
    }

    public int getDraftChangeNumber() {
        return this.draftChangeNumber;
    }
}

