/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.ReplicationMsg;

public class ChangeStatusMsg
extends ReplicationMsg {
    private ServerStatus requestedStatus = ServerStatus.INVALID_STATUS;
    private ServerStatus newStatus = ServerStatus.INVALID_STATUS;

    public ChangeStatusMsg(ServerStatus requestedStatus, ServerStatus newStatus) {
        this.requestedStatus = requestedStatus;
        this.newStatus = newStatus;
    }

    public ChangeStatusMsg(byte[] encodedMsg) throws DataFormatException {
        if (encodedMsg[0] != 28) {
            throw new DataFormatException("byte[] is not a valid msg");
        }
        try {
            this.requestedStatus = ServerStatus.valueOf(encodedMsg[1]);
            this.newStatus = ServerStatus.valueOf(encodedMsg[2]);
        }
        catch (IllegalArgumentException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    @Override
    public byte[] getBytes(short protocolVersion) {
        byte[] encodedMsg = new byte[]{28, this.requestedStatus.getValue(), this.newStatus.getValue()};
        return encodedMsg;
    }

    public ServerStatus getRequestedStatus() {
        return this.requestedStatus;
    }

    public ServerStatus getNewStatus() {
        return this.newStatus;
    }

    public String toString() {
        return "ChangeStatusMsg content:\nnewStatus: " + (Object)((Object)this.newStatus) + "\nrequestedStatus: " + (Object)((Object)this.requestedStatus);
    }
}

