/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DataFormatException;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.Severity;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.ReplicationDomainCfgDefn;
import org.opends.server.admin.std.server.ExternalChangelogDomainCfg;
import org.opends.server.admin.std.server.ReplicationDomainCfg;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.task.Task;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ChangeNumberGenerator;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachineEvent;
import org.opends.server.replication.plugin.EntryHistorical;
import org.opends.server.replication.plugin.ExternalChangelogDomain;
import org.opends.server.replication.plugin.FakeDelOperation;
import org.opends.server.replication.plugin.FakeOperation;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.replication.plugin.PendingChanges;
import org.opends.server.replication.plugin.PersistentServerState;
import org.opends.server.replication.plugin.RemotePendingChanges;
import org.opends.server.replication.plugin.ReplLDIFOutputStream;
import org.opends.server.replication.plugin.UpdateToReplay;
import org.opends.server.replication.protocol.AddContext;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.DeleteContext;
import org.opends.server.replication.protocol.DeleteMsg;
import org.opends.server.replication.protocol.LDAPUpdateMsg;
import org.opends.server.replication.protocol.ModifyContext;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.ModifyDnContext;
import org.opends.server.replication.protocol.ModifyMsg;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.Session;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.service.ReplicationBroker;
import org.opends.server.replication.service.ReplicationDomain;
import org.opends.server.replication.service.ReplicationMonitor;
import org.opends.server.tasks.PurgeConflictsHistoricalTask;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Operation;
import org.opends.server.types.OperationType;
import org.opends.server.types.RDN;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.types.SynchronizationProviderResult;
import org.opends.server.types.operation.PluginOperation;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostOperationOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;
import org.opends.server.workflowelement.externalchangelog.ECLWorkflowElement;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyOperation;

public final class LDAPReplicationDomain
extends ReplicationDomain
implements ConfigurationChangeListener<ReplicationDomainCfg>,
AlertGenerator {
    private static final String CLASS_NAME = "org.opends.server.replication.plugin.LDAPReplicationDomain";
    public static final String DS_SYNC_CONFLICT = "ds-sync-conflict";
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final BlockingQueue<UpdateToReplay> updateToReplayQueue;
    private final AtomicInteger numResolvedNamingConflicts = new AtomicInteger();
    private final AtomicInteger numResolvedModifyConflicts = new AtomicInteger();
    private final AtomicInteger numUnresolvedNamingConflicts = new AtomicInteger();
    private final PersistentServerState state;
    private int numReplayedPostOpCalled = 0;
    private volatile long generationId = -1L;
    private volatile boolean generationIdSavedStatus = false;
    private final ChangeNumberGenerator generator;
    private final PendingChanges pendingChanges;
    private final RemotePendingChanges remotePendingChanges;
    private final int serverId;
    private final DN baseDn;
    private volatile boolean shutdown = false;
    private final InternalClientConnection conn = InternalClientConnection.getRootConnection();
    private boolean solveConflictFlag = true;
    private volatile boolean disabled = false;
    private volatile boolean stateSavingDisabled = false;
    private final SortedMap<ChangeNumber, FakeOperation> replayOperations = new TreeMap<ChangeNumber, FakeOperation>();
    private ReplicationDomainCfgDefn.IsolationPolicy isolationPolicy;
    private final DN configDn;
    private ExternalChangelogDomain eclDomain;
    private volatile boolean done = true;
    private final ServerStateFlush flushThread;
    private static final String REPLICATION_GENERATION_ID = "ds-sync-generation-id";
    public static final String REPLICATION_FRACTIONAL_INCLUDE = "ds-sync-fractional-include";
    public static final String REPLICATION_FRACTIONAL_EXCLUDE = "ds-sync-fractional-exclude";
    private FractionalConfig fractionalConfig = null;
    private static final String[] FRACTIONAL_PROHIBITED_ATTRIBUTES = new String[]{"objectClass", "2.5.4.0"};
    private boolean forceBadDataSet = false;
    private boolean followImport = true;
    private int importErrorMessageId = -1;
    public static final int IMPORT_ERROR_MESSAGE_BAD_REMOTE = 1;
    public static final int IMPORT_ERROR_MESSAGE_REMOTE_IS_FRACTIONAL = 2;
    private static final int FRACTIONAL_HAS_FRACTIONAL_FILTERED_ATTRIBUTES = 1;
    private static final int FRACTIONAL_HAS_NO_FRACTIONAL_FILTERED_ATTRIBUTES = 2;
    private static final int FRACTIONAL_BECOME_NO_OP = 3;
    private boolean logChangeNumber = false;
    private long histPurgeDelayInMilliSec = 0L;
    private ChangeNumber lastChangeNumberPurgedFromHist = new ChangeNumber(0L, 0, 0);

    public LDAPReplicationDomain(ReplicationDomainCfg configuration, BlockingQueue<UpdateToReplay> updateToReplayQueue) throws ConfigException {
        super(configuration.getBaseDN().toNormalizedString(), configuration.getServerId(), configuration.getInitializationWindowSize());
        SortedSet<String> replicationServers = configuration.getReplicationServer();
        this.serverId = configuration.getServerId();
        this.baseDn = configuration.getBaseDN();
        int window = configuration.getWindowSize();
        long heartbeatInterval = configuration.getHeartbeatInterval();
        this.isolationPolicy = configuration.getIsolationPolicy();
        this.configDn = configuration.dn();
        this.logChangeNumber = configuration.isLogChangenumber();
        this.updateToReplayQueue = updateToReplayQueue;
        this.histPurgeDelayInMilliSec = configuration.getConflictsHistoricalPurgeDelay() * 60L * 1000L;
        this.readAssuredConfig(configuration, false);
        this.fractionalConfig = new FractionalConfig(this.baseDn);
        this.readFractionalConfig(configuration, false);
        this.setGroupId((byte)configuration.getGroupId());
        this.setURLs(configuration.getReferralsUrl());
        this.storeECLConfiguration(configuration);
        this.solveConflictFlag = this.baseDn.compareTo(DirectoryServer.getSchemaDN()) == 0 ? false : configuration.isSolveConflicts();
        Backend backend = LDAPReplicationDomain.retrievesBackend(this.baseDn);
        if (backend == null) {
            throw new ConfigException(ReplicationMessages.ERR_SEARCHING_DOMAIN_BACKEND.get(this.baseDn.toNormalizedString()));
        }
        try {
            this.generationId = this.loadGenerationId();
        }
        catch (DirectoryException e) {
            ErrorLogger.logError(ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toNormalizedString(), e.getLocalizedMessage()));
        }
        this.state = new PersistentServerState(this.baseDn, this.serverId, this.getServerState());
        this.flushThread = new ServerStateFlush();
        this.generator = this.getGenerator();
        this.pendingChanges = new PendingChanges(this.generator, this);
        this.remotePendingChanges = new RemotePendingChanges(this.getServerState());
        configuration.addChangeListener(this);
        DirectoryServer.registerAlertGenerator(this);
        this.startPublishService(replicationServers, window, heartbeatInterval, configuration.getChangetimeHeartbeatInterval());
    }

    private void readAssuredConfig(ReplicationDomainCfg configuration, boolean allowReconnection) {
        boolean needReconnection = false;
        byte newSdLevel = (byte)configuration.getAssuredSdLevel();
        if (this.isAssured() && this.getAssuredMode() == AssuredMode.SAFE_DATA_MODE && newSdLevel != this.getAssuredSdLevel()) {
            needReconnection = true;
        }
        ReplicationDomainCfgDefn.AssuredType newAssuredType = configuration.getAssuredType();
        switch (newAssuredType) {
            case NOT_ASSURED: {
                if (!this.isAssured()) break;
                needReconnection = true;
                break;
            }
            case SAFE_DATA: {
                if (this.isAssured() && this.getAssuredMode() != AssuredMode.SAFE_READ_MODE) break;
                needReconnection = true;
                break;
            }
            case SAFE_READ: {
                if (this.isAssured() && this.getAssuredMode() != AssuredMode.SAFE_DATA_MODE) break;
                needReconnection = true;
            }
        }
        if (needReconnection && allowReconnection) {
            this.disableService();
        }
        switch (newAssuredType) {
            case NOT_ASSURED: {
                this.setAssured(false);
                break;
            }
            case SAFE_DATA: {
                this.setAssured(true);
                this.setAssuredMode(AssuredMode.SAFE_DATA_MODE);
                break;
            }
            case SAFE_READ: {
                this.setAssured(true);
                this.setAssuredMode(AssuredMode.SAFE_READ_MODE);
            }
        }
        this.setAssuredSdLevel(newSdLevel);
        this.setAssuredTimeout(configuration.getAssuredTimeout());
        if (needReconnection && allowReconnection) {
            this.enableService();
        }
    }

    public void setImportErrorMessageId(int importErrorMessageId) {
        this.importErrorMessageId = importErrorMessageId;
    }

    public void setFollowImport(boolean followImport) {
        this.followImport = followImport;
    }

    private void readFractionalConfig(ReplicationDomainCfg configuration, boolean allowReconnection) {
        int newFractionalMode;
        boolean needReconnection;
        FractionalConfig newFractionalConfig;
        try {
            newFractionalConfig = FractionalConfig.toFractionalConfig(configuration);
        }
        catch (ConfigException e) {
            Message message = ReplicationMessages.NOTE_ERR_FRACTIONAL.get(this.baseDn.toString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            return;
        }
        try {
            needReconnection = !FractionalConfig.isFractionalConfigEquivalent(this.fractionalConfig, newFractionalConfig);
        }
        catch (ConfigException e) {
            Message message = ReplicationMessages.NOTE_ERR_FRACTIONAL.get(this.baseDn.toString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            return;
        }
        if (needReconnection && allowReconnection) {
            this.disableService();
        }
        this.fractionalConfig.setFractional((newFractionalMode = newFractionalConfig.fractionalConfigToInt()) != 0);
        if (this.fractionalConfig.isFractional()) {
            this.fractionalConfig.setFractionalExclusive(newFractionalMode == 1);
            this.fractionalConfig.setFractionalSpecificClassesAttributes(newFractionalConfig.getFractionalSpecificClassesAttributes());
            this.fractionalConfig.setFractionalAllClassesAttributes(newFractionalConfig.fractionalAllClassesAttributes);
        } else {
            this.fractionalConfig.setFractionalExclusive(true);
            this.fractionalConfig.setFractionalSpecificClassesAttributes(new HashMap<String, List<String>>());
            this.fractionalConfig.setFractionalAllClassesAttributes(new ArrayList<String>());
        }
        if (needReconnection && allowReconnection) {
            this.enableService();
        }
    }

    private boolean isBackendFractionalConfigConsistent() {
        Attribute inclAttr;
        Attribute exclAttr;
        AttributeType synchronizationGenIDType;
        List<Attribute> attrs;
        LinkedList<SearchResultEntry> result;
        LDAPFilter filter;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Attempt to read the potential fractional config in domain root entry " + this.baseDn.toString());
        }
        ByteString asn1BaseDn = ByteString.valueOf(this.baseDn.toString());
        boolean found = false;
        try {
            filter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException e) {
            return false;
        }
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(1);
        attributes.add(REPLICATION_GENERATION_ID);
        attributes.add(REPLICATION_FRACTIONAL_EXCLUDE);
        attributes.add(REPLICATION_FRACTIONAL_INCLUDE);
        InternalSearchOperation search = this.conn.processSearch(asn1BaseDn, SearchScope.BASE_OBJECT, DereferencePolicy.DEREF_ALWAYS, 0, 0, false, filter, attributes);
        if (search.getResultCode() != ResultCode.SUCCESS && search.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
            Message message = ReplicationMessages.ERR_SEARCHING_GENERATION_ID.get(search.getResultCode().getResultCodeName() + " " + search.getErrorMessage(), this.baseDn.toString());
            ErrorLogger.logError(message);
            return false;
        }
        SearchResultEntry resultEntry = null;
        if (search.getResultCode() == ResultCode.SUCCESS && (resultEntry = (result = search.getSearchEntries()).getFirst()) != null && (attrs = resultEntry.getAttribute(synchronizationGenIDType = DirectoryServer.getAttributeType(REPLICATION_GENERATION_ID))) != null) {
            Attribute attr = attrs.get(0);
            if (attr.size() > 1) {
                Message message = ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toString(), "#Values=" + attr.size() + " Must be exactly 1 in entry " + resultEntry.toLDIFString());
                ErrorLogger.logError(message);
            } else if (attr.size() == 1) {
                found = true;
            }
        }
        if (!found) {
            return !this.fractionalConfig.isFractional();
        }
        AttributeValueStringIterator exclIt = null;
        AttributeType fractionalExcludeType = DirectoryServer.getAttributeType(REPLICATION_FRACTIONAL_EXCLUDE);
        List<Attribute> exclAttrs = resultEntry.getAttribute(fractionalExcludeType);
        if (exclAttrs != null && (exclAttr = exclAttrs.get(0)) != null) {
            exclIt = new AttributeValueStringIterator(exclAttr.iterator());
        }
        AttributeValueStringIterator inclIt = null;
        AttributeType fractionalIncludeType = DirectoryServer.getAttributeType(REPLICATION_FRACTIONAL_INCLUDE);
        List<Attribute> inclAttrs = resultEntry.getAttribute(fractionalIncludeType);
        if (inclAttrs != null && (inclAttr = inclAttrs.get(0)) != null) {
            inclIt = new AttributeValueStringIterator(inclAttr.iterator());
        }
        return LDAPReplicationDomain.isFractionalConfigConsistent(this.fractionalConfig, exclIt, inclIt);
    }

    static boolean isFractionalConfigConsistent(FractionalConfig fractionalConfig, Iterator<String> exclIt, Iterator<String> inclIt) {
        int storedFractionalMode;
        HashMap<String, List<String>> storedFractionalSpecificClassesAttributes = new HashMap<String, List<String>>();
        ArrayList<String> storedFractionalAllClassesAttributes = new ArrayList<String>();
        try {
            storedFractionalMode = FractionalConfig.parseFractionalConfig(exclIt, inclIt, storedFractionalSpecificClassesAttributes, storedFractionalAllClassesAttributes);
        }
        catch (ConfigException e) {
            Message message = ReplicationMessages.NOTE_ERR_FRACTIONAL.get(fractionalConfig.getBaseDn().toString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            return false;
        }
        FractionalConfig storedFractionalConfig = new FractionalConfig(fractionalConfig.getBaseDn());
        storedFractionalConfig.setFractional(storedFractionalMode != 0);
        if (storedFractionalConfig.isFractional()) {
            storedFractionalConfig.setFractionalExclusive(storedFractionalMode == 1);
        }
        storedFractionalConfig.setFractionalSpecificClassesAttributes(storedFractionalSpecificClassesAttributes);
        storedFractionalConfig.setFractionalAllClassesAttributes(storedFractionalAllClassesAttributes);
        try {
            return FractionalConfig.isFractionalConfigEquivalent(fractionalConfig, storedFractionalConfig);
        }
        catch (ConfigException e) {
            Message message = ReplicationMessages.NOTE_ERR_FRACTIONAL.get(fractionalConfig.getBaseDn().toString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            return false;
        }
    }

    private static boolean isAttributeListEquivalent(List<String> attributes1, List<String> attributes2) throws ConfigException {
        if (attributes1.size() != attributes2.size()) {
            return false;
        }
        Schema schema = DirectoryServer.getSchema();
        for (String attributName1 : attributes1) {
            AttributeType attributeType1 = schema.getAttributeType(attributName1);
            if (attributeType1 == null) {
                throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_ATTRIBUTE_TYPE.get(attributName1));
            }
            boolean foundAttribute = false;
            for (String attributName2 : attributes2) {
                AttributeType attributeType2 = schema.getAttributeType(attributName2);
                if (attributeType2 == null) {
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_ATTRIBUTE_TYPE.get(attributName2));
                }
                if (!attributeType1.equals(attributeType2)) continue;
                foundAttribute = true;
                break;
            }
            if (foundAttribute) continue;
            return false;
        }
        return true;
    }

    private static void isFractionalConfigAcceptable(ReplicationDomainCfg configuration) throws ConfigException {
        FractionalConfig newFractionalConfig = FractionalConfig.toFractionalConfig(configuration);
        if (!newFractionalConfig.isFractional()) {
            return;
        }
        Map<String, List<String>> newFractionalSpecificClassesAttributes = newFractionalConfig.getFractionalSpecificClassesAttributes();
        List<String> newFractionalAllClassesAttributes = newFractionalConfig.getFractionalAllClassesAttributes();
        Schema schema = DirectoryServer.getSchema();
        int fractionalMode = newFractionalConfig.fractionalConfigToInt();
        for (String className : newFractionalSpecificClassesAttributes.keySet()) {
            ObjectClass fractionalClass = schema.getObjectClass(className.toLowerCase());
            if (fractionalClass == null) {
                throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_OBJECT_CLASS.get(className));
            }
            boolean isExtensibleObjectClass = className.equalsIgnoreCase("extensibleObject");
            List<String> attributes = newFractionalSpecificClassesAttributes.get(className);
            for (String attrName : attributes) {
                if (LDAPReplicationDomain.isFractionalProhibitedAttr(attrName)) {
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_PROHIBITED_ATTRIBUTE.get(attrName));
                }
                AttributeType attributeType = schema.getAttributeType(attrName);
                if (attributeType != null) {
                    if (isExtensibleObjectClass || fractionalMode != 1 || fractionalClass.isOptional(attributeType)) continue;
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_NOT_OPTIONAL_ATTRIBUTE.get(attrName, className));
                }
                throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_ATTRIBUTE_TYPE.get(attrName));
            }
        }
        for (String attrName : newFractionalAllClassesAttributes) {
            if (LDAPReplicationDomain.isFractionalProhibitedAttr(attrName)) {
                throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_PROHIBITED_ATTRIBUTE.get(attrName));
            }
            if (schema.getAttributeType(attrName) != null) continue;
            throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_ATTRIBUTE_TYPE.get(attrName));
        }
    }

    private static boolean isFractionalProhibitedAttr(String attr) {
        for (String forbiddenAttr : FRACTIONAL_PROHIBITED_ATTRIBUTES) {
            if (!forbiddenAttr.equalsIgnoreCase(attr)) continue;
            return true;
        }
        return false;
    }

    public boolean fractionalFilterOperation(PreOperationAddOperation addOperation, boolean performFiltering) {
        return LDAPReplicationDomain.fractionalRemoveAttributesFromEntry(this.fractionalConfig, addOperation.getEntryDN().getRDN(), addOperation.getObjectClasses(), addOperation.getUserAttributes(), performFiltering);
    }

    public boolean fractionalFilterOperation(PreOperationModifyDNOperation modifyDNOperation, boolean performFiltering) {
        boolean inconsistentOperation = false;
        if (performFiltering && modifyDNOperation.deleteOldRDN()) {
            return true;
        }
        Entry concernedEntry = modifyDNOperation.getOriginalEntry();
        List<String> fractionalConcernedAttributes = LDAPReplicationDomain.createFractionalConcernedAttrList(this.fractionalConfig, concernedEntry.getObjectClasses().keySet());
        boolean fractionalExclusive = this.fractionalConfig.isFractionalExclusive();
        if (fractionalExclusive && fractionalConcernedAttributes.isEmpty()) {
            return false;
        }
        RDN rdn = modifyDNOperation.getEntryDN().getRDN();
        RDN newRdn = modifyDNOperation.getNewRDN();
        for (int i = 0; i < rdn.getNumValues(); ++i) {
            boolean attributeToBeFiltered;
            AttributeType attributeType = rdn.getAttributeType(i);
            boolean found = false;
            for (String attrTypeStr : fractionalConcernedAttributes) {
                AttributeType attributeTypeFromList = DirectoryServer.getAttributeType(attrTypeStr);
                if (!attributeTypeFromList.equals(attributeType)) continue;
                found = true;
                break;
            }
            boolean bl = attributeToBeFiltered = fractionalExclusive && found || !fractionalExclusive && !found;
            if (!attributeToBeFiltered || newRdn.hasAttributeType(attributeType) || modifyDNOperation.deleteOldRDN()) continue;
            Modification modification = new Modification(ModificationType.DELETE, Attributes.empty(attributeType));
            modifyDNOperation.addModification(modification);
            inconsistentOperation = true;
        }
        return inconsistentOperation;
    }

    static boolean fractionalRemoveAttributesFromEntry(FractionalConfig fractionalConfig, RDN entryRdn, Map<ObjectClass, String> classes, Map<AttributeType, List<Attribute>> attributesMap, boolean performFiltering) {
        boolean hasSomeAttributesToFilter = false;
        List<String> fractionalConcernedAttributes = LDAPReplicationDomain.createFractionalConcernedAttrList(fractionalConfig, classes.keySet());
        boolean fractionalExclusive = fractionalConfig.isFractionalExclusive();
        if (fractionalExclusive && fractionalConcernedAttributes.isEmpty()) {
            return false;
        }
        Set<ObjectClass> entryClasses = classes.keySet();
        Iterator<AttributeType> attributeTypes = attributesMap.keySet().iterator();
        ArrayList newRdnAttrLists = new ArrayList();
        ArrayList<AttributeType> rdnAttrTypes = new ArrayList<AttributeType>();
        while (attributeTypes.hasNext()) {
            AttributeType attributeType = attributeTypes.next();
            boolean isMandatoryAttribute = false;
            for (ObjectClass objectClass : entryClasses) {
                if (!objectClass.isRequired(attributeType)) continue;
                isMandatoryAttribute = true;
                break;
            }
            if (isMandatoryAttribute) continue;
            String attributeName = attributeType.getPrimaryName();
            String attributeOid = attributeType.getOID();
            if (attributeName != null && LDAPReplicationDomain.isFractionalProhibitedAttr(attributeName) || LDAPReplicationDomain.isFractionalProhibitedAttr(attributeOid)) continue;
            boolean foundAttribute = fractionalConcernedAttributes.contains(attributeName.toLowerCase());
            if (!foundAttribute) {
                foundAttribute = fractionalConcernedAttributes.contains(attributeOid);
            }
            if ((!foundAttribute || !fractionalExclusive) && (foundAttribute || fractionalExclusive)) continue;
            if (performFiltering) {
                if (entryRdn.hasAttributeType(attributeType)) {
                    AttributeValue rdnAttributeValue = entryRdn.getAttributeValue(attributeType);
                    List<Attribute> attrList = attributesMap.get(attributeType);
                    AttributeValue sameAttrValue = null;
                    for (Attribute attr : attrList) {
                        if (attr.contains(rdnAttributeValue)) {
                            for (AttributeValue attrValue : attr) {
                                if (rdnAttributeValue.equals(attrValue)) {
                                    sameAttrValue = attrValue;
                                    continue;
                                }
                                hasSomeAttributesToFilter = true;
                            }
                            continue;
                        }
                        hasSomeAttributesToFilter = true;
                    }
                    if (sameAttrValue == null) continue;
                    ArrayList<Attribute> newRdnAttrList = new ArrayList<Attribute>();
                    AttributeBuilder attrBuilder = new AttributeBuilder(attributeType);
                    attrBuilder.add(sameAttrValue);
                    newRdnAttrList.add(attrBuilder.toAttribute());
                    newRdnAttrLists.add(newRdnAttrList);
                    rdnAttrTypes.add(attributeType);
                    continue;
                }
                attributeTypes.remove();
                hasSomeAttributesToFilter = true;
                continue;
            }
            return true;
        }
        for (int index = 0; index < rdnAttrTypes.size(); ++index) {
            attributesMap.put((AttributeType)rdnAttrTypes.get(index), (List<Attribute>)newRdnAttrLists.get(index));
        }
        return hasSomeAttributesToFilter;
    }

    private static List<String> createFractionalConcernedAttrList(FractionalConfig fractionalConfig, Set<ObjectClass> entryObjectClasses) {
        ArrayList<String> fractionalConcernedAttributes = new ArrayList<String>();
        List<String> fractionalAllClassesAttributes = fractionalConfig.getFractionalAllClassesAttributes();
        Map<String, List<String>> fractionalSpecificClassesAttributes = fractionalConfig.getFractionalSpecificClassesAttributes();
        Set<String> fractionalClasses = fractionalSpecificClassesAttributes.keySet();
        for (ObjectClass entryObjectClass : entryObjectClasses) {
            for (String fractionalClass : fractionalClasses) {
                if (!entryObjectClass.hasNameOrOID(fractionalClass.toLowerCase())) continue;
                List<String> attrList = fractionalSpecificClassesAttributes.get(fractionalClass);
                for (String attr : attrList) {
                    if (fractionalConcernedAttributes.contains(attr)) continue;
                    fractionalConcernedAttributes.add(attr);
                }
            }
        }
        for (String attr : fractionalAllClassesAttributes) {
            if (fractionalConcernedAttributes.contains(attr)) continue;
            fractionalConcernedAttributes.add(attr);
        }
        return fractionalConcernedAttributes;
    }

    public int fractionalFilterOperation(PreOperationModifyOperation modifyOperation, boolean performFiltering) {
        Entry entryToModify;
        int result = 2;
        Entry modifiedEntry = modifyOperation.getCurrentEntry();
        List<String> fractionalConcernedAttributes = LDAPReplicationDomain.createFractionalConcernedAttrList(this.fractionalConfig, modifiedEntry.getObjectClasses().keySet());
        boolean fractionalExclusive = this.fractionalConfig.isFractionalExclusive();
        if (fractionalExclusive && fractionalConcernedAttributes.isEmpty()) {
            return 2;
        }
        DN entryToModifyDn = modifyOperation.getEntryDN();
        try {
            entryToModify = DirectoryServer.getEntry(entryToModifyDn);
        }
        catch (DirectoryException e) {
            Message message = ReplicationMessages.NOTE_ERR_FRACTIONAL.get(this.baseDn.toString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            return 2;
        }
        Set<ObjectClass> entryClasses = entryToModify.getObjectClasses().keySet();
        List<Modification> mods = modifyOperation.getModifications();
        Iterator<Modification> modsIt = mods.iterator();
        while (modsIt.hasNext()) {
            boolean foundAttribute;
            Modification mod = modsIt.next();
            Attribute attr = mod.getAttribute();
            AttributeType attrType = attr.getAttributeType();
            if (attrType.isOperational()) continue;
            boolean isMandatoryAttribute = false;
            for (ObjectClass objectClass : entryClasses) {
                if (!objectClass.isRequired(attrType)) continue;
                isMandatoryAttribute = true;
                break;
            }
            if (isMandatoryAttribute) continue;
            String attributeName = attrType.getPrimaryName();
            String attributeOid = attrType.getOID();
            if (attributeName != null && LDAPReplicationDomain.isFractionalProhibitedAttr(attributeName) || LDAPReplicationDomain.isFractionalProhibitedAttr(attributeOid)) continue;
            boolean bl = foundAttribute = attributeName != null && fractionalConcernedAttributes.contains(attributeName.toLowerCase());
            if (!foundAttribute) {
                foundAttribute = fractionalConcernedAttributes.contains(attributeOid);
            }
            if ((!foundAttribute || !fractionalExclusive) && (foundAttribute || fractionalExclusive)) continue;
            if (performFiltering) {
                modsIt.remove();
                result = 1;
                if (!mods.isEmpty()) continue;
                return 3;
            }
            return 1;
        }
        return result;
    }

    @Override
    protected byte[] receiveEntryBytes() {
        if (this.followImport) {
            return super.receiveEntryBytes();
        }
        Message msg = null;
        switch (this.importErrorMessageId) {
            case 1: {
                msg = ReplicationMessages.NOTE_ERR_FULL_UPDATE_IMPORT_FRACTIONAL_BAD_REMOTE.get(this.baseDn.toString(), Integer.toString(this.ieContext.getImportSource()));
                break;
            }
            case 2: {
                msg = ReplicationMessages.NOTE_ERR_FULL_UPDATE_IMPORT_FRACTIONAL_REMOTE_IS_FRACTIONAL.get(this.baseDn.toString(), Integer.toString(this.ieContext.getImportSource()));
            }
        }
        this.ieContext.setException(new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg));
        return null;
    }

    @Override
    protected void initializeRemote(int target, int requestorID, Task initTask, int initWindow) throws DirectoryException {
        if (target == -2 && this.fractionalConfig.isFractional()) {
            Message msg = ReplicationMessages.NOTE_ERR_FRACTIONAL_FORBIDDEN_FULL_UPDATE_FRACTIONAL.get(this.baseDn.toString(), Integer.toString(this.getServerId()));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        super.initializeRemote(target, requestorID, initTask, this.initWindow);
    }

    public DN getBaseDN() {
        return this.baseDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizationProviderResult handleConflictResolution(PreOperationDeleteOperation deleteOperation) {
        if (!deleteOperation.isSynchronizationOperation() && !this.brokerIsConnected()) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        DeleteContext ctx = (DeleteContext)deleteOperation.getAttachment("replicationContext");
        Entry deletedEntry = deleteOperation.getEntryToDelete();
        if (ctx != null) {
            String modifiedEntryUUID;
            String operationEntryUUID = ctx.getEntryUUID();
            if (!operationEntryUUID.equals(modifiedEntryUUID = EntryHistorical.getEntryUUID(deletedEntry))) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
        } else {
            ChangeNumber changeNumber = this.generateChangeNumber(deleteOperation);
            String modifiedEntryUUID = EntryHistorical.getEntryUUID(deletedEntry);
            ctx = new DeleteContext(changeNumber, modifiedEntryUUID);
            deleteOperation.setAttachment("replicationContext", ctx);
            SortedMap<ChangeNumber, FakeOperation> sortedMap = this.replayOperations;
            synchronized (sortedMap) {
                int size = this.replayOperations.size();
                if (size >= 10000) {
                    this.replayOperations.remove(this.replayOperations.firstKey());
                }
                this.replayOperations.put(changeNumber, new FakeDelOperation(deleteOperation.getEntryDN().toString(), changeNumber, modifiedEntryUUID));
            }
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationAddOperation addOperation) {
        if (!addOperation.isSynchronizationOperation() && !this.brokerIsConnected()) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        if (this.fractionalConfig.isFractional()) {
            if (addOperation.isSynchronizationOperation()) {
                this.fractionalFilterOperation(addOperation, true);
            } else if (this.fractionalFilterOperation(addOperation, false)) {
                StringBuilder sb = new StringBuilder();
                addOperation.toString(sb);
                Message msg = ReplicationMessages.NOTE_ERR_FRACTIONAL_FORBIDDEN_OPERATION.get(this.baseDn.toString(), sb.toString());
                return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
            }
        }
        if (addOperation.isSynchronizationOperation()) {
            AddContext ctx = (AddContext)addOperation.getAttachment("replicationContext");
            String uuid = ctx.getEntryUUID();
            if (this.findEntryDN(uuid) != null) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_OPERATION, null);
            }
            String parentEntryUUID = ctx.getParentEntryUUID();
            if (parentEntryUUID != null) {
                DN parentDnFromCtx = this.findEntryDN(ctx.getParentEntryUUID());
                if (parentDnFromCtx == null) {
                    return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
                }
                DN entryDN = addOperation.getEntryDN();
                DN parentDnFromEntryDn = entryDN.getParentDNInSuffix();
                if (parentDnFromEntryDn != null && !parentDnFromCtx.equals(parentDnFromEntryDn)) {
                    return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
                }
            }
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    private boolean brokerIsConnected() {
        if (this.isolationPolicy.equals((Object)ReplicationDomainCfgDefn.IsolationPolicy.ACCEPT_ALL_UPDATES)) {
            return true;
        }
        if (this.isolationPolicy.equals((Object)ReplicationDomainCfgDefn.IsolationPolicy.REJECT_ALL_UPDATES)) {
            return !this.hasConnectionError();
        }
        return true;
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyDNOperation modifyDNOperation) {
        ModifyDnContext ctx;
        if (!modifyDNOperation.isSynchronizationOperation() && !this.brokerIsConnected()) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        if (this.fractionalConfig.isFractional()) {
            if (modifyDNOperation.isSynchronizationOperation()) {
                this.fractionalFilterOperation(modifyDNOperation, true);
            } else if (this.fractionalFilterOperation(modifyDNOperation, false)) {
                StringBuilder sb = new StringBuilder();
                modifyDNOperation.toString(sb);
                Message msg = ReplicationMessages.NOTE_ERR_FRACTIONAL_FORBIDDEN_OPERATION.get(this.baseDn.toString(), sb.toString());
                return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
            }
        }
        if ((ctx = (ModifyDnContext)modifyDNOperation.getAttachment("replicationContext")) != null) {
            String newParentId;
            String modifiedEntryUUID = EntryHistorical.getEntryUUID(modifyDNOperation.getOriginalEntry());
            if (!modifiedEntryUUID.equals(ctx.getEntryUUID())) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
            if (modifyDNOperation.getNewSuperior() != null && (newParentId = LDAPReplicationDomain.findEntryUUID(modifyDNOperation.getNewSuperior())) != null && ctx.getNewSuperiorEntryUUID() != null && !newParentId.equals(ctx.getNewSuperiorEntryUUID())) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
            EntryHistorical hist = EntryHistorical.newInstanceFromEntry(modifyDNOperation.getOriginalEntry());
            if (hist.addedOrRenamedAfter(ctx.getChangeNumber())) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_OPERATION, null);
            }
        } else {
            ChangeNumber changeNumber = this.generateChangeNumber(modifyDNOperation);
            String newParentId = null;
            if (modifyDNOperation.getNewSuperior() != null) {
                newParentId = LDAPReplicationDomain.findEntryUUID(modifyDNOperation.getNewSuperior());
            }
            Entry modifiedEntry = modifyDNOperation.getOriginalEntry();
            String modifiedEntryUUID = EntryHistorical.getEntryUUID(modifiedEntry);
            ctx = new ModifyDnContext(changeNumber, modifiedEntryUUID, newParentId);
            modifyDNOperation.setAttachment("replicationContext", ctx);
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyOperation modifyOperation) {
        if (!modifyOperation.isSynchronizationOperation() && !this.brokerIsConnected()) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        if (this.fractionalConfig.isFractional()) {
            if (modifyOperation.isSynchronizationOperation()) {
                if (this.fractionalFilterOperation(modifyOperation, true) == 3) {
                    return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_OPERATION, null);
                }
            } else {
                switch (this.fractionalFilterOperation(modifyOperation, false)) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        StringBuilder sb = new StringBuilder();
                        modifyOperation.toString(sb);
                        Message msg = ReplicationMessages.NOTE_ERR_FRACTIONAL_FORBIDDEN_OPERATION.get(this.baseDn.toString(), sb.toString());
                        return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
                    }
                }
            }
        }
        ModifyContext ctx = (ModifyContext)modifyOperation.getAttachment("replicationContext");
        Entry modifiedEntry = modifyOperation.getModifiedEntry();
        if (ctx == null) {
            ChangeNumber changeNumber = this.generateChangeNumber(modifyOperation);
            String modifiedEntryUUID = EntryHistorical.getEntryUUID(modifiedEntry);
            ctx = new ModifyContext(changeNumber, modifiedEntryUUID);
            modifyOperation.setAttachment("replicationContext", ctx);
        } else {
            String modifiedEntryUUID = ctx.getEntryUUID();
            String currentEntryUUID = EntryHistorical.getEntryUUID(modifiedEntry);
            if (currentEntryUUID != null && !currentEntryUUID.equals(modifiedEntryUUID)) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
            EntryHistorical historicalInformation = EntryHistorical.newInstanceFromEntry(modifiedEntry);
            modifyOperation.setAttachment("ds-synch-historical", historicalInformation);
            if (historicalInformation.replayOperation(modifyOperation, modifiedEntry)) {
                this.numResolvedModifyConflicts.incrementAndGet();
            }
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public void doPreOperation(PreOperationAddOperation addOperation) {
        AddContext ctx = new AddContext(this.generateChangeNumber(addOperation), EntryHistorical.getEntryUUID(addOperation), LDAPReplicationDomain.findEntryUUID(addOperation.getEntryDN().getParentDNInSuffix()));
        addOperation.setAttachment("replicationContext", ctx);
    }

    public void synchronize(PostOperationOperation op) {
        ResultCode result = op.getResultCode();
        if (result == ResultCode.SUCCESS && op.isSynchronizationOperation()) {
            ++this.numReplayedPostOpCalled;
        }
        LDAPUpdateMsg msg = null;
        ChangeNumber curChangeNumber = OperationContext.getChangeNumber(op);
        if (curChangeNumber != null && this.logChangeNumber) {
            op.addAdditionalLogItem(AdditionalLogItem.unquotedKeyValue(this.getClass(), "replicationCN", curChangeNumber));
        }
        if (result == ResultCode.SUCCESS && !op.isSynchronizationOperation() && (msg = LDAPUpdateMsg.generateMsg(op)) == null) {
            this.pendingChanges.remove(curChangeNumber);
            Message message = ReplicationMessages.ERR_UNKNOWN_TYPE.get(op.getOperationType().toString());
            ErrorLogger.logError(message);
            return;
        }
        if (result == ResultCode.SUCCESS) {
            block18: {
                try {
                    if (op.isSynchronizationOperation()) {
                        this.remotePendingChanges.commit(curChangeNumber);
                        break block18;
                    }
                    try {
                        this.addEntryAttributesForCL(msg, op);
                    }
                    catch (Exception e) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    this.prepareWaitForAckIfAssuredEnabled(msg);
                    try {
                        msg.encode();
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    this.pendingChanges.commitAndPushCommittedChanges(curChangeNumber, msg);
                }
                catch (NoSuchElementException e) {
                    Message message = ReplicationMessages.ERR_OPERATION_NOT_FOUND_IN_PENDING.get(op.toString(), curChangeNumber.toString());
                    ErrorLogger.logError(message);
                    return;
                }
            }
            if (op.getOperationType().equals((Object)OperationType.DELETE) && ((PostOperationDeleteOperation)op).getEntryDN().equals(this.baseDn)) {
                this.generationIdSavedStatus = false;
            }
            if (!this.generationIdSavedStatus) {
                this.saveGenerationId(this.generationId);
            }
            if (!op.isSynchronizationOperation()) {
                try {
                    this.waitForAckIfAssuredEnabled(msg);
                }
                catch (TimeoutException ex) {
                    Message errorMsg = ReplicationMessages.NOTE_DS_ACK_TIMEOUT.get(this.getServiceID(), Long.toString(this.getAssuredTimeout()), msg.toString());
                    ErrorLogger.logError(errorMsg);
                }
            }
        } else if (!op.isSynchronizationOperation() && curChangeNumber != null) {
            this.pendingChanges.remove(curChangeNumber);
            this.pendingChanges.pushCommittedChanges();
        }
        this.checkForClearedConflict(op);
    }

    private void checkForClearedConflict(PostOperationOperation op) {
        DN entryDN;
        ModifyDNOperationBasis newOp;
        ResultCode res;
        DN freedDN;
        OperationType type = op.getOperationType();
        if (op.getResultCode() != ResultCode.SUCCESS) {
            return;
        }
        if (type == OperationType.DELETE) {
            freedDN = ((PostOperationDeleteOperation)op).getEntryDN();
        } else if (type == OperationType.MODIFY_DN) {
            freedDN = ((PostOperationModifyDNOperation)op).getEntryDN();
        } else {
            return;
        }
        LDAPFilter filter = LDAPFilter.createEqualityFilter(DS_SYNC_CONFLICT, ByteString.valueOf(freedDN.toString()));
        LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
        attrs.add("ds-sync-hist");
        attrs.add("entryuuid");
        attrs.add("*");
        InternalSearchOperation searchOp = this.conn.processSearch(ByteString.valueOf(this.baseDn.toString()), SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, attrs, null);
        LinkedList<SearchResultEntry> entries = searchOp.getSearchEntries();
        Entry entryToRename = null;
        ChangeNumber entryToRenameCN = null;
        for (SearchResultEntry entry : entries) {
            EntryHistorical history = EntryHistorical.newInstanceFromEntry(entry);
            if (entryToRename == null) {
                entryToRename = entry;
                entryToRenameCN = history.getDNDate();
                continue;
            }
            if (history.addedOrRenamedAfter(entryToRenameCN)) continue;
            entryToRename = entry;
            entryToRenameCN = history.getDNDate();
        }
        if (entryToRename != null && (res = (newOp = this.renameEntry(entryDN = entryToRename.getDN(), freedDN.getRDN(), freedDN.getParent(), false)).getResultCode()) != ResultCode.SUCCESS) {
            Message message = ReplicationMessages.ERR_COULD_NOT_SOLVE_CONFLICT.get(entryDN.toString(), res.toString());
            ErrorLogger.logError(message);
        }
    }

    private ModifyDNOperationBasis renameEntry(DN targetDN, RDN newRDN, DN parentDN, boolean markConflict) {
        ModifyDNOperationBasis newOp = new ModifyDNOperationBasis((ClientConnection)this.conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), targetDN, newRDN, false, parentDN);
        newOp.setInternalOperation(true);
        newOp.setSynchronizationOperation(true);
        newOp.setDontSynchronize(true);
        if (markConflict) {
            AttributeType attrType = DirectoryServer.getAttributeType(DS_SYNC_CONFLICT, true);
            Attribute attr = Attributes.create(attrType, AttributeValues.create(attrType, targetDN.toNormalizedString()));
            Modification mod = new Modification(ModificationType.REPLACE, attr);
            newOp.addModification(mod);
        } else {
            AttributeType attrType = DirectoryServer.getAttributeType(DS_SYNC_CONFLICT, true);
            Attribute attr = Attributes.empty(attrType);
            Modification mod = new Modification(ModificationType.DELETE, attr);
            newOp.addModification(mod);
        }
        newOp.run();
        return newOp;
    }

    public int getPendingUpdatesCount() {
        if (this.pendingChanges != null) {
            return this.pendingChanges.size();
        }
        return 0;
    }

    public int getNumReplayedPostOpCalled() {
        return this.numReplayedPostOpCalled;
    }

    public void delete() {
        this.shutdown();
        this.removeECLDomainCfg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            if (this.flushThread != null) {
                ServerStateFlush serverStateFlush = this.flushThread;
                synchronized (serverStateFlush) {
                    this.flushThread.notify();
                }
            }
            DirectoryServer.deregisterAlertGenerator(this);
            this.stopDomain();
        }
        try {
            while (!this.done) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(LDAPUpdateMsg msg, AtomicBoolean shutdown) {
        Operation op = null;
        boolean replayDone = false;
        boolean dependency = false;
        ChangeNumber changeNumber = null;
        int retryCount = 10;
        do {
            String replayErrorMsg = null;
            try {
                op = msg.createOperation(this.conn);
                dependency = this.remotePendingChanges.checkDependencies(op, msg);
                while (!dependency && !replayDone && retryCount-- > 0) {
                    if (shutdown.get()) {
                        return;
                    }
                    op.setInternalOperation(true);
                    op.setSynchronizationOperation(true);
                    op.addRequestControl(new LDAPControl("2.16.840.1.113730.3.4.2"));
                    changeNumber = OperationContext.getChangeNumber(op);
                    op.run();
                    ResultCode result = op.getResultCode();
                    if (result != ResultCode.SUCCESS) {
                        if (result == ResultCode.NO_OPERATION) {
                            replayDone = true;
                        } else {
                            Operation newOp;
                            if (result == ResultCode.BUSY) {
                                Thread.yield();
                                continue;
                            }
                            if (result == ResultCode.UNAVAILABLE) {
                                Thread.sleep(50L);
                                continue;
                            }
                            if (op instanceof ModifyOperation) {
                                newOp = (ModifyOperation)op;
                                dependency = this.remotePendingChanges.checkDependencies((ModifyOperation)newOp);
                                ModifyMsg modifyMsg = (ModifyMsg)msg;
                                replayDone = this.solveNamingConflict((ModifyOperation)newOp, modifyMsg);
                            } else if (op instanceof DeleteOperation) {
                                newOp = (DeleteOperation)op;
                                dependency = this.remotePendingChanges.checkDependencies((DeleteOperation)newOp);
                                replayDone = this.solveNamingConflict((DeleteOperation)newOp, msg);
                            } else if (op instanceof AddOperation) {
                                newOp = (AddOperation)op;
                                AddMsg addMsg = (AddMsg)msg;
                                dependency = this.remotePendingChanges.checkDependencies((AddOperation)newOp);
                                replayDone = this.solveNamingConflict((AddOperation)newOp, addMsg);
                            } else if (op instanceof ModifyDNOperationBasis) {
                                newOp = (ModifyDNOperationBasis)op;
                                replayDone = this.solveNamingConflict((ModifyDNOperation)newOp, msg);
                            } else {
                                replayDone = true;
                            }
                        }
                        if (replayDone) {
                            this.updateError(changeNumber);
                            continue;
                        }
                        op = msg.createOperation(this.conn);
                        continue;
                    }
                    replayDone = true;
                }
                if (!replayDone && !dependency) {
                    Message message = ReplicationMessages.ERR_LOOP_REPLAYING_OPERATION.get(op.toString(), op.getErrorMessage().toString());
                    ErrorLogger.logError(message);
                    this.numUnresolvedNamingConflicts.incrementAndGet();
                    replayErrorMsg = message.toString();
                    this.updateError(changeNumber);
                }
            }
            catch (ASN1Exception e) {
                replayErrorMsg = this.logDecodingOperationError(msg, e);
            }
            catch (LDAPException e) {
                replayErrorMsg = this.logDecodingOperationError(msg, e);
            }
            catch (DataFormatException e) {
                replayErrorMsg = this.logDecodingOperationError(msg, e);
            }
            catch (Exception e) {
                if (changeNumber != null) {
                    Message message = ReplicationMessages.ERR_EXCEPTION_REPLAYING_OPERATION.get(StaticUtils.stackTraceToSingleLineString(e), op.toString());
                    ErrorLogger.logError(message);
                    replayErrorMsg = message.toString();
                    this.updateError(changeNumber);
                } else {
                    replayErrorMsg = this.logDecodingOperationError(msg, e);
                }
            }
            finally {
                if (!dependency) {
                    this.processUpdateDone(msg, replayErrorMsg);
                }
            }
            msg = this.remotePendingChanges.getNextUpdate();
            replayDone = false;
            dependency = false;
            changeNumber = null;
            retryCount = 10;
        } while (msg != null);
    }

    private String logDecodingOperationError(LDAPUpdateMsg msg, Exception e) {
        Message message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
        ErrorLogger.logError(message);
        return message.toString();
    }

    public void updateError(ChangeNumber changeNumber) {
        block2: {
            try {
                this.remotePendingChanges.commit(changeNumber);
            }
            catch (NoSuchElementException e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugInfo("LDAPReplicationDomain.updateError: Unable to find remote pending change for change number %s", changeNumber);
            }
        }
    }

    private ChangeNumber generateChangeNumber(PluginOperation operation) {
        return this.pendingChanges.putLocalOperation(operation);
    }

    static String findEntryUUID(DN dn) {
        if (dn == null) {
            return null;
        }
        try {
            SearchResultEntry resultEntry;
            LinkedList<SearchResultEntry> result;
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
            attrs.add("entryuuid");
            InternalSearchOperation search = conn.processSearch(dn, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createFilterFromString("objectclass=*"), attrs);
            if (search.getResultCode() == ResultCode.SUCCESS && !(result = search.getSearchEntries()).isEmpty() && (resultEntry = result.getFirst()) != null) {
                return EntryHistorical.getEntryUUID(resultEntry);
            }
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        return null;
    }

    private DN findEntryDN(String uuid) {
        try {
            SearchResultEntry resultEntry;
            LinkedList<SearchResultEntry> result;
            InternalSearchOperation search = this.conn.processSearch(this.baseDn, SearchScope.WHOLE_SUBTREE, SearchFilter.createFilterFromString("entryuuid=" + uuid));
            if (search.getResultCode() == ResultCode.SUCCESS && !(result = search.getSearchEntries()).isEmpty() && (resultEntry = result.getFirst()) != null) {
                return resultEntry.getDN();
            }
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        return null;
    }

    private boolean solveNamingConflict(ModifyOperation op, ModifyMsg msg) {
        ResultCode result = op.getResultCode();
        ModifyContext ctx = (ModifyContext)op.getAttachment("replicationContext");
        String entryUUID = ctx.getEntryUUID();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            DN newDN = this.findEntryDN(entryUUID);
            if (newDN != null) {
                msg.setDn(newDN.toString());
                this.numResolvedNamingConflicts.incrementAndGet();
                return false;
            }
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        if (result == ResultCode.NOT_ALLOWED_ON_RDN) {
            DN currentDN = this.findEntryDN(entryUUID);
            if (currentDN == null) {
                this.numResolvedNamingConflicts.incrementAndGet();
                return true;
            }
            RDN currentRDN = currentDN.getRDN();
            List<Modification> mods = op.getModifications();
            for (Modification mod : mods) {
                AttributeType modAttrType = mod.getAttribute().getAttributeType();
                if (mod.getModificationType() != ModificationType.DELETE && mod.getModificationType() != ModificationType.REPLACE || !currentRDN.hasAttributeType(modAttrType)) continue;
                mod.setModificationType(ModificationType.REPLACE);
                Attribute newAttribute = mod.getAttribute();
                AttributeBuilder attrBuilder = new AttributeBuilder(newAttribute);
                attrBuilder.add(currentRDN.getAttributeValue(modAttrType));
                mod.setAttribute(attrBuilder.toAttribute());
            }
            msg.setMods(mods);
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(DeleteOperation op, LDAPUpdateMsg msg) {
        ResultCode result = op.getResultCode();
        DeleteContext ctx = (DeleteContext)op.getAttachment("replicationContext");
        String entryUUID = ctx.getEntryUUID();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            DN currentDn = this.findEntryDN(entryUUID);
            if (currentDn == null) {
                this.numResolvedNamingConflicts.incrementAndGet();
                return true;
            }
            msg.setDn(currentDn.toString());
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.NOT_ALLOWED_ON_NONLEAF) {
            if (this.findAndRenameChild(entryUUID, op.getEntryDN(), op)) {
                this.numUnresolvedNamingConflicts.incrementAndGet();
            }
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(ModifyDNOperation op, LDAPUpdateMsg msg) throws Exception {
        ResultCode result = op.getResultCode();
        ModifyDnContext ctx = (ModifyDnContext)op.getAttachment("replicationContext");
        String entryUUID = ctx.getEntryUUID();
        String newSuperiorID = ctx.getNewSuperiorEntryUUID();
        DN currentDN = this.findEntryDN(entryUUID);
        DN entryDN = op.getEntryDN();
        RDN newRDN = op.getNewRDN();
        DN newSuperior = newSuperiorID != null ? this.findEntryDN(newSuperiorID) : entryDN.getParent();
        if (newSuperior == null) {
            this.markConflictEntry(op, currentDN, currentDN.getParent().concat(newRDN));
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return true;
        }
        DN newDN = newSuperior.concat(newRDN);
        if (currentDN == null) {
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        if (newDN.equals(currentDN)) {
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        if (result == ResultCode.NO_SUCH_OBJECT || result == ResultCode.UNWILLING_TO_PERFORM || result == ResultCode.OBJECTCLASS_VIOLATION) {
            ModifyDNMsg modifyDnMsg = (ModifyDNMsg)msg;
            msg.setDn(currentDN.toString());
            modifyDnMsg.setNewSuperior(newSuperior.toString());
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.ENTRY_ALREADY_EXISTS) {
            ModifyDNMsg modifyDnMsg = (ModifyDNMsg)msg;
            this.markConflictEntry(op, op.getEntryDN(), newDN);
            modifyDnMsg.setNewRDN(this.generateConflictRDN(entryUUID, modifyDnMsg.getNewRDN()));
            modifyDnMsg.setNewSuperior(newSuperior.toString());
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(AddOperation op, AddMsg msg) throws Exception {
        ResultCode result = op.getResultCode();
        AddContext ctx = (AddContext)op.getAttachment("replicationContext");
        String entryUUID = ctx.getEntryUUID();
        String parentUniqueId = ctx.getParentEntryUUID();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            if (parentUniqueId == null) {
                return true;
            }
            DN parentDn = this.findEntryDN(parentUniqueId);
            if (parentDn == null) {
                this.addConflict(msg);
                msg.setDn(this.generateConflictRDN(entryUUID, op.getEntryDN().getRDN().toString()) + "," + this.baseDn);
                msg.setParentEntryUUID(null);
                this.numUnresolvedNamingConflicts.incrementAndGet();
                return false;
            }
            RDN entryRdn = DN.decode(msg.getDn()).getRDN();
            msg.setDn(entryRdn + "," + parentDn);
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.ENTRY_ALREADY_EXISTS) {
            if (this.findEntryDN(entryUUID) != null) {
                return true;
            }
            this.addConflict(msg);
            msg.setDn(this.generateConflictRDN(entryUUID, msg.getDn()));
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean findAndRenameChild(String entryUUID, DN entryDN, Operation conflictOp) {
        boolean conflict = false;
        try {
            LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
            attrs.add("entryuuid");
            attrs.add("ds-sync-hist");
            InternalSearchOperation op = this.conn.processSearch(entryDN, SearchScope.SINGLE_LEVEL, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createFilterFromString("(objectClass=*)"), attrs);
            if (op.getResultCode() == ResultCode.SUCCESS) {
                LinkedList<SearchResultEntry> entries = op.getSearchEntries();
                if (entries != null) {
                    for (SearchResultEntry entry : entries) {
                        conflict = true;
                        this.renameConflictEntry(conflictOp, entry.getDN(), EntryHistorical.getEntryUUID(entry));
                    }
                }
            } else {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CANNOT_RENAME_CONFLICT_ENTRY.get());
                mb.append(String.valueOf(entryDN));
                mb.append(" ");
                mb.append(String.valueOf(conflictOp));
                mb.append(" ");
                mb.append(String.valueOf((Object)op.getResultCode()));
                ErrorLogger.logError(mb.toMessage());
            }
        }
        catch (DirectoryException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_EXCEPTION_RENAME_CONFLICT_ENTRY.get());
            mb.append(String.valueOf(entryDN));
            mb.append(" ");
            mb.append(String.valueOf(conflictOp));
            mb.append(" ");
            mb.append(e.getLocalizedMessage());
            ErrorLogger.logError(mb.toMessage());
        }
        return conflict;
    }

    private void renameConflictEntry(Operation conflictOp, DN dn, String entryUUID) {
        Message alertMessage = ReplicationMessages.NOTE_UNRESOLVED_CONFLICT.get(dn.toString());
        DirectoryServer.sendAlertNotification(this, "org.opends.server.replication.UnresolvedConflict", alertMessage);
        ModifyDNOperationBasis newOp = this.renameEntry(dn, this.generateDeleteConflictDn(entryUUID, dn), this.baseDn, true);
        if (newOp.getResultCode() != ResultCode.SUCCESS) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CANNOT_RENAME_CONFLICT_ENTRY.get());
            mb.append(String.valueOf(dn));
            mb.append(" ");
            mb.append(String.valueOf(conflictOp));
            mb.append(" ");
            mb.append(String.valueOf((Object)newOp.getResultCode()));
            ErrorLogger.logError(mb.toMessage());
        }
    }

    private void markConflictEntry(Operation op, DN currentDN, DN conflictDN) {
        AttributeType attrType = DirectoryServer.getAttributeType(DS_SYNC_CONFLICT, true);
        Attribute attr = Attributes.create(attrType, AttributeValues.create(attrType, conflictDN.toNormalizedString()));
        ArrayList<Modification> mods = new ArrayList<Modification>();
        Modification mod = new Modification(ModificationType.REPLACE, attr);
        mods.add(mod);
        ModifyOperationBasis newOp = new ModifyOperationBasis((ClientConnection)this.conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), currentDN, mods);
        newOp.setInternalOperation(true);
        newOp.setSynchronizationOperation(true);
        newOp.setDontSynchronize(true);
        newOp.run();
        if (newOp.getResultCode() != ResultCode.SUCCESS) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CANNOT_ADD_CONFLICT_ATTRIBUTE.get());
            mb.append(String.valueOf(op));
            mb.append(" ");
            mb.append(String.valueOf((Object)newOp.getResultCode()));
            ErrorLogger.logError(mb.toMessage());
        }
        Message alertMessage = ReplicationMessages.NOTE_UNRESOLVED_CONFLICT.get(conflictDN.toString());
        DirectoryServer.sendAlertNotification(this, "org.opends.server.replication.UnresolvedConflict", alertMessage);
    }

    private void addConflict(AddMsg msg) throws ASN1Exception {
        String normalizedDN;
        try {
            normalizedDN = DN.decode(msg.getDn()).toNormalizedString();
        }
        catch (DirectoryException e) {
            normalizedDN = msg.getDn();
        }
        Message alertMessage = ReplicationMessages.NOTE_UNRESOLVED_CONFLICT.get(normalizedDN);
        DirectoryServer.sendAlertNotification(this, "org.opends.server.replication.UnresolvedConflict", alertMessage);
        msg.addAttribute(DS_SYNC_CONFLICT, normalizedDN);
    }

    private String generateConflictRDN(String entryUUID, String rdn) {
        return "entryuuid=" + entryUUID + "+" + rdn;
    }

    private RDN generateDeleteConflictDn(String entryUUID, DN dn) {
        String newRDN = "entryuuid=" + entryUUID + "+" + dn.getRDN();
        RDN rdn = null;
        try {
            rdn = RDN.decode(newRDN);
        }
        catch (DirectoryException e) {
            // empty catch block
        }
        return rdn;
    }

    public int getNumResolvedModifyConflicts() {
        return this.numResolvedModifyConflicts.get();
    }

    public int getNumResolvedNamingConflicts() {
        return this.numResolvedNamingConflicts.get();
    }

    public int getNumUnresolvedNamingConflicts() {
        return this.numUnresolvedNamingConflicts.get();
    }

    public boolean solveConflict() {
        return this.solveConflictFlag;
    }

    public void disable() {
        this.state.save();
        this.state.clearInMemory();
        this.disabled = true;
        this.disableService();
    }

    protected void loadDataState() throws DirectoryException {
        this.state.clearInMemory();
        this.state.loadState();
        this.generator.adjust(this.state.getMaxChangeNumber(this.serverId));
        this.generationId = this.loadGenerationId();
    }

    public void enable() {
        try {
            this.loadDataState();
        }
        catch (Exception e) {
            ErrorLogger.logError(ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toNormalizedString(), e.getLocalizedMessage()));
            return;
        }
        this.enableService();
        this.disabled = false;
    }

    public long computeGenerationId() throws DirectoryException {
        long genId = this.exportBackend(null, true);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Computed generationId: generationId=" + genId);
        }
        return genId;
    }

    @Override
    public long getGenerationID() {
        return this.generationId;
    }

    private ResultCode runSaveGenerationId(DN entryDN, long generationId) {
        ByteString asn1BaseDn = ByteString.valueOf(entryDN.toString());
        ArrayList<ByteString> values = new ArrayList<ByteString>();
        ByteString value = ByteString.valueOf(Long.toString(generationId));
        values.add(value);
        LDAPAttribute attr = new LDAPAttribute(REPLICATION_GENERATION_ID, values);
        LDAPModification mod = new LDAPModification(ModificationType.REPLACE, attr);
        ArrayList<RawModification> mods = new ArrayList<RawModification>(1);
        mods.add(mod);
        ModifyOperationBasis op = new ModifyOperationBasis((ClientConnection)this.conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), asn1BaseDn, mods);
        op.setInternalOperation(true);
        op.setSynchronizationOperation(true);
        op.setDontSynchronize(true);
        op.run();
        return op.getResultCode();
    }

    public ResultCode saveGenerationId(long generationId) {
        ResultCode result = this.runSaveGenerationId(this.baseDn, generationId);
        if (result != ResultCode.SUCCESS) {
            this.generationIdSavedStatus = false;
            if (result == ResultCode.NO_SUCH_OBJECT) {
                result = this.runSaveGenerationId(this.configDn, generationId);
            }
            if (result != ResultCode.SUCCESS) {
                Message message = ReplicationMessages.ERR_UPDATING_GENERATION_ID.get(result.getResultCodeName() + " ", this.baseDn.toString());
                ErrorLogger.logError(message);
            }
        } else {
            this.generationIdSavedStatus = true;
        }
        return result;
    }

    private long loadGenerationId() throws DirectoryException {
        LDAPFilter filter;
        long aGenerationId = -1L;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Attempt to read generation ID from DB " + this.baseDn.toString());
        }
        ByteString asn1BaseDn = ByteString.valueOf(this.baseDn.toString());
        boolean found = false;
        try {
            filter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException e) {
            return -1L;
        }
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(1);
        attributes.add(REPLICATION_GENERATION_ID);
        InternalSearchOperation search = this.conn.processSearch(asn1BaseDn, SearchScope.BASE_OBJECT, DereferencePolicy.DEREF_ALWAYS, 0, 0, false, filter, attributes);
        if (search.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
            asn1BaseDn = ByteString.valueOf(this.baseDn.toString());
            search = this.conn.processSearch(asn1BaseDn, SearchScope.BASE_OBJECT, DereferencePolicy.DEREF_ALWAYS, 0, 0, false, filter, attributes);
        }
        if (search.getResultCode() != ResultCode.SUCCESS) {
            if (search.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
                Message message = ReplicationMessages.ERR_SEARCHING_GENERATION_ID.get(search.getResultCode().getResultCodeName() + " " + search.getErrorMessage(), this.baseDn.toString());
                ErrorLogger.logError(message);
            }
        } else {
            AttributeType synchronizationGenIDType;
            List<Attribute> attrs;
            LinkedList<SearchResultEntry> result = search.getSearchEntries();
            SearchResultEntry resultEntry = result.getFirst();
            if (resultEntry != null && (attrs = resultEntry.getAttribute(synchronizationGenIDType = DirectoryServer.getAttributeType(REPLICATION_GENERATION_ID))) != null) {
                Attribute attr = attrs.get(0);
                if (attr.size() > 1) {
                    Message message = ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toString(), "#Values=" + attr.size() + " Must be exactly 1 in entry " + resultEntry.toLDIFString());
                    ErrorLogger.logError(message);
                } else if (attr.size() == 1) {
                    found = true;
                    try {
                        aGenerationId = Long.decode(attr.iterator().next().toString());
                    }
                    catch (Exception e) {
                        Message message = ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toString(), e.getLocalizedMessage());
                        ErrorLogger.logError(message);
                    }
                }
            }
        }
        if (!found) {
            aGenerationId = this.computeGenerationId();
            this.saveGenerationId(aGenerationId);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Generation ID created for domain base DN=" + this.baseDn.toString() + " generationId=" + aGenerationId);
            }
        } else {
            this.generationIdSavedStatus = true;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Generation ID successfully read from domain base DN=" + this.baseDn + " generationId=" + aGenerationId);
            }
        }
        return aGenerationId;
    }

    public void backupStart() {
        this.state.save();
    }

    public void backupEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJEBackend(boolean createBaseEntry, String beID, String dn) throws Exception {
        BackendImpl backend = (BackendImpl)DirectoryServer.getBackend(beID);
        TaskUtils.disableBackend(beID);
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                throw new RuntimeException(failureReason.toString());
            }
            try {
                backend.clearBackend();
            }
            finally {
                LockFileManager.releaseLock(lockFile, failureReason);
            }
        }
        finally {
            TaskUtils.enableBackend(beID);
        }
        if (createBaseEntry) {
            DN baseDN = DN.decode(dn);
            Entry e = StaticUtils.createEntry(baseDN);
            backend = (BackendImpl)DirectoryServer.getBackend(beID);
            backend.addEntry(e, null);
        }
    }

    @Override
    protected void exportBackend(OutputStream output) throws DirectoryException {
        this.exportBackend(output, false);
    }

    protected long exportBackend(OutputStream output, boolean checksumOutput) throws DirectoryException {
        Message message;
        OutputStream os;
        long genID = 0L;
        Backend backend = LDAPReplicationDomain.retrievesBackend(this.baseDn);
        long numberOfEntries = backend.numSubordinates(this.baseDn, true) + 1L;
        long entryCount = numberOfEntries < 1000L ? numberOfEntries : 1000L;
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                Message message2 = ToolMessages.ERR_LDIFEXPORT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message2);
                throw new DirectoryException(ResultCode.OTHER, message2, null);
            }
        }
        catch (Exception e) {
            Message message3 = ToolMessages.ERR_LDIFEXPORT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), e.getLocalizedMessage());
            ErrorLogger.logError(message3);
            throw new DirectoryException(ResultCode.OTHER, message3, null);
        }
        ReplLDIFOutputStream ros = null;
        if (checksumOutput) {
            ros = new ReplLDIFOutputStream(entryCount);
            os = ros;
            try {
                os.write(Long.toString(numberOfEntries).getBytes());
            }
            catch (Exception e) {}
        } else {
            os = output;
        }
        LDIFExportConfig exportConfig = new LDIFExportConfig(os);
        ArrayList<DN> includeBranches = new ArrayList<DN>(1);
        includeBranches.add(this.baseDn);
        exportConfig.setIncludeBranches(includeBranches);
        if (checksumOutput) {
            String[] includeAttributeStrings = new String[]{"objectclass", "sn", "cn", "entryuuid"};
            HashSet<AttributeType> includeAttributes = new HashSet<AttributeType>();
            for (String attrName : includeAttributeStrings) {
                AttributeType attrType = DirectoryServer.getAttributeType(attrName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attrName);
                }
                includeAttributes.add(attrType);
            }
            exportConfig.setIncludeAttributes(includeAttributes);
        }
        try {
            backend.exportLDIF(exportConfig);
        }
        catch (DirectoryException de) {
            if (ros == null || ros.getNumExportedEntries() < entryCount) {
                message = ToolMessages.ERR_LDIFEXPORT_ERROR_DURING_EXPORT.get(de.getMessageObject());
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.OTHER, message, null);
            }
        }
        catch (Exception e) {
            message = ToolMessages.ERR_LDIFEXPORT_ERROR_DURING_EXPORT.get(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message, null);
        }
        finally {
            exportConfig.close();
            if (checksumOutput) {
                genID = ros.getChecksumValue();
            }
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            try {
                if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                    Message message4 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                    ErrorLogger.logError(message4);
                    throw new DirectoryException(ResultCode.OTHER, message4, null);
                }
            }
            catch (Exception e) {
                Message message5 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message5);
                throw new DirectoryException(ResultCode.OTHER, message5, null);
            }
        }
        return genID;
    }

    protected static Backend retrievesBackend(DN baseDn) {
        return DirectoryServer.getBackend(baseDn);
    }

    private void preBackendImport(Backend backend) throws Exception {
        this.stateSavingDisabled = true;
        TaskUtils.disableBackend(backend.getBackendID());
        String lockFile = LockFileManager.getBackendLockFileName(backend);
        StringBuilder failureReason = new StringBuilder();
        if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
            Message message = ReplicationMessages.ERR_INIT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void importBackend(InputStream input) throws DirectoryException {
        LDIFImportConfig importConfig = null;
        Backend backend = LDAPReplicationDomain.retrievesBackend(this.baseDn);
        try {
            if (!backend.supportsLDIFImport()) {
                Message message = ReplicationMessages.ERR_INIT_IMPORT_NOT_SUPPORTED.get(backend.getBackendID());
                if (this.ieContext.getException() == null) {
                    this.ieContext.setException(new DirectoryException(ResultCode.OTHER, message));
                }
            } else {
                importConfig = new LDIFImportConfig(input);
                ArrayList<DN> includeBranches = new ArrayList<DN>();
                includeBranches.add(this.baseDn);
                importConfig.setIncludeBranches(includeBranches);
                importConfig.setAppendToExistingData(false);
                importConfig.setSkipDNValidation(true);
                importConfig.setValidateSchema(false);
                importConfig.setInvokeImportPlugins(true);
                this.importErrorMessageId = -1;
                this.followImport = true;
                importConfig.writeRejectedEntries(StaticUtils.getFileForPath("logs" + File.separator + "replInitRejectedEntries").getAbsolutePath(), ExistingFileBehavior.OVERWRITE);
                this.preBackendImport(backend);
                backend.importLDIF(importConfig);
                this.stateSavingDisabled = false;
            }
        }
        catch (Exception e) {
            if (this.ieContext.getException() == null) {
                this.ieContext.setException(new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_INIT_IMPORT_FAILURE.get(e.getLocalizedMessage())));
            }
        }
        finally {
            block19: {
                try {
                    if (importConfig != null) {
                        importConfig.close();
                        this.closeBackendImport(backend);
                        backend = LDAPReplicationDomain.retrievesBackend(this.baseDn);
                    }
                    this.loadDataState();
                    if (this.ieContext.getException() != null) {
                        this.generationId = this.computeGenerationId();
                        this.saveGenerationId(this.generationId);
                    }
                }
                catch (DirectoryException fe) {
                    if (this.ieContext.getException() != null) break block19;
                    this.ieContext.setException(new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_INIT_IMPORT_FAILURE.get(fe.getLocalizedMessage())));
                }
            }
        }
        if (this.ieContext.getException() != null) {
            throw this.ieContext.getException();
        }
    }

    protected void closeBackendImport(Backend backend) throws DirectoryException {
        StringBuilder failureReason;
        String lockFile = LockFileManager.getBackendLockFileName(backend);
        if (!LockFileManager.releaseLock(lockFile, failureReason = new StringBuilder())) {
            Message message = ToolMessages.WARN_LDIFIMPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        TaskUtils.enableBackend(backend.getBackendID());
    }

    public static LDAPReplicationDomain retrievesReplicationDomain(DN baseDn) throws DirectoryException {
        LDAPReplicationDomain replicationDomain = null;
        DirectoryServer.getSynchronizationProviders();
        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
            if (!(provider instanceof MultimasterReplication)) {
                Message message = ReplicationMessages.ERR_INVALID_PROVIDER.get();
                throw new DirectoryException(ResultCode.OTHER, message);
            }
            LDAPReplicationDomain domain = MultimasterReplication.findDomain(baseDn, null);
            if (domain == null) break;
            if (replicationDomain != null) {
                Message message = ReplicationMessages.ERR_MULTIPLE_MATCHING_DOMAIN.get();
                throw new DirectoryException(ResultCode.OTHER, message);
            }
            replicationDomain = domain;
        }
        if (replicationDomain == null) {
            throw new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_NO_MATCHING_DOMAIN.get(String.valueOf(baseDn)));
        }
        return replicationDomain;
    }

    public Backend getBackend() {
        return LDAPReplicationDomain.retrievesBackend(this.baseDn);
    }

    public void synchronizeModifications(List<Modification> modifications) {
        ModifyOperationBasis opBasis = new ModifyOperationBasis((ClientConnection)InternalClientConnection.getRootConnection(), InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, DirectoryServer.getSchemaDN(), modifications);
        LocalBackendModifyOperation op = new LocalBackendModifyOperation(opBasis);
        ChangeNumber cn = this.generateChangeNumber(op);
        ModifyContext ctx = new ModifyContext(cn, "schema");
        op.setAttachment("replicationContext", ctx);
        op.setResultCode(ResultCode.SUCCESS);
        this.synchronize(op);
    }

    public static boolean isConfigurationAcceptable(ReplicationDomainCfg configuration, List<Message> unacceptableReasons) {
        DN dn = configuration.getBaseDN();
        LDAPReplicationDomain domain = MultimasterReplication.findDomain(dn, null);
        if (domain != null && domain.baseDn.equals(dn)) {
            Message message = ReplicationMessages.ERR_SYNC_INVALID_DN.get();
            unacceptableReasons.add(message);
            return false;
        }
        if (LDAPReplicationDomain.retrievesBackend(dn) == null) {
            Message message = ReplicationMessages.ERR_UNKNOWN_DN.get(dn.toString());
            unacceptableReasons.add(message);
            return false;
        }
        try {
            LDAPReplicationDomain.isFractionalConfigAcceptable(configuration);
        }
        catch (ConfigException e) {
            unacceptableReasons.add(e.getMessageObject());
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ReplicationDomainCfg configuration) {
        this.isolationPolicy = configuration.getIsolationPolicy();
        this.logChangeNumber = configuration.isLogChangenumber();
        this.histPurgeDelayInMilliSec = configuration.getConflictsHistoricalPurgeDelay() * 60L * 1000L;
        this.changeConfig(configuration.getReplicationServer(), configuration.getWindowSize(), configuration.getHeartbeatInterval(), (byte)configuration.getGroupId());
        this.readAssuredConfig(configuration, true);
        this.readFractionalConfig(configuration, true);
        this.solveConflictFlag = this.baseDn.compareTo(DirectoryServer.getSchemaDN()) != 0 && configuration.isSolveConflicts();
        try {
            this.storeECLConfiguration(configuration);
        }
        catch (Exception e) {
            return new ConfigChangeResult(ResultCode.OTHER, false);
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ReplicationDomainCfg configuration, List<Message> unacceptableReasons) {
        if (this.importInProgress() || this.exportInProgress()) {
            unacceptableReasons.add(ReplicationMessages.NOTE_ERR_CANNOT_CHANGE_CONFIG_DURING_TOTAL_UPDATE.get());
            return false;
        }
        try {
            LDAPReplicationDomain.isFractionalConfigAcceptable(configuration);
        }
        catch (ConfigException e) {
            unacceptableReasons.add(e.getMessageObject());
            return false;
        }
        return true;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.replication.UnresolvedConflict", "This alert type will be used to notify administrators if multimaster replication cannot resolve a conflict automatically.");
        return alerts;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.configDn;
    }

    public void start() {
        this.flushThread.start();
        this.startListenService();
    }

    public void removeECLDomainCfg() {
        try {
            DN eclConfigEntryDN = DN.decode("cn=external changeLog," + this.configDn);
            if (DirectoryServer.getConfigHandler().entryExists(eclConfigEntryDN)) {
                DirectoryServer.getConfigHandler().deleteEntry(eclConfigEntryDN, null);
            }
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            MessageBuilder mb = new MessageBuilder();
            mb.append(e.getMessage());
            Message msg = ReplicationMessages.ERR_CHECK_CREATE_REPL_BACKEND_FAILED.get(mb.toString());
            ErrorLogger.logError(msg);
        }
    }

    public void storeECLConfiguration(ReplicationDomainCfg domCfg) throws ConfigException {
        ExternalChangelogDomainCfg eclDomCfg = null;
        try {
            if (DirectoryServer.getConfigHandler().entryExists(this.configDn)) {
                try {
                    eclDomCfg = domCfg.getExternalChangelogDomain();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (eclDomCfg == null) {
                    DN eclConfigEntryDN = DN.decode("cn=external changelog," + this.configDn);
                    if (!DirectoryServer.getConfigHandler().entryExists(eclConfigEntryDN)) {
                        String ldif = LDAPReplicationDomain.makeLdif("dn: cn=external changelog," + this.configDn, "objectClass: top", "objectClass: ds-cfg-external-changelog-domain", "cn: external changelog", "ds-cfg-enabled: " + !this.getBackend().isPrivateBackend());
                        LDIFImportConfig ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
                        ldifImportConfig.setValidateSchema(false);
                        LDIFReader reader = new LDIFReader(ldifImportConfig);
                        Entry eclEntry = reader.readEntry();
                        DirectoryServer.getConfigHandler().addEntry(eclEntry, null);
                        ldifImportConfig.close();
                    }
                }
            }
            eclDomCfg = domCfg.getExternalChangelogDomain();
            if (this.eclDomain != null) {
                this.eclDomain.applyConfigurationChange(eclDomCfg);
            } else {
                this.eclDomain = new ExternalChangelogDomain(this, eclDomCfg);
            }
        }
        catch (Exception de) {
            throw new ConfigException(ReplicationMessages.NOTE_ERR_UNABLE_TO_ENABLE_ECL.get("Replication Domain on" + this.baseDn, de.getMessage() + " " + de.getCause().getMessage()), (Throwable)de);
        }
    }

    private static String makeLdif(String ... lines) {
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line).append(ServerConstants.EOL);
        }
        buffer.append(ServerConstants.EOL);
        return buffer.toString();
    }

    @Override
    public void sessionInitiated(ServerStatus initStatus, ServerState replicationServerState, long generationID, Session session) {
        Message message;
        this.forceBadDataSet = !this.isBackendFractionalConfigConsistent();
        super.sessionInitiated(initStatus, replicationServerState, generationID, session);
        if (!this.getBackend().isPrivateBackend()) {
            try {
                ECLWorkflowElement wfe = (ECLWorkflowElement)DirectoryServer.getWorkflowElement("EXTERNAL CHANGE LOG");
                if (wfe != null) {
                    wfe.getReplicationServer().enableECL();
                }
            }
            catch (DirectoryException de) {
                message = ReplicationMessages.NOTE_ERR_UNABLE_TO_ENABLE_ECL.get("Replication Domain on" + this.baseDn, de.getMessage() + " " + de.getCause().getMessage());
                ErrorLogger.logError(message);
            }
        }
        if (this.forceBadDataSet) {
            this.setNewStatus(StatusMachineEvent.TO_BAD_GEN_ID_STATUS_EVENT);
            this.broker.signalStatusChange(this.status);
            Message message2 = ReplicationMessages.NOTE_FRACTIONAL_BAD_DATA_SET_NEED_RESYNC.get(this.baseDn.toString());
            ErrorLogger.logError(message2);
            return;
        }
        try {
            ChangeNumber ourMaxChangeNumber;
            ChangeNumber replServerMaxChangeNumber = replicationServerState.getMaxChangeNumber(this.serverId);
            if (replServerMaxChangeNumber != null && replServerMaxChangeNumber.getSeqnum() != 0 && (ourMaxChangeNumber = this.state.getMaxChangeNumber(this.serverId)) != null && !ourMaxChangeNumber.olderOrEqual(replServerMaxChangeNumber).booleanValue()) {
                this.pendingChanges.setRecovering(true);
                this.broker.setRecoveryRequired(true);
                new RSUpdater(replServerMaxChangeNumber).start();
            }
        }
        catch (Exception e) {
            message = ReplicationMessages.ERR_PUBLISHING_FAKE_OPS.get(this.baseDn.toNormalizedString(), e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildAndPublishMissingChanges(ChangeNumber startingChangeNumber, ReplicationBroker session) throws Exception {
        InternalSearchOperation op;
        ChangeNumber lastRetrievedChange;
        SortedMap<ChangeNumber, FakeOperation> sortedMap = this.replayOperations;
        synchronized (sortedMap) {
            Iterator<ChangeNumber> it = this.replayOperations.keySet().iterator();
            while (it.hasNext() && it.next().olderOrEqual(startingChangeNumber).booleanValue()) {
                it.remove();
            }
        }
        ChangeNumber currentStartChangeNumber = startingChangeNumber;
        do {
            lastRetrievedChange = null;
            long missingChangesDelta = currentStartChangeNumber.getTime() + 10000L;
            ChangeNumber endChangeNumber = new ChangeNumber(missingChangesDelta, -1, this.serverId);
            ScanSearchListener listener = new ScanSearchListener(currentStartChangeNumber, endChangeNumber);
            op = LDAPReplicationDomain.searchForChangedEntries(this.baseDn, currentStartChangeNumber, endChangeNumber, listener);
            LinkedList<FakeOperation> opsToSend = new LinkedList<FakeOperation>();
            SortedMap<ChangeNumber, FakeOperation> sortedMap2 = this.replayOperations;
            synchronized (sortedMap2) {
                FakeOperation fakeOp;
                Iterator<FakeOperation> itOp = this.replayOperations.values().iterator();
                while (itOp.hasNext() && (fakeOp = itOp.next()).getChangeNumber().olderOrEqual(endChangeNumber).booleanValue() && this.state.cover(fakeOp.getChangeNumber())) {
                    lastRetrievedChange = fakeOp.getChangeNumber();
                    opsToSend.add(fakeOp);
                    itOp.remove();
                }
            }
            for (FakeOperation opToSend : opsToSend) {
                session.publishRecovery(opToSend.generateMessage());
            }
            opsToSend.clear();
            currentStartChangeNumber = lastRetrievedChange != null ? lastRetrievedChange : endChangeNumber;
        } while (this.pendingChanges.recoveryUntil(lastRetrievedChange) && op.getResultCode().equals((Object)ResultCode.SUCCESS));
        return op.getResultCode().equals((Object)ResultCode.SUCCESS);
    }

    public static InternalSearchOperation searchForChangedEntries(DN baseDn, ChangeNumber fromChangeNumber, ChangeNumber lastChangeNumber, InternalSearchListener resultListener) throws Exception {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        Integer serverId = fromChangeNumber.getServerId();
        String maxValueForId = lastChangeNumber == null ? "ffffffffffffffff" + String.format("%04x", serverId) + "ffffffff" : lastChangeNumber.toString();
        LDAPFilter filter = LDAPFilter.decode("(&(ds-sync-hist>=dummy:" + fromChangeNumber + ")(" + "ds-sync-hist" + "<=dummy:" + maxValueForId + "))");
        LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
        attrs.add("ds-sync-hist");
        attrs.add("entryuuid");
        attrs.add("*");
        return conn.processSearch(ByteString.valueOf(baseDn.toString()), SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, attrs, resultListener);
    }

    public static InternalSearchOperation searchForChangedEntries(DN baseDn, ChangeNumber fromChangeNumber, InternalSearchListener resultListener) throws Exception {
        return LDAPReplicationDomain.searchForChangedEntries(baseDn, fromChangeNumber, null, resultListener);
    }

    @Override
    public long countEntries() throws DirectoryException {
        Backend backend = LDAPReplicationDomain.retrievesBackend(this.baseDn);
        if (!backend.supportsLDIFExport()) {
            Message message = ReplicationMessages.ERR_INIT_EXPORT_NOT_SUPPORTED.get(backend.getBackendID());
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        return backend.numSubordinates(this.baseDn, true) + 1L;
    }

    @Override
    public boolean processUpdate(UpdateMsg updateMsg, AtomicBoolean shutdown) {
        if (this.forceBadDataSet) {
            return false;
        }
        if (updateMsg instanceof LDAPUpdateMsg) {
            LDAPUpdateMsg msg = (LDAPUpdateMsg)updateMsg;
            this.remotePendingChanges.putRemoteUpdate(msg);
            UpdateToReplay updateToReplay = new UpdateToReplay(msg, this);
            while (!shutdown.get()) {
                try {
                    if (!this.updateToReplayQueue.offer(updateToReplay, 1L, TimeUnit.SECONDS)) continue;
                    break;
                }
                catch (InterruptedException e) {
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public Collection<Attribute> getAdditionalMonitoring() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        ReplicationMonitor.addMonitorData(attributes, "pending-updates", this.getPendingUpdatesCount());
        ReplicationMonitor.addMonitorData(attributes, "replayed-updates-ok", this.getNumReplayedPostOpCalled());
        ReplicationMonitor.addMonitorData(attributes, "resolved-modify-conflicts", this.getNumResolvedModifyConflicts());
        ReplicationMonitor.addMonitorData(attributes, "resolved-naming-conflicts", this.getNumResolvedNamingConflicts());
        ReplicationMonitor.addMonitorData(attributes, "unresolved-naming-conflicts", this.getNumUnresolvedNamingConflicts());
        ReplicationMonitor.addMonitorData(attributes, "remote-pending-changes-size", this.remotePendingChanges.getQueueSize());
        return attributes;
    }

    public int decodeSource(String sourceString) throws DirectoryException {
        int source = 0;
        Exception cause = null;
        try {
            source = Integer.decode(sourceString);
            if (source >= -1 && source != this.serverId) {
                return source;
            }
        }
        catch (Exception e) {
            cause = e;
        }
        ResultCode resultCode = ResultCode.OTHER;
        if (cause != null) {
            Message message = ReplicationMessages.ERR_INVALID_IMPORT_SOURCE.get(this.baseDn.toNormalizedString(), Integer.toString(this.serverId), Integer.toString(source), "Details:" + cause.getLocalizedMessage());
            throw new DirectoryException(resultCode, message, cause);
        }
        Message message = ReplicationMessages.ERR_INVALID_IMPORT_SOURCE.get(this.baseDn.toNormalizedString(), Integer.toString(this.serverId), Integer.toString(source), "");
        throw new DirectoryException(resultCode, message);
    }

    private void addEntryAttributesForCL(UpdateMsg msg, PostOperationOperation op) throws DirectoryException {
        if (op instanceof PostOperationDeleteOperation) {
            Set<String> names = this.getEclIncludesForDeletes();
            PostOperationDeleteOperation delOp = (PostOperationDeleteOperation)op;
            Entry entry = delOp.getEntryToDelete();
            ((DeleteMsg)msg).setEclIncludes(this.getIncludedAttributes(entry, names));
            DN deleterDN = delOp.getAuthorizationDN();
            if (deleterDN != null) {
                ((DeleteMsg)msg).setInitiatorsName(deleterDN.toString());
            }
        } else if (op instanceof PostOperationModifyOperation) {
            Set<String> names = this.getEclIncludes();
            PostOperationModifyOperation modOp = (PostOperationModifyOperation)op;
            Entry entry = modOp.getCurrentEntry();
            ((ModifyMsg)msg).setEclIncludes(this.getIncludedAttributes(entry, names));
        } else if (op instanceof PostOperationModifyDNOperation) {
            Set<String> names = this.getEclIncludes();
            PostOperationModifyDNOperation modDNOp = (PostOperationModifyDNOperation)op;
            Entry entry = modDNOp.getOriginalEntry();
            ((ModifyDNMsg)msg).setEclIncludes(this.getIncludedAttributes(entry, names));
        } else if (op instanceof PostOperationAddOperation) {
            Set<String> names = this.getEclIncludes();
            PostOperationAddOperation addOp = (PostOperationAddOperation)op;
            Entry entry = addOp.getEntryToAdd();
            ((AddMsg)msg).setEclIncludes(this.getIncludedAttributes(entry, names));
        }
    }

    private Collection<Attribute> getIncludedAttributes(Entry entry, Set<String> names) {
        Set<String> expandedNames;
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        if (names.size() == 1 && names.contains("*")) {
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            for (List<Attribute> attributeList : entry.getUserAttributes().values()) {
                attributes.addAll(attributeList);
            }
            Attribute objectClassAttribute = entry.getObjectClassAttribute();
            if (objectClassAttribute != null) {
                attributes.add(objectClassAttribute);
            }
            return attributes;
        }
        boolean needsExpanding = false;
        for (String name : names) {
            if (!name.startsWith("@")) continue;
            needsExpanding = true;
            break;
        }
        if (needsExpanding) {
            expandedNames = new HashSet<String>(names.size());
            for (String name : names) {
                if (name.startsWith("@")) {
                    String ocName = name.substring(1);
                    ObjectClass objectClass = DirectoryServer.getObjectClass(StaticUtils.toLowerCase(ocName));
                    if (objectClass == null) continue;
                    for (AttributeType at : objectClass.getRequiredAttributeChain()) {
                        expandedNames.add(at.getNameOrOID());
                    }
                    for (AttributeType at : objectClass.getOptionalAttributeChain()) {
                        expandedNames.add(at.getNameOrOID());
                    }
                    continue;
                }
                expandedNames.add(name);
            }
        } else {
            expandedNames = names;
        }
        Entry filteredEntry = entry.filterEntry(expandedNames, false, false, false);
        return filteredEntry.getAttributes();
    }

    FractionalConfig getFractionalConfig() {
        return this.fractionalConfig;
    }

    public boolean isECLEnabled() {
        return this.eclDomain.isEnabled();
    }

    public long getHistoricalPurgeDelay() {
        return this.histPurgeDelayInMilliSec;
    }

    public void purgeConflictsHistorical(PurgeConflictsHistoricalTask task, long endDate) throws DirectoryException {
        LDAPFilter filter = null;
        TRACER.debugInfo("[PURGE] purgeConflictsHistorical on domain: " + this.baseDn + "endDate:" + new Date(endDate) + "lastChangeNumberPurgedFromHist: " + this.lastChangeNumberPurgedFromHist.toStringUI());
        try {
            filter = LDAPFilter.decode("(ds-sync-hist>=dummy:" + this.lastChangeNumberPurgedFromHist + ")");
        }
        catch (LDAPException e) {
            // empty catch block
        }
        LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
        attrs.add("ds-sync-hist");
        attrs.add("entryuuid");
        attrs.add("*");
        InternalSearchOperation searchOp = this.conn.processSearch(ByteString.valueOf(this.baseDn.toString()), SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, attrs, null);
        int count = 0;
        if (task != null) {
            task.setProgressStats(this.lastChangeNumberPurgedFromHist, count);
        }
        LinkedList<SearchResultEntry> entries = searchOp.getSearchEntries();
        for (SearchResultEntry entry : entries) {
            long maxTimeToRun = endDate - TimeThread.getTime();
            if (maxTimeToRun < 0L) {
                Message errMsg = Message.raw(Category.SYNC, Severity.NOTICE, " end date reached", new Object[0]);
                DirectoryException de = new DirectoryException(ResultCode.ADMIN_LIMIT_EXCEEDED, errMsg);
                throw de;
            }
            EntryHistorical entryHist = EntryHistorical.newInstanceFromEntry(entry);
            this.lastChangeNumberPurgedFromHist = entryHist.getOldestCN();
            entryHist.setPurgeDelay(this.histPurgeDelayInMilliSec);
            Attribute attr = entryHist.encodeAndPurge();
            count += entryHist.getLastPurgedValuesCount();
            LinkedList<Modification> mods = new LinkedList<Modification>();
            Modification mod = new Modification(ModificationType.REPLACE, attr);
            mods.add(mod);
            ModifyOperationBasis newOp = new ModifyOperationBasis((ClientConnection)this.conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), entry.getDN(), mods);
            newOp.setInternalOperation(true);
            newOp.setSynchronizationOperation(true);
            newOp.setDontSynchronize(true);
            newOp.run();
            if (newOp.getResultCode() != ResultCode.SUCCESS) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CANNOT_ADD_CONFLICT_ATTRIBUTE.get());
                mb.append(String.valueOf(newOp));
                mb.append(" ");
                mb.append(String.valueOf((Object)newOp.getResultCode()));
                ErrorLogger.logError(mb.toMessage());
                continue;
            }
            if (task == null) continue;
            task.setProgressStats(this.lastChangeNumberPurgedFromHist, count);
        }
    }

    static class FractionalConfig {
        private boolean fractional = false;
        private boolean fractionalExclusive = true;
        private Map<String, List<String>> fractionalSpecificClassesAttributes = new HashMap<String, List<String>>();
        private List<String> fractionalAllClassesAttributes = new ArrayList<String>();
        private DN baseDn = null;
        static final int NOT_FRACTIONAL = 0;
        static final int EXCLUSIVE_FRACTIONAL = 1;
        static final int INCLUSIVE_FRACTIONAL = 2;

        FractionalConfig(DN baseDn) {
            this.baseDn = baseDn;
        }

        boolean isFractional() {
            return this.fractional;
        }

        void setFractional(boolean fractional) {
            this.fractional = fractional;
        }

        boolean isFractionalExclusive() {
            return this.fractionalExclusive;
        }

        void setFractionalExclusive(boolean fractionalExclusive) {
            this.fractionalExclusive = fractionalExclusive;
        }

        Map<String, List<String>> getFractionalSpecificClassesAttributes() {
            return this.fractionalSpecificClassesAttributes;
        }

        void setFractionalSpecificClassesAttributes(Map<String, List<String>> fractionalSpecificClassesAttributes) {
            this.fractionalSpecificClassesAttributes = fractionalSpecificClassesAttributes;
        }

        List<String> getFractionalAllClassesAttributes() {
            return this.fractionalAllClassesAttributes;
        }

        void setFractionalAllClassesAttributes(List<String> fractionalAllClassesAttributes) {
            this.fractionalAllClassesAttributes = fractionalAllClassesAttributes;
        }

        DN getBaseDn() {
            return this.baseDn;
        }

        static FractionalConfig toFractionalConfig(ReplicationDomainCfg configuration) throws ConfigException {
            Iterator<String> exclIt = null;
            SortedSet<String> fractionalExclude = configuration.getFractionalExclude();
            if (fractionalExclude != null) {
                exclIt = fractionalExclude.iterator();
            }
            Iterator<String> inclIt = null;
            SortedSet<String> fractionalInclude = configuration.getFractionalInclude();
            if (fractionalInclude != null) {
                inclIt = fractionalInclude.iterator();
            }
            HashMap<String, List<String>> newFractionalSpecificClassesAttributes = new HashMap<String, List<String>>();
            ArrayList<String> newFractionalAllClassesAttributes = new ArrayList<String>();
            int newFractionalMode = FractionalConfig.parseFractionalConfig(exclIt, inclIt, newFractionalSpecificClassesAttributes, newFractionalAllClassesAttributes);
            FractionalConfig result = new FractionalConfig(configuration.getBaseDN());
            switch (newFractionalMode) {
                case 0: {
                    result.setFractional(false);
                    result.setFractionalExclusive(true);
                    break;
                }
                case 1: 
                case 2: {
                    result.setFractional(true);
                    result.setFractionalExclusive(newFractionalMode == 1);
                }
            }
            result.setFractionalSpecificClassesAttributes(newFractionalSpecificClassesAttributes);
            result.setFractionalAllClassesAttributes(newFractionalAllClassesAttributes);
            return result;
        }

        private static int parseFractionalConfig(Iterator<String> exclIt, Iterator<String> inclIt, Map<String, List<String>> fractionalSpecificClassesAttributes, List<String> fractionalAllClassesAttributes) throws ConfigException {
            Iterator<String> iterator;
            int fractionalMode;
            if (exclIt != null && exclIt.hasNext()) {
                if (inclIt != null && inclIt.hasNext()) {
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_BOTH_MODES.get());
                }
                fractionalMode = 1;
                iterator = exclIt;
            } else if (inclIt != null && inclIt.hasNext()) {
                fractionalMode = 2;
                iterator = inclIt;
            } else {
                return 0;
            }
            while (iterator.hasNext()) {
                String fractCfgStr = iterator.next();
                StringTokenizer st = new StringTokenizer(fractCfgStr, ":");
                int nTokens = st.countTokens();
                if (nTokens < 2) {
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_WRONG_FORMAT.get(fractCfgStr));
                }
                String classNameLower = st.nextToken().toLowerCase();
                boolean allClasses = classNameLower.equals("*");
                String attributes = st.nextToken();
                st = new StringTokenizer(attributes, ",");
                while (st.hasMoreTokens()) {
                    String attrNameLower = st.nextToken().toLowerCase();
                    if (allClasses) {
                        if (fractionalAllClassesAttributes.contains(attrNameLower)) continue;
                        fractionalAllClassesAttributes.add(attrNameLower);
                        continue;
                    }
                    List<String> attrList = fractionalSpecificClassesAttributes.get(classNameLower);
                    if (attrList != null) {
                        if (attrList.contains(attrNameLower)) continue;
                        attrList.add(attrNameLower);
                        continue;
                    }
                    attrList = new ArrayList<String>();
                    attrList.add(attrNameLower);
                    fractionalSpecificClassesAttributes.put(classNameLower, attrList);
                }
            }
            return fractionalMode;
        }

        int fractionalConfigToInt() {
            int fractionalMode = this.fractional ? (this.fractionalExclusive ? 1 : 2) : 0;
            return fractionalMode;
        }

        static boolean isFractionalConfigEquivalent(FractionalConfig fractionalConfig1, FractionalConfig fractionalConfig2) throws ConfigException {
            List<String> allClassesAttributes2;
            if (!fractionalConfig1.getBaseDn().equals(fractionalConfig2.getBaseDn())) {
                return false;
            }
            if (fractionalConfig1.isFractional() != fractionalConfig2.isFractional() || fractionalConfig1.isFractionalExclusive() != fractionalConfig2.isFractionalExclusive()) {
                return false;
            }
            List<String> allClassesAttributes1 = fractionalConfig1.getFractionalAllClassesAttributes();
            if (!LDAPReplicationDomain.isAttributeListEquivalent(allClassesAttributes1, allClassesAttributes2 = fractionalConfig2.getFractionalAllClassesAttributes())) {
                return false;
            }
            Map<String, List<String>> specificClassesAttributes1 = fractionalConfig1.getFractionalSpecificClassesAttributes();
            Map<String, List<String>> specificClassesAttributes2 = fractionalConfig2.getFractionalSpecificClassesAttributes();
            if (specificClassesAttributes1.size() != specificClassesAttributes2.size()) {
                return false;
            }
            Schema schema = DirectoryServer.getSchema();
            for (String className1 : specificClassesAttributes1.keySet()) {
                ObjectClass objectClass1 = schema.getObjectClass(className1);
                if (objectClass1 == null) {
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_OBJECT_CLASS.get(className1));
                }
                boolean foundClass = false;
                for (String className2 : specificClassesAttributes2.keySet()) {
                    List<String> attributes2;
                    ObjectClass objectClass2 = schema.getObjectClass(className2);
                    if (objectClass2 == null) {
                        throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_OBJECT_CLASS.get(className2));
                    }
                    if (!objectClass1.equals(objectClass2)) continue;
                    foundClass = true;
                    List<String> attributes1 = specificClassesAttributes1.get(className1);
                    if (LDAPReplicationDomain.isAttributeListEquivalent(attributes1, attributes2 = specificClassesAttributes2.get(className2))) break;
                    return false;
                }
                if (foundClass) continue;
                return false;
            }
            return true;
        }
    }

    public static class AttributeValueStringIterator
    implements Iterator<String> {
        private Iterator<AttributeValue> attrValIt = null;

        public AttributeValueStringIterator(Iterator<AttributeValue> attrValIt) {
            this.attrValIt = attrValIt;
        }

        @Override
        public boolean hasNext() {
            return this.attrValIt.hasNext();
        }

        @Override
        public String next() {
            return this.attrValIt.next().getValue().toString();
        }

        @Override
        public void remove() {
            this.attrValIt.remove();
        }
    }

    private class RSUpdater
    extends DirectoryThread {
        private final ChangeNumber startChangeNumber;

        protected RSUpdater(ChangeNumber replServerMaxChangeNumber) {
            super("Replica DS(" + LDAPReplicationDomain.this.serverId + ") missing change publisher for domain \"" + LDAPReplicationDomain.this.baseDn.toString() + "\"");
            this.startChangeNumber = replServerMaxChangeNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                Message message = ReplicationMessages.DEBUG_GOING_TO_SEARCH_FOR_CHANGES.get();
                ErrorLogger.logError(message);
                try {
                    if (LDAPReplicationDomain.this.buildAndPublishMissingChanges(this.startChangeNumber, LDAPReplicationDomain.this.broker)) {
                        message = ReplicationMessages.DEBUG_CHANGES_SENT.get();
                        ErrorLogger.logError(message);
                        SortedMap sortedMap = LDAPReplicationDomain.this.replayOperations;
                        synchronized (sortedMap) {
                            LDAPReplicationDomain.this.replayOperations.clear();
                            break block9;
                        }
                    }
                    message = ReplicationMessages.ERR_CANNOT_RECOVER_CHANGES.get(LDAPReplicationDomain.this.baseDn.toNormalizedString());
                    ErrorLogger.logError(message);
                }
                catch (Exception e) {
                    message = ReplicationMessages.ERR_CANNOT_RECOVER_CHANGES.get(LDAPReplicationDomain.this.baseDn.toNormalizedString());
                    ErrorLogger.logError(message);
                }
                finally {
                    LDAPReplicationDomain.this.broker.setRecoveryRequired(false);
                }
            }
        }
    }

    private class ServerStateFlush
    extends DirectoryThread {
        protected ServerStateFlush() {
            super("Replica DS(" + LDAPReplicationDomain.this.serverId + ") state checkpointer for domain \"" + LDAPReplicationDomain.this.baseDn.toString() + "\"");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LDAPReplicationDomain.this.done = false;
            while (!LDAPReplicationDomain.this.shutdown) {
                try {
                    ServerStateFlush serverStateFlush = this;
                    synchronized (serverStateFlush) {
                        this.wait(1000L);
                        if (!LDAPReplicationDomain.this.disabled && !LDAPReplicationDomain.this.stateSavingDisabled) {
                            LDAPReplicationDomain.this.state.save();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            LDAPReplicationDomain.this.state.save();
            LDAPReplicationDomain.this.done = true;
        }
    }

    private class ScanSearchListener
    implements InternalSearchListener {
        private final ChangeNumber startingChangeNumber;
        private final ChangeNumber endChangeNumber;

        public ScanSearchListener(ChangeNumber startingChangeNumber, ChangeNumber endChangeNumber) {
            this.startingChangeNumber = startingChangeNumber;
            this.endChangeNumber = endChangeNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleInternalSearchEntry(InternalSearchOperation searchOperation, SearchResultEntry searchEntry) throws DirectoryException {
            Iterable<FakeOperation> updates = EntryHistorical.generateFakeOperations(searchEntry);
            for (FakeOperation op : updates) {
                ChangeNumber cn = op.getChangeNumber();
                if (!cn.newer(this.startingChangeNumber) || !cn.older(this.endChangeNumber).booleanValue()) continue;
                SortedMap sortedMap = LDAPReplicationDomain.this.replayOperations;
                synchronized (sortedMap) {
                    LDAPReplicationDomain.this.replayOperations.put(cn, op);
                }
            }
        }

        @Override
        public void handleInternalSearchReference(InternalSearchOperation searchOperation, SearchResultReference searchReference) throws DirectoryException {
        }
    }
}

