/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.FractionalLDIFImportPluginCfg;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.admin.std.server.ReplicationDomainCfg;
import org.opends.server.admin.std.server.ReplicationSynchronizationProviderCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.replication.plugin.LDAPReplicationDomain;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ResultCode;

public final class FractionalLDIFImportPlugin
extends DirectoryServerPlugin<FractionalLDIFImportPluginCfg>
implements ConfigurationChangeListener<FractionalLDIFImportPluginCfg> {
    private final Hashtable<LDIFImportConfig, ImportFractionalContext> importSessionContexts = new Hashtable();

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, FractionalLDIFImportPluginCfg configuration) throws ConfigException {
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case LDIF_IMPORT: 
                case LDIF_IMPORT_END: {
                    continue block3;
                }
            }
            Message message = ReplicationMessages.ERR_PLUGIN_FRACTIONAL_LDIF_IMPORT_INVALID_PLUGIN_TYPE.get(t.toString());
            throw new ConfigException(message);
        }
    }

    @Override
    public final void finalizePlugin() {
    }

    private static LDAPReplicationDomain.FractionalConfig getStaticReplicationDomainFractionalConfig(Entry entry) throws Exception {
        ServerManagementContext context = ServerManagementContext.getInstance();
        RootCfg root = context.getRootConfiguration();
        ReplicationSynchronizationProviderCfg sync = (ReplicationSynchronizationProviderCfg)root.getSynchronizationProvider("Multimaster Synchronization");
        String[] domainNames = sync.listReplicationDomains();
        if (domainNames == null) {
            return null;
        }
        ReplicationDomainCfg matchingReplicatedDomainCfg = null;
        for (String domainName : domainNames) {
            ReplicationDomainCfg replicationDomainCfg = sync.getReplicationDomain(domainName);
            DN replicatedDn = replicationDomainCfg.getBaseDN();
            DN entryDn = entry.getDN();
            if (!entryDn.isDescendantOf(replicatedDn)) continue;
            matchingReplicatedDomainCfg = replicationDomainCfg;
            break;
        }
        if (matchingReplicatedDomainCfg == null) {
            return null;
        }
        return LDAPReplicationDomain.FractionalConfig.toFractionalConfig(matchingReplicatedDomainCfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doLDIFImportEnd(LDIFImportConfig importConfig) {
        Hashtable<LDIFImportConfig, ImportFractionalContext> hashtable = this.importSessionContexts;
        synchronized (hashtable) {
            this.importSessionContexts.remove(importConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final PluginResult.ImportLDIF doLDIFImport(LDIFImportConfig importConfig, Entry entry) {
        ImportFractionalContext importFractionalContext = this.importSessionContexts.get(importConfig);
        DN entryDn = entry.getDN();
        LDAPReplicationDomain.FractionalConfig localFractionalConfig = null;
        if (importFractionalContext == null) {
            Hashtable<LDIFImportConfig, ImportFractionalContext> hashtable = this.importSessionContexts;
            synchronized (hashtable) {
                importFractionalContext = this.importSessionContexts.get(importConfig);
                if (importFractionalContext == null) {
                    LDAPReplicationDomain domain = MultimasterReplication.findDomain(entryDn, null);
                    if (domain == null) {
                        try {
                            localFractionalConfig = FractionalLDIFImportPlugin.getStaticReplicationDomainFractionalConfig(entry);
                        }
                        catch (Exception ex) {
                            Message message = ReplicationMessages.ERR_FRACTIONAL_COULD_NOT_RETRIEVE_CONFIG.get(entry.toString());
                            return PluginResult.ImportLDIF.stopEntryProcessing(message);
                        }
                    } else {
                        localFractionalConfig = domain.getFractionalConfig();
                    }
                    importFractionalContext = new ImportFractionalContext(localFractionalConfig, domain);
                    this.importSessionContexts.put(importConfig, importFractionalContext);
                }
            }
        }
        if ((localFractionalConfig = importFractionalContext.getFractionalConfig()) == null) {
            return PluginResult.ImportLDIF.continueEntryProcessing();
        }
        DN replicatedDomainBaseDn = localFractionalConfig.getBaseDn();
        if (replicatedDomainBaseDn.equals(entryDn)) {
            LDAPReplicationDomain.AttributeValueStringIterator exclIt = null;
            AttributeType fractionalExcludeType = DirectoryServer.getAttributeType("ds-sync-fractional-exclude");
            List<Attribute> exclAttrs = entry.getAttribute(fractionalExcludeType);
            Attribute exclAttr = null;
            if (exclAttrs != null && (exclAttr = exclAttrs.get(0)) != null) {
                exclIt = new LDAPReplicationDomain.AttributeValueStringIterator(exclAttr.iterator());
            }
            LDAPReplicationDomain.AttributeValueStringIterator inclIt = null;
            AttributeType fractionalIncludeType = DirectoryServer.getAttributeType("ds-sync-fractional-include");
            List<Attribute> inclAttrs = entry.getAttribute(fractionalIncludeType);
            Attribute inclAttr = null;
            if (inclAttrs != null && (inclAttr = inclAttrs.get(0)) != null) {
                inclIt = new LDAPReplicationDomain.AttributeValueStringIterator(inclAttr.iterator());
            }
            boolean sameConfig = LDAPReplicationDomain.isFractionalConfigConsistent(localFractionalConfig, exclIt, inclIt);
            if (localFractionalConfig.isFractional()) {
                if (sameConfig) {
                    return PluginResult.ImportLDIF.continueEntryProcessing();
                }
                boolean remoteDomainHasSomeConfig = false;
                if (exclAttr != null && exclAttr.size() > 0 || inclAttr != null && inclAttr.size() > 0) {
                    remoteDomainHasSomeConfig = true;
                }
                if (remoteDomainHasSomeConfig) {
                    LDAPReplicationDomain domain = importFractionalContext.getDomain();
                    if (domain != null) {
                        domain.setImportErrorMessageId(1);
                        domain.setFollowImport(false);
                        return PluginResult.ImportLDIF.stopEntryProcessing(null);
                    }
                    Message message = ReplicationMessages.NOTE_ERR_LDIF_IMPORT_FRACTIONAL_BAD_DATA_SET.get(replicatedDomainBaseDn.toString());
                    return PluginResult.ImportLDIF.stopEntryProcessing(message);
                }
                FractionalLDIFImportPlugin.flushFractionalConfigIntoEntry(localFractionalConfig, entry);
            } else {
                if (sameConfig) {
                    return PluginResult.ImportLDIF.continueEntryProcessing();
                }
                LDAPReplicationDomain domain = importFractionalContext.getDomain();
                if (domain != null) {
                    domain.setImportErrorMessageId(2);
                    domain.setFollowImport(false);
                    return PluginResult.ImportLDIF.stopEntryProcessing(null);
                }
                Message message = ReplicationMessages.NOTE_ERR_LDIF_IMPORT_FRACTIONAL_DATA_SET_IS_FRACTIONAL.get(replicatedDomainBaseDn.toString());
                return PluginResult.ImportLDIF.stopEntryProcessing(message);
            }
        }
        LDAPReplicationDomain.fractionalRemoveAttributesFromEntry(localFractionalConfig, entry.getDN().getRDN(), entry.getObjectClasses(), entry.getUserAttributes(), true);
        return PluginResult.ImportLDIF.continueEntryProcessing();
    }

    private static void flushFractionalConfigIntoEntry(LDAPReplicationDomain.FractionalConfig localFractionalConfig, Entry entry) {
        if (localFractionalConfig.isFractional()) {
            boolean fractionalExclusive = localFractionalConfig.isFractionalExclusive();
            Map<String, List<String>> fractionalSpecificClassesAttributes = localFractionalConfig.getFractionalSpecificClassesAttributes();
            List<String> fractionalAllClassesAttributes = localFractionalConfig.getFractionalAllClassesAttributes();
            String fractAttribute = null;
            fractAttribute = fractionalExclusive ? "ds-sync-fractional-exclude" : "ds-sync-fractional-include";
            AttributeBuilder attrBuilder = new AttributeBuilder(fractAttribute);
            boolean somethingToFlush = false;
            int size = fractionalAllClassesAttributes.size();
            if (size > 0) {
                String fracValue = "*:";
                int i = 1;
                for (String attrName : fractionalAllClassesAttributes) {
                    fracValue = fracValue + attrName;
                    if (i < size) {
                        fracValue = fracValue + ",";
                    }
                    ++i;
                }
                somethingToFlush = true;
                attrBuilder.add(fracValue);
            }
            if ((size = fractionalSpecificClassesAttributes.size()) > 0) {
                for (String className : fractionalSpecificClassesAttributes.keySet()) {
                    int valuesSize = fractionalSpecificClassesAttributes.get(className).size();
                    if (valuesSize <= 0) continue;
                    String fracValue = className + ":";
                    int i = 1;
                    for (String attrName : fractionalSpecificClassesAttributes.get(className)) {
                        fracValue = fracValue + attrName;
                        if (i < valuesSize) {
                            fracValue = fracValue + ",";
                        }
                        ++i;
                    }
                    somethingToFlush = true;
                    attrBuilder.add(fracValue);
                }
            }
            if (somethingToFlush) {
                ArrayList<AttributeValue> duplicateValues = new ArrayList<AttributeValue>();
                entry.addAttribute(attrBuilder.toAttribute(), duplicateValues);
            }
        }
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FractionalLDIFImportPluginCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FractionalLDIFImportPluginCfg configuration) {
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    private static class ImportFractionalContext {
        private LDAPReplicationDomain.FractionalConfig fractionalConfig = null;
        private LDAPReplicationDomain domain = null;

        public ImportFractionalContext(LDAPReplicationDomain.FractionalConfig fractionalConfig, LDAPReplicationDomain domain) {
            this.fractionalConfig = fractionalConfig;
            this.domain = domain;
        }

        public LDAPReplicationDomain.FractionalConfig getFractionalConfig() {
            return this.fractionalConfig;
        }

        public LDAPReplicationDomain getDomain() {
            return this.domain;
        }
    }
}

