/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.server.ExternalChangelogDomainCfg;
import org.opends.server.replication.plugin.LDAPReplicationDomain;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;

public class ExternalChangelogDomain
implements ConfigurationAddListener<ExternalChangelogDomainCfg>,
ConfigurationDeleteListener<ExternalChangelogDomainCfg>,
ConfigurationChangeListener<ExternalChangelogDomainCfg> {
    private LDAPReplicationDomain domain;
    private boolean isEnabled;

    public ExternalChangelogDomain(LDAPReplicationDomain domain, ExternalChangelogDomainCfg configuration) {
        this.domain = domain;
        this.isEnabled = configuration.isEnabled();
        configuration.addChangeListener(this);
        domain.setEclIncludes(domain.getServerId(), configuration.getECLInclude(), configuration.getECLIncludeForDeletes());
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(ExternalChangelogDomainCfg configuration) {
        try {
            if (this.domain == null) {
                DN rdns = DN.decode(configuration.dn().getParent().getRDN().getAttributeValue(0).getNormalizedValue());
                this.domain = MultimasterReplication.findDomain(rdns, null);
            }
        }
        catch (Exception e) {
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false);
        }
        this.isEnabled = configuration.isEnabled();
        this.domain.setEclIncludes(this.domain.getServerId(), configuration.getECLInclude(), configuration.getECLIncludeForDeletes());
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ExternalChangelogDomainCfg configuration) {
        try {
            if (this.domain == null) {
                DN rdns = DN.decode(configuration.dn().getParent().getRDN().getAttributeValue(0).getNormalizedValue());
                this.domain = MultimasterReplication.findDomain(rdns, null);
            }
            this.isEnabled = configuration.isEnabled();
            this.domain.changeConfig(configuration.getECLInclude(), configuration.getECLIncludeForDeletes());
            return new ConfigChangeResult(ResultCode.SUCCESS, false);
        }
        catch (Exception e) {
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false);
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(ExternalChangelogDomainCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ExternalChangelogDomainCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(ExternalChangelogDomainCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(ExternalChangelogDomainCfg configuration) {
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    boolean isEnabled() {
        return this.isEnabled;
    }
}

