/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.AttrHistorical;
import org.opends.server.replication.plugin.AttrValueHistorical;
import org.opends.server.replication.plugin.HistAttrModificationKey;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;

public class AttrHistoricalMultiple
extends AttrHistorical {
    private ChangeNumber deleteTime;
    private ChangeNumber lastUpdateTime;
    private final Map<AttrValueHistorical, AttrValueHistorical> valuesHist;

    public AttrHistoricalMultiple(ChangeNumber deleteTime, ChangeNumber updateTime, Map<AttrValueHistorical, AttrValueHistorical> valuesHist) {
        this.deleteTime = deleteTime;
        this.lastUpdateTime = updateTime;
        this.valuesHist = valuesHist == null ? new LinkedHashMap<AttrValueHistorical, AttrValueHistorical>() : valuesHist;
    }

    public AttrHistoricalMultiple() {
        this.deleteTime = null;
        this.lastUpdateTime = null;
        this.valuesHist = new LinkedHashMap<AttrValueHistorical, AttrValueHistorical>();
    }

    private ChangeNumber getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public ChangeNumber getDeleteTime() {
        return this.deleteTime;
    }

    AttrHistoricalMultiple duplicate() {
        return new AttrHistoricalMultiple(this.deleteTime, this.lastUpdateTime, this.valuesHist);
    }

    protected void delete(ChangeNumber CN) {
        Iterator<AttrValueHistorical> it = this.valuesHist.keySet().iterator();
        while (it.hasNext()) {
            AttrValueHistorical info = it.next();
            if (!CN.newerOrEquals(info.getValueUpdateTime()) || !CN.newerOrEquals(info.getValueDeleteTime())) continue;
            it.remove();
        }
        if (CN.newer(this.deleteTime)) {
            this.deleteTime = CN;
        }
        if (CN.newer(this.lastUpdateTime)) {
            this.lastUpdateTime = CN;
        }
    }

    protected void delete(AttributeValue val, ChangeNumber CN) {
        AttrValueHistorical info = new AttrValueHistorical(val, null, CN);
        this.valuesHist.remove(info);
        this.valuesHist.put(info, info);
        if (CN.newer(this.lastUpdateTime)) {
            this.lastUpdateTime = CN;
        }
    }

    protected void delete(Attribute attr, ChangeNumber CN) {
        for (AttributeValue val : attr) {
            AttrValueHistorical info = new AttrValueHistorical(val, null, CN);
            this.valuesHist.remove(info);
            this.valuesHist.put(info, info);
            if (!CN.newer(this.lastUpdateTime)) continue;
            this.lastUpdateTime = CN;
        }
    }

    protected void add(AttributeValue addedValue, ChangeNumber CN) {
        AttrValueHistorical info = new AttrValueHistorical(addedValue, CN, null);
        this.valuesHist.remove(info);
        this.valuesHist.put(info, info);
        if (CN.newer(this.lastUpdateTime)) {
            this.lastUpdateTime = CN;
        }
    }

    private void add(Attribute attr, ChangeNumber CN) {
        for (AttributeValue val : attr) {
            AttrValueHistorical info = new AttrValueHistorical(val, CN, null);
            this.valuesHist.remove(info);
            this.valuesHist.put(info, info);
            if (!CN.newer(this.lastUpdateTime)) continue;
            this.lastUpdateTime = CN;
        }
    }

    @Override
    public Map<AttrValueHistorical, AttrValueHistorical> getValuesHistorical() {
        return this.valuesHist;
    }

    @Override
    public boolean replayOperation(Iterator<Modification> modsIterator, ChangeNumber changeNumber, Entry modifiedEntry, Modification m) {
        if (ChangeNumber.compare(changeNumber, this.getLastUpdateTime()) < 0 || m.getModificationType() != ModificationType.REPLACE) {
            switch (m.getModificationType()) {
                case DELETE: {
                    if (changeNumber.older(this.getDeleteTime()).booleanValue()) {
                        modsIterator.remove();
                        break;
                    }
                    if (this.conflictDelete(changeNumber, m, modifiedEntry)) break;
                    modsIterator.remove();
                    break;
                }
                case ADD: {
                    this.conflictAdd(changeNumber, m, modsIterator);
                    break;
                }
                case REPLACE: {
                    if (changeNumber.older(this.getDeleteTime()).booleanValue()) {
                        modsIterator.remove();
                        break;
                    }
                    Attribute addedValues = m.getAttribute();
                    m.setAttribute(new AttributeBuilder(addedValues, true).toAttribute());
                    this.conflictDelete(changeNumber, m, modifiedEntry);
                    Attribute keptValues = m.getAttribute();
                    m.setAttribute(addedValues);
                    this.conflictAdd(changeNumber, m, modsIterator);
                    AttributeBuilder builder = new AttributeBuilder(keptValues);
                    builder.addAll(m.getAttribute());
                    m.setAttribute(builder.toAttribute());
                    break;
                }
            }
            return true;
        }
        this.processLocalOrNonConflictModification(changeNumber, m);
        return false;
    }

    @Override
    public void processLocalOrNonConflictModification(ChangeNumber changeNumber, Modification mod) {
        Attribute modAttr = mod.getAttribute();
        AttributeType type = modAttr.getAttributeType();
        switch (mod.getModificationType()) {
            case DELETE: {
                if (modAttr.isEmpty()) {
                    this.delete(changeNumber);
                    break;
                }
                this.delete(modAttr, changeNumber);
                break;
            }
            case ADD: {
                if (type.isSingleValue()) {
                    this.delete(changeNumber);
                }
                this.add(modAttr, changeNumber);
                break;
            }
            case REPLACE: {
                this.delete(changeNumber);
                this.add(modAttr, changeNumber);
                break;
            }
        }
    }

    private boolean conflictDelete(ChangeNumber changeNumber, Modification m, Entry modifiedEntry) {
        Attribute modAttr = m.getAttribute();
        if (modAttr.isEmpty()) {
            m.setModificationType(ModificationType.REPLACE);
            AttributeBuilder builder = new AttributeBuilder(modAttr, true);
            Iterator<AttrValueHistorical> it = this.valuesHist.keySet().iterator();
            while (it.hasNext()) {
                AttrValueHistorical valInfo = it.next();
                if (changeNumber.older(valInfo.getValueUpdateTime()).booleanValue()) {
                    builder.add(valInfo.getAttributeValue());
                    continue;
                }
                if (!changeNumber.newerOrEquals(valInfo.getValueDeleteTime())) continue;
                it.remove();
            }
            m.setAttribute(builder.toAttribute());
            if (changeNumber.newer(this.getDeleteTime())) {
                this.deleteTime = changeNumber;
            }
            if (changeNumber.newer(this.getLastUpdateTime())) {
                this.lastUpdateTime = changeNumber;
            }
        } else {
            AttributeBuilder builder = new AttributeBuilder(modAttr);
            for (AttributeValue val : modAttr) {
                boolean deleteIt = true;
                boolean addedInCurrentOp = false;
                AttrValueHistorical valInfo = new AttrValueHistorical(val, null, changeNumber);
                AttrValueHistorical oldValInfo = this.valuesHist.get(valInfo);
                if (oldValInfo != null) {
                    if (changeNumber.equals(oldValInfo.getValueUpdateTime())) {
                        addedInCurrentOp = true;
                    }
                    if (changeNumber.newerOrEquals(oldValInfo.getValueDeleteTime()) && changeNumber.newerOrEquals(oldValInfo.getValueUpdateTime())) {
                        this.valuesHist.remove(oldValInfo);
                        this.valuesHist.put(valInfo, valInfo);
                    } else if (oldValInfo.isUpdate()) {
                        deleteIt = false;
                    }
                } else {
                    this.valuesHist.remove(oldValInfo);
                    this.valuesHist.put(valInfo, valInfo);
                }
                if (deleteIt && (modifiedEntry.hasValue(modAttr.getAttributeType(), modAttr.getOptions(), val) || addedInCurrentOp)) continue;
                builder.remove(val);
                if (!builder.isEmpty()) continue;
                return false;
            }
            m.setAttribute(builder.toAttribute());
            if (changeNumber.newer(this.getLastUpdateTime())) {
                this.lastUpdateTime = changeNumber;
            }
        }
        return true;
    }

    private boolean conflictAdd(ChangeNumber changeNumber, Modification m, Iterator<Modification> modsIterator) {
        if (changeNumber.older(this.getDeleteTime()).booleanValue()) {
            modsIterator.remove();
            return false;
        }
        AttributeBuilder builder = new AttributeBuilder(m.getAttribute());
        for (AttributeValue addVal : m.getAttribute()) {
            AttrValueHistorical valInfo = new AttrValueHistorical(addVal, changeNumber, null);
            AttrValueHistorical oldValInfo = this.valuesHist.get(valInfo);
            if (oldValInfo == null) {
                this.valuesHist.put(valInfo, valInfo);
                continue;
            }
            if (oldValInfo.isUpdate()) {
                if (changeNumber.newer(oldValInfo.getValueUpdateTime())) {
                    this.valuesHist.remove(oldValInfo);
                    this.valuesHist.put(valInfo, valInfo);
                }
                builder.remove(addVal);
                continue;
            }
            if (changeNumber.newerOrEquals(oldValInfo.getValueDeleteTime())) {
                this.valuesHist.remove(oldValInfo);
                this.valuesHist.put(valInfo, valInfo);
                continue;
            }
            builder.remove(addVal);
        }
        Attribute attr = builder.toAttribute();
        m.setAttribute(attr);
        if (attr.isEmpty()) {
            modsIterator.remove();
        }
        if (changeNumber.newer(this.getLastUpdateTime())) {
            this.lastUpdateTime = changeNumber;
        }
        return true;
    }

    @Override
    public void assign(HistAttrModificationKey histKey, AttributeValue value, ChangeNumber cn) {
        switch (histKey) {
            case ADD: {
                if (value == null) break;
                this.add(value, cn);
                break;
            }
            case DEL: {
                if (value == null) break;
                this.delete(value, cn);
                break;
            }
            case REPL: {
                this.delete(cn);
                if (value == null) break;
                this.add(value, cn);
                break;
            }
            case DELATTR: {
                this.delete(cn);
            }
        }
    }
}

