/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.Severity;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class MultiDomainServerState
implements Iterable<String> {
    private Map<String, ServerState> list;

    public MultiDomainServerState() {
        this.list = new TreeMap<String, ServerState>();
    }

    public MultiDomainServerState(String mdss) throws DirectoryException {
        this.list = MultiDomainServerState.splitGenStateToServerStates(mdss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        MultiDomainServerState multiDomainServerState = this;
        synchronized (multiDomainServerState) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(String serviceId, ChangeNumber changeNumber) {
        if (changeNumber == null) {
            return false;
        }
        MultiDomainServerState multiDomainServerState = this;
        synchronized (multiDomainServerState) {
            int serverId = changeNumber.getServerId();
            ServerState oldServerState = this.list.get(serviceId);
            if (oldServerState == null) {
                oldServerState = new ServerState();
            }
            if (changeNumber.newer(oldServerState.getMaxChangeNumber(serverId))) {
                oldServerState.update(changeNumber);
                this.list.put(serviceId, oldServerState);
                return true;
            }
            return false;
        }
    }

    public void update(String serviceId, ServerState serverState) {
        this.list.put(serviceId, serverState.duplicate());
    }

    public String toString() {
        String res = "";
        if (this.list != null && !this.list.isEmpty()) {
            for (String serviceId : this.list.keySet()) {
                ServerState ss = this.list.get(serviceId);
                res = res + serviceId + ":" + ss.toString();
                res = res + ";";
            }
        }
        return res;
    }

    public void toString(StringBuilder buffer) {
        buffer.append(this.toString());
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.keySet().iterator();
    }

    public boolean equalsTo(MultiDomainServerState other) {
        return this.cover(other) && other.cover(this);
    }

    public boolean cover(MultiDomainServerState covered) {
        for (String serviceId : covered.list.keySet()) {
            ServerState state = this.list.get(serviceId);
            ServerState coveredState = covered.list.get(serviceId);
            if (state != null && coveredState != null && state.cover(coveredState)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, ServerState> splitGenStateToServerStates(String multidomainserverstate) throws DirectoryException {
        TreeMap<String, ServerState> startStates = new TreeMap<String, ServerState>();
        if (multidomainserverstate != null && multidomainserverstate.length() > 0) {
            try {
                String[] domains;
                for (String domain : domains = multidomainserverstate.split(";")) {
                    ServerState serverStateByDomain = new ServerState();
                    String[] fields = domain.split(":");
                    if (fields.length == 0) {
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, ReplicationMessages.ERR_INVALID_COOKIE_SYNTAX.get());
                    }
                    String domainBaseDN = fields[0];
                    if (fields.length > 1) {
                        String[] strCN;
                        String strState = fields[1];
                        for (String sr : strCN = strState.split(" ")) {
                            ChangeNumber fromChangeNumber = new ChangeNumber(sr);
                            serverStateByDomain.update(fromChangeNumber);
                        }
                    }
                    startStates.put(domainBaseDN, serverStateByDomain);
                }
            }
            catch (DirectoryException de) {
                throw de;
            }
            catch (Exception e) {
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, Message.raw(Category.SYNC, Severity.INFORMATION, "Exception raised: " + e, new Object[0]), e);
            }
        }
        return startStates;
    }
}

