/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.UserDefinedVirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.replication.common.MultiDomainServerState;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.workflowelement.externalchangelog.ECLWorkflowElement;

public class LastCookieVirtualProvider
extends VirtualAttributeProvider<UserDefinedVirtualAttributeCfg>
implements ConfigurationChangeListener<UserDefinedVirtualAttributeCfg> {
    @Override
    public void initializeVirtualAttributeProvider(UserDefinedVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public void finalizeVirtualAttributeProvider() {
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        return entry.getDN().isNullDN();
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        Set<AttributeValue> values = new HashSet<AttributeValue>();
        try {
            ECLWorkflowElement eclwe = (ECLWorkflowElement)DirectoryServer.getWorkflowElement("EXTERNAL CHANGE LOG");
            if (eclwe != null) {
                ArrayList<String> excludedDomains = MultimasterReplication.getECLDisabledDomains();
                if (!excludedDomains.contains("cn=changelog")) {
                    excludedDomains.add("cn=changelog");
                }
                ReplicationServer rs = eclwe.getReplicationServer();
                MultiDomainServerState lastCookie = rs.getLastECLCookie(excludedDomains);
                AttributeValue value = AttributeValues.create(ByteString.valueOf(lastCookie.toString()), ByteString.valueOf(lastCookie.toString()));
                values = Collections.singleton(value);
            }
            return values;
        }
        catch (Exception e) {
            return values;
        }
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation, boolean isPreIndexed) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
        Message message = ExtensionMessages.ERR_LASTCOOKIE_VATTR_NOT_SEARCHABLE.get(rule.getAttributeType().getNameOrOID());
        searchOperation.appendErrorMessage(message);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(UserDefinedVirtualAttributeCfg configuration, List<Message> unacceptableReasons) {
        return false;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(UserDefinedVirtualAttributeCfg configuration) {
        return new ConfigChangeResult(ResultCode.OTHER, false);
    }
}

