/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.util.TimeThread;

public class ChangeNumberGenerator {
    private long lastTime;
    private int seqnum;
    private int serverId;

    public ChangeNumberGenerator(int serverID2, long timestamp) {
        this.lastTime = timestamp;
        this.serverId = serverID2;
        this.seqnum = 0;
    }

    public ChangeNumberGenerator(int id, ServerState state) {
        this.lastTime = TimeThread.getTime();
        for (int stateId : state) {
            if (this.lastTime < state.getMaxChangeNumber(stateId).getTime()) {
                this.lastTime = state.getMaxChangeNumber(stateId).getTime();
            }
            if (stateId != id) continue;
            this.seqnum = state.getMaxChangeNumber(id).getSeqnum();
        }
        this.serverId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeNumber newChangeNumber() {
        long myTime;
        int mySeqnum;
        long curTime = TimeThread.getTime();
        ChangeNumberGenerator changeNumberGenerator = this;
        synchronized (changeNumberGenerator) {
            if (curTime > this.lastTime) {
                this.lastTime = curTime;
            }
            if (++this.seqnum <= 0) {
                this.seqnum = 0;
                ++this.lastTime;
            }
            mySeqnum = this.seqnum;
            myTime = this.lastTime;
        }
        return new ChangeNumber(myTime, mySeqnum, this.serverId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjust(ChangeNumber number) {
        if (number == null) {
            ChangeNumberGenerator changeNumberGenerator = this;
            synchronized (changeNumberGenerator) {
                this.lastTime = TimeThread.getTime();
                this.seqnum = 0;
            }
            return;
        }
        long rcvdTime = number.getTime();
        int changeServerId = number.getServerId();
        int changeSeqNum = number.getSeqnum();
        ChangeNumberGenerator changeNumberGenerator = this;
        synchronized (changeNumberGenerator) {
            if (this.lastTime <= rcvdTime) {
                this.lastTime = ++rcvdTime;
            }
            if (this.serverId == changeServerId && this.seqnum < changeSeqNum) {
                this.seqnum = changeSeqNum;
            }
        }
    }

    public void adjust(ServerState state) {
        for (int localServerId : state) {
            this.adjust(state.getMaxChangeNumber(localServerId));
        }
    }
}

