/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.ldap.AbandonRequestProtocolOp;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.IntermediateResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.protocols.ldap.UnbindRequestProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.LDAPException;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RawFilter;
import org.opends.server.types.RawModification;
import org.opends.server.types.SearchScope;

public class LDAPReader {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static LDAPMessage readMessage(ASN1Reader reader) throws LDAPException {
        ProtocolOp protocolOp;
        int messageID;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            Message message = ProtocolMessages.ERR_LDAP_MESSAGE_DECODE_NULL.get();
            throw new LDAPException(2, message);
        }
        try {
            messageID = (int)reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MESSAGE_DECODE_MESSAGE_ID.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            protocolOp = LDAPReader.readProtocolOp(reader);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MESSAGE_DECODE_PROTOCOL_OP.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        ArrayList<Control> controls = null;
        try {
            if (reader.hasNextElement()) {
                controls = LDAPReader.readControls(reader);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MESSAGE_DECODE_CONTROLS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            Message message = ProtocolMessages.ERR_LDAP_MESSAGE_DECODE_NULL.get();
            throw new LDAPException(2, message);
        }
        return new LDAPMessage(messageID, protocolOp, controls);
    }

    public static ProtocolOp readProtocolOp(ASN1Reader reader) throws LDAPException {
        byte type;
        try {
            type = reader.peekType();
        }
        catch (Exception e) {
            Message message = ProtocolMessages.ERR_LDAP_PROTOCOL_OP_DECODE_NULL.get();
            throw new LDAPException(2, message);
        }
        switch (type) {
            case 66: {
                return LDAPReader.readUnbindRequest(reader);
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                Message message = ProtocolMessages.ERR_LDAP_PROTOCOL_OP_DECODE_INVALID_TYPE.get(type);
                throw new LDAPException(2, message);
            }
            case 74: {
                return LDAPReader.readDeleteRequest(reader);
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                Message message = ProtocolMessages.ERR_LDAP_PROTOCOL_OP_DECODE_INVALID_TYPE.get(type);
                throw new LDAPException(2, message);
            }
            case 80: {
                return LDAPReader.readAbandonRequest(reader);
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                Message message = ProtocolMessages.ERR_LDAP_PROTOCOL_OP_DECODE_INVALID_TYPE.get(type);
                throw new LDAPException(2, message);
            }
            case 96: {
                return LDAPReader.readBindRequest(reader);
            }
            case 97: {
                return LDAPReader.readBindResponse(reader);
            }
            case 98: {
                Message message = ProtocolMessages.ERR_LDAP_PROTOCOL_OP_DECODE_INVALID_TYPE.get(type);
                throw new LDAPException(2, message);
            }
            case 99: {
                return LDAPReader.readSearchRequest(reader);
            }
            case 100: {
                return LDAPReader.readSearchEntry(reader);
            }
            case 101: {
                return LDAPReader.readSearchDone(reader);
            }
            case 102: {
                return LDAPReader.readModifyRequest(reader);
            }
            case 103: {
                return LDAPReader.readModifyResponse(reader);
            }
            case 104: {
                return LDAPReader.readAddRequest(reader);
            }
            case 105: {
                return LDAPReader.readAddResponse(reader);
            }
            case 106: {
                Message message = ProtocolMessages.ERR_LDAP_PROTOCOL_OP_DECODE_INVALID_TYPE.get(type);
                throw new LDAPException(2, message);
            }
            case 107: {
                return LDAPReader.readDeleteResponse(reader);
            }
            case 108: {
                return LDAPReader.readModifyDNRequest(reader);
            }
            case 109: {
                return LDAPReader.readModifyDNResponse(reader);
            }
            case 110: {
                return LDAPReader.readCompareRequest(reader);
            }
            case 111: {
                return LDAPReader.readCompareResponse(reader);
            }
            case 112: 
            case 113: 
            case 114: {
                Message message = ProtocolMessages.ERR_LDAP_PROTOCOL_OP_DECODE_INVALID_TYPE.get(type);
                throw new LDAPException(2, message);
            }
            case 115: {
                return LDAPReader.readSearchReference(reader);
            }
            case 116: 
            case 117: 
            case 118: {
                Message message = ProtocolMessages.ERR_LDAP_PROTOCOL_OP_DECODE_INVALID_TYPE.get(type);
                throw new LDAPException(2, message);
            }
            case 119: {
                return LDAPReader.readExtendedRequest(reader);
            }
            case 120: {
                return LDAPReader.readExtendedResponse(reader);
            }
            case 121: {
                return LDAPReader.readIntermediateResponse(reader);
            }
        }
        Message message = ProtocolMessages.ERR_LDAP_PROTOCOL_OP_DECODE_INVALID_TYPE.get(type);
        throw new LDAPException(2, message);
    }

    private static AbandonRequestProtocolOp readAbandonRequest(ASN1Reader reader) throws LDAPException {
        long idToAbandon;
        try {
            idToAbandon = reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ABANDON_REQUEST_DECODE_ID.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new AbandonRequestProtocolOp((int)idToAbandon);
    }

    private static AddRequestProtocolOp readAddRequest(ASN1Reader reader) throws LDAPException {
        ArrayList<RawAttribute> attributes;
        ByteString dn;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ADD_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            dn = reader.readOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ADD_REQUEST_DECODE_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readStartSequence();
            attributes = new ArrayList<RawAttribute>();
            while (reader.hasNextElement()) {
                attributes.add(LDAPAttribute.decode(reader));
            }
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ADD_REQUEST_DECODE_ATTRS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ADD_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new AddRequestProtocolOp(dn, attributes);
    }

    private static AddResponseProtocolOp readAddResponse(ASN1Reader reader) throws LDAPException {
        Message errorMessage;
        DN matchedDN;
        int resultCode;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            resultCode = (int)reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_RESULT_CODE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            String dnString = reader.readOctetStringAsString();
            matchedDN = dnString.length() == 0 ? null : DN.decode(dnString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_MATCHED_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            errorMessage = Message.raw(reader.readOctetStringAsString(), new Object[0]);
            if (errorMessage.length() == 0) {
                errorMessage = null;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_ERROR_MESSAGE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        ArrayList<String> referralURLs = null;
        try {
            if (reader.hasNextElement()) {
                reader.readStartSequence();
                referralURLs = new ArrayList<String>();
                while (reader.hasNextElement()) {
                    referralURLs.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_REFERRALS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new AddResponseProtocolOp(resultCode, errorMessage, matchedDN, referralURLs);
    }

    private static BindRequestProtocolOp readBindRequest(ASN1Reader reader) throws LDAPException {
        byte type;
        ByteString dn;
        int protocolVersion;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_BIND_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            protocolVersion = (int)reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_BIND_REQUEST_DECODE_VERSION.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            dn = reader.readOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_BIND_REQUEST_DECODE_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            type = reader.peekType();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_BIND_REQUEST_DECODE_CREDENTIALS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        ByteString simplePassword = null;
        String saslMechanism = null;
        ByteString saslCredentials = null;
        switch (type) {
            case -128: {
                try {
                    simplePassword = reader.readOctetString();
                    break;
                }
                catch (Exception e) {
                    Message message = ProtocolMessages.ERR_LDAP_BIND_REQUEST_DECODE_PASSWORD.get(String.valueOf(e));
                    throw new LDAPException(2, message, e);
                }
            }
            case -93: {
                try {
                    reader.readStartSequence();
                    saslMechanism = reader.readOctetStringAsString();
                    if (reader.hasNextElement()) {
                        saslCredentials = reader.readOctetString();
                    }
                    reader.readEndSequence();
                    break;
                }
                catch (Exception e) {
                    Message message = ProtocolMessages.ERR_LDAP_BIND_REQUEST_DECODE_SASL_INFO.get(String.valueOf(e));
                    throw new LDAPException(2, message, e);
                }
            }
            default: {
                Message message = ProtocolMessages.ERR_LDAP_BIND_REQUEST_DECODE_INVALID_CRED_TYPE.get(type);
                throw new LDAPException(7, message);
            }
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_BIND_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        if (type == -128) {
            return new BindRequestProtocolOp(dn, protocolVersion, simplePassword);
        }
        return new BindRequestProtocolOp(dn, saslMechanism, saslCredentials);
    }

    private static BindResponseProtocolOp readBindResponse(ASN1Reader reader) throws LDAPException {
        ByteString serverSASLCredentials;
        ArrayList<String> referralURLs;
        Message errorMessage;
        DN matchedDN;
        int resultCode;
        block26: {
            try {
                reader.readStartSequence();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
            try {
                resultCode = (int)reader.readInteger();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_RESULT_CODE.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
            try {
                String dnString = reader.readOctetStringAsString();
                matchedDN = dnString.length() == 0 ? null : DN.decode(dnString);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_MATCHED_DN.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
            try {
                errorMessage = Message.raw(reader.readOctetStringAsString(), new Object[0]);
                if (errorMessage.length() == 0) {
                    errorMessage = null;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_ERROR_MESSAGE.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
            referralURLs = null;
            serverSASLCredentials = null;
            try {
                if (reader.hasNextElement() && reader.peekType() == -93) {
                    try {
                        reader.readStartSequence();
                        referralURLs = new ArrayList<String>();
                        do {
                            referralURLs.add(reader.readOctetStringAsString());
                        } while (reader.hasNextElement());
                        reader.readEndSequence();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_REFERRALS.get(String.valueOf(e));
                        throw new LDAPException(2, message, e);
                    }
                }
                if (!reader.hasNextElement() || reader.peekType() != -121) break block26;
                try {
                    serverSASLCredentials = reader.readOctetString();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_LDAP_BIND_RESULT_DECODE_SERVER_SASL_CREDENTIALS.get(String.valueOf(e));
                    throw new LDAPException(2, message, e);
                }
            }
            catch (ASN1Exception asn1e) {
                if (!DebugLogger.debugEnabled()) break block26;
                TRACER.debugCaught(DebugLogLevel.ERROR, asn1e);
            }
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new BindResponseProtocolOp(resultCode, errorMessage, matchedDN, referralURLs, serverSASLCredentials);
    }

    private static CompareRequestProtocolOp readCompareRequest(ASN1Reader reader) throws LDAPException {
        ByteString assertionValue;
        String attributeType;
        ByteString dn;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_COMPARE_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            dn = reader.readOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_COMPARE_REQUEST_DECODE_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_COMPARE_REQUEST_DECODE_AVA.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            attributeType = reader.readOctetStringAsString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_COMPARE_REQUEST_DECODE_TYPE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            assertionValue = reader.readOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_COMPARE_REQUEST_DECODE_VALUE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_COMPARE_REQUEST_DECODE_AVA.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_COMPARE_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new CompareRequestProtocolOp(dn, attributeType, assertionValue);
    }

    private static CompareResponseProtocolOp readCompareResponse(ASN1Reader reader) throws LDAPException {
        Message errorMessage;
        DN matchedDN;
        int resultCode;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            resultCode = (int)reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_RESULT_CODE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            String dnString = reader.readOctetStringAsString();
            matchedDN = dnString.length() == 0 ? null : DN.decode(dnString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_MATCHED_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            errorMessage = Message.raw(reader.readOctetStringAsString(), new Object[0]);
            if (errorMessage.length() == 0) {
                errorMessage = null;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_ERROR_MESSAGE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        ArrayList<String> referralURLs = null;
        try {
            if (reader.hasNextElement()) {
                reader.readStartSequence();
                referralURLs = new ArrayList<String>();
                while (reader.hasNextElement()) {
                    referralURLs.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_REFERRALS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new CompareResponseProtocolOp(resultCode, errorMessage, matchedDN, referralURLs);
    }

    private static DeleteRequestProtocolOp readDeleteRequest(ASN1Reader reader) throws LDAPException {
        try {
            return new DeleteRequestProtocolOp(reader.readOctetString());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_DELETE_REQUEST_DECODE_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
    }

    private static DeleteResponseProtocolOp readDeleteResponse(ASN1Reader reader) throws LDAPException {
        Message errorMessage;
        DN matchedDN;
        int resultCode;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            resultCode = (int)reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_RESULT_CODE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            String dnString = reader.readOctetStringAsString();
            matchedDN = dnString.length() == 0 ? null : DN.decode(dnString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_MATCHED_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            errorMessage = Message.raw(reader.readOctetStringAsString(), new Object[0]);
            if (errorMessage.length() == 0) {
                errorMessage = null;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_ERROR_MESSAGE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        ArrayList<String> referralURLs = null;
        try {
            if (reader.hasNextElement()) {
                reader.readStartSequence();
                referralURLs = new ArrayList<String>();
                while (reader.hasNextElement()) {
                    referralURLs.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_REFERRALS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new DeleteResponseProtocolOp(resultCode, errorMessage, matchedDN, referralURLs);
    }

    private static ExtendedRequestProtocolOp readExtendedRequest(ASN1Reader reader) throws LDAPException {
        String oid;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_EXTENDED_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            oid = reader.readOctetStringAsString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_EXTENDED_REQUEST_DECODE_OID.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        ByteString value = null;
        try {
            if (reader.hasNextElement()) {
                value = reader.readOctetString();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_EXTENDED_REQUEST_DECODE_VALUE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_EXTENDED_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new ExtendedRequestProtocolOp(oid, value);
    }

    private static ExtendedResponseProtocolOp readExtendedResponse(ASN1Reader reader) throws LDAPException {
        ByteString value;
        String oid;
        ArrayList<String> referralURLs;
        Message errorMessage;
        DN matchedDN;
        int resultCode;
        block30: {
            try {
                reader.readStartSequence();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
            try {
                resultCode = (int)reader.readInteger();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_RESULT_CODE.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
            try {
                String dnString = reader.readOctetStringAsString();
                matchedDN = dnString.length() == 0 ? null : DN.decode(dnString);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_MATCHED_DN.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
            try {
                errorMessage = Message.raw(reader.readOctetStringAsString(), new Object[0]);
                if (errorMessage.length() == 0) {
                    errorMessage = null;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_ERROR_MESSAGE.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
            referralURLs = null;
            oid = null;
            value = null;
            try {
                if (reader.hasNextElement() && reader.peekType() == -93) {
                    try {
                        reader.readStartSequence();
                        referralURLs = new ArrayList<String>();
                        while (reader.hasNextElement()) {
                            referralURLs.add(reader.readOctetStringAsString());
                        }
                        reader.readEndSequence();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_REFERRALS.get(String.valueOf(e));
                        throw new LDAPException(2, message, e);
                    }
                }
                if (reader.hasNextElement() && reader.peekType() == -118) {
                    try {
                        oid = reader.readOctetStringAsString();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = ProtocolMessages.ERR_LDAP_EXTENDED_RESULT_DECODE_OID.get(String.valueOf(e));
                        throw new LDAPException(2, message, e);
                    }
                }
                if (!reader.hasNextElement() || reader.peekType() != -117) break block30;
                try {
                    value = reader.readOctetString();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_LDAP_EXTENDED_RESULT_DECODE_VALUE.get(String.valueOf(e));
                    throw new LDAPException(2, message, e);
                }
            }
            catch (ASN1Exception asn1e) {
                if (!DebugLogger.debugEnabled()) break block30;
                TRACER.debugCaught(DebugLogLevel.ERROR, asn1e);
            }
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new ExtendedResponseProtocolOp(resultCode, errorMessage, matchedDN, referralURLs, oid, value);
    }

    private static IntermediateResponseProtocolOp readIntermediateResponse(ASN1Reader reader) throws LDAPException {
        ByteString value;
        String oid;
        block16: {
            try {
                reader.readStartSequence();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_INTERMEDIATE_RESPONSE_DECODE_SEQUENCE.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
            oid = null;
            value = null;
            try {
                if (reader.hasNextElement() && reader.peekType() == -128) {
                    try {
                        if (reader.hasNextElement()) {
                            oid = reader.readOctetStringAsString();
                        }
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = ProtocolMessages.ERR_LDAP_INTERMEDIATE_RESPONSE_CANNOT_DECODE_OID.get(e.getMessage());
                        throw new LDAPException(2, message);
                    }
                }
                if (!reader.hasNextElement() || reader.peekType() != -127) break block16;
                try {
                    value = reader.readOctetString();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_LDAP_INTERMEDIATE_RESPONSE_CANNOT_DECODE_VALUE.get(e.getMessage());
                    throw new LDAPException(2, message);
                }
            }
            catch (ASN1Exception asn1e) {
                if (!DebugLogger.debugEnabled()) break block16;
                TRACER.debugCaught(DebugLogLevel.ERROR, asn1e);
            }
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_INTERMEDIATE_RESPONSE_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new IntermediateResponseProtocolOp(oid, value);
    }

    private static ModifyDNRequestProtocolOp readModifyDNRequest(ASN1Reader reader) throws LDAPException {
        boolean deleteOldRDN;
        ByteString newRDN;
        ByteString entryDN;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            entryDN = reader.readOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            newRDN = reader.readOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_NEW_RDN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            deleteOldRDN = reader.readBoolean();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_DELETE_OLD_RDN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        ByteString newSuperior = null;
        try {
            if (reader.hasNextElement()) {
                newSuperior = reader.readOctetString();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_NEW_SUPERIOR.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new ModifyDNRequestProtocolOp(entryDN, newRDN, deleteOldRDN, newSuperior);
    }

    private static ModifyDNResponseProtocolOp readModifyDNResponse(ASN1Reader reader) throws LDAPException {
        Message errorMessage;
        DN matchedDN;
        int resultCode;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            resultCode = (int)reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_RESULT_CODE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            String dnString = reader.readOctetStringAsString();
            matchedDN = dnString.length() == 0 ? null : DN.decode(dnString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_MATCHED_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            errorMessage = Message.raw(reader.readOctetStringAsString(), new Object[0]);
            if (errorMessage.length() == 0) {
                errorMessage = null;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_ERROR_MESSAGE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        ArrayList<String> referralURLs = null;
        try {
            if (reader.hasNextElement()) {
                reader.readStartSequence();
                referralURLs = new ArrayList<String>();
                while (reader.hasNextElement()) {
                    referralURLs.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_REFERRALS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new ModifyDNResponseProtocolOp(resultCode, errorMessage, matchedDN, referralURLs);
    }

    private static ModifyRequestProtocolOp readModifyRequest(ASN1Reader reader) throws LDAPException {
        ArrayList<RawModification> modifications;
        ByteString dn;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            dn = reader.readOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_REQUEST_DECODE_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readStartSequence();
            modifications = new ArrayList<RawModification>();
            while (reader.hasNextElement()) {
                modifications.add(LDAPModification.decode(reader));
            }
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_REQUEST_DECODE_MODS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new ModifyRequestProtocolOp(dn, modifications);
    }

    private static ModifyResponseProtocolOp readModifyResponse(ASN1Reader reader) throws LDAPException {
        Message errorMessage;
        DN matchedDN;
        int resultCode;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            resultCode = (int)reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_RESULT_CODE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            String dnString = reader.readOctetStringAsString();
            matchedDN = dnString.length() == 0 ? null : DN.decode(dnString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_MATCHED_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            errorMessage = Message.raw(reader.readOctetStringAsString(), new Object[0]);
            if (errorMessage.length() == 0) {
                errorMessage = null;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_ERROR_MESSAGE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        ArrayList<String> referralURLs = null;
        try {
            if (reader.hasNextElement()) {
                reader.readStartSequence();
                referralURLs = new ArrayList<String>();
                while (reader.hasNextElement()) {
                    referralURLs.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_REFERRALS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new ModifyResponseProtocolOp(resultCode, errorMessage, matchedDN, referralURLs);
    }

    private static SearchRequestProtocolOp readSearchRequest(ASN1Reader reader) throws LDAPException {
        LinkedHashSet<String> attributes;
        LDAPFilter filter;
        boolean typesOnly;
        int timeLimit;
        int sizeLimit;
        DereferencePolicy dereferencePolicy;
        SearchScope scope;
        ByteString baseDN;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            baseDN = reader.readOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_BASE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            int scopeValue = (int)reader.readInteger();
            switch (scopeValue) {
                case 0: {
                    scope = SearchScope.BASE_OBJECT;
                    break;
                }
                case 1: {
                    scope = SearchScope.SINGLE_LEVEL;
                    break;
                }
                case 2: {
                    scope = SearchScope.WHOLE_SUBTREE;
                    break;
                }
                case 3: {
                    scope = SearchScope.SUBORDINATE_SUBTREE;
                    break;
                }
                default: {
                    Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_INVALID_SCOPE.get(scopeValue);
                    throw new LDAPException(2, message);
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_SCOPE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            int derefValue = (int)reader.readInteger();
            switch (derefValue) {
                case 0: {
                    dereferencePolicy = DereferencePolicy.NEVER_DEREF_ALIASES;
                    break;
                }
                case 1: {
                    dereferencePolicy = DereferencePolicy.DEREF_IN_SEARCHING;
                    break;
                }
                case 2: {
                    dereferencePolicy = DereferencePolicy.DEREF_FINDING_BASE_OBJECT;
                    break;
                }
                case 3: {
                    dereferencePolicy = DereferencePolicy.DEREF_ALWAYS;
                    break;
                }
                default: {
                    Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_INVALID_DEREF.get(derefValue);
                    throw new LDAPException(2, message);
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_DEREF.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            sizeLimit = (int)reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_SIZE_LIMIT.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            timeLimit = (int)reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_TIME_LIMIT.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            typesOnly = reader.readBoolean();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_TYPES_ONLY.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            filter = RawFilter.decode(reader);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_FILTER.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readStartSequence();
            attributes = new LinkedHashSet<String>();
            while (reader.hasNextElement()) {
                attributes.add(reader.readOctetStringAsString());
            }
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_ATTRIBUTES.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new SearchRequestProtocolOp(baseDN, scope, dereferencePolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    private static SearchResultDoneProtocolOp readSearchDone(ASN1Reader reader) throws LDAPException {
        Message errorMessage;
        DN matchedDN;
        int resultCode;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            resultCode = (int)reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_RESULT_CODE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            String dnString = reader.readOctetStringAsString();
            matchedDN = dnString.length() == 0 ? null : DN.decode(dnString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_MATCHED_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            errorMessage = Message.raw(reader.readOctetStringAsString(), new Object[0]);
            if (errorMessage.length() == 0) {
                errorMessage = null;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_ERROR_MESSAGE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        ArrayList<String> referralURLs = null;
        try {
            if (reader.hasNextElement()) {
                reader.readStartSequence();
                referralURLs = new ArrayList<String>();
                while (reader.hasNextElement()) {
                    referralURLs.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_REFERRALS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new SearchResultDoneProtocolOp(resultCode, errorMessage, matchedDN, referralURLs);
    }

    public static SearchResultEntryProtocolOp readSearchEntry(ASN1Reader reader) throws LDAPException {
        LinkedList<LDAPAttribute> attributes;
        DN dn;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_ENTRY_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            dn = DN.decode(reader.readOctetStringAsString());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_ENTRY_DECODE_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readStartSequence();
            attributes = new LinkedList<LDAPAttribute>();
            while (reader.hasNextElement()) {
                attributes.add(LDAPAttribute.decode(reader));
            }
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_ENTRY_DECODE_ATTRS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_ENTRY_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new SearchResultEntryProtocolOp(dn, attributes);
    }

    private static SearchResultReferenceProtocolOp readSearchReference(ASN1Reader reader) throws LDAPException {
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REFERENCE_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        ArrayList<String> referralURLs = new ArrayList<String>();
        try {
            do {
                referralURLs.add(reader.readOctetStringAsString());
            } while (reader.hasNextElement());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REFERENCE_DECODE_URLS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REFERENCE_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new SearchResultReferenceProtocolOp(referralURLs);
    }

    private static UnbindRequestProtocolOp readUnbindRequest(ASN1Reader reader) throws LDAPException {
        try {
            reader.readNull();
            return new UnbindRequestProtocolOp();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_UNBIND_DECODE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
    }

    private static ArrayList<Control> readControls(ASN1Reader reader) throws LDAPException {
        try {
            reader.readStartSequence();
            ArrayList<Control> controls = new ArrayList<Control>();
            while (reader.hasNextElement()) {
                controls.add(LDAPReader.readControl(reader));
            }
            reader.readEndSequence();
            return controls;
        }
        catch (Exception e) {
            Message message = ProtocolMessages.ERR_LDAP_CONTROL_DECODE_CONTROLS_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
    }

    public static LDAPControl readControl(ASN1Reader reader) throws LDAPException {
        ByteString value;
        boolean isCritical;
        String oid;
        block18: {
            try {
                reader.readStartSequence();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_CONTROL_DECODE_SEQUENCE.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
            try {
                oid = reader.readOctetStringAsString();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_CONTROL_DECODE_OID.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
            isCritical = false;
            value = null;
            try {
                if (reader.hasNextElement() && reader.peekType() == 1) {
                    try {
                        isCritical = reader.readBoolean();
                    }
                    catch (Exception e2) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                        }
                        Message message = ProtocolMessages.ERR_LDAP_CONTROL_DECODE_CRITICALITY.get(String.valueOf(e2));
                        throw new LDAPException(2, message, e2);
                    }
                }
                if (!reader.hasNextElement() || reader.peekType() != 4) break block18;
                try {
                    value = reader.readOctetString();
                }
                catch (Exception e2) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                    Message message = ProtocolMessages.ERR_LDAP_CONTROL_DECODE_VALUE.get(String.valueOf(e2));
                    throw new LDAPException(2, message, e2);
                }
            }
            catch (ASN1Exception asn1e) {
                if (!DebugLogger.debugEnabled()) break block18;
                TRACER.debugCaught(DebugLogLevel.ERROR, asn1e);
            }
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_CONTROL_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new LDAPControl(oid, isCritical, value);
    }
}

