/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.util.ServerConstants;

public class LDAPControl
extends Control {
    private ByteString value;

    public LDAPControl(String oid) {
        super(oid, false);
    }

    public LDAPControl(String oid, boolean isCritical) {
        super(oid, isCritical);
    }

    public LDAPControl(String oid, boolean isCritical, ByteString value) {
        super(oid, isCritical);
        this.value = value;
    }

    public final ByteString getValue() {
        return this.value;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    @Override
    public void writeValue(ASN1Writer stream) throws IOException {
        if (this.value != null) {
            stream.writeOctetString(this.value);
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPControl(oid=");
        buffer.append(this.getOID());
        buffer.append(", criticality=");
        buffer.append(this.isCritical());
        if (this.value != null) {
            buffer.append(", value=");
            this.value.toHexPlusAscii(buffer, 4);
        }
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("LDAP Control");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  OID:  ");
        buffer.append(this.getOID());
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Criticality:  ");
        buffer.append(this.isCritical());
        buffer.append(ServerConstants.EOL);
        if (this.value != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Value:");
            this.value.toHexPlusAscii(buffer, indent + 4);
        }
    }
}

