/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.util.ServerConstants;

public class DeleteRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString dn;

    public DeleteRequestProtocolOp(ByteString dn) {
        this.dn = dn;
    }

    public ByteString getDN() {
        return this.dn;
    }

    @Override
    public void write(ASN1Writer stream) throws IOException {
        stream.writeOctetString((byte)74, this.dn);
    }

    @Override
    public byte getType() {
        return 74;
    }

    @Override
    public String getProtocolOpName() {
        return "Delete Request";
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("DeleteRequest(dn=");
        buffer.append(this.dn.toString());
        buffer.append(")");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Delete Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Entry DN:  ");
        buffer.append(this.dn.toString());
        buffer.append(ServerConstants.EOL);
    }
}

