/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.util.ServerConstants;

public class CompareRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString assertionValue;
    private ByteString dn;
    private String attributeType;

    public CompareRequestProtocolOp(ByteString dn, String attributeType, ByteString assertionValue) {
        this.dn = dn;
        this.attributeType = attributeType;
        this.assertionValue = assertionValue;
    }

    public ByteString getDN() {
        return this.dn;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public ByteString getAssertionValue() {
        return this.assertionValue;
    }

    @Override
    public byte getType() {
        return 110;
    }

    @Override
    public String getProtocolOpName() {
        return "Compare Request";
    }

    @Override
    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence((byte)110);
        stream.writeOctetString(this.dn);
        stream.writeStartSequence();
        stream.writeOctetString(this.attributeType);
        stream.writeOctetString(this.assertionValue);
        stream.writeEndSequence();
        stream.writeEndSequence();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("CompareRequest(dn=");
        buffer.append(this.dn.toString());
        buffer.append(", attribute=");
        buffer.append(this.attributeType);
        buffer.append(", value=");
        buffer.append(this.assertionValue.toString());
        buffer.append(")");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Compare Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Target DN:  ");
        buffer.append(this.dn.toString());
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Attribute Type:  ");
        buffer.append(this.attributeType);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Assertion Value:");
        buffer.append(ServerConstants.EOL);
        this.assertionValue.toHexPlusAscii(buffer, indent + 4);
    }
}

