/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;

public class DirectoryRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final long serialVersionUID = -6701450600497520362L;
    private static InheritableThreadLocal<Map> tlMapConnectionEnv = new InheritableThreadLocal();
    private static InheritableThreadLocal<String> tlStrServerHostname = new InheritableThreadLocal();
    private final boolean needClientCertificate;
    private transient SSLSocketFactory sslSocketFactory = null;
    private transient String serverHostname = null;

    public DirectoryRMIClientSocketFactory(boolean wellknown) {
        this.needClientCertificate = wellknown;
    }

    public static void setConnectionEnv(Map connectionEnv) {
        tlMapConnectionEnv.set(connectionEnv);
    }

    public static Map getConnectionEnv() {
        return (Map)tlMapConnectionEnv.get();
    }

    public static void setServerHostname(String serverHostname) {
        tlStrServerHostname.set(serverHostname);
    }

    public static String getServerHostname() {
        return (String)tlStrServerHostname.get();
    }

    public boolean getNeedClientCertificate() {
        return this.needClientCertificate;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory();
        String realhost = this.getRealServerHostname(host);
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(realhost, port);
        return sslSocket;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private synchronized String getRealServerHostname(String rmiHostname) throws IOException {
        if (this.serverHostname == null) {
            this.serverHostname = DirectoryRMIClientSocketFactory.getServerHostname();
            if (this.serverHostname == null) {
                this.serverHostname = "";
            }
        }
        if (this.serverHostname.length() > 0) {
            return this.serverHostname;
        }
        return rmiHostname;
    }

    private synchronized SSLSocketFactory getSSLSocketFactory() throws IOException {
        if (this.sslSocketFactory == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("sslSocketFactory is null, get a new one");
            }
            Map connectionEnv = DirectoryRMIClientSocketFactory.getConnectionEnv();
            TrustManager[] tms = null;
            if (connectionEnv != null && connectionEnv.containsKey("org.opends.server.protocol.jmx.ssl.trust.manager.array")) {
                try {
                    tms = (TrustManager[])connectionEnv.get("org.opends.server.protocol.jmx.ssl.trust.manager.array");
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    tms = null;
                }
                if (tms == null) {
                    throw new IOException("invalid type or null value for key [org.opends.server.protocol.jmx.ssl.trust.manager.array] in connection environment : " + connectionEnv.get("org.opends.server.protocol.jmx.ssl.trust.manager.array"));
                }
            }
            SSLContext ctx = null;
            try {
                ctx = SSLContext.getInstance("TLSv1");
                ctx.init(null, tms, null);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                throw new IOException("Unable to initialize SSL context : " + e.getMessage());
            }
            this.sslSocketFactory = ctx.getSocketFactory();
        }
        return this.sslSocketFactory;
    }
}

