/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.http;

import com.forgerock.opendj.util.AsynchronousFutureResult;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.opendj.adapter.server2x.Converters;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AbandonOperationBasis;
import org.opends.server.core.AddOperation;
import org.opends.server.core.AddOperationBasis;
import org.opends.server.core.BindOperation;
import org.opends.server.core.BindOperationBasis;
import org.opends.server.core.BoundedWorkQueueStrategy;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.CompareOperationBasis;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DeleteOperationBasis;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ExtendedOperationBasis;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.core.QueueingStrategy;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.SearchOperationBasis;
import org.opends.server.core.UnbindOperation;
import org.opends.server.core.UnbindOperationBasis;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.http.HTTPClientConnection;
import org.opends.server.protocols.http.HTTPConnectionHandler;
import org.opends.server.protocols.ldap.AbandonRequestProtocolOp;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.UnbindRequestProtocolOp;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Operation;

public class SdkConnectionAdapter
extends AbstractAsynchronousConnection {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final HTTPClientConnection clientConnection;
    private AtomicInteger nextMessageID = new AtomicInteger(0);
    private final QueueingStrategy queueingStrategy;
    private boolean isClosed;

    public SdkConnectionAdapter(HTTPClientConnection clientConnection) {
        this.clientConnection = clientConnection;
        this.queueingStrategy = new BoundedWorkQueueStrategy(clientConnection.getConnectionHandler().getCurrentConfig().getMaxConcurrentOpsPerConnection());
    }

    private <R> FutureResult<R> enqueueOperation(Operation operation, ResultHandler<? super R> resultHandler) {
        AsynchronousFutureResult futureResult = new AsynchronousFutureResult(resultHandler, operation.getMessageID());
        try {
            operation.setInnerOperation(this.clientConnection.isInnerConnection());
            HTTPConnectionHandler connHandler = this.clientConnection.getConnectionHandler();
            if (connHandler.keepStats()) {
                connHandler.getStatTracker().updateMessageRead(new LDAPMessage(operation.getMessageID(), this.toRequestProtocolOp(operation)));
            }
            this.clientConnection.addOperationInProgress(operation, (AsynchronousFutureResult<Result, ResultHandler<? super Result>>)futureResult);
            this.queueingStrategy.enqueueRequest(operation);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.clientConnection.removeOperationInProgress(operation.getMessageID());
            futureResult.handleErrorResult(ErrorResultException.newErrorResult((ResultCode)ResultCode.OPERATIONS_ERROR, (Throwable)e));
        }
        return futureResult;
    }

    private ProtocolOp toRequestProtocolOp(Operation operation) {
        operation.getResultCode().getIntValue();
        if (operation instanceof AbandonOperation) {
            AbandonOperation op = (AbandonOperation)operation;
            return new AbandonRequestProtocolOp(op.getIDToAbandon());
        }
        if (operation instanceof AddOperation) {
            AddOperation op = (AddOperation)operation;
            return new AddRequestProtocolOp(op.getRawEntryDN(), op.getRawAttributes());
        }
        if (operation instanceof BindOperation) {
            BindOperation op = (BindOperation)operation;
            return new BindRequestProtocolOp(op.getRawBindDN(), op.getSASLMechanism(), op.getSASLCredentials());
        }
        if (operation instanceof CompareOperation) {
            CompareOperation op = (CompareOperation)operation;
            return new CompareRequestProtocolOp(op.getRawEntryDN(), op.getRawAttributeType(), op.getAssertionValue());
        }
        if (operation instanceof DeleteOperation) {
            DeleteOperation op = (DeleteOperation)operation;
            return new DeleteRequestProtocolOp(op.getRawEntryDN());
        }
        if (operation instanceof ExtendedOperation) {
            ExtendedOperation op = (ExtendedOperation)operation;
            return new ExtendedRequestProtocolOp(op.getRequestOID(), op.getRequestValue());
        }
        if (operation instanceof ModifyDNOperation) {
            ModifyDNOperation op = (ModifyDNOperation)operation;
            return new ModifyDNRequestProtocolOp(op.getRawEntryDN(), op.getRawNewRDN(), op.deleteOldRDN(), op.getRawNewSuperior());
        }
        if (operation instanceof ModifyOperation) {
            ModifyOperation op = (ModifyOperation)operation;
            return new ModifyRequestProtocolOp(op.getRawEntryDN(), op.getRawModifications());
        }
        if (operation instanceof SearchOperation) {
            SearchOperation op = (SearchOperation)operation;
            return new SearchRequestProtocolOp(op.getRawBaseDN(), op.getScope(), op.getDerefPolicy(), op.getSizeLimit(), op.getTimeLimit(), op.getTypesOnly(), op.getRawFilter(), op.getAttributes());
        }
        if (operation instanceof UnbindOperation) {
            return new UnbindRequestProtocolOp();
        }
        throw new RuntimeException("Not implemented for operation " + operation);
    }

    public FutureResult<Void> abandonAsync(AbandonRequest request) {
        int messageID = this.nextMessageID.getAndIncrement();
        AbandonOperationBasis operation = new AbandonOperationBasis(this.clientConnection, messageID, messageID, Converters.to((List)request.getControls()), request.getRequestID());
        return this.enqueueOperation(operation, null);
    }

    public FutureResult<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int messageID = this.nextMessageID.getAndIncrement();
        AddOperationBasis operation = new AddOperationBasis(this.clientConnection, messageID, messageID, Converters.to((List)request.getControls()), Converters.to((ByteString)ByteString.valueOf((Object)request.getName())), Converters.to((Iterable)request.getAllAttributes()));
        return this.enqueueOperation(operation, resultHandler);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
    }

    public FutureResult<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super BindResult> resultHandler) {
        int messageID = this.nextMessageID.getAndIncrement();
        String userName = request.getName();
        byte[] password = ((SimpleBindRequest)request).getPassword();
        BindOperationBasis operation = new BindOperationBasis((ClientConnection)this.clientConnection, (long)messageID, messageID, (List<Control>)Converters.to((List)request.getControls()), "3", Converters.to((String)userName), org.opends.server.types.ByteString.wrap(password));
        return this.enqueueOperation(operation, resultHandler);
    }

    public void close(UnbindRequest request, String reason) {
        AuthenticationInfo authInfo = this.clientConnection.getAuthenticationInfo();
        if (authInfo != null && authInfo.isAuthenticated()) {
            int messageID = this.nextMessageID.getAndIncrement();
            UnbindOperationBasis operation = new UnbindOperationBasis(this.clientConnection, messageID, messageID, Converters.to((List)request.getControls()));
            operation.setInnerOperation(this.clientConnection.isInnerConnection());
            operation.run();
        } else {
            this.clientConnection.disconnect(DisconnectReason.UNBIND, false, null);
        }
        this.clientConnection.log(200);
        this.isClosed = true;
    }

    public FutureResult<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super CompareResult> resultHandler) {
        int messageID = this.nextMessageID.getAndIncrement();
        CompareOperationBasis operation = new CompareOperationBasis((ClientConnection)this.clientConnection, (long)messageID, messageID, (List<Control>)Converters.to((List)request.getControls()), Converters.to((ByteString)ByteString.valueOf((Object)request.getName())), request.getAttributeDescription().getAttributeType().getOID(), Converters.to((ByteString)request.getAssertionValue()));
        return this.enqueueOperation(operation, resultHandler);
    }

    public FutureResult<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int messageID = this.nextMessageID.getAndIncrement();
        DeleteOperationBasis operation = new DeleteOperationBasis((ClientConnection)this.clientConnection, (long)messageID, messageID, (List<Control>)Converters.to((List)request.getControls()), Converters.to((ByteString)ByteString.valueOf((Object)request.getName())));
        return this.enqueueOperation(operation, resultHandler);
    }

    public <R extends ExtendedResult> FutureResult<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super R> resultHandler) {
        int messageID = this.nextMessageID.getAndIncrement();
        ExtendedOperationBasis operation = new ExtendedOperationBasis(this.clientConnection, messageID, messageID, Converters.to((List)request.getControls()), request.getOID(), Converters.to((ByteString)request.getValue()));
        return this.enqueueOperation(operation, resultHandler);
    }

    public QueueingStrategy getQueueingStrategy() {
        return this.queueingStrategy;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isValid() {
        return this.clientConnection.isConnectionValid();
    }

    public FutureResult<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int messageID = this.nextMessageID.getAndIncrement();
        ModifyOperationBasis operation = new ModifyOperationBasis((ClientConnection)this.clientConnection, (long)messageID, messageID, (List<Control>)Converters.to((List)request.getControls()), Converters.to((DN)request.getName()), Converters.toModifications((List)request.getModifications()));
        return this.enqueueOperation(operation, resultHandler);
    }

    public FutureResult<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int messageID = this.nextMessageID.getAndIncrement();
        ModifyDNOperationBasis operation = new ModifyDNOperationBasis((ClientConnection)this.clientConnection, (long)messageID, messageID, (List<Control>)Converters.to((List)request.getControls()), Converters.to((DN)request.getName()), Converters.to((RDN)request.getNewRDN()), request.isDeleteOldRDN(), Converters.to((DN)request.getNewSuperior()));
        return this.enqueueOperation(operation, resultHandler);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
    }

    public FutureResult<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler resultHandler) {
        int messageID = this.nextMessageID.getAndIncrement();
        SearchOperationBasis operation = new SearchOperationBasis((ClientConnection)this.clientConnection, (long)messageID, messageID, (List<Control>)Converters.to((List)request.getControls()), Converters.to((ByteString)ByteString.valueOf((Object)request.getName())), Converters.to((SearchScope)request.getScope()), Converters.to((DereferenceAliasesPolicy)request.getDereferenceAliasesPolicy()), request.getSizeLimit(), request.getTimeLimit(), request.isTypesOnly(), Converters.to((Filter)request.getFilter()), new LinkedHashSet<String>(request.getAttributes()));
        return this.enqueueOperation(operation, (ResultHandler)resultHandler);
    }

    public String toString() {
        return this.clientConnection.toString();
    }
}

