/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.http;

import com.forgerock.opendj.util.AsynchronousFutureResult;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import org.forgerock.opendj.adapter.server2x.Converters;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.responses.Result;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.HTTPAccessLogger;
import org.opends.server.loggers.HTTPRequestInfo;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.http.HTTPConnectionHandler;
import org.opends.server.protocols.http.HTTPStatistics;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.Operation;
import org.opends.server.types.OperationType;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;

final class HTTPClientConnection
extends ClientConnection
implements HTTPRequestInfo {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String SERVLET_SSF_CONSTANT = "javax.servlet.request.key_size";
    private volatile boolean connectionValid = true;
    private boolean disconnectRequested;
    private final boolean keepStats;
    private final Map<Integer, OperationWithFutureResult> operationsInProgress = new ConcurrentHashMap<Integer, OperationWithFutureResult>();
    private final AtomicLong operationsPerformed = new AtomicLong(0L);
    private final Object opsInProgressLock = new Object();
    private final long connectionID;
    private final HTTPConnectionHandler connectionHandler;
    private final HTTPStatistics statTracker;
    private boolean useNanoTime = false;
    private AtomicLong totalProcessingTime = new AtomicLong();
    private String protocol;
    private final String method;
    private final String query;
    private final String userAgent;
    private String authUser;
    private AtomicInteger statusCode = new AtomicInteger(0);
    private String clientAddress;
    private String clientHost;
    private int clientPort;
    private InetAddress remoteAddress;
    private String serverAddress;
    private String serverHost;
    private int serverPort;
    private InetAddress localAddress;
    private boolean isSecure;
    private int securityStrengthFactor;

    public HTTPClientConnection(HTTPConnectionHandler connectionHandler, HttpServletRequest request) {
        this.connectionHandler = connectionHandler;
        this.clientAddress = request.getRemoteAddr();
        this.clientPort = request.getRemotePort();
        this.serverAddress = request.getLocalAddr();
        this.serverPort = request.getLocalPort();
        this.remoteAddress = this.toInetAddress(request.getRemoteAddr());
        this.localAddress = this.toInetAddress(request.getLocalAddr());
        this.isSecure = request.isSecure();
        this.securityStrengthFactor = this.calcSSF(request.getAttribute(SERVLET_SSF_CONSTANT));
        this.method = request.getMethod();
        this.query = this.computeQuery(request);
        this.protocol = request.getProtocol();
        this.userAgent = request.getHeader("User-Agent");
        this.statTracker = this.connectionHandler.getStatTracker();
        this.keepStats = connectionHandler.keepStats();
        if (this.keepStats) {
            this.statTracker.updateConnect();
            this.useNanoTime = DirectoryServer.getUseNanoTime();
        }
        this.connectionID = DirectoryServer.newConnectionAccepted(this);
    }

    private String computeQuery(HttpServletRequest request) {
        if (request.getQueryString() != null) {
            return request.getRequestURI() + "?" + request.getQueryString();
        }
        return request.getRequestURI();
    }

    @Override
    public String getAuthUser() {
        return this.authUser;
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    public HTTPConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public long getTotalProcessingTime() {
        return this.totalProcessingTime.get();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getClientAddress() {
        return this.clientAddress;
    }

    @Override
    public String getClientHost() {
        return this.clientHost;
    }

    @Override
    public int getClientPort() {
        return this.clientPort;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public String getServerHost() {
        return this.serverHost;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public void sendResponse(Operation operation) {
        OperationWithFutureResult op;
        long time = this.getProcessingTime(operation);
        this.totalProcessingTime.addAndGet(time);
        if (this.keepStats) {
            this.statTracker.updateRequestMonitoringData(this.getMethod(), time);
            this.statTracker.updateOperationMonitoringData(operation.getOperationType(), time);
        }
        if ((op = this.operationsInProgress.get(operation.getMessageID())) != null) {
            try {
                op.futureResult.handleResult((Object)Converters.getResponseResult((Operation)operation));
                if (this.keepStats) {
                    this.statTracker.updateMessageWritten(new LDAPMessage(operation.getMessageID(), this.toResponseProtocolOp(operation)));
                }
            }
            catch (ErrorResultException e) {
                op.futureResult.handleErrorResult(e);
            }
        }
    }

    private long getProcessingTime(Operation operation) {
        if (this.useNanoTime) {
            return operation.getProcessingNanoTime();
        }
        return operation.getProcessingTime();
    }

    private ProtocolOp toResponseProtocolOp(Operation operation) {
        int resultCode = operation.getResultCode().getIntValue();
        if (operation instanceof AddOperation) {
            return new AddResponseProtocolOp(resultCode);
        }
        if (operation instanceof BindOperation) {
            return new BindResponseProtocolOp(resultCode);
        }
        if (operation instanceof CompareOperation) {
            return new CompareResponseProtocolOp(resultCode);
        }
        if (operation instanceof DeleteOperation) {
            return new DeleteResponseProtocolOp(resultCode);
        }
        if (operation instanceof ExtendedOperation) {
            return new ExtendedResponseProtocolOp(resultCode);
        }
        if (operation instanceof ModifyDNOperation) {
            return new ModifyDNResponseProtocolOp(resultCode);
        }
        if (operation instanceof ModifyOperation) {
            return new ModifyResponseProtocolOp(resultCode);
        }
        if (operation instanceof SearchOperation) {
            return new SearchResultDoneProtocolOp(resultCode);
        }
        throw new RuntimeException("Not implemented for operation " + operation);
    }

    @Override
    public void sendSearchEntry(SearchOperation operation, SearchResultEntry searchEntry) throws DirectoryException {
        OperationWithFutureResult op = this.operationsInProgress.get(operation.getMessageID());
        if (op != null) {
            ((SearchResultHandler)op.futureResult.getResultHandler()).handleEntry(Converters.from((SearchResultEntry)searchEntry));
            if (this.keepStats) {
                this.statTracker.updateMessageWritten(new LDAPMessage(operation.getMessageID(), new SearchResultEntryProtocolOp(searchEntry)));
            }
        }
    }

    @Override
    public boolean sendSearchReference(SearchOperation operation, SearchResultReference searchReference) throws DirectoryException {
        OperationWithFutureResult op = this.operationsInProgress.get(operation.getMessageID());
        if (op != null) {
            ((SearchResultHandler)op.futureResult.getResultHandler()).handleReference(Converters.from((SearchResultReference)searchReference));
            if (this.keepStats) {
                this.statTracker.updateMessageWritten(new LDAPMessage(operation.getMessageID(), new SearchResultReferenceProtocolOp(searchReference)));
            }
        }
        return this.connectionValid;
    }

    @Override
    protected boolean sendIntermediateResponseMessage(IntermediateResponse intermediateResponse) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(DisconnectReason disconnectReason, boolean sendNotification, Message message) {
        Object object = this.opsInProgressLock;
        synchronized (object) {
            if (this.disconnectRequested) {
                return;
            }
            this.disconnectRequested = true;
        }
        if (this.keepStats) {
            this.statTracker.updateDisconnect();
        }
        if (this.connectionID >= 0L) {
            DirectoryServer.connectionClosed(this);
        }
        this.connectionValid = false;
        if (message != null) {
            MessageBuilder msgBuilder = new MessageBuilder();
            msgBuilder.append(disconnectReason.getClosureMessage());
            msgBuilder.append(": ");
            msgBuilder.append(message);
            this.cancelAllOperations(new CancelRequest(true, msgBuilder.toMessage()));
        } else {
            this.cancelAllOperations(new CancelRequest(true, disconnectReason.getClosureMessage()));
        }
        this.finalizeConnectionInternal();
        this.connectionHandler.removeClientConnection(this);
        AccessLogger.logDisconnect(this, disconnectReason, message);
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode.get();
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public Collection<Operation> getOperationsInProgress() {
        Collection<OperationWithFutureResult> values = this.operationsInProgress.values();
        ArrayList<Operation> results = new ArrayList<Operation>(values.size());
        for (OperationWithFutureResult op : values) {
            results.add(op.operation);
        }
        return results;
    }

    @Override
    public Operation getOperationInProgress(int messageID) {
        OperationWithFutureResult op = this.operationsInProgress.get(messageID);
        if (op != null) {
            return op.operation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOperationInProgress(Operation operation, AsynchronousFutureResult<Result, ResultHandler<? super Result>> futureResult) throws DirectoryException {
        Object object = this.opsInProgressLock;
        synchronized (object) {
            if (this.disconnectRequested) {
                Message message = ProtocolMessages.WARN_CLIENT_DISCONNECT_IN_PROGRESS.get();
                throw new DirectoryException(org.opends.server.types.ResultCode.UNWILLING_TO_PERFORM, message);
            }
            this.operationsInProgress.put(operation.getMessageID(), new OperationWithFutureResult(operation, futureResult));
        }
    }

    @Override
    public boolean removeOperationInProgress(int messageID) {
        OperationWithFutureResult previousValue = this.operationsInProgress.remove(messageID);
        if (previousValue != null) {
            this.operationsPerformed.incrementAndGet();
            Operation operation = previousValue.operation;
            if (operation.getOperationType() == OperationType.ABANDON && this.keepStats && operation.getResultCode() == org.opends.server.types.ResultCode.CANCELED) {
                this.statTracker.updateAbandonedOperation();
            }
        }
        return previousValue != null;
    }

    @Override
    public CancelResult cancelOperation(int messageID, CancelRequest cancelRequest) {
        OperationWithFutureResult op = this.operationsInProgress.remove(messageID);
        if (op != null) {
            op.futureResult.handleErrorResult(ErrorResultException.newErrorResult((ResultCode)ResultCode.CANCELLED));
            return op.operation.cancel(cancelRequest);
        }
        return new CancelResult(org.opends.server.types.ResultCode.NO_SUCH_OPERATION, null);
    }

    private int calcSSF(Object ssf) {
        block4: {
            if (ssf instanceof Number) {
                return ((Number)ssf).intValue();
            }
            if (ssf instanceof String) {
                try {
                    return Integer.parseInt((String)ssf);
                }
                catch (IllegalArgumentException ignored) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, ignored);
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllOperations(CancelRequest cancelRequest) {
        Object object = this.opsInProgressLock;
        synchronized (object) {
            block8: {
                try {
                    for (OperationWithFutureResult op : this.operationsInProgress.values()) {
                        try {
                            op.futureResult.handleErrorResult(ErrorResultException.newErrorResult((ResultCode)ResultCode.CANCELLED));
                            op.operation.abort(cancelRequest);
                            if (!this.keepStats) continue;
                            this.statTracker.updateAbandonedOperation();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    this.operationsInProgress.clear();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block8;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllOperationsExcept(CancelRequest cancelRequest, int messageID) {
        Object object = this.opsInProgressLock;
        synchronized (object) {
            OperationWithFutureResult toKeep = this.operationsInProgress.remove(messageID);
            try {
                this.cancelAllOperations(cancelRequest);
            }
            finally {
                this.operationsInProgress.put(messageID, toKeep);
            }
        }
    }

    @Override
    public long getNumberOfOperations() {
        return this.operationsPerformed.get();
    }

    @Override
    public String getMonitorSummary() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("connID=\"");
        buffer.append(this.getConnectionID());
        buffer.append("\" connectTime=\"");
        buffer.append(this.getConnectTimeString());
        buffer.append("\" source=\"");
        buffer.append(this.getClientAddress());
        buffer.append(":");
        buffer.append(this.getClientPort());
        buffer.append("\" destination=\"");
        buffer.append(this.getServerAddress());
        buffer.append(":");
        buffer.append(this.connectionHandler.getListenPort());
        buffer.append("\" authDN=\"");
        DN authDN = this.getAuthenticationInfo().getAuthenticationDN();
        if (authDN != null) {
            authDN.toString(buffer);
        }
        return buffer.toString();
    }

    private InetAddress toInetAddress(String address) {
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("HTTP client connection from ");
        buffer.append(this.getClientAddress()).append(":").append(this.getClientPort());
        buffer.append(" to ");
        buffer.append(this.getServerAddress()).append(":").append(this.getServerPort());
    }

    public HTTPStatistics getStatTracker() {
        return this.statTracker;
    }

    @Override
    public int getSSF() {
        return this.securityStrengthFactor;
    }

    @Override
    public boolean isConnectionValid() {
        return this.connectionValid;
    }

    @Override
    public boolean isInnerConnection() {
        return true;
    }

    @Override
    public void log(int statusCode) {
        if (this.statusCode.compareAndSet(0, statusCode)) {
            HTTPAccessLogger.logRequestInfo(this);
        }
    }

    private static final class OperationWithFutureResult {
        final Operation operation;
        final AsynchronousFutureResult<Result, ResultHandler<? super Result>> futureResult;

        public OperationWithFutureResult(Operation operation, AsynchronousFutureResult<Result, ResultHandler<? super Result>> futureResult) {
            this.operation = operation;
            this.futureResult = futureResult;
        }

        public String toString() {
            return this.operation.toString();
        }
    }
}

