/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.IOException;
import java.io.OutputStream;
import org.opends.server.types.ByteStringBuilder;

final class ByteSequenceOutputStream
extends OutputStream {
    private static final int BUFFER_INIT_SIZE = 32;
    private final ByteStringBuilder buffer;
    private final int maxInternalBufferSize;

    ByteSequenceOutputStream(ByteStringBuilder buffer, int maxInternalBufferSize) {
        this.buffer = buffer;
        this.maxInternalBufferSize = Math.max(maxInternalBufferSize, 32);
    }

    @Override
    public void write(int i) throws IOException {
        this.buffer.append((byte)(i & 0xFF));
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.buffer.append(bytes);
    }

    @Override
    public void write(byte[] bytes, int i, int i1) throws IOException {
        this.buffer.append(bytes, i, i1);
    }

    int length() {
        return this.buffer.length();
    }

    void writeTo(OutputStream stream) throws IOException {
        this.buffer.copyTo(stream);
    }

    void reset() {
        if (this.buffer.capacity() > this.maxInternalBufferSize) {
            this.buffer.clear(32);
        } else {
            this.buffer.clear();
        }
    }

    @Override
    public void close() throws IOException {
        this.reset();
    }
}

