/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.admin.std.server.SevenBitCleanPluginCfg;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.RDN;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreParseAddOperation;
import org.opends.server.types.operation.PreParseModifyDNOperation;
import org.opends.server.types.operation.PreParseModifyOperation;

public final class SevenBitCleanPlugin
extends DirectoryServerPlugin<SevenBitCleanPluginCfg>
implements ConfigurationChangeListener<SevenBitCleanPluginCfg> {
    private static final byte MASK = 127;
    private SevenBitCleanPluginCfg currentConfig;

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, SevenBitCleanPluginCfg configuration) throws ConfigException {
        this.currentConfig = configuration;
        configuration.addSevenBitCleanChangeListener(this);
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case LDIF_IMPORT: 
                case PRE_PARSE_ADD: 
                case PRE_PARSE_MODIFY: 
                case PRE_PARSE_MODIFY_DN: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_7BIT_INVALID_PLUGIN_TYPE.get(t.toString());
            throw new ConfigException(message);
        }
    }

    @Override
    public final void finalizePlugin() {
        this.currentConfig.removeSevenBitCleanChangeListener(this);
    }

    @Override
    public final PluginResult.ImportLDIF doLDIFImport(LDIFImportConfig importConfig, Entry entry) {
        SevenBitCleanPluginCfg config = this.currentConfig;
        SortedSet<DN> baseDNs = config.getBaseDN();
        if (baseDNs != null && !baseDNs.isEmpty()) {
            boolean found = true;
            for (DN baseDN : baseDNs) {
                if (!baseDN.isAncestorOf(entry.getDN())) continue;
                found = true;
                break;
            }
            if (!found) {
                return PluginResult.ImportLDIF.continueEntryProcessing();
            }
        }
        for (AttributeType t : config.getAttributeType()) {
            List<Attribute> attrList = entry.getAttribute(t);
            if (attrList == null) continue;
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    if (this.is7BitClean(v.getValue())) continue;
                    Message rejectMessage = PluginMessages.ERR_PLUGIN_7BIT_IMPORT_ATTR_NOT_CLEAN.get(a.getNameWithOptions());
                    return PluginResult.ImportLDIF.stopEntryProcessing(rejectMessage);
                }
            }
        }
        return PluginResult.ImportLDIF.continueEntryProcessing();
    }

    @Override
    public final PluginResult.PreParse doPreParse(PreParseAddOperation addOperation) {
        DN entryDN;
        SevenBitCleanPluginCfg config = this.currentConfig;
        try {
            entryDN = DN.decode(addOperation.getRawEntryDN());
        }
        catch (DirectoryException de) {
            return PluginResult.PreParse.stopProcessing(de.getResultCode(), PluginMessages.ERR_PLUGIN_7BIT_CANNOT_DECODE_DN.get(de.getMessageObject()));
        }
        if (this.isInScope(config, entryDN)) {
            for (RawAttribute rawAttr : addOperation.getRawAttributes()) {
                Attribute a;
                try {
                    a = rawAttr.toAttribute();
                }
                catch (LDAPException le) {
                    return PluginResult.PreParse.stopProcessing(ResultCode.valueOf(le.getResultCode()), PluginMessages.ERR_PLUGIN_7BIT_CANNOT_DECODE_ATTR.get(rawAttr.getAttributeType(), le.getErrorMessage()));
                }
                if (!config.getAttributeType().contains(a.getAttributeType())) continue;
                for (AttributeValue v : a) {
                    if (this.is7BitClean(v.getValue())) continue;
                    return PluginResult.PreParse.stopProcessing(ResultCode.CONSTRAINT_VIOLATION, PluginMessages.ERR_PLUGIN_7BIT_MODIFYDN_ATTR_NOT_CLEAN.get(rawAttr.getAttributeType()));
                }
            }
        }
        return PluginResult.PreParse.continueOperationProcessing();
    }

    @Override
    public final PluginResult.PreParse doPreParse(PreParseModifyOperation modifyOperation) {
        DN entryDN;
        SevenBitCleanPluginCfg config = this.currentConfig;
        try {
            entryDN = DN.decode(modifyOperation.getRawEntryDN());
        }
        catch (DirectoryException de) {
            return PluginResult.PreParse.stopProcessing(de.getResultCode(), PluginMessages.ERR_PLUGIN_7BIT_CANNOT_DECODE_DN.get(de.getMessageObject()));
        }
        if (this.isInScope(config, entryDN)) {
            block7: for (RawModification m : modifyOperation.getRawModifications()) {
                Attribute a;
                switch (m.getModificationType()) {
                    case ADD: 
                    case REPLACE: {
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                RawAttribute rawAttr = m.getAttribute();
                try {
                    a = rawAttr.toAttribute();
                }
                catch (LDAPException le) {
                    return PluginResult.PreParse.stopProcessing(ResultCode.valueOf(le.getResultCode()), PluginMessages.ERR_PLUGIN_7BIT_CANNOT_DECODE_ATTR.get(rawAttr.getAttributeType(), le.getErrorMessage()));
                }
                if (!config.getAttributeType().contains(a.getAttributeType())) continue;
                for (AttributeValue v : a) {
                    if (this.is7BitClean(v.getValue())) continue;
                    return PluginResult.PreParse.stopProcessing(ResultCode.CONSTRAINT_VIOLATION, PluginMessages.ERR_PLUGIN_7BIT_MODIFYDN_ATTR_NOT_CLEAN.get(rawAttr.getAttributeType()));
                }
            }
        }
        return PluginResult.PreParse.continueOperationProcessing();
    }

    @Override
    public final PluginResult.PreParse doPreParse(PreParseModifyDNOperation modifyDNOperation) {
        DN entryDN;
        SevenBitCleanPluginCfg config = this.currentConfig;
        try {
            entryDN = DN.decode(modifyDNOperation.getRawEntryDN());
        }
        catch (DirectoryException de) {
            return PluginResult.PreParse.stopProcessing(de.getResultCode(), PluginMessages.ERR_PLUGIN_7BIT_CANNOT_DECODE_DN.get(de.getMessageObject()));
        }
        if (this.isInScope(config, entryDN)) {
            RDN newRDN;
            ByteString rawNewRDN = modifyDNOperation.getRawNewRDN();
            try {
                newRDN = RDN.decode(rawNewRDN.toString());
            }
            catch (DirectoryException de) {
                return PluginResult.PreParse.stopProcessing(de.getResultCode(), PluginMessages.ERR_PLUGIN_7BIT_CANNOT_DECODE_NEW_RDN.get(de.getMessageObject()));
            }
            int numValues = newRDN.getNumValues();
            for (int i = 0; i < numValues; ++i) {
                if (!config.getAttributeType().contains(newRDN.getAttributeType(i)) || this.is7BitClean(newRDN.getAttributeValue(i).getValue())) continue;
                return PluginResult.PreParse.stopProcessing(ResultCode.CONSTRAINT_VIOLATION, PluginMessages.ERR_PLUGIN_7BIT_MODIFYDN_ATTR_NOT_CLEAN.get(newRDN.getAttributeName(i)));
            }
        }
        return PluginResult.PreParse.continueOperationProcessing();
    }

    private final boolean isInScope(SevenBitCleanPluginCfg config, DN dn) {
        Set<DN> baseDNs = config.getBaseDN();
        if (baseDNs == null || baseDNs.isEmpty()) {
            baseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        boolean found = false;
        for (DN baseDN : baseDNs) {
            if (!dn.isDescendantOf(baseDN)) continue;
            found = true;
            break;
        }
        return found;
    }

    private final boolean is7BitClean(ByteSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            byte b = value.byteAt(i);
            if ((b & 0x7F) == b) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        SevenBitCleanPluginCfg cfg = (SevenBitCleanPluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SevenBitCleanPluginCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case LDIFIMPORT: 
                case PREPARSEADD: 
                case PREPARSEMODIFY: 
                case PREPARSEMODIFYDN: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_7BIT_INVALID_PLUGIN_TYPE.get(pluginType.toString());
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SevenBitCleanPluginCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

