/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionStats;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.MonitorProvider;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Attributes;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.TimeThread;

public class DatabaseEnvironmentMonitor
extends MonitorProvider<MonitorProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private String name;
    private RootContainer rootContainer;
    private int maxEntries = 1024;
    private boolean filterUseEnabled = false;
    private String startTimeStamp;
    private final HashMap<SearchFilter, FilterStats> filterToStats = new HashMap();
    private final AtomicInteger indexedSearchCount = new AtomicInteger();
    private final AtomicInteger unindexedSearchCount = new AtomicInteger();

    public DatabaseEnvironmentMonitor(String name, RootContainer rootContainer) {
        this.name = name;
        this.rootContainer = rootContainer;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        return this.name;
    }

    private void addAttributesForStatsObject(ArrayList<Attribute> monitorAttrs, Object stats, String attrPrefix) {
        Method[] methods;
        Class<?> c = stats.getClass();
        for (Method method : methods = c.getMethods()) {
            Class<?> returnType;
            if (!method.getName().startsWith("get") || !(returnType = method.getReturnType()).equals(Integer.TYPE) && !returnType.equals(Long.TYPE)) continue;
            AttributeSyntax integerSyntax = DirectoryServer.getDefaultIntegerSyntax();
            String attrName = attrPrefix + method.getName().substring(3);
            try {
                Object statValue = method.invoke(stats, new Object[0]);
                AttributeType attrType = DirectoryServer.getDefaultAttributeType(attrName, integerSyntax);
                monitorAttrs.add(Attributes.create(attrType, String.valueOf(statValue)));
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Attribute> getMonitorData() {
        EnvironmentStats environmentStats = null;
        TransactionStats transactionStats = null;
        StatsConfig statsConfig = new StatsConfig();
        try {
            environmentStats = this.rootContainer.getEnvironmentStats(statsConfig);
            transactionStats = this.rootContainer.getEnvironmentTransactionStats(statsConfig);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return null;
        }
        ArrayList<Attribute> monitorAttrs = new ArrayList<Attribute>();
        String jeVersion = JEVersion.CURRENT_VERSION.getVersionString();
        AttributeType versionType = DirectoryServer.getDefaultAttributeType("JEVersion");
        monitorAttrs.add(Attributes.create(versionType, jeVersion));
        this.addAttributesForStatsObject(monitorAttrs, environmentStats, "Environment");
        this.addAttributesForStatsObject(monitorAttrs, transactionStats, "Transaction");
        AttributeBuilder needReindex = new AttributeBuilder("need-reindex");
        for (EntryContainer ec : this.rootContainer.getEntryContainers()) {
            ArrayList<DatabaseContainer> databases = new ArrayList<DatabaseContainer>();
            ec.listDatabases(databases);
            for (DatabaseContainer databaseContainer : databases) {
                if (!(databaseContainer instanceof Index) || ((Index)databaseContainer).isTrusted()) continue;
                needReindex.add(databaseContainer.getName());
            }
        }
        if (needReindex.size() > 0) {
            monitorAttrs.add(needReindex.toAttribute());
        }
        if (this.filterUseEnabled) {
            monitorAttrs.add(Attributes.create("filter-use-startTime", this.startTimeStamp));
            AttributeBuilder builder = new AttributeBuilder("filter-use");
            StringBuilder stringBuilder = new StringBuilder();
            HashMap<SearchFilter, FilterStats> hashMap = this.filterToStats;
            synchronized (hashMap) {
                for (Map.Entry entry : this.filterToStats.entrySet()) {
                    ((SearchFilter)entry.getKey()).toString(stringBuilder);
                    stringBuilder.append(" hits:");
                    stringBuilder.append(((FilterStats)entry.getValue()).hits.get());
                    stringBuilder.append(" maxmatches:");
                    stringBuilder.append(((FilterStats)entry.getValue()).maxMatchingEntries);
                    stringBuilder.append(" message:");
                    stringBuilder.append(((FilterStats)entry.getValue()).failureReason);
                    builder.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
            }
            monitorAttrs.add(builder.toAttribute());
            monitorAttrs.add(Attributes.create("filter-use-indexed", String.valueOf(this.indexedSearchCount.get())));
            monitorAttrs.add(Attributes.create("filter-use-unindexed", String.valueOf(this.unindexedSearchCount.get())));
        }
        return monitorAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats(SearchFilter searchFilter, Message failureMessage) {
        if (!this.filterUseEnabled) {
            return;
        }
        HashMap<SearchFilter, FilterStats> hashMap = this.filterToStats;
        synchronized (hashMap) {
            FilterStats stats = this.filterToStats.get(searchFilter);
            if (stats != null) {
                stats.update(1, failureMessage);
            } else {
                stats = new FilterStats();
                stats.update(1, failureMessage);
                this.removeLowestHit();
                this.filterToStats.put(searchFilter, stats);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats(SearchFilter searchFilter, long matchingEntries) {
        if (!this.filterUseEnabled) {
            return;
        }
        HashMap<SearchFilter, FilterStats> hashMap = this.filterToStats;
        synchronized (hashMap) {
            FilterStats stats = this.filterToStats.get(searchFilter);
            if (stats != null) {
                stats.update(1, matchingEntries);
            } else {
                stats = new FilterStats();
                stats.update(1, matchingEntries);
                this.removeLowestHit();
                this.filterToStats.put(searchFilter, stats);
            }
        }
    }

    public void enableFilterUseStats(boolean enabled) {
        if (enabled && !this.filterUseEnabled) {
            this.startTimeStamp = TimeThread.getGMTTime();
            this.indexedSearchCount.set(0);
            this.unindexedSearchCount.set(0);
        } else if (!enabled) {
            this.filterToStats.clear();
        }
        this.filterUseEnabled = enabled;
    }

    public boolean isFilterUseEnabled() {
        return this.filterUseEnabled;
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void updateIndexedSearchCount() {
        this.indexedSearchCount.getAndIncrement();
    }

    public void updateUnindexedSearchCount() {
        this.unindexedSearchCount.getAndIncrement();
    }

    private void removeLowestHit() {
        while (!this.filterToStats.isEmpty() && this.filterToStats.size() > this.maxEntries) {
            Iterator<Map.Entry<SearchFilter, FilterStats>> i = this.filterToStats.entrySet().iterator();
            Map.Entry<SearchFilter, FilterStats> lowest = i.next();
            while (lowest.getValue().hits.get() > 1 && i.hasNext()) {
                Map.Entry<SearchFilter, FilterStats> entry = i.next();
                if (entry.getValue().hits.get() >= lowest.getValue().hits.get()) continue;
                lowest = entry;
            }
            this.filterToStats.remove(lowest.getKey());
        }
    }

    private static class FilterStats
    implements Comparable<FilterStats> {
        private volatile Message failureReason = Message.EMPTY;
        private long maxMatchingEntries = -1L;
        private final AtomicInteger hits = new AtomicInteger();

        private FilterStats() {
        }

        @Override
        public int compareTo(FilterStats that) {
            return this.hits.get() - that.hits.get();
        }

        private void update(int hitCount, Message failureReason) {
            this.hits.getAndAdd(hitCount);
            this.failureReason = failureReason;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(int hitCount, long matchingEntries) {
            this.hits.getAndAdd(hitCount);
            this.failureReason = Message.EMPTY;
            FilterStats filterStats = this;
            synchronized (filterStats) {
                if (matchingEntries > this.maxMatchingEntries) {
                    this.maxMatchingEntries = matchingEntries;
                }
            }
        }
    }
}

