/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.opends.server.admin.std.server.ClientConnectionMonitorProviderCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.InitializationException;

public class ClientConnectionMonitorProvider
extends MonitorProvider<ClientConnectionMonitorProviderCfg> {
    private final ConnectionHandler<?> handler;

    public ClientConnectionMonitorProvider() {
        this.handler = null;
    }

    public ClientConnectionMonitorProvider(ConnectionHandler handler) {
        this.handler = handler;
    }

    @Override
    public void initializeMonitorProvider(ClientConnectionMonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        if (this.handler == null) {
            return "Client Connections";
        }
        return "Client Connections,cn=" + this.handler.getConnectionHandlerName();
    }

    public ArrayList<Attribute> getMonitorData() {
        TreeMap<Long, ClientConnection> connMap = new TreeMap<Long, ClientConnection>();
        if (this.handler == null) {
            for (ConnectionHandler hdl : DirectoryServer.getConnectionHandlers()) {
                for (ClientConnection conn : hdl.getClientConnections()) {
                    connMap.put(conn.getConnectionID(), conn);
                }
            }
        } else {
            Collection<ClientConnection> collection = this.handler.getClientConnections();
            for (ClientConnection conn : collection) {
                connMap.put(conn.getConnectionID(), conn);
            }
        }
        AttributeType attrType = DirectoryServer.getDefaultAttributeType("connection");
        AttributeBuilder builder = new AttributeBuilder(attrType);
        for (ClientConnection conn : connMap.values()) {
            builder.add(AttributeValues.create(attrType, conn.getMonitorSummary()));
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
        attrs.add(builder.toAttribute());
        return attrs;
    }
}

