/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FileBasedHTTPAccessLogPublisherCfg;
import org.opends.server.api.HTTPAccessLogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.AsynchronousTextWriter;
import org.opends.server.loggers.HTTPRequestInfo;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.ParallelTextWriter;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.TimeStampNaming;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public final class TextHTTPAccessLogPublisher
extends HTTPAccessLogPublisher<FileBasedHTTPAccessLogPublisherCfg>
implements ConfigurationChangeListener<FileBasedHTTPAccessLogPublisherCfg> {
    private static final String ELF_C_IP = "c-ip";
    private static final String ELF_C_PORT = "c-port";
    private static final String ELF_CS_HOST = "cs-host";
    private static final String ELF_CS_METHOD = "cs-method";
    private static final String ELF_CS_URI_QUERY = "cs-uri-query";
    private static final String ELF_CS_USER_AGENT = "cs(User-Agent)";
    private static final String ELF_CS_USERNAME = "cs-username";
    private static final String ELF_CS_VERSION = "cs-version";
    private static final String ELF_S_COMPUTERNAME = "s-computername";
    private static final String ELF_S_IP = "s-ip";
    private static final String ELF_S_PORT = "s-port";
    private static final String ELF_SC_STATUS = "sc-status";
    private static final String X_CONNECTION_ID = "x-connection-id";
    private static final String X_DATETIME = "x-datetime";
    private static final String X_ETIME = "x-etime";
    private static final Set<String> ALL_SUPPORTED_FIELDS = new HashSet<String>(Arrays.asList("c-ip", "c-port", "cs-host", "cs-method", "cs-uri-query", "cs(User-Agent)", "cs-username", "cs-version", "s-computername", "s-ip", "s-port", "sc-status", "x-connection-id", "x-datetime", "x-etime"));
    private TextWriter writer = null;
    private FileBasedHTTPAccessLogPublisherCfg cfg = null;
    private List<String> logFormatFields;
    private String timeStampFormat = "dd/MMM/yyyy:HH:mm:ss Z";

    public static TextHTTPAccessLogPublisher getStartupTextHTTPAccessPublisher(TextWriter writer) {
        TextHTTPAccessLogPublisher startupPublisher = new TextHTTPAccessLogPublisher();
        startupPublisher.writer = writer;
        return startupPublisher;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedHTTPAccessLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            boolean writerAutoFlush;
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            boolean bl = writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            TextWriter currentWriter = this.writer instanceof AsynchronousTextWriter ? ((AsynchronousTextWriter)this.writer).getWrappedWriter() : (this.writer instanceof ParallelTextWriter ? ((ParallelTextWriter)this.writer).getWrappedWriter() : this.writer);
            if (currentWriter instanceof MultifileTextWriter) {
                TextWriter asyncWriter;
                MultifileTextWriter mfWriter = (MultifileTextWriter)currentWriter;
                mfWriter.setNamingPolicy(fnPolicy);
                mfWriter.setFilePermissions(perm);
                mfWriter.setAppend(config.isAppend());
                mfWriter.setAutoFlush(writerAutoFlush);
                mfWriter.setBufferSize((int)config.getBufferSize());
                mfWriter.setInterval(config.getTimeInterval());
                mfWriter.removeAllRetentionPolicies();
                mfWriter.removeAllRotationPolicies();
                for (DN dn : config.getRotationPolicyDNs()) {
                    mfWriter.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
                }
                for (DN dn : config.getRetentionPolicyDNs()) {
                    mfWriter.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
                }
                if (this.writer instanceof AsynchronousTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (AsynchronousTextWriter)this.writer;
                    this.writer = mfWriter;
                    ((AsynchronousTextWriter)asyncWriter).shutdown(false);
                }
                if (this.writer instanceof ParallelTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (ParallelTextWriter)this.writer;
                    this.writer = mfWriter;
                    ((ParallelTextWriter)asyncWriter).shutdown(false);
                }
                if (!(this.writer instanceof AsynchronousTextWriter) && config.isAsynchronous()) {
                    this.writer = asyncWriter = new AsynchronousTextWriter("Asynchronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), mfWriter);
                }
                if (!(this.writer instanceof ParallelTextWriter) && config.isAsynchronous()) {
                    this.writer = asyncWriter = new ParallelTextWriter("Parallel Text Writer for " + config.dn().toNormalizedString(), config.isAutoFlush(), mfWriter);
                }
                if (this.cfg.isAsynchronous() && config.isAsynchronous() && this.cfg.getQueueSize() != config.getQueueSize()) {
                    adminActionRequired = true;
                }
                if (!config.getLogRecordTimeFormat().equals(this.timeStampFormat)) {
                    TimeThread.removeUserDefinedFormatter(this.timeStampFormat);
                    this.timeStampFormat = config.getLogRecordTimeFormat();
                }
                this.cfg = config;
                this.logFormatFields = this.extractFieldsOrder(this.cfg.getLogFormat());
                Message errorMessage = this.validateLogFormat(this.logFormatFields);
                if (errorMessage != null) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    adminActionRequired = true;
                    messages.add(errorMessage);
                }
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private List<String> extractFieldsOrder(String logFormat) {
        return Arrays.asList(logFormat.split(" "));
    }

    private Message validateLogFormat(List<String> fields) {
        Collection<String> unsupportedFields = this.subtract(fields, ALL_SUPPORTED_FIELDS);
        if (!unsupportedFields.isEmpty()) {
            return ConfigMessages.WARN_CONFIG_LOGGING_UNSUPPORTED_FIELDS_IN_LOG_FORMAT.get(this.cfg.dn().toString(), StaticUtils.collectionToString(unsupportedFields, ", "));
        }
        if (fields.size() == unsupportedFields.size()) {
            return ConfigMessages.ERR_CONFIG_LOGGING_EMPTY_LOG_FORMAT.get(this.cfg.dn().toString());
        }
        return null;
    }

    private <T> Collection<T> subtract(Collection<T> a, Collection<T> b) {
        ArrayList<T> result = new ArrayList<T>();
        for (T elem : a) {
            if (b.contains(elem)) continue;
            result.add(elem);
        }
        return result;
    }

    @Override
    public void initializeLogPublisher(FileBasedHTTPAccessLogPublisherCfg cfg) throws ConfigException, InitializationException {
        File logFile = StaticUtils.getFileForPath(cfg.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(cfg.getLogFilePermissions());
            LogPublisherErrorHandler errorHandler = new LogPublisherErrorHandler(cfg.dn());
            boolean writerAutoFlush = cfg.isAutoFlush() && !cfg.isAsynchronous();
            MultifileTextWriter theWriter = new MultifileTextWriter("Multifile Text Writer for " + cfg.dn().toNormalizedString(), cfg.getTimeInterval(), fnPolicy, perm, errorHandler, "UTF-8", writerAutoFlush, cfg.isAppend(), (int)cfg.getBufferSize());
            for (DN dn : cfg.getRotationPolicyDNs()) {
                theWriter.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
            }
            for (DN dn : cfg.getRetentionPolicyDNs()) {
                theWriter.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
            }
            this.writer = cfg.isAsynchronous() ? (cfg.getQueueSize() > 0 ? new AsynchronousTextWriter("Asynchronous Text Writer for " + cfg.dn().toNormalizedString(), cfg.getQueueSize(), cfg.isAutoFlush(), theWriter) : new ParallelTextWriter("Parallel Text Writer for " + cfg.dn().toNormalizedString(), cfg.isAutoFlush(), theWriter)) : theWriter;
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(cfg.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        catch (IOException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_OPEN_FILE.get(logFile.toString(), cfg.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.cfg = cfg;
        this.logFormatFields = this.extractFieldsOrder(cfg.getLogFormat());
        Message error = this.validateLogFormat(this.logFormatFields);
        if (error != null) {
            throw new InitializationException(error);
        }
        this.timeStampFormat = cfg.getLogRecordTimeFormat();
        cfg.addFileBasedHTTPAccessChangeListener(this);
    }

    @Override
    public boolean isConfigurationAcceptable(FileBasedHTTPAccessLogPublisherCfg configuration, List<Message> unacceptableReasons) {
        return this.isConfigurationChangeAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedHTTPAccessLogPublisherCfg config, List<Message> unacceptableReasons) {
        String formatString = config.getLogRecordTimeFormat();
        try {
            new SimpleDateFormat(formatString);
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_INVALID_TIME_FORMAT.get(String.valueOf(formatString));
            unacceptableReasons.add(message);
            return false;
        }
        try {
            FilePermission filePerm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            if (!filePerm.isOwnerWritable()) {
                Message message = ConfigMessages.ERR_CONFIG_LOGGING_INSANE_MODE.get(config.getLogFilePermissions());
                unacceptableReasons.add(message);
                return false;
            }
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_MODE_INVALID.get(config.getLogFilePermissions(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public final void close() {
        this.writer.shutdown();
        TimeThread.removeUserDefinedFormatter(this.timeStampFormat);
        if (this.cfg != null) {
            this.cfg.removeFileBasedHTTPAccessChangeListener(this);
        }
    }

    @Override
    public final DN getDN() {
        return this.cfg != null ? this.cfg.dn() : null;
    }

    @Override
    public void logRequestInfo(HTTPRequestInfo ri) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put(ELF_C_IP, ri.getClientAddress());
        fields.put(ELF_C_PORT, ri.getClientPort());
        fields.put(ELF_CS_HOST, ri.getClientHost());
        fields.put(ELF_CS_METHOD, ri.getMethod());
        fields.put(ELF_CS_URI_QUERY, ri.getQuery());
        fields.put(ELF_CS_USER_AGENT, ri.getUserAgent());
        fields.put(ELF_CS_USERNAME, ri.getAuthUser());
        fields.put(ELF_CS_VERSION, ri.getProtocol());
        fields.put(ELF_S_IP, ri.getServerAddress());
        fields.put(ELF_S_COMPUTERNAME, ri.getServerHost());
        fields.put(ELF_S_PORT, ri.getServerPort());
        fields.put(ELF_SC_STATUS, ri.getStatusCode());
        fields.put(X_CONNECTION_ID, ri.getConnectionID());
        fields.put(X_DATETIME, TimeThread.getUserDefinedTime(this.timeStampFormat));
        fields.put(X_ETIME, ri.getTotalProcessingTime());
        this.writeLogRecord(fields, this.logFormatFields);
    }

    private void writeLogRecord(Map<String, Object> fields, List<String> fieldnames) {
        if (fieldnames == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(100);
        for (String fieldname : fieldnames) {
            this.append(sb, fields.get(fieldname));
        }
        this.writer.writeRecord(sb.toString());
    }

    private void append(StringBuilder sb, Object value) {
        int separator = 9;
        if (sb.length() > 0) {
            sb.append('\t');
        }
        if (value != null) {
            String val = String.valueOf(value);
            boolean useQuotes = val.contains(Character.toString('\t'));
            if (useQuotes) {
                sb.append('\"').append(val.replaceAll("\"", "\"\"")).append('\"');
            } else {
                sb.append(val);
            }
        } else {
            sb.append('-');
        }
    }
}

