/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.SizeLimitLogRotationPolicyCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class SizeBasedRotationPolicy
implements RotationPolicy<SizeLimitLogRotationPolicyCfg>,
ConfigurationChangeListener<SizeLimitLogRotationPolicyCfg> {
    private long sizeLimit;
    SizeLimitLogRotationPolicyCfg currentConfig;

    @Override
    public void initializeLogRotationPolicy(SizeLimitLogRotationPolicyCfg config) throws ConfigException, InitializationException {
        this.sizeLimit = config.getFileSizeLimit();
        config.addSizeLimitChangeListener(this);
        this.currentConfig = config;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SizeLimitLogRotationPolicyCfg config, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SizeLimitLogRotationPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.sizeLimit = config.getFileSizeLimit();
        this.currentConfig = config;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean rotateFile(MultifileTextWriter writer) {
        long fileSize = writer.getBytesWritten();
        return fileSize >= this.sizeLimit;
    }
}

