/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.opends.server.loggers.PostRotationAction;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;

public class GZIPAction
implements PostRotationAction {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private File originalFile;
    private File newFile;
    private boolean deleteOriginal;

    public GZIPAction(String origFile, String newFile, boolean deleteOrig) {
        this.originalFile = new File(origFile);
        this.newFile = new File(newFile);
        this.deleteOriginal = deleteOrig;
    }

    @Override
    public boolean execute() {
        FileInputStream fis = null;
        DeflaterOutputStream gzip = null;
        boolean inputStreamOpen = false;
        boolean outputStreamOpen = false;
        try {
            int n;
            if (!this.originalFile.exists()) {
                System.err.println("Source file does not exist:" + this.originalFile);
                return false;
            }
            fis = new FileInputStream(this.originalFile);
            inputStreamOpen = true;
            FileOutputStream fos = new FileOutputStream(this.newFile);
            gzip = new GZIPOutputStream(fos);
            outputStreamOpen = true;
            byte[] buf = new byte[8192];
            while ((n = fis.read(buf)) != -1) {
                ((GZIPOutputStream)gzip).write(buf, 0, n);
            }
            gzip.close();
            outputStreamOpen = false;
            fis.close();
            inputStreamOpen = false;
            if (this.deleteOriginal && !this.originalFile.delete()) {
                System.err.println("Cannot delete original file:" + this.originalFile);
                return false;
            }
            return true;
        }
        catch (IOException ioe) {
            block13: {
                block12: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
                    }
                    if (inputStreamOpen) {
                        try {
                            fis.close();
                        }
                        catch (Exception fe) {
                            if (!DebugLogger.debugEnabled()) break block12;
                            TRACER.debugCaught(DebugLogLevel.ERROR, fe);
                        }
                    }
                }
                if (outputStreamOpen) {
                    try {
                        gzip.close();
                    }
                    catch (Exception ge) {
                        if (!DebugLogger.debugEnabled()) break block13;
                        TRACER.debugCaught(DebugLogLevel.ERROR, ge);
                    }
                }
            }
            return false;
        }
    }
}

