/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opends.messages.Message;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.TextWriter;

public class AsynchronousTextWriter
implements ServerShutdownListener,
TextWriter {
    private final TextWriter writer;
    private final LinkedBlockingQueue<String> queue;
    private final int capacity;
    private String name;
    private AtomicBoolean stopRequested;
    private WriterThread writerThread;
    private boolean autoFlush;

    public AsynchronousTextWriter(String name, int capacity, boolean autoFlush, TextWriter writer) {
        this.name = name;
        this.autoFlush = autoFlush;
        this.writer = writer;
        this.queue = new LinkedBlockingQueue(capacity);
        this.capacity = capacity;
        this.writerThread = null;
        this.stopRequested = new AtomicBoolean(false);
        this.writerThread = new WriterThread();
        this.writerThread.start();
        DirectoryServer.registerShutdownListener(this);
    }

    @Override
    public void writeRecord(String record) {
        if (this.writer != null) {
            while (!this.stopRequested.get()) {
                try {
                    this.queue.put(record);
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public long getBytesWritten() {
        return this.writer.getBytesWritten();
    }

    public TextWriter getWrappedWriter() {
        return this.writer;
    }

    @Override
    public String getShutdownListenerName() {
        return "AsynchronousTextWriter Thread " + this.name;
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.shutdown(false);
    }

    @Override
    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean shutdownWrapped) {
        this.stopRequested.set(true);
        while (this.writerThread != null && this.writerThread.isAlive()) {
            try {
                this.writerThread.interrupt();
                this.writerThread.join();
            }
            catch (InterruptedException ex) {}
        }
        while (!this.queue.isEmpty()) {
            String message = this.queue.poll();
            this.writer.writeRecord(message);
        }
        if (shutdownWrapped && this.writer != null) {
            this.writer.shutdown();
        }
        DirectoryServer.deregisterShutdownListener(this);
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    private class WriterThread
    extends DirectoryThread {
        public WriterThread() {
            super(AsynchronousTextWriter.this.name);
        }

        @Override
        public void run() {
            ArrayList drainList = new ArrayList(AsynchronousTextWriter.this.capacity);
            String message = null;
            while (!AsynchronousTextWriter.this.stopRequested.get() || !AsynchronousTextWriter.this.queue.isEmpty()) {
                try {
                    AsynchronousTextWriter.this.queue.drainTo(drainList, AsynchronousTextWriter.this.capacity);
                    if (drainList.isEmpty()) {
                        message = (String)AsynchronousTextWriter.this.queue.poll(10L, TimeUnit.SECONDS);
                        if (message == null) continue;
                        do {
                            AsynchronousTextWriter.this.writer.writeRecord(message);
                        } while ((message = (String)AsynchronousTextWriter.this.queue.poll()) != null);
                        if (!AsynchronousTextWriter.this.autoFlush) continue;
                        AsynchronousTextWriter.this.flush();
                        continue;
                    }
                    for (String record : drainList) {
                        AsynchronousTextWriter.this.writer.writeRecord(record);
                    }
                    drainList.clear();
                    if (!AsynchronousTextWriter.this.autoFlush) continue;
                    AsynchronousTextWriter.this.flush();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

