/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.meta.AccessLogFilteringCriteriaCfgDefn;
import org.opends.server.admin.std.meta.AccessLogPublisherCfgDefn;
import org.opends.server.admin.std.server.AccessLogFilteringCriteriaCfg;
import org.opends.server.admin.std.server.AccessLogPublisherCfg;
import org.opends.server.api.AccessLogPublisher;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.Group;
import org.opends.server.authorization.dseecompat.PatternDN;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.GroupManager;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.AddressMask;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public abstract class AbstractTextAccessLogPublisher<T extends AccessLogPublisherCfg>
extends AccessLogPublisher<T> {
    protected static final DebugTracer TRACER = DebugLogger.getTracer();
    private AccessLogPublisherCfg cfg = null;
    private Filter filter = null;
    private final ChangeListener changeListener = new ChangeListener();
    private final FilterListener filterListener = new FilterListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        try {
            this.close0();
        }
        finally {
            if (this.cfg != null) {
                this.cfg.removeAccessChangeListener(this.changeListener);
                for (String criteriaName : this.cfg.listAccessLogFilteringCriteria()) {
                    try {
                        this.cfg.getAccessLogFilteringCriteria(criteriaName).removeChangeListener(this.filterListener);
                    }
                    catch (ConfigException e) {}
                }
                this.cfg.removeAccessLogFilteringCriteriaAddListener(this.filterListener);
                this.cfg.removeAccessLogFilteringCriteriaDeleteListener(this.filterListener);
            }
        }
    }

    @Override
    public final DN getDN() {
        return this.cfg != null ? this.cfg.dn() : null;
    }

    protected void buildFilters(boolean suppressInternal) {
        this.buildFilters(suppressInternal, false, AccessLogPublisherCfgDefn.FilteringPolicy.NO_FILTERING);
    }

    protected abstract void close0();

    protected final void initializeFilters(T config) throws ConfigException, InitializationException {
        this.cfg = config;
        this.buildFilters();
        for (String criteriaName : this.cfg.listAccessLogFilteringCriteria()) {
            try {
                this.cfg.getAccessLogFilteringCriteria(criteriaName).addChangeListener(this.filterListener);
            }
            catch (ConfigException e) {
                // empty catch block
            }
        }
        this.cfg.addAccessLogFilteringCriteriaAddListener(this.filterListener);
        this.cfg.addAccessLogFilteringCriteriaDeleteListener(this.filterListener);
        this.cfg.addAccessChangeListener(this.changeListener);
    }

    protected final boolean isConnectLoggable(ClientConnection c) {
        return this.filter.isConnectLoggable(c);
    }

    protected final boolean isDisconnectLoggable(ClientConnection c) {
        return this.filter.isDisconnectLoggable(c);
    }

    protected final boolean isFilterConfigurationAcceptable(T config, List<Message> unacceptableReasons) {
        for (String criteriaName : config.listAccessLogFilteringCriteria()) {
            try {
                AccessLogFilteringCriteriaCfg criteriaCfg = config.getAccessLogFilteringCriteria(criteriaName);
                new CriteriaFilter(criteriaCfg);
            }
            catch (ConfigException e) {
                unacceptableReasons.add(e.getMessageObject());
                return false;
            }
        }
        return true;
    }

    protected final boolean isRequestLoggable(Operation o) {
        return this.filter.isRequestLoggable(o);
    }

    protected final boolean isResponseLoggable(Operation o) {
        return this.filter.isResponseLoggable(o);
    }

    private void buildFilters() {
        this.buildFilters(this.cfg.isSuppressInternalOperations(), this.cfg.isSuppressSynchronizationOperations(), this.cfg.getFilteringPolicy());
    }

    private void buildFilters(boolean suppressInternal, boolean suppressSynchronization, AccessLogPublisherCfgDefn.FilteringPolicy policy) {
        ArrayList<CriteriaFilter> subFilters = new ArrayList<CriteriaFilter>();
        if (this.cfg != null) {
            for (String criteriaName : this.cfg.listAccessLogFilteringCriteria()) {
                try {
                    AccessLogFilteringCriteriaCfg criteriaCfg = this.cfg.getAccessLogFilteringCriteria(criteriaName);
                    subFilters.add(new CriteriaFilter(criteriaCfg));
                }
                catch (ConfigException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        OrFilter orFilter = new OrFilter(subFilters.toArray(new Filter[0]));
        this.filter = new RootFilter(suppressInternal, suppressSynchronization, policy, orFilter);
    }

    private final class FilterListener
    implements ConfigurationChangeListener<AccessLogFilteringCriteriaCfg>,
    ConfigurationAddListener<AccessLogFilteringCriteriaCfg>,
    ConfigurationDeleteListener<AccessLogFilteringCriteriaCfg> {
        private FilterListener() {
        }

        @Override
        public ConfigChangeResult applyConfigurationAdd(AccessLogFilteringCriteriaCfg configuration) {
            AbstractTextAccessLogPublisher.this.buildFilters();
            configuration.addChangeListener(this);
            return new ConfigChangeResult(ResultCode.SUCCESS, false);
        }

        @Override
        public ConfigChangeResult applyConfigurationChange(AccessLogFilteringCriteriaCfg configuration) {
            AbstractTextAccessLogPublisher.this.buildFilters();
            return new ConfigChangeResult(ResultCode.SUCCESS, false);
        }

        @Override
        public ConfigChangeResult applyConfigurationDelete(AccessLogFilteringCriteriaCfg configuration) {
            AbstractTextAccessLogPublisher.this.buildFilters();
            return new ConfigChangeResult(ResultCode.SUCCESS, false);
        }

        @Override
        public boolean isConfigurationAddAcceptable(AccessLogFilteringCriteriaCfg configuration, List<Message> unacceptableReasons) {
            return this.validateConfiguration(configuration, unacceptableReasons);
        }

        @Override
        public boolean isConfigurationChangeAcceptable(AccessLogFilteringCriteriaCfg configuration, List<Message> unacceptableReasons) {
            return this.validateConfiguration(configuration, unacceptableReasons);
        }

        @Override
        public boolean isConfigurationDeleteAcceptable(AccessLogFilteringCriteriaCfg configuration, List<Message> unacceptableReasons) {
            return true;
        }

        private boolean validateConfiguration(AccessLogFilteringCriteriaCfg configuration, List<Message> unacceptableReasons) {
            try {
                new CriteriaFilter(configuration);
                return true;
            }
            catch (ConfigException e) {
                unacceptableReasons.add(e.getMessageObject());
                return false;
            }
        }
    }

    private final class ChangeListener
    implements ConfigurationChangeListener<AccessLogPublisherCfg> {
        private ChangeListener() {
        }

        @Override
        public final ConfigChangeResult applyConfigurationChange(AccessLogPublisherCfg configuration) {
            AbstractTextAccessLogPublisher.this.cfg = configuration;
            AbstractTextAccessLogPublisher.this.buildFilters();
            return new ConfigChangeResult(ResultCode.SUCCESS, false);
        }

        @Override
        public final boolean isConfigurationChangeAcceptable(AccessLogPublisherCfg configuration, List<Message> unacceptableReasons) {
            return true;
        }
    }

    static final class RootFilter
    implements Filter {
        private final Filter subFilter;
        private final boolean suppressInternalOperations;
        private final boolean suppressSynchronizationOperations;
        private final AccessLogPublisherCfgDefn.FilteringPolicy policy;

        RootFilter(boolean suppressInternal, boolean suppressSynchronization, AccessLogPublisherCfgDefn.FilteringPolicy policy, Filter subFilter) {
            this.suppressInternalOperations = suppressInternal;
            this.suppressSynchronizationOperations = suppressSynchronization;
            this.policy = policy;
            this.subFilter = subFilter;
        }

        @Override
        public boolean isConnectLoggable(ClientConnection connection) {
            if (!connection.isInnerConnection() || !this.suppressInternalOperations) {
                switch (this.policy) {
                    case INCLUSIVE: {
                        return this.subFilter.isConnectLoggable(connection);
                    }
                    case EXCLUSIVE: {
                        return !this.subFilter.isConnectLoggable(connection);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isDisconnectLoggable(ClientConnection connection) {
            if (!connection.isInnerConnection() || !this.suppressInternalOperations) {
                switch (this.policy) {
                    case INCLUSIVE: {
                        return this.subFilter.isDisconnectLoggable(connection);
                    }
                    case EXCLUSIVE: {
                        return !this.subFilter.isDisconnectLoggable(connection);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isRequestLoggable(Operation operation) {
            if (this.isLoggable(operation)) {
                switch (this.policy) {
                    case INCLUSIVE: {
                        return this.subFilter.isRequestLoggable(operation);
                    }
                    case EXCLUSIVE: {
                        return !this.subFilter.isRequestLoggable(operation);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isResponseLoggable(Operation operation) {
            if (this.isLoggable(operation)) {
                switch (this.policy) {
                    case INCLUSIVE: {
                        return this.subFilter.isResponseLoggable(operation);
                    }
                    case EXCLUSIVE: {
                        return !this.subFilter.isResponseLoggable(operation);
                    }
                }
                return true;
            }
            return false;
        }

        boolean isLoggable(Operation operation) {
            if (operation.isSynchronizationOperation()) {
                return !this.suppressSynchronizationOperations;
            }
            if (operation.isInnerOperation()) {
                return !this.suppressInternalOperations;
            }
            return true;
        }
    }

    static final class OrFilter
    implements Filter {
        private final Filter[] subFilters;

        OrFilter(Filter[] subFilters) {
            this.subFilters = subFilters;
        }

        @Override
        public boolean isConnectLoggable(ClientConnection connection) {
            for (Filter filter : this.subFilters) {
                if (!filter.isConnectLoggable(connection)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isDisconnectLoggable(ClientConnection connection) {
            for (Filter filter : this.subFilters) {
                if (!filter.isDisconnectLoggable(connection)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isRequestLoggable(Operation operation) {
            for (Filter filter : this.subFilters) {
                if (!filter.isRequestLoggable(operation)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isResponseLoggable(Operation operation) {
            for (Filter filter : this.subFilters) {
                if (!filter.isResponseLoggable(operation)) continue;
                return true;
            }
            return false;
        }
    }

    static interface Filter {
        public boolean isConnectLoggable(ClientConnection var1);

        public boolean isDisconnectLoggable(ClientConnection var1);

        public boolean isRequestLoggable(Operation var1);

        public boolean isResponseLoggable(Operation var1);
    }

    static final class CriteriaFilter
    implements Filter {
        private final AccessLogFilteringCriteriaCfg cfg;
        private final boolean logConnectRecords;
        private final boolean logDisconnectRecords;
        private final EnumSet<OperationType> logOperationRecords;
        private final Collection<AddressMask> clientAddressEqualTo;
        private final Collection<AddressMask> clientAddressNotEqualTo;
        private final int[] clientPorts;
        private final String[] clientProtocols;
        private final PatternDN[] userDNEqualTo;
        private final PatternDN[] userDNNotEqualTo;
        private final PatternDN[] targetDNEqualTo;
        private final PatternDN[] targetDNNotEqualTo;
        private final DN[] userIsMemberOf;
        private final DN[] userIsNotMemberOf;
        private final String attachmentName;

        CriteriaFilter(AccessLogFilteringCriteriaCfg cfg) throws ConfigException {
            this.cfg = cfg;
            this.attachmentName = this.getClass().getName() + "#" + this.hashCode();
            if (cfg.getLogRecordType().isEmpty()) {
                this.logConnectRecords = true;
                this.logDisconnectRecords = true;
                this.logOperationRecords = EnumSet.allOf(OperationType.class);
            } else {
                this.logConnectRecords = cfg.getLogRecordType().contains((Object)AccessLogFilteringCriteriaCfgDefn.LogRecordType.CONNECT);
                this.logDisconnectRecords = cfg.getLogRecordType().contains((Object)AccessLogFilteringCriteriaCfgDefn.LogRecordType.DISCONNECT);
                this.logOperationRecords = EnumSet.noneOf(OperationType.class);
                for (AccessLogFilteringCriteriaCfgDefn.LogRecordType type : cfg.getLogRecordType()) {
                    switch (type) {
                        case ABANDON: {
                            this.logOperationRecords.add(OperationType.ABANDON);
                            break;
                        }
                        case ADD: {
                            this.logOperationRecords.add(OperationType.ADD);
                            break;
                        }
                        case BIND: {
                            this.logOperationRecords.add(OperationType.BIND);
                            break;
                        }
                        case COMPARE: {
                            this.logOperationRecords.add(OperationType.COMPARE);
                            break;
                        }
                        case DELETE: {
                            this.logOperationRecords.add(OperationType.DELETE);
                            break;
                        }
                        case EXTENDED: {
                            this.logOperationRecords.add(OperationType.EXTENDED);
                            break;
                        }
                        case MODIFY: {
                            this.logOperationRecords.add(OperationType.MODIFY);
                            break;
                        }
                        case RENAME: {
                            this.logOperationRecords.add(OperationType.MODIFY_DN);
                            break;
                        }
                        case SEARCH: {
                            this.logOperationRecords.add(OperationType.SEARCH);
                            break;
                        }
                        case UNBIND: {
                            this.logOperationRecords.add(OperationType.UNBIND);
                            break;
                        }
                    }
                }
            }
            this.clientPorts = new int[cfg.getConnectionPortEqualTo().size()];
            int i = 0;
            for (Integer port : cfg.getConnectionPortEqualTo()) {
                this.clientPorts[i++] = port;
            }
            this.clientProtocols = new String[cfg.getConnectionProtocolEqualTo().size()];
            i = 0;
            for (String protocol : cfg.getConnectionProtocolEqualTo()) {
                this.clientProtocols[i++] = StaticUtils.toLowerCase(protocol);
            }
            this.clientAddressEqualTo = cfg.getConnectionClientAddressEqualTo();
            this.clientAddressNotEqualTo = cfg.getConnectionClientAddressNotEqualTo();
            this.userDNEqualTo = new PatternDN[cfg.getUserDNEqualTo().size()];
            i = 0;
            for (String s : cfg.getUserDNEqualTo()) {
                try {
                    this.userDNEqualTo[i++] = PatternDN.decode(s);
                }
                catch (DirectoryException e) {
                    Message m = ConfigMessages.ERR_CONFIG_LOGGING_INVALID_USER_DN_PATTERN.get(String.valueOf(cfg.dn()), s);
                    throw new ConfigException(m);
                }
            }
            this.userDNNotEqualTo = new PatternDN[cfg.getUserDNNotEqualTo().size()];
            i = 0;
            for (String s : cfg.getUserDNNotEqualTo()) {
                try {
                    this.userDNNotEqualTo[i++] = PatternDN.decode(s);
                }
                catch (DirectoryException e) {
                    Message m = ConfigMessages.ERR_CONFIG_LOGGING_INVALID_USER_DN_PATTERN.get(String.valueOf(cfg.dn()), s);
                    throw new ConfigException(m);
                }
            }
            this.userIsMemberOf = cfg.getUserIsMemberOf().toArray(new DN[0]);
            this.userIsNotMemberOf = cfg.getUserIsNotMemberOf().toArray(new DN[0]);
            this.targetDNEqualTo = new PatternDN[cfg.getRequestTargetDNEqualTo().size()];
            i = 0;
            for (String s : cfg.getRequestTargetDNEqualTo()) {
                try {
                    this.targetDNEqualTo[i++] = PatternDN.decode(s);
                }
                catch (DirectoryException e) {
                    Message m = ConfigMessages.ERR_CONFIG_LOGGING_INVALID_TARGET_DN_PATTERN.get(String.valueOf(cfg.dn()), s);
                    throw new ConfigException(m);
                }
            }
            this.targetDNNotEqualTo = new PatternDN[cfg.getRequestTargetDNNotEqualTo().size()];
            i = 0;
            for (String s : cfg.getRequestTargetDNNotEqualTo()) {
                try {
                    this.targetDNNotEqualTo[i++] = PatternDN.decode(s);
                }
                catch (DirectoryException e) {
                    Message m = ConfigMessages.ERR_CONFIG_LOGGING_INVALID_TARGET_DN_PATTERN.get(String.valueOf(cfg.dn()), s);
                    throw new ConfigException(m);
                }
            }
        }

        @Override
        public boolean isConnectLoggable(ClientConnection connection) {
            if (!this.logConnectRecords) {
                return false;
            }
            return this.filterClientConnection(connection);
        }

        @Override
        public boolean isDisconnectLoggable(ClientConnection connection) {
            if (!this.logDisconnectRecords) {
                return false;
            }
            if (!this.filterClientConnection(connection)) {
                return false;
            }
            return this.filterUser(connection);
        }

        @Override
        public boolean isRequestLoggable(Operation operation) {
            ClientConnection connection = operation.getClientConnection();
            boolean matches = this.logOperationRecords.contains((Object)operation.getOperationType()) && this.filterClientConnection(connection) && this.filterUser(connection) && this.filterRequest(operation);
            operation.setAttachment(this.attachmentName, matches);
            return matches;
        }

        @Override
        public boolean isResponseLoggable(Operation operation) {
            Boolean requestMatched = (Boolean)operation.getAttachment(this.attachmentName);
            if (requestMatched == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugWarning("Operation attachment %s not found while logging response", this.attachmentName);
                }
                requestMatched = this.isRequestLoggable(operation);
            }
            if (!requestMatched.booleanValue()) {
                return false;
            }
            return this.filterResponse(operation);
        }

        private boolean filterClientConnection(ClientConnection connection) {
            boolean found;
            if (this.clientProtocols.length > 0) {
                found = false;
                String protocol = StaticUtils.toLowerCase(connection.getProtocol());
                for (String p : this.clientProtocols) {
                    if (!protocol.equals(p)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            if (this.clientPorts.length > 0) {
                found = false;
                int port = connection.getServerPort();
                for (int p : this.clientPorts) {
                    if (port != p) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            InetAddress ipAddr = connection.getRemoteAddress();
            if (!this.clientAddressNotEqualTo.isEmpty() && AddressMask.maskListContains(ipAddr, this.clientAddressNotEqualTo)) {
                return false;
            }
            return this.clientAddressEqualTo.isEmpty() || AddressMask.maskListContains(ipAddr, this.clientAddressEqualTo);
        }

        private boolean filterRequest(Operation operation) {
            return this.targetDNNotEqualTo.length <= 0 && this.targetDNEqualTo.length <= 0 || this.filterRequestTargetDN(operation);
        }

        private boolean filterRequestTargetDN(Operation operation) {
            DN targetDN = null;
            ByteString rawTargetDN = null;
            switch (operation.getOperationType()) {
                case ABANDON: 
                case UNBIND: {
                    return true;
                }
                case EXTENDED: {
                    return true;
                }
                case ADD: {
                    targetDN = ((AddOperation)operation).getEntryDN();
                    rawTargetDN = ((AddOperation)operation).getRawEntryDN();
                    break;
                }
                case BIND: {
                    targetDN = ((BindOperation)operation).getBindDN();
                    rawTargetDN = ((BindOperation)operation).getRawBindDN();
                    break;
                }
                case COMPARE: {
                    targetDN = ((CompareOperation)operation).getEntryDN();
                    rawTargetDN = ((CompareOperation)operation).getRawEntryDN();
                    break;
                }
                case DELETE: {
                    targetDN = ((DeleteOperation)operation).getEntryDN();
                    rawTargetDN = ((DeleteOperation)operation).getRawEntryDN();
                    break;
                }
                case MODIFY: {
                    targetDN = ((ModifyOperation)operation).getEntryDN();
                    rawTargetDN = ((ModifyOperation)operation).getRawEntryDN();
                    break;
                }
                case MODIFY_DN: {
                    targetDN = ((ModifyDNOperation)operation).getEntryDN();
                    rawTargetDN = ((ModifyDNOperation)operation).getRawEntryDN();
                    break;
                }
                case SEARCH: {
                    targetDN = ((SearchOperation)operation).getBaseDN();
                    rawTargetDN = ((SearchOperation)operation).getRawBaseDN();
                }
            }
            if (targetDN == null) {
                try {
                    targetDN = DN.decode(rawTargetDN);
                }
                catch (DirectoryException e) {
                    return this.targetDNEqualTo.length == 0;
                }
            }
            if (this.targetDNNotEqualTo.length > 0) {
                for (PatternDN pattern : this.targetDNNotEqualTo) {
                    if (!pattern.matchesDN(targetDN)) continue;
                    return false;
                }
            }
            if (this.targetDNEqualTo.length > 0) {
                for (PatternDN pattern : this.targetDNEqualTo) {
                    if (!pattern.matchesDN(targetDN)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean filterResponse(Operation operation) {
            Integer resultCode = operation.getResultCode().getIntValue();
            if (!this.cfg.getResponseResultCodeNotEqualTo().isEmpty() && this.cfg.getResponseResultCodeNotEqualTo().contains(resultCode)) {
                return false;
            }
            if (!this.cfg.getResponseResultCodeEqualTo().isEmpty() && !this.cfg.getResponseResultCodeNotEqualTo().contains(resultCode)) {
                return false;
            }
            long etime = operation.getProcessingTime();
            Integer etimeGT = this.cfg.getResponseEtimeLessThan();
            if (etimeGT != null && etime <= (long)etimeGT.intValue()) {
                return false;
            }
            Integer etimeLT = this.cfg.getResponseEtimeLessThan();
            if (etimeLT != null && etime >= (long)etimeLT.intValue()) {
                return false;
            }
            if (operation instanceof SearchOperation) {
                SearchOperation searchOperation = (SearchOperation)operation;
                Boolean isIndexed = this.cfg.isSearchResponseIsIndexed();
                if (isIndexed != null) {
                    boolean wasUnindexed = false;
                    for (AdditionalLogItem item : operation.getAdditionalLogItems()) {
                        if (!item.getKey().equals("unindexed")) continue;
                        wasUnindexed = true;
                        break;
                    }
                    if (isIndexed != false ? wasUnindexed : !wasUnindexed) {
                        return false;
                    }
                }
                int nentries = searchOperation.getEntriesSent();
                Integer nentriesGT = this.cfg.getSearchResponseNentriesGreaterThan();
                if (nentriesGT != null && nentries <= nentriesGT) {
                    return false;
                }
                Integer nentriesLT = this.cfg.getSearchResponseNentriesLessThan();
                if (nentriesLT != null && nentries >= nentriesLT) {
                    return false;
                }
            }
            return true;
        }

        private boolean filterUser(ClientConnection connection) {
            if (!(this.userDNNotEqualTo.length <= 0 && this.userDNEqualTo.length <= 0 || this.filterUserBindDN(connection))) {
                return false;
            }
            return this.userIsNotMemberOf.length <= 0 && this.userIsMemberOf.length <= 0 || this.filterUserIsMemberOf(connection);
        }

        private boolean filterUserBindDN(ClientConnection connection) {
            DN userDN = connection.getAuthenticationInfo().getAuthenticationDN();
            if (userDN == null) {
                return this.userDNEqualTo.length == 0;
            }
            if (this.userDNNotEqualTo.length > 0) {
                for (PatternDN pattern : this.userDNNotEqualTo) {
                    if (!pattern.matchesDN(userDN)) continue;
                    return false;
                }
            }
            if (this.userDNEqualTo.length > 0) {
                for (PatternDN pattern : this.userDNEqualTo) {
                    if (!pattern.matchesDN(userDN)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean filterUserIsMemberOf(ClientConnection connection) {
            Group group;
            Entry userEntry = connection.getAuthenticationInfo().getAuthenticationEntry();
            if (userEntry == null) {
                return this.userIsMemberOf.length == 0;
            }
            GroupManager groupManager = DirectoryServer.getGroupManager();
            if (this.userIsNotMemberOf.length > 0) {
                for (DN groupDN : this.userIsNotMemberOf) {
                    group = groupManager.getGroupInstance(groupDN);
                    try {
                        if (group != null && group.isMember(userEntry)) {
                            return false;
                        }
                    }
                    catch (DirectoryException e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            if (this.userIsMemberOf.length > 0) {
                for (DN groupDN : this.userIsMemberOf) {
                    group = groupManager.getGroupInstance(groupDN);
                    try {
                        if (group != null && group.isMember(userEntry)) {
                            return true;
                        }
                    }
                    catch (DirectoryException e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            return false;
        }
    }
}

