/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.HashSet;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.server.admin.std.server.WhoAmIExtendedOperationHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;

public class WhoAmIExtendedOperation
extends ExtendedOperationHandler<WhoAmIExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Set<String> supportedControlOIDs = new HashSet<String>(0);

    @Override
    public void initializeExtendedOperationHandler(WhoAmIExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        this.supportedControlOIDs = new HashSet<String>(2);
        this.supportedControlOIDs.add("2.16.840.1.113730.3.4.12");
        this.supportedControlOIDs.add("2.16.840.1.113730.3.4.18");
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.4203.1.11.3", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.4203.1.11.3");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public Set<String> getSupportedControls() {
        return this.supportedControlOIDs;
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        ClientConnection clientConnection = operation.getClientConnection();
        try {
            ProxiedAuthV1Control proxyControlV1 = operation.getRequestControl(ProxiedAuthV1Control.DECODER);
            ProxiedAuthV2Control proxyControlV2 = operation.getRequestControl(ProxiedAuthV2Control.DECODER);
            if (proxyControlV1 != null || proxyControlV2 != null) {
                Entry authorizationEntry;
                if (!clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, operation)) {
                    operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_WHOAMI_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    operation.setResultCode(ResultCode.AUTHORIZATION_DENIED);
                    return;
                }
                if (proxyControlV2 != null) {
                    authorizationEntry = proxyControlV2.getAuthorizationEntry();
                } else {
                    operation.addAdditionalLogItem(AdditionalLogItem.keyOnly(this.getClass(), "obsoleteProxiedAuthzV1Control"));
                    authorizationEntry = proxyControlV1.getAuthorizationEntry();
                }
                operation.setAuthorizationEntry(authorizationEntry);
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            operation.setResultCode(de.getResultCode());
            operation.appendErrorMessage(de.getMessageObject());
            return;
        }
        DN authzDN = operation.getAuthorizationDN();
        String authzID = authzDN == null ? "" : "dn:" + authzDN.toString();
        operation.setResponseValue(ByteString.valueOf(authzID));
        operation.addAdditionalLogItem(AdditionalLogItem.quotedKeyValue(this.getClass(), "authzID", authzID));
        operation.setResultCode(ResultCode.SUCCESS);
    }

    @Override
    public String getExtendedOperationName() {
        return "Who Am I?";
    }
}

