/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.TraditionalWorkQueueCfg;
import org.opends.server.api.WorkQueue;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.TraditionalWorkerThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.monitors.TraditionalWorkQueueMonitor;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;

public class TraditionalWorkQueue
extends WorkQueue<TraditionalWorkQueueCfg>
implements ConfigurationChangeListener<TraditionalWorkQueueCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int MAX_RETRY_COUNT = 5;
    private final ArrayList<TraditionalWorkerThread> workerThreads = new ArrayList();
    private AtomicLong opsSubmitted;
    private AtomicLong queueFullRejects;
    private boolean killThreads;
    private boolean shutdownRequested;
    private int lastThreadNumber;
    private int maxCapacity;
    private int numWorkerThreads;
    private final boolean isBlocking = true;
    private LinkedBlockingQueue<Operation> opQueue;
    private final ReentrantReadWriteLock.ReadLock queueReadLock;
    private final ReentrantReadWriteLock.WriteLock queueWriteLock;

    public TraditionalWorkQueue() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.queueReadLock = lock.readLock();
        this.queueWriteLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeWorkQueue(TraditionalWorkQueueCfg configuration) throws ConfigException, InitializationException {
        this.queueWriteLock.lock();
        try {
            this.shutdownRequested = false;
            this.killThreads = false;
            this.opsSubmitted = new AtomicLong(0L);
            this.queueFullRejects = new AtomicLong(0L);
            configuration.addTraditionalChangeListener(this);
            this.numWorkerThreads = this.computeNumWorkerThreads(configuration.getNumWorkerThreads());
            this.maxCapacity = configuration.getMaxWorkQueueCapacity();
            this.opQueue = this.maxCapacity > 0 ? new LinkedBlockingQueue(this.maxCapacity) : new LinkedBlockingQueue();
            this.lastThreadNumber = 0;
            while (this.lastThreadNumber < this.numWorkerThreads) {
                TraditionalWorkerThread t = new TraditionalWorkerThread(this, this.lastThreadNumber);
                t.start();
                this.workerThreads.add(t);
                ++this.lastThreadNumber;
            }
            try {
                TraditionalWorkQueueMonitor monitor = new TraditionalWorkQueueMonitor(this);
                monitor.initializeMonitorProvider(null);
                DirectoryServer.registerMonitorProvider(monitor);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ConfigMessages.ERR_CONFIG_WORK_QUEUE_CANNOT_CREATE_MONITOR.get(String.valueOf(TraditionalWorkQueueMonitor.class), String.valueOf(e));
                ErrorLogger.logError(message);
            }
        }
        finally {
            this.queueWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeWorkQueue(Message reason) {
        this.queueWriteLock.lock();
        try {
            this.shutdownRequested = true;
        }
        finally {
            this.queueWriteLock.unlock();
        }
        CancelRequest cancelRequest = new CancelRequest(true, reason);
        ArrayList pendingOperations = new ArrayList();
        this.opQueue.removeAll(pendingOperations);
        for (Operation o : pendingOperations) {
            try {
                if (o.getCancelResult() != null) continue;
                o.abort(cancelRequest);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(CoreMessages.WARN_QUEUE_UNABLE_TO_CANCEL.get(String.valueOf(o), String.valueOf(e)));
            }
        }
        for (TraditionalWorkerThread t : this.workerThreads) {
            try {
                t.shutDown();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(CoreMessages.WARN_QUEUE_UNABLE_TO_NOTIFY_THREAD.get(t.getName(), String.valueOf(e)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownRequested() {
        this.queueReadLock.lock();
        try {
            boolean bl = this.shutdownRequested;
            return bl;
        }
        finally {
            this.queueReadLock.unlock();
        }
    }

    @Override
    public void submitOperation(Operation operation) throws DirectoryException {
        this.submitOperation(operation, true);
    }

    @Override
    public boolean trySubmitOperation(Operation operation) throws DirectoryException {
        try {
            this.submitOperation(operation, false);
            return true;
        }
        catch (DirectoryException e) {
            if (ResultCode.BUSY == e.getResultCode()) {
                return false;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitOperation(Operation operation, boolean blockEnqueuingWhenFull) throws DirectoryException {
        this.queueReadLock.lock();
        try {
            if (this.shutdownRequested) {
                Message message = CoreMessages.WARN_OP_REJECTED_BY_SHUTDOWN.get();
                throw new DirectoryException(ResultCode.UNAVAILABLE, message);
            }
            if (blockEnqueuingWhenFull) {
                try {
                    while (!this.opQueue.offer(operation, 1L, TimeUnit.SECONDS)) {
                        this.queueReadLock.unlock();
                        Thread.yield();
                        this.queueReadLock.lock();
                        if (!this.shutdownRequested) continue;
                        Message message = CoreMessages.WARN_OP_REJECTED_BY_SHUTDOWN.get();
                        throw new DirectoryException(ResultCode.UNAVAILABLE, message);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.queueFullRejects.incrementAndGet();
                    Message message = CoreMessages.WARN_OP_REJECTED_BY_QUEUE_INTERRUPT.get();
                    throw new DirectoryException(ResultCode.BUSY, message);
                }
            } else if (!this.opQueue.offer(operation)) {
                this.queueFullRejects.incrementAndGet();
                Message message = CoreMessages.WARN_OP_REJECTED_BY_QUEUE_FULL.get(this.maxCapacity);
                throw new DirectoryException(ResultCode.BUSY, message);
            }
            this.opsSubmitted.incrementAndGet();
        }
        finally {
            this.queueReadLock.unlock();
        }
    }

    public Operation nextOperation(TraditionalWorkerThread workerThread) {
        return this.retryNextOperation(workerThread, 0);
    }

    /*
     * Exception decompiling
     */
    private Operation retryNextOperation(TraditionalWorkerThread workerThread, int numFailures) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryKillThisWorkerThread(TraditionalWorkerThread workerThread) {
        this.queueReadLock.unlock();
        this.queueWriteLock.lock();
        try {
            if (this.shutdownRequested) {
                boolean bl = true;
                return bl;
            }
            int currentThreads = this.workerThreads.size();
            if (currentThreads > this.numWorkerThreads) {
                if (this.workerThreads.remove(Thread.currentThread())) {
                    --currentThreads;
                }
                if (currentThreads <= this.numWorkerThreads) {
                    this.killThreads = false;
                }
                workerThread.setStoppedByReducedThreadNumber();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.queueWriteLock.unlock();
            this.queueReadLock.lock();
            if (this.shutdownRequested) {
                return true;
            }
        }
        return false;
    }

    public long getOpsSubmitted() {
        return this.opsSubmitted.longValue();
    }

    public long getOpsRejectedDueToQueueFull() {
        return this.queueFullRejects.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.queueReadLock.lock();
        try {
            int n = this.opQueue.size();
            return n;
        }
        finally {
            this.queueReadLock.unlock();
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(TraditionalWorkQueueCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(TraditionalWorkQueueCfg configuration) {
        ArrayList<Message> resultMessages = new ArrayList<Message>();
        int newNumThreads = this.computeNumWorkerThreads(configuration.getNumWorkerThreads());
        int newMaxCapacity = configuration.getMaxWorkQueueCapacity();
        int currentThreads = this.workerThreads.size();
        if (newNumThreads != currentThreads) {
            this.queueWriteLock.lock();
            try {
                int threadsToAdd = newNumThreads - currentThreads;
                if (threadsToAdd > 0) {
                    for (int i = 0; i < threadsToAdd; ++i) {
                        TraditionalWorkerThread t = new TraditionalWorkerThread(this, this.lastThreadNumber++);
                        this.workerThreads.add(t);
                        t.start();
                    }
                    this.killThreads = false;
                } else {
                    this.killThreads = true;
                }
                this.numWorkerThreads = newNumThreads;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            finally {
                this.queueWriteLock.unlock();
            }
        }
        if (newMaxCapacity != this.maxCapacity) {
            LinkedBlockingQueue<Operation> oldOpQueue;
            this.queueWriteLock.lock();
            try {
                LinkedBlockingQueue newOpQueue = null;
                newOpQueue = newMaxCapacity > 0 ? new LinkedBlockingQueue(newMaxCapacity) : new LinkedBlockingQueue();
                oldOpQueue = this.opQueue;
                this.opQueue = newOpQueue;
                this.maxCapacity = newMaxCapacity;
            }
            finally {
                this.queueWriteLock.unlock();
            }
            Operation pendingOperation = null;
            this.queueReadLock.lock();
            try {
                while ((pendingOperation = oldOpQueue.poll()) != null) {
                    this.opQueue.put(pendingOperation);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Message message = CoreMessages.WARN_OP_REJECTED_BY_QUEUE_INTERRUPT.get();
                CancelRequest cancelRequest = new CancelRequest(true, message);
                if (pendingOperation != null) {
                    pendingOperation.abort(cancelRequest);
                }
                while ((pendingOperation = oldOpQueue.poll()) != null) {
                    pendingOperation.abort(cancelRequest);
                }
            }
            finally {
                this.queueReadLock.unlock();
            }
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false, resultMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        this.queueReadLock.lock();
        try {
            if (this.opQueue.size() > 0) {
                boolean bl = false;
                return bl;
            }
            for (TraditionalWorkerThread t : this.workerThreads) {
                if (!t.isActive()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.queueReadLock.unlock();
        }
    }

    @Override
    public int getNumWorkerThreads() {
        return this.numWorkerThreads;
    }
}

