/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.opends.server.extensions.ConnectionSecurityProvider;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;

public final class TLSByteChannel
implements ConnectionSecurityProvider {
    static final Map<String, Integer> CIPHER_MAP;
    private static final ByteBuffer EMPTY_BUFFER;
    private static final DebugTracer TRACER;
    private final ByteChannelImpl pimpl = new ByteChannelImpl();
    private final ByteChannel channel;
    private final SSLEngine sslEngine;
    private volatile SSLException sslException = null;
    private ByteBuffer recvWrappedBuffer;
    private ByteBuffer recvUnwrappedBuffer;
    private ByteBuffer sendWrappedBuffer;
    private final Object handshakeLock = new Object();
    private final Object unwrapLock = new Object();
    private final Object wrapLock = new Object();
    private final Object readLock = new Object();
    private final Object writeLock = new Object();

    public TLSByteChannel(ByteChannel channel, SSLEngine sslEngine) {
        this.channel = channel;
        this.sslEngine = sslEngine;
        SSLSession session = sslEngine.getSession();
        int wrappedBufferSize = session.getPacketBufferSize();
        int unwrappedBufferSize = session.getApplicationBufferSize();
        this.sendWrappedBuffer = ByteBuffer.allocate(wrappedBufferSize);
        this.recvWrappedBuffer = ByteBuffer.allocate(wrappedBufferSize);
        this.recvUnwrappedBuffer = ByteBuffer.allocate(unwrappedBufferSize);
        this.recvWrappedBuffer.flip();
        this.recvUnwrappedBuffer.flip();
    }

    @Override
    public ByteChannel getChannel() {
        return this.pimpl;
    }

    @Override
    public Certificate[] getClientCertificateChain() {
        try {
            return this.sslEngine.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return new Certificate[0];
        }
    }

    @Override
    public String getName() {
        return "TLS";
    }

    @Override
    public int getSSF() {
        Integer ssf = TLSByteChannel.getSSF(this.sslEngine.getSession().getCipherSuite());
        if (ssf != null) {
            return ssf;
        }
        return 0;
    }

    static Integer getSSF(String cipherString) {
        for (Map.Entry<String, Integer> mapEntry : CIPHER_MAP.entrySet()) {
            if (!cipherString.contains(mapEntry.getKey())) continue;
            return mapEntry.getValue();
        }
        return null;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    static {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        map.put("_WITH_AES_256_", 256);
        map.put("_WITH_ARIA_256_", 256);
        map.put("_WITH_CAMELLIA_256_", 256);
        map.put("_WITH_AES_128_", 128);
        map.put("_WITH_ARIA_128_", 128);
        map.put("_WITH_SEED_", 128);
        map.put("_WITH_CAMELLIA_128_", 128);
        map.put("_WITH_IDEA_", 128);
        map.put("_WITH_RC4_128_", 128);
        map.put("_WITH_3DES_EDE_", 112);
        map.put("_WITH_FORTEZZA_", 96);
        map.put("_WITH_RC4_56_", 56);
        map.put("_WITH_DES_CBC_40_", 40);
        map.put("_WITH_RC2_CBC_40_", 40);
        map.put("_WITH_RC4_40_", 40);
        map.put("_WITH_DES40_", 40);
        map.put("_WITH_DES_", 56);
        map.put("_WITH_NULL_", 0);
        CIPHER_MAP = Collections.unmodifiableMap(map);
        EMPTY_BUFFER = ByteBuffer.allocate(0);
        TRACER = DebugLogger.getTracer();
    }

    private final class ByteChannelImpl
    implements ByteChannel {
        private ByteChannelImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            Object object = TLSByteChannel.this.readLock;
            // MONITORENTER : object
            Object object2 = TLSByteChannel.this.writeLock;
            // MONITORENTER : object2
            boolean isInitiator = !TLSByteChannel.this.sslEngine.isInboundDone();
            try {
                if (TLSByteChannel.this.sslEngine.isOutboundDone()) return;
                TLSByteChannel.this.sslEngine.closeOutbound();
                while (this.doWrapAndSend(EMPTY_BUFFER) > 0) {
                }
                return;
            }
            catch (ClosedChannelException e) {
                try {
                    TLSByteChannel.this.sslEngine.closeInbound();
                    return;
                }
                catch (SSLException e2) {
                    if (isInitiator) return;
                    throw e2;
                }
                finally {
                    TLSByteChannel.this.channel.close();
                }
            }
            finally {
                try {
                    TLSByteChannel.this.sslEngine.closeInbound();
                }
                catch (SSLException e) {
                    if (!isInitiator) {
                        throw e;
                    }
                }
                finally {
                    TLSByteChannel.this.channel.close();
                }
            }
        }

        @Override
        public boolean isOpen() {
            return !TLSByteChannel.this.sslEngine.isOutboundDone() || !TLSByteChannel.this.sslEngine.isInboundDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer unwrappedData) throws IOException {
            Object object = TLSByteChannel.this.readLock;
            synchronized (object) {
                int read;
                if (!TLSByteChannel.this.recvUnwrappedBuffer.hasRemaining() && (read = this.doRecvAndUnwrap()) <= 0) {
                    return read;
                }
                int startPos = unwrappedData.position();
                if (TLSByteChannel.this.recvUnwrappedBuffer.remaining() > unwrappedData.remaining()) {
                    while (unwrappedData.hasRemaining()) {
                        unwrappedData.put(TLSByteChannel.this.recvUnwrappedBuffer.get());
                    }
                } else {
                    unwrappedData.put(TLSByteChannel.this.recvUnwrappedBuffer);
                }
                return unwrappedData.position() - startPos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer unwrappedData) throws IOException {
            int bytesWritten = unwrappedData.remaining();
            Object object = TLSByteChannel.this.writeLock;
            synchronized (object) {
                while (unwrappedData.hasRemaining()) {
                    this.doWrapAndSend(unwrappedData);
                    if (!this.isHandshaking(TLSByteChannel.this.sslEngine.getHandshakeStatus())) continue;
                    this.doHandshake(false);
                }
            }
            return bytesWritten;
        }

        private void abortOnSSLException() throws IOException {
            if (TLSByteChannel.this.sslException != null) {
                throw TLSByteChannel.this.sslException;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void doHandshake(boolean isReading) throws IOException {
            Object object = TLSByteChannel.this.handshakeLock;
            synchronized (object) {
                block7: while (true) {
                    switch (TLSByteChannel.this.sslEngine.getHandshakeStatus()) {
                        case NEED_TASK: {
                            while (true) {
                                Runnable runnable;
                                if ((runnable = TLSByteChannel.this.sslEngine.getDelegatedTask()) == null) continue block7;
                                runnable.run();
                            }
                        }
                        case NEED_UNWRAP: {
                            if (isReading) {
                                return;
                            }
                            if (this.doRecvAndUnwrap() >= 0) continue block7;
                            throw new ClosedChannelException();
                        }
                        case NEED_WRAP: {
                            this.doWrapAndSend(EMPTY_BUFFER);
                            continue block7;
                        }
                    }
                    break;
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int doRecvAndUnwrap() throws IOException {
            Object object = TLSByteChannel.this.unwrapLock;
            synchronized (object) {
                block12: while (true) {
                    SSLEngineResult result;
                    this.abortOnSSLException();
                    TLSByteChannel.this.recvUnwrappedBuffer.compact();
                    try {
                        result = TLSByteChannel.this.sslEngine.unwrap(TLSByteChannel.this.recvWrappedBuffer, TLSByteChannel.this.recvUnwrappedBuffer);
                    }
                    catch (SSLException e) {
                        TLSByteChannel.this.sslException = e;
                        throw e;
                    }
                    finally {
                        TLSByteChannel.this.recvUnwrappedBuffer.flip();
                    }
                    switch (result.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            int newAppSize = TLSByteChannel.this.sslEngine.getSession().getApplicationBufferSize();
                            ByteBuffer newRecvUnwrappedBuffer = ByteBuffer.allocate(TLSByteChannel.this.recvUnwrappedBuffer.limit() + newAppSize);
                            newRecvUnwrappedBuffer.put(TLSByteChannel.this.recvUnwrappedBuffer);
                            newRecvUnwrappedBuffer.flip();
                            TLSByteChannel.this.recvUnwrappedBuffer = newRecvUnwrappedBuffer;
                            continue block12;
                        }
                        case BUFFER_UNDERFLOW: {
                            int newPktSize = TLSByteChannel.this.sslEngine.getSession().getPacketBufferSize();
                            if (newPktSize > TLSByteChannel.this.recvWrappedBuffer.capacity()) {
                                ByteBuffer newRecvWrappedBuffer = ByteBuffer.allocate(newPktSize);
                                newRecvWrappedBuffer.put(TLSByteChannel.this.recvWrappedBuffer);
                                newRecvWrappedBuffer.flip();
                                TLSByteChannel.this.recvWrappedBuffer = newRecvWrappedBuffer;
                            }
                            TLSByteChannel.this.recvWrappedBuffer.compact();
                            int read = TLSByteChannel.this.channel.read(TLSByteChannel.this.recvWrappedBuffer);
                            TLSByteChannel.this.recvWrappedBuffer.flip();
                            if (read > 0) continue block12;
                            return read;
                        }
                        case CLOSED: {
                            return -1;
                        }
                    }
                    if (TLSByteChannel.this.recvUnwrappedBuffer.hasRemaining()) {
                        return TLSByteChannel.this.recvUnwrappedBuffer.remaining();
                    }
                    if (!this.isHandshaking(result.getHandshakeStatus())) continue;
                    this.doHandshake(true);
                }
            }
        }

        private int doWrapAndSend(ByteBuffer unwrappedData) throws IOException {
            Object object = TLSByteChannel.this.wrapLock;
            synchronized (object) {
                block10: while (true) {
                    SSLEngineResult result;
                    this.abortOnSSLException();
                    try {
                        result = TLSByteChannel.this.sslEngine.wrap(unwrappedData, TLSByteChannel.this.sendWrappedBuffer);
                    }
                    catch (SSLException e) {
                        TLSByteChannel.this.sslException = e;
                        throw e;
                    }
                    switch (result.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            int newSize = TLSByteChannel.this.sslEngine.getSession().getPacketBufferSize();
                            ByteBuffer newSendWrappedBuffer = ByteBuffer.allocate(TLSByteChannel.this.sendWrappedBuffer.position() + newSize);
                            TLSByteChannel.this.sendWrappedBuffer.flip();
                            newSendWrappedBuffer.put(TLSByteChannel.this.sendWrappedBuffer);
                            TLSByteChannel.this.sendWrappedBuffer = newSendWrappedBuffer;
                            continue block10;
                        }
                        case BUFFER_UNDERFLOW: {
                            TLSByteChannel.this.sslException = new SSLException("Got unexpected underflow while wrapping");
                            throw TLSByteChannel.this.sslException;
                        }
                        case CLOSED: {
                            throw new ClosedChannelException();
                        }
                    }
                    break;
                }
                TLSByteChannel.this.sendWrappedBuffer.flip();
                while (TLSByteChannel.this.sendWrappedBuffer.hasRemaining()) {
                    TLSByteChannel.this.channel.write(TLSByteChannel.this.sendWrappedBuffer);
                }
                int written = TLSByteChannel.this.sendWrappedBuffer.position();
                TLSByteChannel.this.sendWrappedBuffer.clear();
                return written;
            }
        }

        private boolean isHandshaking(SSLEngineResult.HandshakeStatus status) {
            return status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
    }
}

