/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CertificateMapperCfg;
import org.opends.server.admin.std.server.SubjectDNToUserAttributeCertificateMapperCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.CertificateMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;

public class SubjectDNToUserAttributeCertificateMapper
extends CertificateMapper<SubjectDNToUserAttributeCertificateMapperCfg>
implements ConfigurationChangeListener<SubjectDNToUserAttributeCertificateMapperCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN configEntryDN;
    private SubjectDNToUserAttributeCertificateMapperCfg currentConfig;
    private LinkedHashSet<String> requestedAttributes;

    @Override
    public void initializeCertificateMapper(SubjectDNToUserAttributeCertificateMapperCfg configuration) throws ConfigException, InitializationException {
        configuration.addSubjectDNToUserAttributeChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        Set<DN> cfgBaseDNs = configuration.getUserBaseDN();
        if (cfgBaseDNs == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        AttributeType t = configuration.getSubjectAttribute();
        for (DN baseDN : cfgBaseDNs) {
            Backend b = DirectoryServer.getBackend(baseDN);
            if (b == null || b.isIndexed(t, IndexType.EQUALITY)) continue;
            Message message = ExtensionMessages.WARN_SATUACM_ATTR_UNINDEXED.get(configuration.dn().toString(), t.getNameOrOID(), b.getBackendID());
            ErrorLogger.logError(message);
        }
        this.requestedAttributes = new LinkedHashSet(2);
        this.requestedAttributes.add("*");
        this.requestedAttributes.add("+");
    }

    @Override
    public void finalizeCertificateMapper() {
        this.currentConfig.removeSubjectDNToUserAttributeChangeListener(this);
    }

    @Override
    public Entry mapCertificateToUser(Certificate[] certificateChain) throws DirectoryException {
        X509Certificate peerCertificate;
        SubjectDNToUserAttributeCertificateMapperCfg config = this.currentConfig;
        AttributeType subjectAttributeType = config.getSubjectAttribute();
        if (certificateChain == null || certificateChain.length == 0) {
            Message message = ExtensionMessages.ERR_SDTUACM_NO_PEER_CERTIFICATE.get();
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
        }
        try {
            peerCertificate = (X509Certificate)certificateChain[0];
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_SDTUACM_PEER_CERT_NOT_X509.get(String.valueOf(certificateChain[0].getType()));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
        }
        X500Principal peerPrincipal = peerCertificate.getSubjectX500Principal();
        String peerName = peerPrincipal.getName("RFC2253");
        AttributeValue value = AttributeValues.create(subjectAttributeType, peerName);
        SearchFilter filter = SearchFilter.createEqualityFilter(subjectAttributeType, value);
        Set<DN> baseDNs = config.getUserBaseDN();
        if (baseDNs == null || baseDNs.isEmpty()) {
            baseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        SearchResultEntry userEntry = null;
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        for (DN baseDN : baseDNs) {
            InternalSearchOperation searchOperation = conn.processSearch(baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 1, 10, false, filter, this.requestedAttributes);
            switch (searchOperation.getResultCode()) {
                case SUCCESS: {
                    break;
                }
                case NO_SUCH_OBJECT: {
                    break;
                }
                case SIZE_LIMIT_EXCEEDED: {
                    Message message = ExtensionMessages.ERR_SDTUACM_MULTIPLE_SEARCH_MATCHING_ENTRIES.get(peerName);
                    throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
                }
                case TIME_LIMIT_EXCEEDED: 
                case ADMIN_LIMIT_EXCEEDED: {
                    Message message = ExtensionMessages.ERR_SDTUACM_INEFFICIENT_SEARCH.get(peerName, String.valueOf(searchOperation.getErrorMessage()));
                    throw new DirectoryException(searchOperation.getResultCode(), message);
                }
                default: {
                    Message message = ExtensionMessages.ERR_SDTUACM_SEARCH_FAILED.get(peerName, String.valueOf(searchOperation.getErrorMessage()));
                    throw new DirectoryException(searchOperation.getResultCode(), message);
                }
            }
            for (SearchResultEntry entry : searchOperation.getSearchEntries()) {
                if (userEntry == null) {
                    userEntry = entry;
                    continue;
                }
                Message message = ExtensionMessages.ERR_SDTUACM_MULTIPLE_MATCHING_ENTRIES.get(peerName, String.valueOf(userEntry.getDN()), String.valueOf(entry.getDN()));
                throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
            }
        }
        return userEntry;
    }

    @Override
    public boolean isConfigurationAcceptable(CertificateMapperCfg configuration, List<Message> unacceptableReasons) {
        SubjectDNToUserAttributeCertificateMapperCfg config = (SubjectDNToUserAttributeCertificateMapperCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SubjectDNToUserAttributeCertificateMapperCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SubjectDNToUserAttributeCertificateMapperCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

