/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.SaltedSHA1PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

public class SaltedSHA1PasswordStorageScheme
extends PasswordStorageScheme<SaltedSHA1PasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.extensions.SaltedSHA1PasswordStorageScheme";
    private static final int NUM_SALT_BYTES = 8;
    private static final int SHA1_LENGTH = 20;
    private MessageDigest messageDigest;
    private Object digestLock;
    private Random random;

    @Override
    public void initializePasswordStorageScheme(SaltedSHA1PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_INITIALIZE_MESSAGE_DIGEST.get("SHA-1", String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.digestLock = new Object();
        this.random = new Random();
    }

    @Override
    public String getStorageSchemeName() {
        return "SSHA";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString encodePassword(ByteSequence plaintext) throws DirectoryException {
        byte[] digestBytes;
        int plainBytesLength = plaintext.length();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plainBytesLength + 8];
        plaintext.copyTo(plainPlusSalt);
        Object object = this.digestLock;
        synchronized (object) {
            try {
                this.random.nextBytes(saltBytes);
                System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytesLength, 8);
                digestBytes = this.messageDigest.digest(plainPlusSalt);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        byte[] hashPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, hashPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, hashPlusSalt, digestBytes.length, 8);
        return ByteString.valueOf(Base64.encode(hashPlusSalt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString encodePasswordWithScheme(ByteSequence plaintext) throws DirectoryException {
        byte[] digestBytes;
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("SSHA");
        buffer.append('}');
        int plainBytesLength = plaintext.length();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plainBytesLength + 8];
        plaintext.copyTo(plainPlusSalt);
        Object object = this.digestLock;
        synchronized (object) {
            try {
                this.random.nextBytes(saltBytes);
                System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytesLength, 8);
                digestBytes = this.messageDigest.digest(plainPlusSalt);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        byte[] hashPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, hashPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, hashPlusSalt, digestBytes.length, 8);
        buffer.append(Base64.encode(hashPlusSalt));
        return ByteString.valueOf(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean passwordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        byte[] userDigestBytes;
        byte[] saltBytes;
        byte[] digestBytes = new byte[20];
        int saltLength = 0;
        try {
            byte[] decodedBytes = Base64.decode(storedPassword.toString());
            saltLength = decodedBytes.length - 20;
            if (saltLength <= 0) {
                Message message = ExtensionMessages.ERR_PWSCHEME_INVALID_BASE64_DECODED_STORED_PASSWORD.get(storedPassword.toString());
                ErrorLogger.logError(message);
                return false;
            }
            saltBytes = new byte[saltLength];
            System.arraycopy(decodedBytes, 0, digestBytes, 0, 20);
            System.arraycopy(decodedBytes, 20, saltBytes, 0, saltLength);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_BASE64_DECODE_STORED_PASSWORD.get(storedPassword.toString(), String.valueOf(e));
            ErrorLogger.logError(message);
            return false;
        }
        int plainBytesLength = plaintextPassword.length();
        byte[] plainPlusSalt = new byte[plainBytesLength + saltLength];
        plaintextPassword.copyTo(plainPlusSalt);
        System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytesLength, saltLength);
        Object object = this.digestLock;
        synchronized (object) {
            try {
                userDigestBytes = this.messageDigest.digest(plainPlusSalt);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return false;
            }
        }
        return Arrays.equals(digestBytes, userDigestBytes);
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return true;
    }

    @Override
    public String getAuthPasswordSchemeName() {
        return "SHA1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString encodeAuthPassword(ByteSequence plaintext) throws DirectoryException {
        byte[] digestBytes;
        int plaintextLength = plaintext.length();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plaintextLength + 8];
        plaintext.copyTo(plainPlusSalt);
        Object object = this.digestLock;
        synchronized (object) {
            try {
                this.random.nextBytes(saltBytes);
                System.arraycopy(saltBytes, 0, plainPlusSalt, plaintextLength, 8);
                digestBytes = this.messageDigest.digest(plainPlusSalt);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        StringBuilder authPWValue = new StringBuilder();
        authPWValue.append("SHA1");
        authPWValue.append('$');
        authPWValue.append(Base64.encode(saltBytes));
        authPWValue.append('$');
        authPWValue.append(Base64.encode(digestBytes));
        return ByteString.valueOf(authPWValue.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authPasswordMatches(ByteSequence plaintextPassword, String authInfo, String authValue) {
        byte[] digestBytes;
        byte[] saltBytes;
        try {
            saltBytes = Base64.decode(authInfo);
            digestBytes = Base64.decode(authValue);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
        int plainBytesLength = plaintextPassword.length();
        byte[] plainPlusSaltBytes = new byte[plainBytesLength + saltBytes.length];
        plaintextPassword.copyTo(plainPlusSaltBytes);
        System.arraycopy(saltBytes, 0, plainPlusSaltBytes, plainBytesLength, saltBytes.length);
        Object object = this.digestLock;
        synchronized (object) {
            return Arrays.equals(digestBytes, this.messageDigest.digest(plainPlusSaltBytes));
        }
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public ByteString getPlaintextValue(ByteSequence storedPassword) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("SSHA");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("SHA1");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return true;
    }

    public static String encodeOffline(byte[] passwordBytes) throws DirectoryException {
        MessageDigest messageDigest;
        byte[] saltBytes = new byte[8];
        new Random().nextBytes(saltBytes);
        byte[] passwordPlusSalt = new byte[passwordBytes.length + 8];
        System.arraycopy(passwordBytes, 0, passwordPlusSalt, 0, passwordBytes.length);
        System.arraycopy(saltBytes, 0, passwordPlusSalt, passwordBytes.length, 8);
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_INITIALIZE_MESSAGE_DIGEST.get("SHA-1", String.valueOf(e));
            throw new DirectoryException(ResultCode.OTHER, message, e);
        }
        byte[] digestBytes = messageDigest.digest(passwordPlusSalt);
        byte[] digestPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, digestPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, digestPlusSalt, digestBytes.length, 8);
        return "{SSHA}" + Base64.encode(digestPlusSalt);
    }
}

