/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.SaltedMD5PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

public class SaltedMD5PasswordStorageScheme
extends PasswordStorageScheme<SaltedMD5PasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.extensions.SaltedMD5PasswordStorageScheme";
    private static final int NUM_SALT_BYTES = 8;
    private MessageDigest messageDigest;
    private Object digestLock;
    private Random random;

    @Override
    public void initializePasswordStorageScheme(SaltedMD5PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_INITIALIZE_MESSAGE_DIGEST.get("MD5", String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.digestLock = new Object();
        this.random = new Random();
    }

    @Override
    public String getStorageSchemeName() {
        return "SMD5";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString encodePassword(ByteSequence plaintext) throws DirectoryException {
        byte[] digestBytes;
        int plainBytesLength = plaintext.length();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plainBytesLength + 8];
        plaintext.copyTo(plainPlusSalt);
        Object object = this.digestLock;
        synchronized (object) {
            try {
                this.random.nextBytes(saltBytes);
                System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytesLength, 8);
                digestBytes = this.messageDigest.digest(plainPlusSalt);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        byte[] hashPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, hashPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, hashPlusSalt, digestBytes.length, 8);
        return ByteString.valueOf(Base64.encode(hashPlusSalt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString encodePasswordWithScheme(ByteSequence plaintext) throws DirectoryException {
        byte[] digestBytes;
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("SMD5");
        buffer.append('}');
        int plainBytesLength = plaintext.length();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plainBytesLength + 8];
        plaintext.copyTo(plainPlusSalt);
        Object object = this.digestLock;
        synchronized (object) {
            try {
                this.random.nextBytes(saltBytes);
                System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytesLength, 8);
                digestBytes = this.messageDigest.digest(plainPlusSalt);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        byte[] hashPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, hashPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, hashPlusSalt, digestBytes.length, 8);
        buffer.append(Base64.encode(hashPlusSalt));
        return ByteString.valueOf(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean passwordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        byte[] userDigestBytes;
        byte[] digestBytes;
        byte[] saltBytes = new byte[8];
        try {
            byte[] decodedBytes = Base64.decode(storedPassword.toString());
            int digestLength = decodedBytes.length - 8;
            digestBytes = new byte[digestLength];
            System.arraycopy(decodedBytes, 0, digestBytes, 0, digestLength);
            System.arraycopy(decodedBytes, digestLength, saltBytes, 0, 8);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_BASE64_DECODE_STORED_PASSWORD.get(storedPassword.toString(), String.valueOf(e));
            ErrorLogger.logError(message);
            return false;
        }
        int plainBytesLength = plaintextPassword.length();
        byte[] plainPlusSalt = new byte[plainBytesLength + 8];
        plaintextPassword.copyTo(plainPlusSalt);
        System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytesLength, 8);
        Object object = this.digestLock;
        synchronized (object) {
            try {
                userDigestBytes = this.messageDigest.digest(plainPlusSalt);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return false;
            }
        }
        return Arrays.equals(digestBytes, userDigestBytes);
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return true;
    }

    @Override
    public String getAuthPasswordSchemeName() {
        return "MD5";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString encodeAuthPassword(ByteSequence plaintext) throws DirectoryException {
        byte[] digestBytes;
        int plaintextLength = plaintext.length();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plaintextLength + 8];
        plaintext.copyTo(plainPlusSalt);
        Object object = this.digestLock;
        synchronized (object) {
            try {
                this.random.nextBytes(saltBytes);
                System.arraycopy(saltBytes, 0, plainPlusSalt, plaintextLength, 8);
                digestBytes = this.messageDigest.digest(plainPlusSalt);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        StringBuilder authPWValue = new StringBuilder();
        authPWValue.append("MD5");
        authPWValue.append('$');
        authPWValue.append(Base64.encode(saltBytes));
        authPWValue.append('$');
        authPWValue.append(Base64.encode(digestBytes));
        return ByteString.valueOf(authPWValue.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authPasswordMatches(ByteSequence plaintextPassword, String authInfo, String authValue) {
        byte[] digestBytes;
        byte[] saltBytes;
        try {
            saltBytes = Base64.decode(authInfo);
            digestBytes = Base64.decode(authValue);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
        int plainBytesLength = plaintextPassword.length();
        byte[] plainPlusSaltBytes = new byte[plainBytesLength + saltBytes.length];
        plaintextPassword.copyTo(plainPlusSaltBytes);
        System.arraycopy(saltBytes, 0, plainPlusSaltBytes, plainBytesLength, saltBytes.length);
        Object object = this.digestLock;
        synchronized (object) {
            return Arrays.equals(digestBytes, this.messageDigest.digest(plainPlusSaltBytes));
        }
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public ByteString getPlaintextValue(ByteSequence storedPassword) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("SMD5");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("MD5");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return true;
    }
}

