/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.AccountStatusNotificationHandlerCfg;
import org.opends.server.admin.std.server.SMTPAccountStatusNotificationHandlerCfg;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.NotificationMessageNotificationMessageTemplateElement;
import org.opends.server.extensions.NotificationMessageTemplateElement;
import org.opends.server.extensions.NotificationPropertyNotificationMessageTemplateElement;
import org.opends.server.extensions.NotificationTypeNotificationMessageTemplateElement;
import org.opends.server.extensions.TextNotificationMessageTemplateElement;
import org.opends.server.extensions.UserAttributeNotificationMessageTemplateElement;
import org.opends.server.extensions.UserDNNotificationMessageTemplateElement;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AccountStatusNotification;
import org.opends.server.types.AccountStatusNotificationProperty;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.EMailMessage;
import org.opends.server.util.StaticUtils;

public class SMTPAccountStatusNotificationHandler
extends AccountStatusNotificationHandler<SMTPAccountStatusNotificationHandlerCfg>
implements ConfigurationChangeListener<SMTPAccountStatusNotificationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private HashMap<AccountStatusNotificationType, List<NotificationMessageTemplateElement>> templateMap;
    private HashMap<AccountStatusNotificationType, String> subjectMap;
    private SMTPAccountStatusNotificationHandlerCfg currentConfig;

    @Override
    public void initializeStatusNotificationHandler(SMTPAccountStatusNotificationHandlerCfg configuration) throws ConfigException, InitializationException {
        this.currentConfig = configuration;
        this.currentConfig.addSMTPChangeListener(this);
        this.subjectMap = this.parseSubjects(configuration);
        this.templateMap = this.parseTemplates(configuration);
        List<Properties> propList = DirectoryServer.getMailServerPropertySets();
        if (propList == null || propList.isEmpty()) {
            throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_NO_MAIL_SERVERS_CONFIGURED.get(configuration.dn().toString()));
        }
        SortedSet<AttributeType> mailAttrs = configuration.getEmailAddressAttributeType();
        SortedSet<String> recipients = configuration.getRecipientAddress();
        if ((mailAttrs == null || mailAttrs.isEmpty()) && (recipients == null || recipients.isEmpty())) {
            throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_NO_RECIPIENTS.get(configuration.dn().toString()));
        }
    }

    private HashMap<AccountStatusNotificationType, String> parseSubjects(SMTPAccountStatusNotificationHandlerCfg configuration) throws ConfigException {
        HashMap<AccountStatusNotificationType, String> map = new HashMap<AccountStatusNotificationType, String>();
        for (String s : configuration.getMessageSubject()) {
            int colonPos = s.indexOf(58);
            if (colonPos < 0) {
                throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_SUBJECT_NO_COLON.get(s, configuration.dn().toString()));
            }
            String notificationTypeName = s.substring(0, colonPos).trim();
            AccountStatusNotificationType t = AccountStatusNotificationType.typeForName(notificationTypeName);
            if (t == null) {
                throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_SUBJECT_INVALID_NOTIFICATION_TYPE.get(s, configuration.dn().toString(), notificationTypeName));
            }
            if (map.containsKey((Object)t)) {
                throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_SUBJECT_DUPLICATE_TYPE.get(configuration.dn().toString(), notificationTypeName));
            }
            map.put(t, s.substring(colonPos + 1).trim());
            if (!DebugLogger.debugEnabled()) continue;
            TRACER.debugInfo("Subject for notification type " + t.getName() + ":  " + map.get((Object)t));
        }
        return map;
    }

    private HashMap<AccountStatusNotificationType, List<NotificationMessageTemplateElement>> parseTemplates(SMTPAccountStatusNotificationHandlerCfg configuration) throws ConfigException {
        HashMap<AccountStatusNotificationType, List<NotificationMessageTemplateElement>> map = new HashMap<AccountStatusNotificationType, List<NotificationMessageTemplateElement>>();
        for (String s : configuration.getMessageTemplateFile()) {
            int colonPos = s.indexOf(58);
            if (colonPos < 0) {
                throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_TEMPLATE_NO_COLON.get(s, configuration.dn().toString()));
            }
            String notificationTypeName = s.substring(0, colonPos).trim();
            AccountStatusNotificationType t = AccountStatusNotificationType.typeForName(notificationTypeName);
            if (t == null) {
                throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_TEMPLATE_INVALID_NOTIFICATION_TYPE.get(s, configuration.dn().toString(), notificationTypeName));
            }
            if (map.containsKey((Object)t)) {
                throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_TEMPLATE_DUPLICATE_TYPE.get(configuration.dn().toString(), notificationTypeName));
            }
            String path = s.substring(colonPos + 1).trim();
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(DirectoryServer.getInstanceRoot() + File.separator + path);
            }
            if (!f.exists()) {
                throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_TEMPLATE_NO_SUCH_FILE.get(path, configuration.dn().toString()));
            }
            map.put(t, this.parseTemplateFile(f));
            if (!DebugLogger.debugEnabled()) continue;
            TRACER.debugInfo("Decoded template elment list for type " + t.getName());
        }
        return map;
    }

    private List<NotificationMessageTemplateElement> parseTemplateFile(File f) throws ConfigException {
        LinkedList<NotificationMessageTemplateElement> elementList = new LinkedList<NotificationMessageTemplateElement>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(f));
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Read message template line " + line);
                }
                ++lineNumber;
                int startPos = 0;
                while (startPos < line.length()) {
                    int closeDelimPos;
                    int delimPos = line.indexOf("%%", startPos);
                    if (delimPos < 0) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("No more tokens -- adding text " + line.substring(startPos));
                        }
                        elementList.add(new TextNotificationMessageTemplateElement(line.substring(startPos)));
                        break;
                    }
                    if (delimPos > startPos) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Adding text before token " + line.substring(startPos));
                        }
                        elementList.add(new TextNotificationMessageTemplateElement(line.substring(startPos, delimPos)));
                    }
                    if ((closeDelimPos = line.indexOf("%%", delimPos + 1)) < 0) {
                        throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_TEMPLATE_UNCLOSED_TOKEN.get(delimPos, lineNumber));
                    }
                    String tokenStr = line.substring(delimPos + 2, closeDelimPos);
                    String lowerTokenStr = StaticUtils.toLowerCase(tokenStr);
                    if (lowerTokenStr.equals("notification-type")) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Found a notification type token " + tokenStr);
                        }
                        elementList.add(new NotificationTypeNotificationMessageTemplateElement());
                    } else if (lowerTokenStr.equals("notification-message")) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Found a notification message token " + tokenStr);
                        }
                        elementList.add(new NotificationMessageNotificationMessageTemplateElement());
                    } else if (lowerTokenStr.equals("notification-user-dn")) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Found a notification user DN token " + tokenStr);
                        }
                        elementList.add(new UserDNNotificationMessageTemplateElement());
                    } else if (lowerTokenStr.startsWith("notification-user-attr:")) {
                        String attrName = lowerTokenStr.substring(23);
                        AttributeType attrType = DirectoryServer.getAttributeType(attrName, false);
                        if (attrType == null) {
                            throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_TEMPLATE_UNDEFINED_ATTR_TYPE.get(delimPos, lineNumber, attrName));
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Found a user attribute token for  " + attrType.getNameOrOID() + " -- " + tokenStr);
                        }
                        elementList.add(new UserAttributeNotificationMessageTemplateElement(attrType));
                    } else if (lowerTokenStr.startsWith("notification-property:")) {
                        String propertyName = lowerTokenStr.substring(22);
                        AccountStatusNotificationProperty property = AccountStatusNotificationProperty.forName(propertyName);
                        if (property == null) {
                            throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_TEMPLATE_UNDEFINED_PROPERTY.get(delimPos, lineNumber, propertyName));
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Found a notification property token for " + propertyName + " -- " + tokenStr);
                        }
                        elementList.add(new NotificationPropertyNotificationMessageTemplateElement(property));
                    } else {
                        throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_TEMPLATE_UNRECOGNIZED_TOKEN.get(tokenStr, delimPos, lineNumber));
                    }
                    startPos = closeDelimPos + 2;
                }
                elementList.add(new TextNotificationMessageTemplateElement("\r\n"));
            }
            LinkedList<NotificationMessageTemplateElement> linkedList = elementList;
            return linkedList;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new ConfigException(ExtensionMessages.ERR_SMTP_ASNH_TEMPLATE_CANNOT_PARSE.get(f.getAbsolutePath(), this.currentConfig.dn().toString(), StaticUtils.getExceptionMessage(e)));
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean isConfigurationAcceptable(AccountStatusNotificationHandlerCfg configuration, List<Message> unacceptableReasons) {
        SMTPAccountStatusNotificationHandlerCfg config = (SMTPAccountStatusNotificationHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public void handleStatusNotification(AccountStatusNotification notification) {
        String subject;
        SMTPAccountStatusNotificationHandlerCfg config = this.currentConfig;
        HashMap<AccountStatusNotificationType, String> subjects = this.subjectMap;
        HashMap<AccountStatusNotificationType, List<NotificationMessageTemplateElement>> templates = this.templateMap;
        AccountStatusNotificationType notificationType = notification.getNotificationType();
        List<NotificationMessageTemplateElement> templateElements = templates.get((Object)notificationType);
        if (templateElements == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("No message template for notification type " + notificationType.getName());
            }
            return;
        }
        LinkedList<String> recipients = new LinkedList<String>();
        SortedSet<AttributeType> addressAttrs = config.getEmailAddressAttributeType();
        SortedSet<String> recipientAddrs = config.getRecipientAddress();
        if (addressAttrs != null && !addressAttrs.isEmpty()) {
            Entry userEntry = notification.getUserEntry();
            for (AttributeType t : addressAttrs) {
                List<Attribute> attrList = userEntry.getAttribute(t);
                if (attrList == null) continue;
                for (Attribute a : attrList) {
                    for (AttributeValue v : a) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Adding end user recipient " + v.getValue().toString() + " from attr " + a.getNameWithOptions());
                        }
                        recipients.add(v.getValue().toString());
                    }
                }
            }
            if (recipients.isEmpty()) {
                if (recipientAddrs == null || recipientAddrs.isEmpty()) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("No end user recipients, and no explicit recipients");
                    }
                    return;
                }
                if (!config.isSendMessageWithoutEndUserAddress()) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("No end user recipients, and shouldn't send without end user recipients");
                    }
                    return;
                }
            }
        }
        if (recipientAddrs != null) {
            if (DebugLogger.debugEnabled()) {
                for (String s : recipientAddrs) {
                    TRACER.debugInfo("Adding explicit recipient " + s);
                }
            }
            recipients.addAll(recipientAddrs);
        }
        if ((subject = subjects.get((Object)notificationType)) == null) {
            subject = ExtensionMessages.INFO_SMTP_ASNH_DEFAULT_SUBJECT.get().toString();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Using default subject of " + subject);
            }
        } else if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Using per-type subject of " + subject);
        }
        MessageBuilder messageBody = new MessageBuilder();
        for (NotificationMessageTemplateElement e : templateElements) {
            e.generateValue(messageBody, notification);
        }
        EMailMessage message = new EMailMessage(config.getSenderAddress(), recipients, subject);
        message.setBody(messageBody);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Set message body of " + messageBody.toString());
        }
        try {
            message.send();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Successfully sent the message");
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(ExtensionMessages.ERR_SMTP_ASNH_CANNOT_SEND_MESSAGE.get(notificationType.getName(), notification.getUserDN().toString(), StaticUtils.getExceptionMessage(e)));
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SMTPAccountStatusNotificationHandlerCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        List<Properties> propList = DirectoryServer.getMailServerPropertySets();
        if (propList == null || propList.isEmpty()) {
            unacceptableReasons.add(ExtensionMessages.ERR_SMTP_ASNH_NO_MAIL_SERVERS_CONFIGURED.get(configuration.dn().toString()));
            configAcceptable = false;
        }
        SortedSet<AttributeType> mailAttrs = configuration.getEmailAddressAttributeType();
        SortedSet<String> recipients = configuration.getRecipientAddress();
        if ((mailAttrs == null || mailAttrs.isEmpty()) && (recipients == null || recipients.isEmpty())) {
            unacceptableReasons.add(ExtensionMessages.ERR_SMTP_ASNH_NO_RECIPIENTS.get(configuration.dn().toString()));
            configAcceptable = false;
        }
        try {
            this.parseSubjects(configuration);
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            unacceptableReasons.add(ce.getMessageObject());
            configAcceptable = false;
        }
        try {
            this.parseTemplates(configuration);
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            unacceptableReasons.add(ce.getMessageObject());
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SMTPAccountStatusNotificationHandlerCfg configuration) {
        try {
            HashMap<AccountStatusNotificationType, String> subjects = this.parseSubjects(configuration);
            HashMap<AccountStatusNotificationType, List<NotificationMessageTemplateElement>> templates = this.parseTemplates(configuration);
            this.currentConfig = configuration;
            this.subjectMap = subjects;
            this.templateMap = templates;
            return new ConfigChangeResult(ResultCode.SUCCESS, false);
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            LinkedList<Message> messageList = new LinkedList<Message>();
            messageList.add(ce.getMessageObject());
            return new ConfigChangeResult(ResultCode.UNWILLING_TO_PERFORM, false, messageList);
        }
    }
}

