/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.security.cert.Certificate;
import org.opends.server.api.ClientConnection;
import org.opends.server.extensions.ConnectionSecurityProvider;
import org.opends.server.extensions.SASLContext;

public final class SASLByteChannel
implements ConnectionSecurityProvider {
    private final String name;
    private final ByteChannel channel;
    private final ByteChannelImpl pimpl = new ByteChannelImpl();
    private final SASLContext saslContext;
    private ByteBuffer recvUnwrappedBuffer;
    private final ByteBuffer recvWrappedBuffer;
    private final int recvWrappedBufferMaximumSize;
    private int recvWrappedLength = -1;
    private final ByteBuffer recvWrappedLengthBuffer = ByteBuffer.allocate(4);
    private final int sendUnwrappedBufferSize;
    private final byte[] sendUnwrappedBytes;
    private ByteBuffer sendWrappedBuffer;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();

    public static SASLByteChannel getSASLByteChannel(ClientConnection c, String name, SASLContext context) {
        return new SASLByteChannel(c, name, context);
    }

    private SASLByteChannel(ClientConnection connection, String name, SASLContext saslContext) {
        this.name = name;
        this.saslContext = saslContext;
        this.channel = connection.getChannel();
        this.recvWrappedBufferMaximumSize = saslContext.getMaxReceiveBufferSize();
        this.sendUnwrappedBufferSize = saslContext.getMaxRawSendBufferSize();
        this.recvWrappedBuffer = ByteBuffer.allocate(this.recvWrappedBufferMaximumSize);
        this.recvUnwrappedBuffer = ByteBuffer.allocate(0);
        this.sendUnwrappedBytes = new byte[this.sendUnwrappedBufferSize];
        this.sendWrappedBuffer = ByteBuffer.allocate(this.sendUnwrappedBufferSize + 64);
    }

    @Override
    public ByteChannel getChannel() {
        return this.pimpl;
    }

    @Override
    public Certificate[] getClientCertificateChain() {
        return new Certificate[0];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSSF() {
        return this.saslContext.getSSF();
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    private final class ByteChannelImpl
    implements ByteChannel {
        private ByteChannelImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = SASLByteChannel.this.readLock;
            synchronized (object) {
                Object object2 = SASLByteChannel.this.writeLock;
                synchronized (object2) {
                    SASLByteChannel.this.saslContext.dispose();
                    SASLByteChannel.this.channel.close();
                }
            }
        }

        @Override
        public boolean isOpen() {
            return SASLByteChannel.this.saslContext != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer unwrappedData) throws IOException {
            Object object = SASLByteChannel.this.readLock;
            synchronized (object) {
                int read;
                if (!SASLByteChannel.this.recvUnwrappedBuffer.hasRemaining() && (read = this.doRecvAndUnwrap()) <= 0) {
                    return read;
                }
                int startPos = unwrappedData.position();
                if (SASLByteChannel.this.recvUnwrappedBuffer.remaining() > unwrappedData.remaining()) {
                    while (unwrappedData.hasRemaining()) {
                        unwrappedData.put(SASLByteChannel.this.recvUnwrappedBuffer.get());
                    }
                } else {
                    unwrappedData.put(SASLByteChannel.this.recvUnwrappedBuffer);
                }
                return unwrappedData.position() - startPos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer unwrappedData) throws IOException {
            int bytesWritten = unwrappedData.remaining();
            Object object = SASLByteChannel.this.writeLock;
            synchronized (object) {
                while (unwrappedData.hasRemaining()) {
                    byte[] wrappedDataBytes;
                    int wrapSize;
                    int remaining = unwrappedData.remaining();
                    int n = wrapSize = remaining < SASLByteChannel.this.sendUnwrappedBufferSize ? remaining : SASLByteChannel.this.sendUnwrappedBufferSize;
                    if (unwrappedData.hasArray()) {
                        wrappedDataBytes = SASLByteChannel.this.saslContext.wrap(unwrappedData.array(), unwrappedData.arrayOffset() + unwrappedData.position(), wrapSize);
                    } else {
                        unwrappedData.get(SASLByteChannel.this.sendUnwrappedBytes, 0, wrapSize);
                        wrappedDataBytes = SASLByteChannel.this.saslContext.wrap(SASLByteChannel.this.sendUnwrappedBytes, 0, wrapSize);
                    }
                    unwrappedData.position(unwrappedData.position() + wrapSize);
                    if (SASLByteChannel.this.sendWrappedBuffer.capacity() < wrappedDataBytes.length + 4) {
                        SASLByteChannel.this.sendWrappedBuffer = ByteBuffer.allocate(wrappedDataBytes.length + 4);
                    }
                    SASLByteChannel.this.sendWrappedBuffer.clear();
                    SASLByteChannel.this.sendWrappedBuffer.putInt(wrappedDataBytes.length);
                    SASLByteChannel.this.sendWrappedBuffer.put(wrappedDataBytes);
                    SASLByteChannel.this.sendWrappedBuffer.flip();
                    SASLByteChannel.this.channel.write(SASLByteChannel.this.sendWrappedBuffer);
                }
            }
            return bytesWritten;
        }

        private int doRecvAndUnwrap() throws IOException {
            byte[] unwrappedDataBytes;
            do {
                if (SASLByteChannel.this.recvWrappedLength < 0) {
                    while (SASLByteChannel.this.recvWrappedLengthBuffer.hasRemaining()) {
                        int read = SASLByteChannel.this.channel.read(SASLByteChannel.this.recvWrappedLengthBuffer);
                        if (read > 0) continue;
                        return read;
                    }
                    SASLByteChannel.this.recvWrappedLengthBuffer.flip();
                    SASLByteChannel.this.recvWrappedLength = SASLByteChannel.this.recvWrappedLengthBuffer.getInt();
                    SASLByteChannel.this.recvWrappedLengthBuffer.clear();
                    if (SASLByteChannel.this.recvWrappedLength > SASLByteChannel.this.recvWrappedBufferMaximumSize) {
                        throw new IOException("Client sent a SASL packet specifying a length " + SASLByteChannel.this.recvWrappedLength + " which exceeds the negotiated limit of " + SASLByteChannel.this.recvWrappedBufferMaximumSize);
                    }
                    if (SASLByteChannel.this.recvWrappedLength < 0) {
                        throw new IOException("Client sent a SASL packet specifying a negative length " + SASLByteChannel.this.recvWrappedLength);
                    }
                    SASLByteChannel.this.recvWrappedBuffer.clear();
                    SASLByteChannel.this.recvWrappedBuffer.limit(SASLByteChannel.this.recvWrappedLength);
                }
                while (SASLByteChannel.this.recvWrappedBuffer.hasRemaining()) {
                    int read = SASLByteChannel.this.channel.read(SASLByteChannel.this.recvWrappedBuffer);
                    if (read > 0) continue;
                    return read;
                }
                SASLByteChannel.this.recvWrappedBuffer.flip();
                unwrappedDataBytes = SASLByteChannel.this.saslContext.unwrap(SASLByteChannel.this.recvWrappedBuffer.array(), 0, SASLByteChannel.this.recvWrappedLength);
                SASLByteChannel.this.recvWrappedLength = -1;
            } while (unwrappedDataBytes.length <= 0);
            SASLByteChannel.this.recvUnwrappedBuffer = ByteBuffer.wrap(unwrappedDataBytes);
            return SASLByteChannel.this.recvUnwrappedBuffer.remaining();
        }
    }
}

