/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.opends.messages.CoreMessages;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.PlainSASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.AuthenticationPolicyState;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class PlainSASLMechanismHandler
extends SASLMechanismHandler<PlainSASLMechanismHandlerCfg>
implements ConfigurationChangeListener<PlainSASLMechanismHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private IdentityMapper<?> identityMapper;
    private PlainSASLMechanismHandlerCfg currentConfig;

    @Override
    public void initializeSASLMechanismHandler(PlainSASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        configuration.addPlainChangeListener(this);
        this.currentConfig = configuration;
        DN identityMapperDN = configuration.getIdentityMapperDN();
        this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        DirectoryServer.registerSASLMechanismHandler("PLAIN", this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        this.currentConfig.removePlainChangeListener(this);
        DirectoryServer.deregisterSASLMechanismHandler("PLAIN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void processSASLBind(BindOperation bindOperation) {
        Message message;
        Entry authZEntry;
        Entry userEntry;
        String password;
        block47: {
            AuthenticationInfo tempAuthInfo;
            InternalClientConnection tempConn;
            String lowerAuthzID;
            String authzID;
            block48: {
                DN authzDN;
                int nullPos2;
                authzID = null;
                String authcID = null;
                password = null;
                ByteString saslCredentials = bindOperation.getSASLCredentials();
                if (saslCredentials == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message2 = ExtensionMessages.ERR_SASLPLAIN_NO_SASL_CREDENTIALS.get();
                    bindOperation.setAuthFailureReason(message2);
                    return;
                }
                String credString = saslCredentials.toString();
                int length = credString.length();
                int nullPos1 = credString.indexOf(0);
                if (nullPos1 < 0) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message3 = ExtensionMessages.ERR_SASLPLAIN_NO_NULLS_IN_CREDENTIALS.get();
                    bindOperation.setAuthFailureReason(message3);
                    return;
                }
                if (nullPos1 > 0) {
                    authzID = credString.substring(0, nullPos1);
                }
                if ((nullPos2 = credString.indexOf(0, nullPos1 + 1)) < 0) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message4 = ExtensionMessages.ERR_SASLPLAIN_NO_SECOND_NULL.get();
                    bindOperation.setAuthFailureReason(message4);
                    return;
                }
                if (nullPos2 == nullPos1 + 1) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message5 = ExtensionMessages.ERR_SASLPLAIN_ZERO_LENGTH_AUTHCID.get();
                    bindOperation.setAuthFailureReason(message5);
                    return;
                }
                if (nullPos2 == length - 1) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message6 = ExtensionMessages.ERR_SASLPLAIN_ZERO_LENGTH_PASSWORD.get();
                    bindOperation.setAuthFailureReason(message6);
                    return;
                }
                authcID = credString.substring(nullPos1 + 1, nullPos2);
                password = credString.substring(nullPos2 + 1);
                userEntry = null;
                String lowerAuthcID = StaticUtils.toLowerCase(authcID);
                if (lowerAuthcID.startsWith("dn:")) {
                    Lock readLock;
                    DN userDN;
                    try {
                        userDN = DN.decode(authcID.substring(3));
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message7 = ExtensionMessages.ERR_SASLPLAIN_CANNOT_DECODE_AUTHCID_AS_DN.get(authcID, de.getMessageObject());
                        bindOperation.setAuthFailureReason(message7);
                        return;
                    }
                    if (userDN.isNullDN()) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message8 = ExtensionMessages.ERR_SASLPLAIN_AUTHCID_IS_NULL_DN.get();
                        bindOperation.setAuthFailureReason(message8);
                        return;
                    }
                    DN rootDN = DirectoryServer.getActualRootBindDN(userDN);
                    if (rootDN != null) {
                        userDN = rootDN;
                    }
                    if ((readLock = LockManager.lockRead(userDN)) == null) {
                        bindOperation.setResultCode(ResultCode.BUSY);
                        bindOperation.setAuthFailureReason(ExtensionMessages.INFO_SASLPLAIN_CANNOT_LOCK_ENTRY.get(String.valueOf(userDN)));
                        return;
                    }
                    try {
                        userEntry = DirectoryServer.getEntry(userDN);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message9 = ExtensionMessages.ERR_SASLPLAIN_CANNOT_GET_ENTRY_BY_DN.get(String.valueOf(userDN), de.getMessageObject());
                        bindOperation.setAuthFailureReason(message9);
                        return;
                    }
                    finally {
                        LockManager.unlock(userDN, readLock);
                    }
                }
                if (lowerAuthcID.startsWith("u:")) {
                    authcID = authcID.substring(2);
                }
                try {
                    userEntry = this.identityMapper.getEntryForID(authcID);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message10 = ExtensionMessages.ERR_SASLPLAIN_CANNOT_MAP_USERNAME.get(String.valueOf(authcID), de.getMessageObject());
                    bindOperation.setAuthFailureReason(message10);
                    return;
                }
                if (userEntry == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message11 = ExtensionMessages.ERR_SASLPLAIN_NO_MATCHING_ENTRIES.get(authcID);
                    bindOperation.setAuthFailureReason(message11);
                    return;
                }
                bindOperation.setSASLAuthUserEntry(userEntry);
                authZEntry = userEntry;
                if (authzID == null) break block47;
                lowerAuthzID = StaticUtils.toLowerCase(authzID);
                if (!lowerAuthzID.startsWith("dn:")) break block48;
                try {
                    authzDN = DN.decode(authzID.substring(3));
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message12 = ExtensionMessages.ERR_SASLPLAIN_AUTHZID_INVALID_DN.get(authzID, de.getMessageObject());
                    bindOperation.setAuthFailureReason(message12);
                    return;
                }
                DN actualAuthzDN = DirectoryServer.getActualRootBindDN(authzDN);
                if (actualAuthzDN != null) {
                    authzDN = actualAuthzDN;
                }
                if (authzDN.equals(userEntry.getDN())) break block47;
                AuthenticationInfo tempAuthInfo2 = new AuthenticationInfo(userEntry, DirectoryServer.isRootDN(userEntry.getDN()));
                InternalClientConnection tempConn2 = new InternalClientConnection(tempAuthInfo2);
                if (!tempConn2.hasPrivilege(Privilege.PROXIED_AUTH, bindOperation)) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message13 = ExtensionMessages.ERR_SASLPLAIN_AUTHZID_INSUFFICIENT_PRIVILEGES.get(String.valueOf(userEntry.getDN()));
                    bindOperation.setAuthFailureReason(message13);
                    return;
                }
                if (authzDN.isNullDN()) {
                    authZEntry = null;
                    break block47;
                } else {
                    try {
                        authZEntry = DirectoryServer.getEntry(authzDN);
                        if (authZEntry == null) {
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            Message message14 = ExtensionMessages.ERR_SASLPLAIN_AUTHZID_NO_SUCH_ENTRY.get(String.valueOf(authzDN));
                            bindOperation.setAuthFailureReason(message14);
                            return;
                        }
                        break block47;
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message15 = ExtensionMessages.ERR_SASLPLAIN_AUTHZID_CANNOT_GET_ENTRY.get(String.valueOf(authzDN), de.getMessageObject());
                        bindOperation.setAuthFailureReason(message15);
                        return;
                    }
                }
            }
            String idStr = lowerAuthzID.startsWith("u:") ? authzID.substring(2) : authzID;
            if (idStr.length() == 0) {
                authZEntry = null;
            } else {
                try {
                    authZEntry = this.identityMapper.getEntryForID(idStr);
                    if (authZEntry == null) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message16 = ExtensionMessages.ERR_SASLPLAIN_AUTHZID_NO_MAPPED_ENTRY.get(authzID);
                        bindOperation.setAuthFailureReason(message16);
                        return;
                    }
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message17 = ExtensionMessages.ERR_SASLPLAIN_AUTHZID_CANNOT_MAP_AUTHZID.get(authzID, de.getMessageObject());
                    bindOperation.setAuthFailureReason(message17);
                    return;
                }
            }
            if (!(authZEntry != null && authZEntry.getDN().equals(userEntry.getDN()) || (tempConn = new InternalClientConnection(tempAuthInfo = new AuthenticationInfo(userEntry, DirectoryServer.isRootDN(userEntry.getDN())))).hasPrivilege(Privilege.PROXIED_AUTH, bindOperation))) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                Message message18 = ExtensionMessages.ERR_SASLPLAIN_AUTHZID_INSUFFICIENT_PRIVILEGES.get(String.valueOf(userEntry.getDN()));
                bindOperation.setAuthFailureReason(message18);
                return;
            }
        }
        try {
            AuthenticationPolicyState authState = AuthenticationPolicyState.forUser(userEntry, false);
            if (authState.isDisabled()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                message = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_DISABLED.get();
                bindOperation.setAuthFailureReason(message);
                return;
            }
            if (!authState.passwordMatches(ByteString.valueOf(password))) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                message = ExtensionMessages.ERR_SASLPLAIN_INVALID_PASSWORD.get();
                bindOperation.setAuthFailureReason(message);
                return;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            message = ExtensionMessages.ERR_SASLPLAIN_CANNOT_CHECK_PASSWORD_VALIDITY.get(String.valueOf(userEntry.getDN()), String.valueOf(e));
            bindOperation.setAuthFailureReason(message);
            return;
        }
        bindOperation.setResultCode(ResultCode.SUCCESS);
        AuthenticationInfo authInfo = new AuthenticationInfo(userEntry, authZEntry, "PLAIN", bindOperation.getSASLCredentials(), DirectoryServer.isRootDN(userEntry.getDN()));
        bindOperation.setAuthenticationInfo(authInfo);
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return true;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return false;
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        PlainSASLMechanismHandlerCfg config = (PlainSASLMechanismHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PlainSASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PlainSASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        this.currentConfig = configuration;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

