/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ParallelWorkQueueCfg;
import org.opends.server.api.WorkQueue;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ParallelWorkerThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.monitors.ParallelWorkQueueMonitor;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;

public class ParallelWorkQueue
extends WorkQueue<ParallelWorkQueueCfg>
implements ConfigurationChangeListener<ParallelWorkQueueCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int MAX_RETRY_COUNT = 5;
    private ArrayList<ParallelWorkerThread> workerThreads;
    private AtomicLong opsSubmitted;
    private boolean killThreads;
    private boolean shutdownRequested;
    private int lastThreadNumber;
    private int numWorkerThreads;
    private ConcurrentLinkedQueue<Operation> opQueue;
    private final Object queueLock = new Object();
    private final Semaphore queueSemaphore = new Semaphore(0, false);

    @Override
    public void initializeWorkQueue(ParallelWorkQueueCfg configuration) throws ConfigException, InitializationException {
        this.shutdownRequested = false;
        this.killThreads = false;
        this.opsSubmitted = new AtomicLong(0L);
        configuration.addParallelChangeListener(this);
        this.numWorkerThreads = this.computeNumWorkerThreads(configuration.getNumWorkerThreads());
        this.opQueue = new ConcurrentLinkedQueue();
        this.workerThreads = new ArrayList(this.numWorkerThreads);
        this.lastThreadNumber = 0;
        while (this.lastThreadNumber < this.numWorkerThreads) {
            ParallelWorkerThread t = new ParallelWorkerThread(this, this.lastThreadNumber);
            t.start();
            this.workerThreads.add(t);
            ++this.lastThreadNumber;
        }
        try {
            ParallelWorkQueueMonitor monitor = new ParallelWorkQueueMonitor(this);
            monitor.initializeMonitorProvider(null);
            DirectoryServer.registerMonitorProvider(monitor);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_WORK_QUEUE_CANNOT_CREATE_MONITOR.get(String.valueOf(ParallelWorkQueueMonitor.class), String.valueOf(e));
            ErrorLogger.logError(message);
        }
    }

    @Override
    public void finalizeWorkQueue(Message reason) {
        this.shutdownRequested = true;
        CancelRequest cancelRequest = new CancelRequest(true, reason);
        ArrayList pendingOperations = new ArrayList();
        this.opQueue.removeAll(pendingOperations);
        for (Operation o : pendingOperations) {
            try {
                if (o.getCancelResult() != null) continue;
                o.abort(cancelRequest);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(CoreMessages.WARN_QUEUE_UNABLE_TO_CANCEL.get(String.valueOf(o), String.valueOf(e)));
            }
        }
        for (ParallelWorkerThread t : this.workerThreads) {
            try {
                t.shutDown();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(CoreMessages.WARN_QUEUE_UNABLE_TO_NOTIFY_THREAD.get(t.getName(), String.valueOf(e)));
            }
        }
    }

    public boolean shutdownRequested() {
        return this.shutdownRequested;
    }

    @Override
    public void submitOperation(Operation operation) throws DirectoryException {
        if (this.shutdownRequested) {
            Message message = CoreMessages.WARN_OP_REJECTED_BY_SHUTDOWN.get();
            throw new DirectoryException(ResultCode.UNAVAILABLE, message);
        }
        this.opQueue.add(operation);
        this.queueSemaphore.release();
        this.opsSubmitted.incrementAndGet();
    }

    @Override
    public boolean trySubmitOperation(Operation operation) throws DirectoryException {
        this.submitOperation(operation);
        return true;
    }

    public Operation nextOperation(ParallelWorkerThread workerThread) {
        return this.retryNextOperation(workerThread, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Operation retryNextOperation(ParallelWorkerThread workerThread, int numFailures) {
        block24: {
            if (this.killThreads) {
                Object object = this.queueLock;
                synchronized (object) {
                    try {
                        int currentThreads = this.workerThreads.size();
                        if (currentThreads > this.numWorkerThreads) {
                            if (this.workerThreads.remove(Thread.currentThread())) {
                                --currentThreads;
                            }
                            if (currentThreads <= this.numWorkerThreads) {
                                this.killThreads = false;
                            }
                            workerThread.setStoppedByReducedThreadNumber();
                            return null;
                        }
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block24;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        if (this.shutdownRequested || numFailures > 5) {
            if (numFailures > 5) {
                Message message = ConfigMessages.ERR_CONFIG_WORK_QUEUE_TOO_MANY_FAILURES.get(Thread.currentThread().getName(), numFailures, 5);
                ErrorLogger.logError(message);
            }
            return null;
        }
        try {
            while (true) {
                block25: {
                    Operation nextOperation = null;
                    if (this.queueSemaphore.tryAcquire(5L, TimeUnit.SECONDS)) {
                        nextOperation = this.opQueue.poll();
                    }
                    if (nextOperation != null) {
                        return nextOperation;
                    }
                    if (this.shutdownRequested) {
                        return null;
                    }
                    if (!this.killThreads) continue;
                    Object object = this.queueLock;
                    synchronized (object) {
                        try {
                            int currentThreads = this.workerThreads.size();
                            if (currentThreads > this.numWorkerThreads) {
                                if (this.workerThreads.remove(Thread.currentThread())) {
                                    --currentThreads;
                                }
                                if (currentThreads <= this.numWorkerThreads) {
                                    this.killThreads = false;
                                }
                                workerThread.setStoppedByReducedThreadNumber();
                                return null;
                            }
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block25;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(CoreMessages.WARN_WORKER_WAITING_UNCAUGHT_EXCEPTION.get(Thread.currentThread().getName(), String.valueOf(e)));
            return this.retryNextOperation(workerThread, numFailures + 1);
        }
    }

    public boolean removeOperation(Operation operation) {
        return this.opQueue.remove(operation);
    }

    public long getOpsSubmitted() {
        return this.opsSubmitted.longValue();
    }

    public int size() {
        return this.opQueue.size();
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ParallelWorkQueueCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(ParallelWorkQueueCfg configuration) {
        int currentThreads;
        ArrayList<Message> resultMessages = new ArrayList<Message>();
        int newNumThreads = this.computeNumWorkerThreads(configuration.getNumWorkerThreads());
        if (newNumThreads != (currentThreads = this.workerThreads.size())) {
            Object object = this.queueLock;
            synchronized (object) {
                block9: {
                    try {
                        int threadsToAdd = newNumThreads - currentThreads;
                        if (threadsToAdd > 0) {
                            for (int i = 0; i < threadsToAdd; ++i) {
                                ParallelWorkerThread t = new ParallelWorkerThread(this, this.lastThreadNumber++);
                                this.workerThreads.add(t);
                                t.start();
                            }
                            this.killThreads = false;
                        } else {
                            this.killThreads = true;
                        }
                        this.numWorkerThreads = newNumThreads;
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block9;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false, resultMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        if (this.opQueue.size() > 0) {
            return false;
        }
        Object object = this.queueLock;
        synchronized (object) {
            for (ParallelWorkerThread t : this.workerThreads) {
                if (!t.isActive()) continue;
                return false;
            }
            return true;
        }
    }

    @Override
    public int getNumWorkerThreads() {
        return this.numWorkerThreads;
    }
}

