/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.PBKDF2PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

public class PBKDF2PasswordStorageScheme
extends PasswordStorageScheme<PBKDF2PasswordStorageSchemeCfg>
implements ConfigurationChangeListener<PBKDF2PasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.extensions.PBKDF2PasswordStorageScheme";
    private static final int NUM_SALT_BYTES = 8;
    private static final int SHA1_LENGTH = 20;
    private SecretKeyFactory factory;
    private Object factoryLock;
    private SecureRandom random;
    private volatile PBKDF2PasswordStorageSchemeCfg config;

    @Override
    public void initializePasswordStorageScheme(PBKDF2PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
        this.factoryLock = new Object();
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
            this.factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InitializationException(null);
        }
        this.config = configuration;
        this.config.addPBKDF2ChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PBKDF2PasswordStorageSchemeCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PBKDF2PasswordStorageSchemeCfg configuration) {
        this.config = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public String getStorageSchemeName() {
        return "PBKDF2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString encodePassword(ByteSequence plaintext) throws DirectoryException {
        byte[] digestBytes;
        byte[] saltBytes = new byte[8];
        int iterations = this.config.getPBKDF2Iterations();
        Object object = this.factoryLock;
        synchronized (object) {
            try {
                this.random.nextBytes(saltBytes);
                PBEKeySpec spec = new PBEKeySpec(plaintext.toString().toCharArray(), saltBytes, iterations, 160);
                digestBytes = this.factory.generateSecret(spec).getEncoded();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        byte[] hashPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, hashPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, hashPlusSalt, digestBytes.length, 8);
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(iterations));
        sb.append(':');
        sb.append(Base64.encode(hashPlusSalt));
        return ByteString.valueOf(sb.toString());
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteSequence plaintext) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("PBKDF2");
        buffer.append('}');
        buffer.append(this.encodePassword(plaintext));
        return ByteString.valueOf(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean passwordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        byte[] userDigestBytes;
        byte[] saltBytes;
        int iterations;
        byte[] digestBytes = new byte[20];
        int saltLength = 0;
        try {
            int pos;
            String stored = storedPassword.toString();
            int stored_length = stored.length();
            for (pos = 0; pos < stored_length && stored.charAt(pos) != ':'; ++pos) {
            }
            if (pos >= stored_length - 1 || pos == 0) {
                throw new Exception();
            }
            iterations = Integer.parseInt(stored.substring(0, pos));
            byte[] decodedBytes = Base64.decode(stored.substring(pos + 1));
            saltLength = decodedBytes.length - 20;
            if (saltLength <= 0) {
                Message message = ExtensionMessages.ERR_PWSCHEME_INVALID_BASE64_DECODED_STORED_PASSWORD.get(storedPassword.toString());
                ErrorLogger.logError(message);
                return false;
            }
            saltBytes = new byte[saltLength];
            System.arraycopy(decodedBytes, 0, digestBytes, 0, 20);
            System.arraycopy(decodedBytes, 20, saltBytes, 0, saltLength);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_BASE64_DECODE_STORED_PASSWORD.get(storedPassword.toString(), String.valueOf(e));
            ErrorLogger.logError(message);
            return false;
        }
        int plainBytesLength = plaintextPassword.length();
        byte[] plainPlusSalt = new byte[plainBytesLength + saltLength];
        plaintextPassword.copyTo(plainPlusSalt);
        System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytesLength, saltLength);
        Object object = this.factoryLock;
        synchronized (object) {
            try {
                PBEKeySpec spec = new PBEKeySpec(plaintextPassword.toString().toCharArray(), saltBytes, iterations, 160);
                userDigestBytes = this.factory.generateSecret(spec).getEncoded();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return false;
            }
        }
        return Arrays.equals(digestBytes, userDigestBytes);
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return true;
    }

    @Override
    public String getAuthPasswordSchemeName() {
        return "PBKDF2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString encodeAuthPassword(ByteSequence plaintext) throws DirectoryException {
        byte[] digestBytes;
        byte[] saltBytes = new byte[8];
        int iterations = this.config.getPBKDF2Iterations();
        Object object = this.factoryLock;
        synchronized (object) {
            try {
                this.random.nextBytes(saltBytes);
                PBEKeySpec spec = new PBEKeySpec(plaintext.toString().toCharArray(), saltBytes, iterations, 160);
                digestBytes = this.factory.generateSecret(spec).getEncoded();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        StringBuilder authPWValue = new StringBuilder();
        authPWValue.append("PBKDF2");
        authPWValue.append('$');
        authPWValue.append(Integer.toString(iterations));
        authPWValue.append(':');
        authPWValue.append(Base64.encode(saltBytes));
        authPWValue.append('$');
        authPWValue.append(Base64.encode(digestBytes));
        return ByteString.valueOf(authPWValue.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authPasswordMatches(ByteSequence plaintextPassword, String authInfo, String authValue) {
        byte[] userDigestBytes;
        byte[] digestBytes;
        byte[] saltBytes;
        int iterations;
        try {
            int pos;
            int length = authInfo.length();
            for (pos = 0; pos < length && authInfo.charAt(pos) != ':'; ++pos) {
            }
            if (pos >= length - 1 || pos == 0) {
                throw new Exception();
            }
            iterations = Integer.parseInt(authInfo.substring(0, pos));
            saltBytes = Base64.decode(authInfo.substring(pos + 1));
            digestBytes = Base64.decode(authValue);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
        int plainBytesLength = plaintextPassword.length();
        byte[] plainPlusSalt = new byte[plainBytesLength + saltBytes.length];
        plaintextPassword.copyTo(plainPlusSalt);
        System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytesLength, saltBytes.length);
        Object object = this.factoryLock;
        synchronized (object) {
            try {
                PBEKeySpec spec = new PBEKeySpec(plaintextPassword.toString().toCharArray(), saltBytes, iterations, 160);
                userDigestBytes = this.factory.generateSecret(spec).getEncoded();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return false;
            }
        }
        return Arrays.equals(digestBytes, userDigestBytes);
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public ByteString getPlaintextValue(ByteSequence storedPassword) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("PBKDF2");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("PBKDF2");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return true;
    }

    public static String encodeOffline(byte[] passwordBytes) throws DirectoryException {
        byte[] digestBytes;
        byte[] saltBytes = new byte[8];
        int iterations = 10000;
        try {
            SecureRandom.getInstance("SHA1PRNG").nextBytes(saltBytes);
            PBEKeySpec spec = new PBEKeySpec(passwordBytes.toString().toCharArray(), saltBytes, iterations, 160);
            digestBytes = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1").generateSecret(spec).getEncoded();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        byte[] hashPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, hashPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, hashPlusSalt, digestBytes.length, 8);
        return "{PBKDF2}" + iterations + ":" + Base64.encode(hashPlusSalt);
    }
}

