/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.NumSubordinatesVirtualAttributeCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;

public class NumSubordinatesVirtualAttributeProvider
extends VirtualAttributeProvider<NumSubordinatesVirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeVirtualAttributeProvider(NumSubordinatesVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        block3: {
            Backend backend = DirectoryServer.getBackend(entry.getDN());
            try {
                long count = backend.numSubordinates(entry.getDN(), false);
                if (count >= 0L) {
                    AttributeValue value = AttributeValues.create(ByteString.valueOf(String.valueOf(count)), ByteString.valueOf(String.valueOf(count)));
                    return Collections.singleton(value);
                }
            }
            catch (DirectoryException de) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        Backend backend = DirectoryServer.getBackend(entry.getDN());
        try {
            return backend.numSubordinates(entry.getDN(), false) >= 0L;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            return false;
        }
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        Backend backend = DirectoryServer.getBackend(entry.getDN());
        try {
            long count = backend.numSubordinates(entry.getDN(), false);
            if (count >= 0L) {
                return Long.parseLong(value.getNormalizedValue().toString()) == count;
            }
            return false;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            return false;
        }
    }

    @Override
    public ConditionResult matchesSubstring(Entry entry, VirtualAttributeRule rule, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult approximatelyEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation, boolean isPreIndexed) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
        Message message = ExtensionMessages.ERR_NUMSUBORDINATES_VATTR_NOT_SEARCHABLE.get(rule.getAttributeType().getNameOrOID());
        searchOperation.appendErrorMessage(message);
    }
}

