/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.MemberVirtualAttributeCfg;
import org.opends.server.api.Group;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.MemberList;
import org.opends.server.types.MembershipException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;

public class MemberVirtualAttributeProvider
extends VirtualAttributeProvider<MemberVirtualAttributeCfg>
implements ConfigurationChangeListener<MemberVirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private MemberVirtualAttributeCfg currentConfig;

    @Override
    public void initializeVirtualAttributeProvider(MemberVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
        configuration.addMemberChangeListener(this);
        this.currentConfig = configuration;
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        HashSet<AttributeValue> values;
        block7: {
            if (!this.currentConfig.isAllowRetrievingMembership()) {
                return Collections.emptySet();
            }
            Group g = DirectoryServer.getGroupManager().getGroupInstance(entry.getDN());
            if (g == null) {
                return Collections.emptySet();
            }
            values = new HashSet<AttributeValue>();
            try {
                MemberList memberList = g.getMembers();
                while (memberList.hasMoreMembers()) {
                    try {
                        DN memberDN = memberList.nextMemberDN();
                        if (memberDN == null) continue;
                        values.add(AttributeValues.create(rule.getAttributeType(), memberDN.toString()));
                    }
                    catch (MembershipException me) {
                        if (me.continueIterating()) continue;
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block7;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return Collections.unmodifiableSet(values);
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        block6: {
            Group g = DirectoryServer.getGroupManager().getGroupInstance(entry.getDN());
            if (g == null) {
                return false;
            }
            try {
                MemberList memberList = g.getMembers();
                while (memberList.hasMoreMembers()) {
                    try {
                        DN memberDN = memberList.nextMemberDN();
                        if (memberDN == null) continue;
                        memberList.close();
                        return true;
                    }
                    catch (MembershipException me) {
                        if (me.continueIterating()) continue;
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block6;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return false;
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        Group g = DirectoryServer.getGroupManager().getGroupInstance(entry.getDN());
        if (g == null) {
            return false;
        }
        try {
            return g.isMember(DN.decode(value.getValue()));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    @Override
    public boolean hasAnyValue(Entry entry, VirtualAttributeRule rule, Collection<AttributeValue> values) {
        for (AttributeValue v : values) {
            if (!this.hasValue(entry, rule, v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConditionResult matchesSubstring(Entry entry, VirtualAttributeRule rule, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult greaterThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult lessThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult approximatelyEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation, boolean isPreIndexed) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(MemberVirtualAttributeCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(MemberVirtualAttributeCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

