/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.admin.std.server.GetConnectionIdExtendedOperationHandlerCfg;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class GetConnectionIDExtendedOperation
extends ExtendedOperationHandler<GetConnectionIdExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeExtendedOperationHandler(GetConnectionIdExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.26027.1.6.2", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.26027.1.6.2");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        operation.setResponseOID("1.3.6.1.4.1.26027.1.6.2");
        operation.setResponseValue(GetConnectionIDExtendedOperation.encodeResponseValue(operation.getConnectionID()));
        operation.setResultCode(ResultCode.SUCCESS);
    }

    public static ByteString encodeResponseValue(long connectionID) {
        ByteStringBuilder builder;
        block2: {
            builder = new ByteStringBuilder(8);
            ASN1Writer writer = ASN1.getWriter(builder);
            try {
                writer.writeInteger(connectionID);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return builder.toByteString();
    }

    public static long decodeResponseValue(ByteString responseValue) throws ASN1Exception {
        ASN1Reader reader = ASN1.getReader(responseValue);
        try {
            return reader.readInteger();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public String getExtendedOperationName() {
        return "Get Connection ID";
    }
}

