/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CertificateMapperCfg;
import org.opends.server.admin.std.server.FingerprintCertificateMapperCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.CertificateMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

public class FingerprintCertificateMapper
extends CertificateMapper<FingerprintCertificateMapperCfg>
implements ConfigurationChangeListener<FingerprintCertificateMapperCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN configEntryDN;
    private FingerprintCertificateMapperCfg currentConfig;
    private String fingerprintAlgorithm;
    private LinkedHashSet<String> requestedAttributes;

    @Override
    public void initializeCertificateMapper(FingerprintCertificateMapperCfg configuration) throws ConfigException, InitializationException {
        configuration.addFingerprintChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        switch (configuration.getFingerprintAlgorithm()) {
            case MD5: {
                this.fingerprintAlgorithm = "MD5";
                break;
            }
            case SHA1: {
                this.fingerprintAlgorithm = "SHA1";
            }
        }
        Set<DN> cfgBaseDNs = configuration.getUserBaseDN();
        if (cfgBaseDNs == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        AttributeType t = configuration.getFingerprintAttribute();
        for (DN baseDN : cfgBaseDNs) {
            Backend b = DirectoryServer.getBackend(baseDN);
            if (b == null || b.isIndexed(t, IndexType.EQUALITY)) continue;
            Message message = ExtensionMessages.WARN_SATUACM_ATTR_UNINDEXED.get(configuration.dn().toString(), t.getNameOrOID(), b.getBackendID());
            ErrorLogger.logError(message);
        }
        this.requestedAttributes = new LinkedHashSet(2);
        this.requestedAttributes.add("*");
        this.requestedAttributes.add("+");
    }

    @Override
    public void finalizeCertificateMapper() {
        this.currentConfig.removeFingerprintChangeListener(this);
    }

    @Override
    public Entry mapCertificateToUser(Certificate[] certificateChain) throws DirectoryException {
        String fingerprintString;
        X509Certificate peerCertificate;
        FingerprintCertificateMapperCfg config = this.currentConfig;
        AttributeType fingerprintAttributeType = config.getFingerprintAttribute();
        String theFingerprintAlgorithm = this.fingerprintAlgorithm;
        if (certificateChain == null || certificateChain.length == 0) {
            Message message = ExtensionMessages.ERR_FCM_NO_PEER_CERTIFICATE.get();
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
        }
        try {
            peerCertificate = (X509Certificate)certificateChain[0];
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_FCM_PEER_CERT_NOT_X509.get(String.valueOf(certificateChain[0].getType()));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(theFingerprintAlgorithm);
            byte[] fingerprintBytes = digest.digest(peerCertificate.getEncoded());
            fingerprintString = StaticUtils.bytesToColonDelimitedHex(fingerprintBytes);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            String peerSubject = peerCertificate.getSubjectX500Principal().getName("RFC2253");
            Message message = ExtensionMessages.ERR_FCM_CANNOT_CALCULATE_FINGERPRINT.get(peerSubject, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
        }
        AttributeValue value = AttributeValues.create(fingerprintAttributeType, fingerprintString);
        SearchFilter filter = SearchFilter.createEqualityFilter(fingerprintAttributeType, value);
        Set<DN> baseDNs = config.getUserBaseDN();
        if (baseDNs == null || baseDNs.isEmpty()) {
            baseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        SearchResultEntry userEntry = null;
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        for (DN baseDN : baseDNs) {
            InternalSearchOperation searchOperation = conn.processSearch(baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 1, 10, false, filter, this.requestedAttributes);
            switch (searchOperation.getResultCode()) {
                case SUCCESS: {
                    break;
                }
                case NO_SUCH_OBJECT: {
                    break;
                }
                case SIZE_LIMIT_EXCEEDED: {
                    Message message = ExtensionMessages.ERR_FCM_MULTIPLE_SEARCH_MATCHING_ENTRIES.get(fingerprintString);
                    throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
                }
                case TIME_LIMIT_EXCEEDED: 
                case ADMIN_LIMIT_EXCEEDED: {
                    Message message = ExtensionMessages.ERR_FCM_INEFFICIENT_SEARCH.get(fingerprintString, String.valueOf(searchOperation.getErrorMessage()));
                    throw new DirectoryException(searchOperation.getResultCode(), message);
                }
                default: {
                    Message message = ExtensionMessages.ERR_FCM_SEARCH_FAILED.get(fingerprintString, String.valueOf(searchOperation.getErrorMessage()));
                    throw new DirectoryException(searchOperation.getResultCode(), message);
                }
            }
            for (SearchResultEntry entry : searchOperation.getSearchEntries()) {
                if (userEntry == null) {
                    userEntry = entry;
                    continue;
                }
                Message message = ExtensionMessages.ERR_FCM_MULTIPLE_MATCHING_ENTRIES.get(fingerprintString, String.valueOf(userEntry.getDN()), String.valueOf(entry.getDN()));
                throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
            }
        }
        return userEntry;
    }

    @Override
    public boolean isConfigurationAcceptable(CertificateMapperCfg configuration, List<Message> unacceptableReasons) {
        FingerprintCertificateMapperCfg config = (FingerprintCertificateMapperCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FingerprintCertificateMapperCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FingerprintCertificateMapperCfg configuration) {
        Set<DN> cfgBaseDNs;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        String newFingerprintAlgorithm = null;
        switch (configuration.getFingerprintAlgorithm()) {
            case MD5: {
                newFingerprintAlgorithm = "MD5";
                break;
            }
            case SHA1: {
                newFingerprintAlgorithm = "SHA1";
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.fingerprintAlgorithm = newFingerprintAlgorithm;
            this.currentConfig = configuration;
        }
        if ((cfgBaseDNs = configuration.getUserBaseDN()) == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        AttributeType t = configuration.getFingerprintAttribute();
        for (DN baseDN : cfgBaseDNs) {
            Backend b = DirectoryServer.getBackend(baseDN);
            if (b == null || b.isIndexed(t, IndexType.EQUALITY)) continue;
            Message message = ExtensionMessages.WARN_SATUACM_ATTR_UNINDEXED.get(configuration.dn().toString(), t.getNameOrOID(), b.getBackendID());
            messages.add(message);
            ErrorLogger.logError(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

