/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.ConfigMessages;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.admin.std.server.FileSystemEntryCacheCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.EntryCache;
import org.opends.server.backends.jeb.ConfigurableEnvironment;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.EntryCacheCommon;
import org.opends.server.extensions.FileSystemEntryCacheIndex;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.EntryEncodeConfig;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class FileSystemEntryCache
extends EntryCache<FileSystemEntryCacheCfg>
implements ConfigurationChangeListener<FileSystemEntryCacheCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final FilePermission CACHE_HOME_PERMISSIONS = new FilePermission(448);
    private long maxAllowedMemory;
    private AtomicLong maxEntries;
    private String cacheHome;
    private String cacheType;
    private boolean persistentCache;
    private ReentrantReadWriteLock cacheLock;
    private Lock cacheReadLock;
    private Lock cacheWriteLock;
    FileSystemEntryCacheIndex entryCacheIndex;
    boolean accessOrder = false;
    private Environment entryCacheEnv;
    private EnvironmentConfig entryCacheEnvConfig;
    private EnvironmentMutableConfig entryCacheEnvMutableConfig;
    private DatabaseConfig entryCacheDBConfig;
    private StatsConfig entryCacheEnvStatsConfig = new StatsConfig();
    private Database entryCacheDB;
    private Database entryCacheClassDB;
    private StoredClassCatalog classCatalog;
    private EntryBinding<FileSystemEntryCacheIndex> entryCacheDataBinding;
    private static final String ENTRYCACHEDBNAME = "EntryCacheDB";
    private static final String INDEXCLASSDBNAME = "IndexClassDB";
    private static final String INDEXKEY = "EntryCacheIndex";
    private EntryEncodeConfig encodeConfig = new EntryEncodeConfig(true, true, true);
    private HashMap<String, String> configAttrMap = new HashMap();
    private FileSystemEntryCacheCfg registeredConfiguration;
    private long lockTimeout = 9000L;

    public FileSystemEntryCache() {
        this.configAttrMap.put("je.maxMemoryPercent", "ds-cfg-db-cache-percent");
        this.configAttrMap.put("je.maxMemory", "ds-cfg-db-cache-size");
    }

    @Override
    public void initializeEntryCache(FileSystemEntryCacheCfg configuration) throws ConfigException, InitializationException {
        this.registeredConfiguration = configuration;
        configuration.addFileSystemChangeListener(this);
        boolean applyChanges = true;
        ArrayList<Message> errorMessages = new ArrayList<Message>();
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_INIT, null, errorMessages);
        if (!this.processEntryCacheConfig(configuration, applyChanges, errorHandler)) {
            MessageBuilder buffer = new MessageBuilder();
            if (!errorMessages.isEmpty()) {
                Iterator<Message> iterator = errorMessages.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append(".  ");
                    buffer.append(iterator.next());
                }
            }
            Message message = ExtensionMessages.ERR_FSCACHE_CANNOT_INITIALIZE.get(buffer.toString());
            throw new ConfigException(message);
        }
        if (this.cacheType.equalsIgnoreCase("LRU")) {
            this.accessOrder = true;
        } else {
            this.cacheType = "FIFO";
            this.accessOrder = false;
        }
        this.entryCacheIndex = new FileSystemEntryCacheIndex(this, this.accessOrder);
        this.cacheLock = new ReentrantReadWriteLock(true);
        this.cacheReadLock = this.accessOrder ? this.cacheLock.writeLock() : this.cacheLock.readLock();
        this.cacheWriteLock = this.cacheLock.writeLock();
        try {
            this.checkAndSetupCacheHome(this.cacheHome);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_FSCACHE_HOMELESS.get();
            throw new InitializationException(message, (Throwable)e);
        }
        try {
            this.entryCacheEnvConfig.setAllowCreate(true);
            this.entryCacheEnv = new Environment(new File(this.cacheHome), this.entryCacheEnvConfig);
            this.entryCacheEnv.setMutableConfig(this.entryCacheEnvMutableConfig);
            this.entryCacheDBConfig = new DatabaseConfig();
            this.entryCacheDBConfig.setAllowCreate(true);
            this.entryCacheEnvStatsConfig.setFast(true);
            if (!this.persistentCache) {
                try {
                    this.entryCacheEnv.removeDatabase(null, INDEXCLASSDBNAME);
                }
                catch (DatabaseNotFoundException e) {
                    // empty catch block
                }
                try {
                    this.entryCacheEnv.removeDatabase(null, ENTRYCACHEDBNAME);
                }
                catch (DatabaseNotFoundException e) {
                    // empty catch block
                }
            }
            this.entryCacheDB = this.entryCacheEnv.openDatabase(null, ENTRYCACHEDBNAME, this.entryCacheDBConfig);
            this.entryCacheClassDB = this.entryCacheEnv.openDatabase(null, INDEXCLASSDBNAME, this.entryCacheDBConfig);
            this.classCatalog = new StoredClassCatalog(this.entryCacheClassDB);
            this.entryCacheDataBinding = new SerialBinding((ClassCatalog)this.classCatalog, FileSystemEntryCacheIndex.class);
            ServerManagementContext managementContext = ServerManagementContext.getInstance();
            RootCfg rootConfiguration = managementContext.getRootConfiguration();
            if (this.persistentCache && !rootConfiguration.getGlobalConfiguration().isEntryCachePreload()) {
                try {
                    DatabaseEntry indexData = new DatabaseEntry();
                    DatabaseEntry indexKey = new DatabaseEntry(INDEXKEY.getBytes("UTF-8"));
                    Message message = ExtensionMessages.NOTE_FSCACHE_RESTORE.get();
                    ErrorLogger.logError(message);
                    if (OperationStatus.SUCCESS != this.entryCacheDB.get(null, indexKey, indexData, LockMode.DEFAULT)) {
                        throw new CacheIndexNotFoundException();
                    }
                    this.entryCacheIndex = (FileSystemEntryCacheIndex)this.entryCacheDataBinding.entryToObject(indexData);
                    if (this.entryCacheIndex.dnMap.isEmpty() || this.entryCacheIndex.backendMap.isEmpty() || this.entryCacheIndex.offlineState.isEmpty()) {
                        throw new CacheIndexImpairedException();
                    }
                    AtomicLong currentMaxEntries = this.maxEntries;
                    this.maxEntries.set(Long.MAX_VALUE);
                    Map<String, Long> currentBackendsState = DirectoryServer.getOfflineBackendsStateIDs();
                    Set<String> offlineBackendSet = this.entryCacheIndex.offlineState.keySet();
                    for (String backend : offlineBackendSet) {
                        Long currentId;
                        Long offlineId = this.entryCacheIndex.offlineState.get(backend);
                        if (offlineId.equals(currentId = currentBackendsState.get(backend))) continue;
                        this.clearBackend(DirectoryServer.getBackend(backend));
                        ErrorLogger.logError(ExtensionMessages.WARN_FSCACHE_OFFLINE_STATE_FAIL.get(backend));
                    }
                    this.maxEntries = currentMaxEntries;
                    message = ExtensionMessages.NOTE_FSCACHE_RESTORE_REPORT.get(this.entryCacheIndex.dnMap.size());
                    ErrorLogger.logError(message);
                }
                catch (CacheIndexNotFoundException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(ExtensionMessages.NOTE_FSCACHE_INDEX_NOT_FOUND.get());
                    this.clear();
                }
                catch (CacheIndexImpairedException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_INDEX_IMPAIRED.get());
                    this.clear();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_CANNOT_LOAD_PERSISTENT_DATA.get());
                    this.clear();
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_FSCACHE_CANNOT_INITIALIZE.get(e.getCause() != null ? e.getCause().getMessage() : StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeEntryCache() {
        block18: {
            this.cacheWriteLock.lock();
            try {
                this.registeredConfiguration.removeFileSystemChangeListener(this);
                if (this.persistentCache && !this.entryCacheIndex.dnMap.isEmpty()) {
                    this.entryCacheIndex.offlineState = DirectoryServer.getOfflineBackendsStateIDs();
                    try {
                        DatabaseEntry indexData = new DatabaseEntry();
                        Message message = ExtensionMessages.NOTE_FSCACHE_SAVE.get();
                        ErrorLogger.logError(message);
                        this.entryCacheDataBinding.objectToEntry((Object)this.entryCacheIndex, indexData);
                        DatabaseEntry indexKey = new DatabaseEntry(INDEXKEY.getBytes("UTF-8"));
                        if (OperationStatus.SUCCESS != this.entryCacheDB.put(null, indexKey, indexData)) {
                            throw new Exception();
                        }
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_CANNOT_STORE_PERSISTENT_DATA.get());
                    }
                    Message message = ExtensionMessages.NOTE_FSCACHE_SAVE_REPORT.get(this.entryCacheIndex.dnMap.size());
                    ErrorLogger.logError(message);
                }
                try {
                    this.entryCacheIndex.backendMap.clear();
                    this.entryCacheIndex.dnMap.clear();
                    if (this.entryCacheDB != null) {
                        this.entryCacheDB.close();
                    }
                    if (this.entryCacheClassDB != null) {
                        this.entryCacheClassDB.close();
                    }
                    if (this.entryCacheEnv == null) break block18;
                    if (!this.persistentCache) {
                        try {
                            this.entryCacheEnv.removeDatabase(null, INDEXCLASSDBNAME);
                        }
                        catch (DatabaseNotFoundException e) {
                            // empty catch block
                        }
                        try {
                            this.entryCacheEnv.removeDatabase(null, ENTRYCACHEDBNAME);
                        }
                        catch (DatabaseNotFoundException e) {
                            // empty catch block
                        }
                    }
                    this.entryCacheEnv.cleanLog();
                    this.entryCacheEnv.close();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsEntry(DN entryDN) {
        if (entryDN == null) {
            return false;
        }
        boolean containsEntry = false;
        this.cacheReadLock.lock();
        try {
            containsEntry = this.entryCacheIndex.dnMap.containsKey(entryDN.toNormalizedString());
        }
        finally {
            this.cacheReadLock.unlock();
        }
        return containsEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(DN entryDN) {
        Entry entry = null;
        this.cacheReadLock.lock();
        try {
            if (this.entryCacheIndex.dnMap.get(entryDN.toNormalizedString()) != null) {
                entry = this.getEntryFromDB(entryDN);
                this.cacheHits.getAndIncrement();
            } else {
                this.cacheMisses.getAndIncrement();
            }
        }
        finally {
            this.cacheReadLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEntryID(DN entryDN) {
        long entryID = -1L;
        this.cacheReadLock.lock();
        try {
            Long eid = this.entryCacheIndex.dnMap.get(entryDN.toNormalizedString());
            if (eid != null) {
                entryID = eid;
            }
        }
        finally {
            this.cacheReadLock.unlock();
        }
        return entryID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DN getEntryDN(Backend backend, long entryID) {
        DN entryDN = null;
        this.cacheReadLock.lock();
        try {
            Map<Long, String> map = this.entryCacheIndex.backendMap.get(backend.getBackendID());
            if (map != null) {
                entryDN = DN.decode(map.get(entryID));
            }
        }
        catch (Exception e) {
        }
        finally {
            this.cacheReadLock.unlock();
        }
        return entryDN;
    }

    @Override
    public void putEntry(Entry entry, Backend backend, long entryID) {
        block2: {
            try {
                ByteStringBuilder buffer = new ByteStringBuilder();
                entry.encode(buffer, this.encodeConfig);
                this.putEntryToDB(entry.getDN().toNormalizedString(), backend, entryID, buffer);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putEntryIfAbsent(Entry entry, Backend backend, long entryID) {
        this.cacheReadLock.lock();
        try {
            if (this.entryCacheIndex.dnMap.containsKey(entry.getDN().toNormalizedString())) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.cacheReadLock.unlock();
        }
        try {
            ByteStringBuilder buffer = new ByteStringBuilder();
            entry.encode(buffer, this.encodeConfig);
            return this.putEntryToDB(entry.getDN().toNormalizedString(), backend, entryID, buffer);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(DN entryDN) {
        this.cacheWriteLock.lock();
        try {
            Long entryID = this.entryCacheIndex.dnMap.get(entryDN.toNormalizedString());
            if (entryID == null) {
                return;
            }
            Set<String> backendSet = this.entryCacheIndex.backendMap.keySet();
            Iterator<String> backendIterator = backendSet.iterator();
            while (backendIterator.hasNext()) {
                Map<Long, String> map = this.entryCacheIndex.backendMap.get(backendIterator.next());
                if (map.get(entryID) == null || !map.get(entryID).equals(entryDN.toNormalizedString())) continue;
                map.remove(entryID);
                if (!map.isEmpty()) break;
                backendIterator.remove();
                break;
            }
            this.entryCacheIndex.dnMap.remove(entryDN.toNormalizedString());
            this.entryCacheDB.delete(null, new DatabaseEntry(entryDN.toNormalizedString().getBytes("UTF-8")));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.cacheWriteLock.lock();
        try {
            this.entryCacheIndex.dnMap.clear();
            this.entryCacheIndex.backendMap.clear();
            try {
                if (this.entryCacheDB != null && this.entryCacheEnv != null && this.entryCacheClassDB != null && this.entryCacheDBConfig != null) {
                    this.entryCacheDBConfig = this.entryCacheDB.getConfig();
                    this.entryCacheDB.close();
                    this.entryCacheClassDB.close();
                    this.entryCacheEnv.truncateDatabase(null, ENTRYCACHEDBNAME, false);
                    this.entryCacheEnv.truncateDatabase(null, INDEXCLASSDBNAME, false);
                    this.entryCacheEnv.cleanLog();
                    this.entryCacheDB = this.entryCacheEnv.openDatabase(null, ENTRYCACHEDBNAME, this.entryCacheDBConfig);
                    this.entryCacheClassDB = this.entryCacheEnv.openDatabase(null, INDEXCLASSDBNAME, this.entryCacheDBConfig);
                    this.classCatalog = new StoredClassCatalog(this.entryCacheClassDB);
                    this.entryCacheDataBinding = new SerialBinding((ClassCatalog)this.classCatalog, FileSystemEntryCacheIndex.class);
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBackend(Backend backend) {
        this.cacheWriteLock.lock();
        try {
            Map<Long, String> backendEntriesMap;
            block9: {
                backendEntriesMap = this.entryCacheIndex.backendMap.get(backend.getBackendID());
                if (backendEntriesMap != null) break block9;
                return;
            }
            try {
                int entriesExamined = 0;
                Iterator<Long> backendEntriesIterator = backendEntriesMap.keySet().iterator();
                while (backendEntriesIterator.hasNext()) {
                    Long entryID = backendEntriesIterator.next();
                    DN entryDN = DN.decode(backendEntriesMap.get(entryID));
                    this.entryCacheDB.delete(null, new DatabaseEntry(entryDN.toNormalizedString().getBytes("UTF-8")));
                    backendEntriesIterator.remove();
                    this.entryCacheIndex.dnMap.remove(entryDN.toNormalizedString());
                    if (++entriesExamined % 1000 != 0) continue;
                    this.cacheWriteLock.unlock();
                    Thread.yield();
                    this.cacheWriteLock.lock();
                }
                this.entryCacheIndex.backendMap.remove(backend.getBackendID());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSubtree(DN baseDN) {
        Backend backend = DirectoryServer.getBackend(baseDN);
        if (backend == null) {
            return;
        }
        this.cacheWriteLock.lock();
        try {
            this.clearSubtree(baseDN, backend);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    private void clearSubtree(DN baseDN, Backend backend) {
        Map<Long, String> map = this.entryCacheIndex.backendMap.get(backend.getBackendID());
        if (map == null) {
            return;
        }
        int entriesExamined = 0;
        Iterator<String> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            try {
                block10: {
                    DN entryDN = DN.decode(iterator.next());
                    if (entryDN.isDescendantOf(baseDN)) {
                        iterator.remove();
                        this.entryCacheIndex.dnMap.remove(entryDN.toNormalizedString());
                        try {
                            this.entryCacheDB.delete(null, new DatabaseEntry(entryDN.toNormalizedString().getBytes("UTF-8")));
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block10;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
                if (++entriesExamined % 1000 != 0) continue;
                this.cacheWriteLock.unlock();
                Thread.yield();
                this.cacheWriteLock.lock();
            }
            catch (Exception e) {}
        }
        if (map.isEmpty()) {
            this.entryCacheIndex.backendMap.remove(backend.getBackendID());
        }
        for (Backend subBackend : backend.getSubordinateBackends()) {
            boolean isAppropriate = false;
            for (DN subBase : subBackend.getBaseDNs()) {
                if (!subBase.isDescendantOf(baseDN)) continue;
                isAppropriate = true;
                break;
            }
            if (!isAppropriate) continue;
            this.clearSubtree(baseDN, subBackend);
        }
    }

    @Override
    public void handleLowMemory() {
        block3: {
            if (this.entryCacheEnv != null) {
                try {
                    this.entryCacheEnv.evictMemory();
                    this.entryCacheEnv.cleanLog();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    @Override
    public boolean isConfigurationAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        FileSystemEntryCacheCfg config = (FileSystemEntryCacheCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileSystemEntryCacheCfg configuration, List<Message> unacceptableReasons) {
        boolean applyChanges = false;
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_ACCEPTABLE, unacceptableReasons, null);
        this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        return errorHandler.getIsAcceptable();
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileSystemEntryCacheCfg configuration) {
        boolean applyChanges = true;
        ArrayList<Message> errorMessages = new ArrayList<Message>();
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_APPLY, null, errorMessages);
        if (configuration.isEnabled()) {
            this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        }
        boolean adminActionRequired = errorHandler.getIsAdminActionRequired();
        ConfigChangeResult changeResult = new ConfigChangeResult(errorHandler.getResultCode(), adminActionRequired, errorHandler.getErrorMessages());
        return changeResult;
    }

    public boolean processEntryCacheConfig(FileSystemEntryCacheCfg configuration, boolean applyChanges, EntryCacheCommon.ConfigErrorHandler errorHandler) {
        HashSet<SearchFilter> newIncludeFilters = null;
        HashSet<SearchFilter> newExcludeFilters = null;
        String newCacheType = "FIFO";
        String newCacheHome = "/tmp/OpenDS.FSCache";
        EnvironmentMutableConfig newMutableEnvConfig = new EnvironmentMutableConfig();
        EnvironmentConfig newEnvConfig = new EnvironmentConfig();
        DN newConfigEntryDN = configuration.dn();
        long newLockTimeout = configuration.getLockTimeout();
        long newMaxEntries = configuration.getMaxEntries();
        if (newMaxEntries <= 0L) {
            newMaxEntries = Long.MAX_VALUE;
        }
        long newMaxAllowedMemory = configuration.getMaxMemorySize();
        int newJECachePercent = configuration.getDBCachePercent();
        long newJECacheSize = configuration.getDBCacheSize();
        boolean newPersistentCache = configuration.isPersistentCache();
        boolean newCompactEncoding = configuration.isCompactEncoding();
        SortedSet<String> newJEProperties = configuration.getJEProperty();
        switch (errorHandler.getConfigPhase()) {
            case PHASE_INIT: {
                newCacheType = configuration.getCacheType().toString();
                newCacheHome = configuration.getCacheDirectory();
                newIncludeFilters = EntryCacheCommon.getFilters(configuration.getIncludeFilter(), ExtensionMessages.ERR_CACHE_INVALID_INCLUDE_FILTER, errorHandler, newConfigEntryDN);
                newExcludeFilters = EntryCacheCommon.getFilters(configuration.getExcludeFilter(), ExtensionMessages.ERR_CACHE_INVALID_EXCLUDE_FILTER, errorHandler, newConfigEntryDN);
                try {
                    newMutableEnvConfig.setCachePercent(newJECachePercent != 0 ? newJECachePercent : EnvironmentConfig.DEFAULT.getCachePercent());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    errorHandler.reportError(ExtensionMessages.ERR_FSCACHE_CANNOT_SET_JE_MEMORY_PCT.get(), false, DirectoryServer.getServerErrorResultCode());
                }
                try {
                    newMutableEnvConfig.setCacheSize(newJECacheSize);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    errorHandler.reportError(ExtensionMessages.ERR_FSCACHE_CANNOT_SET_JE_MEMORY_SIZE.get(), false, DirectoryServer.getServerErrorResultCode());
                }
                try {
                    newEnvConfig = ConfigurableEnvironment.setJEProperties(newEnvConfig, newJEProperties, this.configAttrMap);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    errorHandler.reportError(ExtensionMessages.ERR_FSCACHE_CANNOT_SET_JE_PROPERTIES.get(e.getMessage()), false, DirectoryServer.getServerErrorResultCode());
                }
                break;
            }
            case PHASE_ACCEPTABLE: 
            case PHASE_APPLY: {
                newIncludeFilters = EntryCacheCommon.getFilters(configuration.getIncludeFilter(), ExtensionMessages.ERR_CACHE_INVALID_INCLUDE_FILTER, errorHandler, newConfigEntryDN);
                newExcludeFilters = EntryCacheCommon.getFilters(configuration.getExcludeFilter(), ExtensionMessages.ERR_CACHE_INVALID_EXCLUDE_FILTER, errorHandler, newConfigEntryDN);
                try {
                    Map paramsMap = EnvironmentParams.SUPPORTED_PARAMS;
                    if (configuration.isEnabled()) {
                        newMutableEnvConfig = ConfigurableEnvironment.setJEProperties(this.entryCacheEnv.getConfig(), newJEProperties, this.configAttrMap);
                        EnvironmentConfig oldEnvConfig = this.entryCacheEnv.getConfig();
                        for (String jeEntry : newJEProperties) {
                            String newValue;
                            String oldValue;
                            StringTokenizer st = new StringTokenizer(jeEntry, "=");
                            if (st.countTokens() != 2) continue;
                            String jePropertyName = st.nextToken();
                            String jePropertyValue = st.nextToken();
                            ConfigParam param = (ConfigParam)paramsMap.get(jePropertyName);
                            if (param.isMutable() || (oldValue = oldEnvConfig.getConfigParam(param.getName())).equalsIgnoreCase(newValue = jePropertyValue)) continue;
                            Message message = ConfigMessages.INFO_CONFIG_JE_PROPERTY_REQUIRES_RESTART.get(jePropertyName);
                            errorHandler.reportError(message, true, ResultCode.SUCCESS, true);
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugInfo("The change to the following property will take effect when the component is restarted: " + jePropertyName);
                        }
                        break;
                    }
                    newMutableEnvConfig = ConfigurableEnvironment.setJEProperties(new EnvironmentConfig(), newJEProperties, this.configAttrMap);
                    break;
                }
                catch (ConfigException ce) {
                    errorHandler.reportError(ce.getMessageObject(), false, DirectoryServer.getServerErrorResultCode());
                    break;
                }
                catch (Exception e) {
                    errorHandler.reportError(Message.raw(StaticUtils.stackTraceToSingleLineString(e), new Object[0]), false, DirectoryServer.getServerErrorResultCode());
                }
            }
        }
        if (applyChanges && errorHandler.getIsAcceptable()) {
            switch (errorHandler.getConfigPhase()) {
                case PHASE_INIT: {
                    this.cacheType = newCacheType;
                    this.cacheHome = newCacheHome;
                    this.entryCacheEnvConfig = newEnvConfig;
                    this.entryCacheEnvMutableConfig = newMutableEnvConfig;
                    break;
                }
                case PHASE_APPLY: {
                    try {
                        newMutableEnvConfig = this.entryCacheEnv.getMutableConfig();
                        newMutableEnvConfig.setCachePercent(newJECachePercent != 0 ? newJECachePercent : EnvironmentConfig.DEFAULT.getCachePercent());
                        this.entryCacheEnv.setMutableConfig(newMutableEnvConfig);
                        this.entryCacheEnv.evictMemory();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        errorHandler.reportError(ExtensionMessages.ERR_FSCACHE_CANNOT_SET_JE_MEMORY_PCT.get(), false, DirectoryServer.getServerErrorResultCode());
                    }
                    try {
                        newMutableEnvConfig = this.entryCacheEnv.getMutableConfig();
                        newMutableEnvConfig.setCacheSize(newJECacheSize);
                        this.entryCacheEnv.setMutableConfig(newMutableEnvConfig);
                        this.entryCacheEnv.evictMemory();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        errorHandler.reportError(ExtensionMessages.ERR_FSCACHE_CANNOT_SET_JE_MEMORY_SIZE.get(), false, DirectoryServer.getServerErrorResultCode());
                    }
                    try {
                        EnvironmentConfig oldEnvConfig = this.entryCacheEnv.getConfig();
                        newEnvConfig = ConfigurableEnvironment.setJEProperties(oldEnvConfig, newJEProperties, this.configAttrMap);
                        this.entryCacheEnv.setMutableConfig((EnvironmentMutableConfig)newEnvConfig);
                        break;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        errorHandler.reportError(ExtensionMessages.ERR_FSCACHE_CANNOT_SET_JE_PROPERTIES.get(e.getMessage()), false, DirectoryServer.getServerErrorResultCode());
                    }
                }
            }
            this.maxEntries = new AtomicLong(newMaxEntries);
            this.maxAllowedMemory = newMaxAllowedMemory;
            this.persistentCache = newPersistentCache;
            this.encodeConfig = new EntryEncodeConfig(true, newCompactEncoding, newCompactEncoding);
            this.lockTimeout = newLockTimeout;
            this.setIncludeFilters(newIncludeFilters);
            this.setExcludeFilters(newExcludeFilters);
            this.registeredConfiguration = configuration;
        }
        return errorHandler.getIsAcceptable();
    }

    @Override
    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attrs;
        block2: {
            attrs = new ArrayList<Attribute>();
            try {
                attrs = EntryCacheCommon.getGenericMonitorData(new Long(this.cacheHits.longValue()), DirectoryServer.getEntryCache().getCacheMisses(), new Long(this.entryCacheEnv.getStats(this.entryCacheEnvStatsConfig).getTotalLogSize()), new Long(this.maxAllowedMemory), new Long(this.entryCacheIndex.dnMap.size()), this.maxEntries.longValue() != Integer.MAX_VALUE && this.maxEntries.longValue() != Long.MAX_VALUE ? new Long(this.maxEntries.longValue()) : new Long(0L));
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return attrs;
    }

    @Override
    public Long getCacheCount() {
        return new Long(this.entryCacheIndex.dnMap.size());
    }

    private Entry getEntryFromDB(DN entryDN) {
        DatabaseEntry cacheEntryKey = new DatabaseEntry();
        DatabaseEntry primaryData = new DatabaseEntry();
        try {
            cacheEntryKey.setData(entryDN.toNormalizedString().getBytes("UTF-8"));
            if (this.entryCacheDB.get(null, cacheEntryKey, primaryData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                Entry entry = Entry.decode(ByteString.wrap(primaryData.getData()).asReader());
                entry.setDN(entryDN);
                return entry;
            }
            throw new Exception();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_CANNOT_RETRIEVE_ENTRY.get());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putEntryToDB(String dnString, Backend backend, long entryID, ByteStringBuilder entryBytes) {
        try {
            long usedMemory;
            if (!this.cacheWriteLock.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS)) {
                boolean bl = false;
                return bl;
            }
            if (this.maxAllowedMemory != 0L && (usedMemory = this.entryCacheEnv.getStats(this.entryCacheEnvStatsConfig).getTotalLogSize()) > this.maxAllowedMemory) {
                long savedMaxEntries = this.maxEntries.longValue();
                this.maxEntries.set(this.entryCacheIndex.dnMap.isEmpty() ? 0 : this.entryCacheIndex.dnMap.size() - 1);
                this.entryCacheIndex.dnMap.put(dnString, entryID);
                this.entryCacheIndex.dnMap.remove(dnString);
                this.maxEntries.set(savedMaxEntries);
                boolean bl = true;
                return bl;
            }
            DatabaseEntry cacheEntryKey = new DatabaseEntry();
            cacheEntryKey.setData(dnString.getBytes("UTF-8"));
            if (this.entryCacheDB.put(null, cacheEntryKey, new DatabaseEntry(entryBytes.getBackingArray(), 0, entryBytes.length())) == OperationStatus.SUCCESS) {
                Map<Long, String> map = this.entryCacheIndex.backendMap.get(backend.getBackendID());
                if (map == null) {
                    map = new HashMap<Long, String>();
                    map.put(entryID, dnString);
                    this.entryCacheIndex.backendMap.put(backend.getBackendID(), map);
                } else {
                    map.put(entryID, dnString);
                }
                this.entryCacheIndex.dnMap.put(dnString, entryID);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_CANNOT_STORE_ENTRY.get());
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.cacheLock.isWriteLockedByCurrentThread()) {
                this.cacheWriteLock.unlock();
            }
        }
    }

    private void checkAndSetupCacheHome(String cacheHome) throws Exception {
        boolean cacheHasHome;
        File cacheHomeDir = new File(cacheHome);
        if (cacheHomeDir.exists() && cacheHomeDir.canRead() && cacheHomeDir.canWrite()) {
            cacheHasHome = true;
        } else {
            try {
                cacheHasHome = cacheHomeDir.mkdirs();
            }
            catch (SecurityException e) {
                cacheHasHome = false;
            }
        }
        if (cacheHasHome) {
            if (FilePermission.canSetPermissions()) {
                try {
                    if (!FilePermission.setPermissions(cacheHomeDir, CACHE_HOME_PERMISSIONS)) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    Message message = ExtensionMessages.WARN_FSCACHE_SET_PERMISSIONS_FAILED.get(cacheHome);
                    ErrorLogger.logError(message);
                }
            }
        } else {
            throw new Exception();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toVerboseString() {
        HashMap<String, Map<Long, String>> backendMapCopy;
        LinkedHashMap<String, Long> dnMapCopy;
        StringBuilder sb = new StringBuilder();
        this.cacheWriteLock.lock();
        try {
            dnMapCopy = new LinkedHashMap<String, Long>(this.entryCacheIndex.dnMap);
            backendMapCopy = new HashMap<String, Map<Long, String>>(this.entryCacheIndex.backendMap);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
        for (String dn : dnMapCopy.keySet()) {
            Map map;
            sb.append(dn.toString());
            sb.append(":");
            sb.append(dnMapCopy.get(dn) != null ? ((Long)dnMapCopy.get(dn)).toString() : null);
            sb.append(":");
            String backendID = null;
            Iterator backendIterator = backendMapCopy.keySet().iterator();
            while (backendIterator.hasNext() && ((map = (Map)backendMapCopy.get(backendID = (String)backendIterator.next())) == null || map.get(dnMapCopy.get(dn)) == null || !((String)map.get(dnMapCopy.get(dn))).equals(dn))) {
            }
            sb.append(backendID);
            sb.append(ServerConstants.EOL);
        }
        for (String backendID : backendMapCopy.keySet()) {
            Map map = (Map)backendMapCopy.get(backendID);
            for (Long id : map.keySet()) {
                if (dnMapCopy.containsKey(map.get(id)) && map.get(id) != null) continue;
                sb.append(map.get(id) != null ? (String)map.get(id) : null);
                sb.append(":");
                sb.append(id.toString());
                sb.append(":");
                sb.append(backendID);
                sb.append(ServerConstants.EOL);
            }
        }
        String verboseString = sb.toString();
        return verboseString.length() > 0 ? verboseString : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeEldestEntry(Map.Entry<String, Long> eldest) {
        if ((long)this.entryCacheIndex.dnMap.size() > this.maxEntries.longValue()) {
            DatabaseEntry cacheEntryKey = new DatabaseEntry();
            this.cacheWriteLock.lock();
            try {
                String entryStringDN = eldest.getKey();
                long entryID = eldest.getValue();
                cacheEntryKey.setData(entryStringDN.getBytes("UTF-8"));
                Set<String> backendSet = this.entryCacheIndex.backendMap.keySet();
                Iterator<String> backendIterator = backendSet.iterator();
                while (backendIterator.hasNext()) {
                    Map<Long, String> map = this.entryCacheIndex.backendMap.get(backendIterator.next());
                    if (map.get(entryID) == null || !map.get(entryID).equals(entryStringDN)) continue;
                    map.remove(entryID);
                    if (!map.isEmpty()) break;
                    backendIterator.remove();
                    break;
                }
                this.entryCacheDB.delete(null, cacheEntryKey);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            finally {
                this.cacheWriteLock.unlock();
            }
            return true;
        }
        return false;
    }

    private class CacheIndexImpairedException
    extends OpenDsException {
        static final long serialVersionUID = -369455697709478407L;
    }

    private class CacheIndexNotFoundException
    extends OpenDsException {
        static final long serialVersionUID = 6444756053577853869L;
    }
}

