/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ExternalSASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.CertificateMapper;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.CertificateValidationPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.ldap.LDAPClientConnection;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class ExternalSASLMechanismHandler
extends SASLMechanismHandler<ExternalSASLMechanismHandlerCfg>
implements ConfigurationChangeListener<ExternalSASLMechanismHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType certificateAttributeType;
    private CertificateValidationPolicy validationPolicy;
    private ExternalSASLMechanismHandlerCfg currentConfig;

    @Override
    public void initializeSASLMechanismHandler(ExternalSASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        configuration.addExternalChangeListener(this);
        this.currentConfig = configuration;
        switch (configuration.getCertificateValidationPolicy()) {
            case NEVER: {
                this.validationPolicy = CertificateValidationPolicy.NEVER;
                break;
            }
            case IFPRESENT: {
                this.validationPolicy = CertificateValidationPolicy.IFPRESENT;
                break;
            }
            case ALWAYS: {
                this.validationPolicy = CertificateValidationPolicy.ALWAYS;
            }
        }
        this.certificateAttributeType = configuration.getCertificateAttribute();
        if (this.certificateAttributeType == null) {
            this.certificateAttributeType = DirectoryServer.getAttributeType("usercertificate", true);
        }
        DirectoryServer.registerSASLMechanismHandler("EXTERNAL", this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        this.currentConfig.removeExternalChangeListener(this);
        DirectoryServer.deregisterSASLMechanismHandler("EXTERNAL");
    }

    @Override
    public void processSASLBind(BindOperation bindOperation) {
        Entry userEntry;
        ExternalSASLMechanismHandlerCfg config = this.currentConfig;
        AttributeType certificateAttributeType = this.certificateAttributeType;
        CertificateValidationPolicy validationPolicy = this.validationPolicy;
        ClientConnection clientConnection = bindOperation.getClientConnection();
        if (clientConnection == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message = ExtensionMessages.ERR_SASLEXTERNAL_NO_CLIENT_CONNECTION.get();
            bindOperation.setAuthFailureReason(message);
            return;
        }
        if (!(clientConnection instanceof LDAPClientConnection)) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message = ExtensionMessages.ERR_SASLEXTERNAL_NOT_LDAP_CLIENT_INSTANCE.get();
            bindOperation.setAuthFailureReason(message);
            return;
        }
        LDAPClientConnection lc = (LDAPClientConnection)clientConnection;
        Certificate[] clientCertChain = lc.getClientCertificateChain();
        if (clientCertChain == null || clientCertChain.length == 0) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message = ExtensionMessages.ERR_SASLEXTERNAL_NO_CLIENT_CERT.get();
            bindOperation.setAuthFailureReason(message);
            return;
        }
        DN certificateMapperDN = config.getCertificateMapperDN();
        CertificateMapper certificateMapper = DirectoryServer.getCertificateMapper(certificateMapperDN);
        try {
            userEntry = certificateMapper.mapCertificateToUser(clientCertChain);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            bindOperation.setResponseData(de);
            return;
        }
        if (userEntry == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message = ExtensionMessages.ERR_SASLEXTERNAL_NO_MAPPING.get();
            bindOperation.setAuthFailureReason(message);
            return;
        }
        bindOperation.setSASLAuthUserEntry(userEntry);
        List<Attribute> certAttrList = userEntry.getAttribute(certificateAttributeType);
        switch (validationPolicy) {
            case ALWAYS: {
                byte[] certBytes;
                if (certAttrList == null) {
                    if (validationPolicy != CertificateValidationPolicy.ALWAYS) break;
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message = ExtensionMessages.ERR_SASLEXTERNAL_NO_CERT_IN_ENTRY.get(String.valueOf(userEntry.getDN()));
                    bindOperation.setAuthFailureReason(message);
                    return;
                }
                try {
                    certBytes = clientCertChain[0].getEncoded();
                    AttributeValue v = AttributeValues.create(certificateAttributeType, ByteString.wrap(certBytes));
                    boolean found = false;
                    for (Attribute a : certAttrList) {
                        if (!a.contains(v)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message = ExtensionMessages.ERR_SASLEXTERNAL_PEER_CERT_NOT_FOUND.get(String.valueOf(userEntry.getDN()));
                        bindOperation.setAuthFailureReason(message);
                        return;
                    }
                    break;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message = ExtensionMessages.ERR_SASLEXTERNAL_CANNOT_VALIDATE_CERT.get(String.valueOf(userEntry.getDN()), StaticUtils.getExceptionMessage(e));
                    bindOperation.setAuthFailureReason(message);
                    return;
                }
            }
            case IFPRESENT: {
                byte[] certBytes;
                if (certAttrList == null) break;
                try {
                    certBytes = clientCertChain[0].getEncoded();
                    AttributeValue v = AttributeValues.create(certificateAttributeType, ByteString.wrap(certBytes));
                    boolean found = false;
                    for (Attribute a : certAttrList) {
                        if (!a.contains(v)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message = ExtensionMessages.ERR_SASLEXTERNAL_PEER_CERT_NOT_FOUND.get(String.valueOf(userEntry.getDN()));
                        bindOperation.setAuthFailureReason(message);
                        return;
                    }
                    break;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message = ExtensionMessages.ERR_SASLEXTERNAL_CANNOT_VALIDATE_CERT.get(String.valueOf(userEntry.getDN()), StaticUtils.getExceptionMessage(e));
                    bindOperation.setAuthFailureReason(message);
                    return;
                }
            }
        }
        AuthenticationInfo authInfo = new AuthenticationInfo(userEntry, "EXTERNAL", bindOperation.getSASLCredentials(), DirectoryServer.isRootDN(userEntry.getDN()));
        bindOperation.setAuthenticationInfo(authInfo);
        bindOperation.setResultCode(ResultCode.SUCCESS);
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return false;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        ExternalSASLMechanismHandlerCfg config = (ExternalSASLMechanismHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ExternalSASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ExternalSASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        CertificateValidationPolicy newValidationPolicy = CertificateValidationPolicy.ALWAYS;
        switch (configuration.getCertificateValidationPolicy()) {
            case NEVER: {
                newValidationPolicy = CertificateValidationPolicy.NEVER;
                break;
            }
            case IFPRESENT: {
                newValidationPolicy = CertificateValidationPolicy.IFPRESENT;
                break;
            }
            case ALWAYS: {
                newValidationPolicy = CertificateValidationPolicy.ALWAYS;
            }
        }
        AttributeType newCertificateType = configuration.getCertificateAttribute();
        if (newCertificateType == null) {
            newCertificateType = DirectoryServer.getAttributeType("usercertificate", true);
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.validationPolicy = newValidationPolicy;
            this.certificateAttributeType = newCertificateType;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

