/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.EntityTagVirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.StaticUtils;

public final class EntityTagVirtualAttributeProvider
extends VirtualAttributeProvider<EntityTagVirtualAttributeCfg>
implements ConfigurationChangeListener<EntityTagVirtualAttributeCfg> {
    private static final Comparator<Attribute> ATTRIBUTE_COMPARATOR = new Comparator<Attribute>(){

        @Override
        public int compare(Attribute a1, Attribute a2) {
            return a1.getNameWithOptions().compareTo(a2.getNameWithOptions());
        }
    };
    private volatile EntityTagVirtualAttributeCfg config;

    @Override
    public ConfigChangeResult applyConfigurationChange(EntityTagVirtualAttributeCfg configuration) {
        this.config = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public ConditionResult approximatelyEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public void finalizeVirtualAttributeProvider() {
        this.config.removeEntityTagChangeListener(this);
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        Checksum checksummer;
        EntityTagVirtualAttributeCfg cfg = this.config;
        switch (cfg.getChecksumAlgorithm()) {
            case CRC_32: {
                checksummer = new CRC32();
                break;
            }
            default: {
                checksummer = new Adler32();
            }
        }
        ByteString etag = this.checksumEntry(cfg, checksummer, entry);
        AttributeValue value = AttributeValues.create(etag, etag);
        return Collections.singleton(value);
    }

    @Override
    public ConditionResult greaterThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        return true;
    }

    @Override
    public void initializeVirtualAttributeProvider(EntityTagVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
        this.config = configuration;
        configuration.addEntityTagChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(EntityTagVirtualAttributeCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation, boolean isPreIndexed) {
        return false;
    }

    @Override
    public ConditionResult lessThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult matchesSubstring(Entry entry, VirtualAttributeRule rule, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        Message message = ExtensionMessages.ERR_ETAG_VATTR_NOT_SEARCHABLE.get(rule.getAttributeType().getNameOrOID());
        searchOperation.appendErrorMessage(message);
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
    }

    private void checksumAttribute(EntityTagVirtualAttributeCfg cfg, Checksum checksummer, Attribute attribute) {
        if (attribute == null) {
            return;
        }
        if (attribute.isVirtual()) {
            return;
        }
        if (cfg.getExcludedAttribute().contains(attribute.getAttributeType())) {
            return;
        }
        String atd = attribute.getNameWithOptions();
        byte[] bytes = StaticUtils.getBytes(atd);
        checksummer.update(bytes, 0, bytes.length);
        int size = attribute.size();
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                this.checksumValue(checksummer, attribute.iterator().next().getValue());
                break;
            }
            default: {
                Object[] values = new ByteString[size];
                int i = 0;
                for (AttributeValue av : attribute) {
                    values[i++] = av.getValue();
                }
                Arrays.sort(values);
                for (Object value : values) {
                    this.checksumValue(checksummer, (ByteString)value);
                }
            }
        }
    }

    private ByteString checksumEntry(EntityTagVirtualAttributeCfg cfg, Checksum checksummer, Entry entry) {
        this.checksumAttribute(cfg, checksummer, entry.getObjectClassAttribute());
        List<Attribute> attributes = entry.getAttributes();
        Collections.sort(attributes, ATTRIBUTE_COMPARATOR);
        for (Attribute attribute : attributes) {
            this.checksumAttribute(cfg, checksummer, attribute);
        }
        long checksum = checksummer.getValue();
        byte[] bytes = new byte[16];
        int j = 15;
        for (int i = 7; i >= 0; --i) {
            byte b = (byte)(checksum & 0xFFL);
            byte l = (byte)(b & 0xF);
            bytes[j--] = (byte)(l < 10 ? l + 48 : l + 87);
            byte h = (byte)((b & 0xF0) >>> 4);
            bytes[j--] = (byte)(h < 10 ? h + 48 : h + 87);
            checksum >>>= 8;
        }
        return ByteString.wrap(bytes);
    }

    private void checksumValue(Checksum checksummer, ByteString value) {
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            checksummer.update(value.byteAt(i) & 0xFF);
        }
    }
}

