/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opends.messages.CoreMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.DiskSpaceMonitorHandler;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Attributes;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;

public class DiskSpaceMonitor
extends MonitorProvider<MonitorProviderCfg>
implements Runnable {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private volatile File directory;
    private volatile long lowThreshold;
    private volatile long fullThreshold;
    private final DiskSpaceMonitorHandler handler;
    private final int interval;
    private final TimeUnit unit;
    private final String instanceName;
    private int lastState = 0;

    public DiskSpaceMonitor(String instanceName, File directory, long lowThreshold, long fullThreshold, int interval, TimeUnit unit, DiskSpaceMonitorHandler handler) {
        this.directory = directory;
        this.lowThreshold = lowThreshold;
        this.fullThreshold = fullThreshold;
        this.interval = interval;
        this.unit = unit;
        this.handler = handler;
        this.instanceName = instanceName + ",cn=Disk Space Monitor";
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public long getLowThreshold() {
        return this.lowThreshold;
    }

    public void setLowThreshold(long lowThreshold) {
        this.lowThreshold = lowThreshold;
    }

    public long getFullThreshold() {
        return this.fullThreshold;
    }

    public void setFullThreshold(long fullThreshold) {
        this.fullThreshold = fullThreshold;
    }

    public long getFreeSpace() {
        return this.directory.getUsableSpace();
    }

    public boolean isFullThresholdReached() {
        return this.lastState >= 2;
    }

    public boolean isLowThresholdReached() {
        return this.lastState >= 1;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
        this.scheduleUpdate(this, 0L, this.interval, this.unit);
    }

    @Override
    public String getMonitorInstanceName() {
        return this.instanceName;
    }

    @Override
    public List<Attribute> getMonitorData() {
        ArrayList<Attribute> monitorAttrs = new ArrayList<Attribute>();
        AttributeType attrType = DirectoryServer.getDefaultAttributeType("disk-dir", DirectoryServer.getDefaultStringSyntax());
        monitorAttrs.add(Attributes.create(attrType, this.directory.getPath()));
        attrType = DirectoryServer.getDefaultAttributeType("disk-free", DirectoryServer.getDefaultIntegerSyntax());
        monitorAttrs.add(Attributes.create(attrType, String.valueOf(this.getFreeSpace())));
        attrType = DirectoryServer.getDefaultAttributeType("disk-state", DirectoryServer.getDefaultStringSyntax());
        switch (this.lastState) {
            case 0: {
                monitorAttrs.add(Attributes.create(attrType, "normal"));
                break;
            }
            case 1: {
                monitorAttrs.add(Attributes.create(attrType, "low"));
                break;
            }
            case 2: {
                monitorAttrs.add(Attributes.create(attrType, "full"));
            }
        }
        return monitorAttrs;
    }

    @Override
    public void run() {
        try {
            long lastFreeSpace = this.directory.getUsableSpace();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Free space for %s: %d, low threshold: %d, full threshold: %d, state: %d", this.directory.getPath(), lastFreeSpace, this.lowThreshold, this.fullThreshold, this.lastState);
            }
            if (lastFreeSpace < this.fullThreshold) {
                if (this.lastState < 2) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("State change: %d -> %d", this.lastState, 2);
                    }
                    this.lastState = 2;
                    if (this.handler != null) {
                        this.handler.diskFullThresholdReached(this);
                    }
                }
            } else if (lastFreeSpace < this.lowThreshold) {
                if (this.lastState < 1) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("State change: %d -> %d", this.lastState, 1);
                    }
                    this.lastState = 1;
                    if (this.handler != null) {
                        this.handler.diskLowThresholdReached(this);
                    }
                }
            } else if (this.lastState != 0) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("State change: %d -> %d", this.lastState, 0);
                }
                this.lastState = 0;
                if (this.handler != null) {
                    this.handler.diskSpaceRestored(this);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.logError(CoreMessages.ERR_DISK_SPACE_MONITOR_UPDATE_FAILED.get(this.directory.getPath(), e.toString()));
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
        }
    }
}

