/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CharacterSetPasswordValidatorCfg;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigException;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class CharacterSetPasswordValidator
extends PasswordValidator<CharacterSetPasswordValidatorCfg>
implements ConfigurationChangeListener<CharacterSetPasswordValidatorCfg> {
    private CharacterSetPasswordValidatorCfg currentConfig;
    private HashMap<String, Integer> characterSets;
    private HashMap<String, Integer> characterRanges;

    @Override
    public void initializePasswordValidator(CharacterSetPasswordValidatorCfg configuration) throws ConfigException {
        configuration.addCharacterSetChangeListener(this);
        this.currentConfig = configuration;
        this.processCharacterSetsAndRanges(configuration, true);
    }

    @Override
    public void finalizePasswordValidator() {
        this.currentConfig.removeCharacterSetChangeListener(this);
    }

    @Override
    public boolean passwordIsAcceptable(ByteString newPassword, Set<ByteString> currentPasswords, Operation operation, Entry userEntry, MessageBuilder invalidReason) {
        int requiredOptionalCharacterSets;
        Integer passwordCount;
        CharacterSetPasswordValidatorCfg config = this.currentConfig;
        HashMap<String, Integer> characterSets = this.characterSets;
        String password = newPassword.toString();
        HashMap<String, Integer> setCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> rangeCounts = new HashMap<String, Integer>();
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            boolean found = false;
            for (String characterSet : characterSets.keySet()) {
                if (characterSet.indexOf(c) < 0) continue;
                Integer count = (Integer)setCounts.get(characterSet);
                if (count == null) {
                    setCounts.put(characterSet, 1);
                } else {
                    setCounts.put(characterSet, count + 1);
                }
                found = true;
                break;
            }
            if (!found) {
                block2: for (String characterRange : this.characterRanges.keySet()) {
                    for (int rangeStart = 0; rangeStart < characterRange.length(); rangeStart += 3) {
                        if (characterRange.charAt(rangeStart) > c || c > characterRange.charAt(rangeStart + 2)) continue;
                        Integer count = (Integer)rangeCounts.get(characterRange);
                        if (count == null) {
                            rangeCounts.put(characterRange, 1);
                        } else {
                            rangeCounts.put(characterRange, count + 1);
                        }
                        found = true;
                        continue block2;
                    }
                }
            }
            if (found || config.isAllowUnclassifiedCharacters()) continue;
            invalidReason.append(ExtensionMessages.ERR_CHARSET_VALIDATOR_ILLEGAL_CHARACTER.get(String.valueOf(c)));
            return false;
        }
        int usedOptionalCharacterSets = 0;
        int optionalCharacterSets = 0;
        int mandatoryCharacterSets = 0;
        for (String characterSet : characterSets.keySet()) {
            int minimumCount = characterSets.get(characterSet);
            passwordCount = (Integer)setCounts.get(characterSet);
            if (minimumCount > 0) {
                ++mandatoryCharacterSets;
                if (passwordCount != null && passwordCount >= minimumCount) continue;
                invalidReason.append(ExtensionMessages.ERR_CHARSET_VALIDATOR_TOO_FEW_CHARS_FROM_SET.get(characterSet, minimumCount));
                return false;
            }
            ++optionalCharacterSets;
            if (passwordCount == null) continue;
            ++usedOptionalCharacterSets;
        }
        for (String characterRange : this.characterRanges.keySet()) {
            int minimumCount = this.characterRanges.get(characterRange);
            passwordCount = (Integer)rangeCounts.get(characterRange);
            if (minimumCount > 0) {
                ++mandatoryCharacterSets;
                if (passwordCount != null && passwordCount >= minimumCount) continue;
                invalidReason.append(ExtensionMessages.ERR_CHARSET_VALIDATOR_TOO_FEW_CHARS_FROM_RANGE.get(characterRange, minimumCount));
                return false;
            }
            ++optionalCharacterSets;
            if (passwordCount == null) continue;
            ++usedOptionalCharacterSets;
        }
        if (optionalCharacterSets > 0 && usedOptionalCharacterSets < (requiredOptionalCharacterSets = this.currentConfig.getMinCharacterSets() == null ? 1 : this.currentConfig.getMinCharacterSets() - mandatoryCharacterSets)) {
            StringBuilder builder = new StringBuilder();
            for (String characterSet : characterSets.keySet()) {
                if (characterSets.get(characterSet) != 0) continue;
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append('\'');
                builder.append(characterSet);
                builder.append('\'');
            }
            for (String characterRange : this.characterRanges.keySet()) {
                if (this.characterRanges.get(characterRange) != 0) continue;
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append('\'');
                builder.append(characterRange);
                builder.append('\'');
            }
            invalidReason.append(ExtensionMessages.ERR_CHARSET_VALIDATOR_TOO_FEW_OPTIONAL_CHAR_SETS.get(requiredOptionalCharacterSets, builder.toString()));
            return false;
        }
        return true;
    }

    private void processCharacterSetsAndRanges(CharacterSetPasswordValidatorCfg configuration, boolean apply) throws ConfigException {
        Message message;
        int minCount;
        int colonPos;
        HashMap<String, Integer> characterSets = new HashMap<String, Integer>();
        HashMap<String, Integer> characterRanges = new HashMap<String, Integer>();
        HashSet<Character> usedCharacters = new HashSet<Character>();
        int mandatoryCharacterSets = 0;
        for (String definition : configuration.getCharacterSet()) {
            colonPos = definition.indexOf(58);
            if (colonPos <= 0) {
                Message message2 = ExtensionMessages.ERR_CHARSET_VALIDATOR_NO_SET_COLON.get(definition);
                throw new ConfigException(message2);
            }
            if (colonPos == definition.length() - 1) {
                Message message3 = ExtensionMessages.ERR_CHARSET_VALIDATOR_NO_SET_CHARS.get(definition);
                throw new ConfigException(message3);
            }
            try {
                minCount = Integer.parseInt(definition.substring(0, colonPos));
            }
            catch (Exception e) {
                Message message4 = ExtensionMessages.ERR_CHARSET_VALIDATOR_INVALID_SET_COUNT.get(definition);
                throw new ConfigException(message4);
            }
            if (minCount < 0) {
                message = ExtensionMessages.ERR_CHARSET_VALIDATOR_INVALID_SET_COUNT.get(definition);
                throw new ConfigException(message);
            }
            String characterSet = definition.substring(colonPos + 1);
            for (int i = 0; i < characterSet.length(); ++i) {
                char c = characterSet.charAt(i);
                if (usedCharacters.contains(Character.valueOf(c))) {
                    Message message5 = ExtensionMessages.ERR_CHARSET_VALIDATOR_DUPLICATE_CHAR.get(definition, String.valueOf(c));
                    throw new ConfigException(message5);
                }
                usedCharacters.add(Character.valueOf(c));
            }
            characterSets.put(characterSet, minCount);
            if (minCount <= 0) continue;
            ++mandatoryCharacterSets;
        }
        for (String definition : configuration.getCharacterSetRanges()) {
            colonPos = definition.indexOf(58);
            if (colonPos <= 0) {
                Message message6 = ExtensionMessages.ERR_CHARSET_VALIDATOR_NO_RANGE_COLON.get(definition);
                throw new ConfigException(message6);
            }
            if (colonPos == definition.length() - 1) {
                Message message7 = ExtensionMessages.ERR_CHARSET_VALIDATOR_NO_RANGE_CHARS.get(definition);
                throw new ConfigException(message7);
            }
            try {
                minCount = Integer.parseInt(definition.substring(0, colonPos));
            }
            catch (Exception e) {
                Message message8 = ExtensionMessages.ERR_CHARSET_VALIDATOR_INVALID_RANGE_COUNT.get(definition);
                throw new ConfigException(message8);
            }
            if (minCount < 0) {
                message = ExtensionMessages.ERR_CHARSET_VALIDATOR_INVALID_RANGE_COUNT.get(definition);
                throw new ConfigException(message);
            }
            String characterRange = definition.substring(colonPos + 1);
            for (int rangeOffset = 0; rangeOffset < characterRange.length(); rangeOffset += 3) {
                if (rangeOffset > characterRange.length() - 3) {
                    Message message9 = ExtensionMessages.ERR_CHARSET_VALIDATOR_SHORT_RANGE.get(definition, characterRange.substring(rangeOffset));
                    throw new ConfigException(message9);
                }
                if (characterRange.charAt(rangeOffset + 1) != '-') {
                    Message message10 = ExtensionMessages.ERR_CHARSET_VALIDATOR_MALFORMED_RANGE.get(definition, characterRange.substring(rangeOffset, rangeOffset + 3));
                    throw new ConfigException(message10);
                }
                if (characterRange.charAt(rangeOffset) < characterRange.charAt(rangeOffset + 2)) continue;
                Message message11 = ExtensionMessages.ERR_CHARSET_VALIDATOR_UNSORTED_RANGE.get(definition, characterRange.substring(rangeOffset, rangeOffset + 3));
                throw new ConfigException(message11);
            }
            characterRanges.put(characterRange, minCount);
            if (minCount <= 0) continue;
            ++mandatoryCharacterSets;
        }
        int optionalCharacterSets = characterSets.size() + characterRanges.size() - mandatoryCharacterSets;
        if (optionalCharacterSets > 0 && configuration.getMinCharacterSets() != null) {
            int minCharacterSets = configuration.getMinCharacterSets();
            if (minCharacterSets <= mandatoryCharacterSets) {
                Message message12 = ExtensionMessages.ERR_CHARSET_VALIDATOR_MIN_CHAR_SETS_TOO_SMALL.get(minCharacterSets);
                throw new ConfigException(message12);
            }
            if (minCharacterSets > characterSets.size() + characterRanges.size()) {
                Message message13 = ExtensionMessages.ERR_CHARSET_VALIDATOR_MIN_CHAR_SETS_TOO_BIG.get(minCharacterSets);
                throw new ConfigException(message13);
            }
        }
        if (apply) {
            this.characterSets = characterSets;
            this.characterRanges = characterRanges;
        }
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordValidatorCfg configuration, List<Message> unacceptableReasons) {
        CharacterSetPasswordValidatorCfg config = (CharacterSetPasswordValidatorCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(CharacterSetPasswordValidatorCfg configuration, List<Message> unacceptableReasons) {
        try {
            this.processCharacterSetsAndRanges(configuration, false);
        }
        catch (ConfigException ce) {
            unacceptableReasons.add(ce.getMessageObject());
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(CharacterSetPasswordValidatorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.processCharacterSetsAndRanges(configuration, true);
            this.currentConfig = configuration;
        }
        catch (Exception e) {
            resultCode = DirectoryConfig.getServerErrorResultCode();
            messages.add(StaticUtils.getExceptionMessage(e));
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

